/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.pack;

import java.io.IOException;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.Pack;
import scouter.util.DateUtil;
import scouter.util.Hexa32;

public class XLogProfilePack
implements Pack {
    public long time;
    public int objHash;
    public int service;
    public long txid;
    public int elapsed;
    public byte[] profile;

    @Override
    public byte getPackType() {
        return 26;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Profile ");
        sb.append(DateUtil.timestamp(this.time));
        sb.append(" objHash=").append(Hexa32.toString32(this.objHash));
        sb.append(" profile=").append(this.profile == null ? null : Integer.valueOf(this.profile.length));
        return sb.toString();
    }

    @Override
    public void write(DataOutputX dout) throws IOException {
        dout.writeDecimal(this.time);
        dout.writeDecimal(this.objHash);
        dout.writeDecimal(this.service);
        dout.writeLong(this.txid);
        dout.writeBlob(this.profile);
    }

    @Override
    public Pack read(DataInputX din) throws IOException {
        this.time = din.readDecimal();
        this.objHash = (int)din.readDecimal();
        this.service = (int)din.readDecimal();
        this.txid = din.readLong();
        this.profile = din.readBlob();
        return this;
    }
}

