/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.value;

import java.io.IOException;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.value.NumberValue;
import scouter.lang.value.Value;

public class FloatValue
extends NumberValue
implements Value,
Comparable {
    public float value;

    public FloatValue() {
    }

    public FloatValue(float value) {
        this.value = value;
    }

    public int compareTo(Object o) {
        if (o instanceof FloatValue) {
            return Float.compare(this.value, ((FloatValue)o).value);
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (o instanceof FloatValue) {
            return this.value == ((FloatValue)o).value;
        }
        return false;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    @Override
    public byte getValueType() {
        return 30;
    }

    @Override
    public void write(DataOutputX out) throws IOException {
        out.writeFloat(this.value);
    }

    @Override
    public Value read(DataInputX in) throws IOException {
        this.value = in.readFloat();
        return this;
    }

    public String toString() {
        return Float.toString(this.value);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public Object toJavaObject() {
        return Float.valueOf(this.value);
    }
}

