/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import scouter.lang.value.DecimalValue;

public class FormatUtil {
    private static String[] unit = new String[]{"B", "K", "M", "G", "T", "P"};

    public static String print(Object o, String format) {
        if (o == null) {
            return "";
        }
        if (format == null) {
            return o.toString();
        }
        try {
            if (o instanceof Date) {
                return new SimpleDateFormat(format).format((Date)o);
            }
            if (o instanceof Number || o instanceof BigDecimal) {
                return new DecimalFormat(format).format(o);
            }
            if (o instanceof DecimalValue) {
                return new DecimalFormat(format).format(new Long(((DecimalValue)o).value));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return o.toString();
    }

    public static String printMem(double mem) {
        int x = 0;
        for (x = 0; mem >= 1024.0 && x < unit.length; mem /= 1024.0, ++x) {
        }
        if (x == 0) {
            return mem + unit[0];
        }
        return FormatUtil.print(mem, "#,##0.0") + unit[x];
    }

    public static void main(String[] args) {
        System.out.println(FormatUtil.printMem(1.073741824E9));
    }
}

