/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

public class StrMatch {
    protected COMP comp = COMP.EQU;
    protected String start;
    protected String end;
    protected String mid;
    protected String mid2;
    protected String pattern;
    private final String any1;
    private final String any2;

    public boolean equals(Object obj) {
        if (obj instanceof StrMatch) {
            return this.pattern.equals(((StrMatch)obj).pattern);
        }
        return false;
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public StrMatch(String pattern) {
        this('*', pattern);
    }

    public StrMatch(char CHAR, String pattern) {
        boolean anyMid;
        this.pattern = pattern;
        this.any1 = new String(new char[]{CHAR});
        this.any2 = new String(new char[]{CHAR, CHAR});
        if (this.any1.equals(pattern) || this.any2.equals(pattern)) {
            this.comp = COMP.ANY;
            return;
        }
        int length = pattern.length();
        if (length < 2) {
            this.comp = COMP.EQU;
            this.mid = pattern;
            return;
        }
        boolean anyStart = pattern.charAt(0) == CHAR;
        boolean anyEnd = pattern.charAt(length - 1) == CHAR;
        int x = pattern.indexOf(CHAR, 1);
        boolean bl = anyMid = x > 0 && x < length - 1;
        if (anyMid) {
            if (anyStart && anyEnd) {
                this.comp = COMP.MID_MID;
                this.mid = pattern.substring(1, x);
                this.mid2 = pattern.substring(x + 1, length - 1);
            } else if (anyStart) {
                this.comp = COMP.MID_END;
                this.mid = pattern.substring(1, x);
                this.end = pattern.substring(x + 1);
            } else if (anyEnd) {
                this.comp = COMP.STR_MID;
                this.start = pattern.substring(0, x);
                this.mid = pattern.substring(x + 1, length - 1);
            } else {
                this.comp = COMP.STR_END;
                this.start = pattern.substring(0, x);
                this.end = pattern.substring(x + 1);
            }
        } else if (anyStart && anyEnd) {
            this.comp = COMP.MID;
            this.mid = pattern.substring(1, length - 1);
        } else if (anyStart) {
            this.comp = COMP.END;
            this.end = pattern.substring(1);
        } else if (anyEnd) {
            this.comp = COMP.STR;
            this.start = pattern.substring(0, length - 1);
        } else {
            this.comp = COMP.EQU;
            this.mid = pattern;
        }
    }

    public boolean include(String target) {
        if (target == null || target.length() == 0) {
            return false;
        }
        switch (this.comp) {
            case ANY: {
                return true;
            }
            case EQU: {
                return target.equals(this.mid);
            }
            case STR: {
                return target.startsWith(this.start);
            }
            case STR_MID: {
                return target.startsWith(this.start) && target.indexOf(this.mid) >= 0;
            }
            case STR_END: {
                return target.startsWith(this.start) && target.endsWith(this.end);
            }
            case MID: {
                return target.indexOf(this.mid) >= 0;
            }
            case MID_MID: {
                int x = target.indexOf(this.mid);
                if (x < 0) {
                    return false;
                }
                return target.indexOf(this.mid2, x + this.mid.length()) >= 0;
            }
            case MID_END: {
                return target.indexOf(this.mid) >= 0 && target.endsWith(this.end);
            }
            case END: {
                return target.endsWith(this.end);
            }
        }
        return false;
    }

    public String toString() {
        return this.pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public COMP getComp() {
        return this.comp;
    }

    public static void main(String[] args) {
        StrMatch sc = new StrMatch("**");
        System.out.println(sc.pattern);
    }

    public static enum COMP {
        EQU,
        STR,
        STR_MID,
        STR_END,
        MID,
        MID_MID,
        MID_END,
        END,
        ANY;

    }
}

