/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Webhook {
    private final String webhookId;
    private final String url;
    private final Optional<List<String>> eventTypes;
    private final Optional<String> secret;

    private Webhook(String webhookId, String url, Optional<List<String>> eventTypes, Optional<String> secret) {
        this.webhookId = webhookId;
        this.url = url;
        this.eventTypes = eventTypes;
        this.secret = secret;
    }

    @JsonProperty(value="webhook_id")
    public String getWebhookId() {
        return this.webhookId;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="event_types")
    public Optional<List<String>> getEventTypes() {
        return this.eventTypes;
    }

    @JsonProperty(value="secret")
    public Optional<String> getSecret() {
        return this.secret;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Webhook && this.equalTo((Webhook)other);
    }

    private boolean equalTo(Webhook other) {
        return this.webhookId.equals(other.webhookId) && this.url.equals(other.url) && this.eventTypes.equals(other.eventTypes) && this.secret.equals(other.secret);
    }

    public int hashCode() {
        return Objects.hash(this.webhookId, this.url, this.eventTypes, this.secret);
    }

    public String toString() {
        return "Webhook{webhookId: " + this.webhookId + ", url: " + this.url + ", eventTypes: " + this.eventTypes + ", secret: " + this.secret + "}";
    }

    public static WebhookIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements WebhookIdStage,
    UrlStage,
    _FinalStage {
        private String webhookId;
        private String url;
        private Optional<String> secret = Optional.empty();
        private Optional<List<String>> eventTypes = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(Webhook other) {
            this.webhookId(other.getWebhookId());
            this.url(other.getUrl());
            this.eventTypes(other.getEventTypes());
            this.secret(other.getSecret());
            return this;
        }

        @Override
        @JsonSetter(value="webhook_id")
        public UrlStage webhookId(String webhookId) {
            this.webhookId = webhookId;
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public _FinalStage url(String url) {
            this.url = url;
            return this;
        }

        @Override
        public _FinalStage secret(String secret) {
            this.secret = Optional.of(secret);
            return this;
        }

        @Override
        @JsonSetter(value="secret", nulls=Nulls.SKIP)
        public _FinalStage secret(Optional<String> secret) {
            this.secret = secret;
            return this;
        }

        @Override
        public _FinalStage eventTypes(List<String> eventTypes) {
            this.eventTypes = Optional.of(eventTypes);
            return this;
        }

        @Override
        @JsonSetter(value="event_types", nulls=Nulls.SKIP)
        public _FinalStage eventTypes(Optional<List<String>> eventTypes) {
            this.eventTypes = eventTypes;
            return this;
        }

        @Override
        public Webhook build() {
            return new Webhook(this.webhookId, this.url, this.eventTypes, this.secret);
        }
    }

    public static interface _FinalStage {
        public Webhook build();

        public _FinalStage eventTypes(Optional<List<String>> var1);

        public _FinalStage eventTypes(List<String> var1);

        public _FinalStage secret(Optional<String> var1);

        public _FinalStage secret(String var1);
    }

    public static interface UrlStage {
        public _FinalStage url(String var1);
    }

    public static interface WebhookIdStage {
        public UrlStage webhookId(String var1);

        public Builder from(Webhook var1);
    }
}

