/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.accesscodes.unmanaged.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class UnmanagedDeleteRequest {
    private final String accessCodeId;
    private final Optional<Boolean> sync;

    private UnmanagedDeleteRequest(String accessCodeId, Optional<Boolean> sync) {
        this.accessCodeId = accessCodeId;
        this.sync = sync;
    }

    @JsonProperty(value="access_code_id")
    public String getAccessCodeId() {
        return this.accessCodeId;
    }

    @JsonProperty(value="sync")
    public Optional<Boolean> getSync() {
        return this.sync;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UnmanagedDeleteRequest && this.equalTo((UnmanagedDeleteRequest)other);
    }

    private boolean equalTo(UnmanagedDeleteRequest other) {
        return this.accessCodeId.equals(other.accessCodeId) && this.sync.equals(other.sync);
    }

    public int hashCode() {
        return Objects.hash(this.accessCodeId, this.sync);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccessCodeIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccessCodeIdStage,
    _FinalStage {
        private String accessCodeId;
        private Optional<Boolean> sync = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(UnmanagedDeleteRequest other) {
            this.accessCodeId(other.getAccessCodeId());
            this.sync(other.getSync());
            return this;
        }

        @Override
        @JsonSetter(value="access_code_id")
        public _FinalStage accessCodeId(String accessCodeId) {
            this.accessCodeId = accessCodeId;
            return this;
        }

        @Override
        public _FinalStage sync(Boolean sync) {
            this.sync = Optional.of(sync);
            return this;
        }

        @Override
        @JsonSetter(value="sync", nulls=Nulls.SKIP)
        public _FinalStage sync(Optional<Boolean> sync) {
            this.sync = sync;
            return this;
        }

        @Override
        public UnmanagedDeleteRequest build() {
            return new UnmanagedDeleteRequest(this.accessCodeId, this.sync);
        }
    }

    public static interface _FinalStage {
        public UnmanagedDeleteRequest build();

        public _FinalStage sync(Optional<Boolean> var1);

        public _FinalStage sync(Boolean var1);
    }

    public static interface AccessCodeIdStage {
        public _FinalStage accessCodeId(String var1);

        public Builder from(UnmanagedDeleteRequest var1);
    }
}

