/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.thermostats;

import com.seam.api.core.ClientOptions;
import com.seam.api.core.ObjectMappers;
import com.seam.api.core.RequestOptions;
import com.seam.api.core.Suppliers;
import com.seam.api.resources.thermostats.climatesettingschedules.ClimateSettingSchedulesClient;
import com.seam.api.resources.thermostats.requests.ThermostatsGetRequest;
import com.seam.api.resources.thermostats.requests.ThermostatsHeatRequest;
import com.seam.api.resources.thermostats.requests.ThermostatsListRequest;
import com.seam.api.resources.thermostats.requests.ThermostatsUpdateRequest;
import com.seam.api.types.ThermostatsGetResponse;
import com.seam.api.types.ThermostatsHeatResponse;
import com.seam.api.types.ThermostatsListResponse;
import com.seam.api.types.ThermostatsUpdateResponse;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Supplier;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ThermostatsClient {
    protected final ClientOptions clientOptions;
    protected final Supplier<ClimateSettingSchedulesClient> climateSettingSchedulesClient;

    public ThermostatsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.climateSettingSchedulesClient = Suppliers.memoize(() -> new ClimateSettingSchedulesClient(clientOptions));
    }

    public ThermostatsGetResponse get(ThermostatsGetRequest request) {
        return this.get(request, null);
    }

    public ThermostatsGetResponse get(ThermostatsGetRequest request, RequestOptions requestOptions) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("thermostats/get").build();
        HashMap<String, Optional<String>> _requestBodyProperties = new HashMap<String, Optional<String>>();
        if (request.getDeviceId().isPresent()) {
            _requestBodyProperties.put("device_id", request.getDeviceId());
        }
        if (request.getName().isPresent()) {
            _requestBodyProperties.put("name", request.getName());
        }
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (ThermostatsGetResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), ThermostatsGetResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ThermostatsHeatResponse heat(ThermostatsHeatRequest request) {
        return this.heat(request, null);
    }

    public ThermostatsHeatResponse heat(ThermostatsHeatRequest request, RequestOptions requestOptions) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("thermostats/heat").build();
        HashMap<String, Object> _requestBodyProperties = new HashMap<String, Object>();
        _requestBodyProperties.put("device_id", request.getDeviceId());
        if (request.getHeatingSetPointCelsius().isPresent()) {
            _requestBodyProperties.put("heating_set_point_celsius", request.getHeatingSetPointCelsius());
        }
        if (request.getHeatingSetPointFahrenheit().isPresent()) {
            _requestBodyProperties.put("heating_set_point_fahrenheit", request.getHeatingSetPointFahrenheit());
        }
        if (request.getSync().isPresent()) {
            _requestBodyProperties.put("sync", request.getSync());
        }
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (ThermostatsHeatResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), ThermostatsHeatResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ThermostatsListResponse list(ThermostatsListRequest request) {
        return this.list(request, null);
    }

    public ThermostatsListResponse list(ThermostatsListRequest request, RequestOptions requestOptions) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("thermostats/list").build();
        HashMap<String, Optional<Object>> _requestBodyProperties = new HashMap<String, Optional<Object>>();
        if (request.getConnectedAccountId().isPresent()) {
            _requestBodyProperties.put("connected_account_id", request.getConnectedAccountId());
        }
        if (request.getConnectedAccountIds().isPresent()) {
            _requestBodyProperties.put("connected_account_ids", request.getConnectedAccountIds());
        }
        if (request.getConnectWebviewId().isPresent()) {
            _requestBodyProperties.put("connect_webview_id", request.getConnectWebviewId());
        }
        if (request.getDeviceType().isPresent()) {
            _requestBodyProperties.put("device_type", request.getDeviceType());
        }
        if (request.getDeviceTypes().isPresent()) {
            _requestBodyProperties.put("device_types", request.getDeviceTypes());
        }
        if (request.getManufacturer().isPresent()) {
            _requestBodyProperties.put("manufacturer", request.getManufacturer());
        }
        if (request.getDeviceIds().isPresent()) {
            _requestBodyProperties.put("device_ids", request.getDeviceIds());
        }
        if (request.getLimit().isPresent()) {
            _requestBodyProperties.put("limit", request.getLimit());
        }
        if (request.getCreatedBefore().isPresent()) {
            _requestBodyProperties.put("created_before", request.getCreatedBefore());
        }
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (ThermostatsListResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), ThermostatsListResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ThermostatsUpdateResponse update(ThermostatsUpdateRequest request) {
        return this.update(request, null);
    }

    public ThermostatsUpdateResponse update(ThermostatsUpdateRequest request, RequestOptions requestOptions) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("thermostats/update").build();
        HashMap<String, Object> _requestBodyProperties = new HashMap<String, Object>();
        _requestBodyProperties.put("device_id", request.getDeviceId());
        _requestBodyProperties.put("default_climate_setting", request.getDefaultClimateSetting());
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (ThermostatsUpdateResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), ThermostatsUpdateResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ClimateSettingSchedulesClient climateSettingSchedules() {
        return this.climateSettingSchedulesClient.get();
    }
}

