/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.accesscodes.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class AccessCodesListRequest {
    private final String deviceId;
    private final Optional<List<String>> accessCodeIds;

    private AccessCodesListRequest(String deviceId, Optional<List<String>> accessCodeIds) {
        this.deviceId = deviceId;
        this.accessCodeIds = accessCodeIds;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="access_code_ids")
    public Optional<List<String>> getAccessCodeIds() {
        return this.accessCodeIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AccessCodesListRequest && this.equalTo((AccessCodesListRequest)other);
    }

    private boolean equalTo(AccessCodesListRequest other) {
        return this.deviceId.equals(other.deviceId) && this.accessCodeIds.equals(other.accessCodeIds);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.accessCodeIds);
    }

    public String toString() {
        return "AccessCodesListRequest{deviceId: " + this.deviceId + ", accessCodeIds: " + this.accessCodeIds + "}";
    }

    public static DeviceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DeviceIdStage,
    _FinalStage {
        private String deviceId;
        private Optional<List<String>> accessCodeIds = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(AccessCodesListRequest other) {
            this.deviceId(other.getDeviceId());
            this.accessCodeIds(other.getAccessCodeIds());
            return this;
        }

        @Override
        @JsonSetter(value="device_id")
        public _FinalStage deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        public _FinalStage accessCodeIds(List<String> accessCodeIds) {
            this.accessCodeIds = Optional.of(accessCodeIds);
            return this;
        }

        @Override
        @JsonSetter(value="access_code_ids", nulls=Nulls.SKIP)
        public _FinalStage accessCodeIds(Optional<List<String>> accessCodeIds) {
            this.accessCodeIds = accessCodeIds;
            return this;
        }

        @Override
        public AccessCodesListRequest build() {
            return new AccessCodesListRequest(this.deviceId, this.accessCodeIds);
        }
    }

    public static interface _FinalStage {
        public AccessCodesListRequest build();

        public _FinalStage accessCodeIds(Optional<List<String>> var1);

        public _FinalStage accessCodeIds(List<String> var1);
    }

    public static interface DeviceIdStage {
        public _FinalStage deviceId(String var1);

        public Builder from(AccessCodesListRequest var1);
    }
}

