/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.clientsessions;

import com.seam.api.core.ApiError;
import com.seam.api.core.ClientOptions;
import com.seam.api.core.ObjectMappers;
import com.seam.api.core.RequestOptions;
import com.seam.api.resources.clientsessions.requests.ClientSessionsCreateRequest;
import com.seam.api.resources.clientsessions.requests.ClientSessionsDeleteRequest;
import com.seam.api.resources.clientsessions.requests.ClientSessionsGetRequest;
import com.seam.api.resources.clientsessions.requests.ClientSessionsListRequest;
import com.seam.api.types.ClientSessionsCreateResponse;
import com.seam.api.types.ClientSessionsDeleteResponse;
import com.seam.api.types.ClientSessionsGetResponse;
import com.seam.api.types.ClientSessionsListResponse;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ClientSessionsClient {
    protected final ClientOptions clientOptions;

    public ClientSessionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public ClientSessionsCreateResponse create(ClientSessionsCreateRequest request) {
        return this.create(request, null);
    }

    public ClientSessionsCreateResponse create(ClientSessionsCreateRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("client_sessions/create").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (ClientSessionsCreateResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), ClientSessionsCreateResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ClientSessionsCreateResponse create() {
        return this.create(ClientSessionsCreateRequest.builder().build());
    }

    public ClientSessionsDeleteResponse delete(ClientSessionsDeleteRequest request) {
        return this.delete(request, null);
    }

    public ClientSessionsDeleteResponse delete(ClientSessionsDeleteRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("client_sessions/delete").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (ClientSessionsDeleteResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), ClientSessionsDeleteResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ClientSessionsGetResponse get(ClientSessionsGetRequest request) {
        return this.get(request, null);
    }

    public ClientSessionsGetResponse get(ClientSessionsGetRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("client_sessions/get").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (ClientSessionsGetResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), ClientSessionsGetResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ClientSessionsGetResponse get() {
        return this.get(ClientSessionsGetRequest.builder().build());
    }

    public ClientSessionsListResponse list(ClientSessionsListRequest request) {
        return this.list(request, null);
    }

    public ClientSessionsListResponse list(ClientSessionsListRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("client_sessions/list").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (ClientSessionsListResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), ClientSessionsListResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ClientSessionsListResponse list() {
        return this.list(ClientSessionsListRequest.builder().build());
    }
}

