/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.locks.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LocksUnlockDoorRequest {
    private final String deviceId;
    private final Optional<Boolean> sync;

    private LocksUnlockDoorRequest(String deviceId, Optional<Boolean> sync) {
        this.deviceId = deviceId;
        this.sync = sync;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="sync")
    public Optional<Boolean> getSync() {
        return this.sync;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LocksUnlockDoorRequest && this.equalTo((LocksUnlockDoorRequest)other);
    }

    private boolean equalTo(LocksUnlockDoorRequest other) {
        return this.deviceId.equals(other.deviceId) && this.sync.equals(other.sync);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.sync);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DeviceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DeviceIdStage,
    _FinalStage {
        private String deviceId;
        private Optional<Boolean> sync = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(LocksUnlockDoorRequest other) {
            this.deviceId(other.getDeviceId());
            this.sync(other.getSync());
            return this;
        }

        @Override
        @JsonSetter(value="device_id")
        public _FinalStage deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        public _FinalStage sync(Boolean sync) {
            this.sync = Optional.of(sync);
            return this;
        }

        @Override
        @JsonSetter(value="sync", nulls=Nulls.SKIP)
        public _FinalStage sync(Optional<Boolean> sync) {
            this.sync = sync;
            return this;
        }

        @Override
        public LocksUnlockDoorRequest build() {
            return new LocksUnlockDoorRequest(this.deviceId, this.sync);
        }
    }

    public static interface _FinalStage {
        public LocksUnlockDoorRequest build();

        public _FinalStage sync(Optional<Boolean> var1);

        public _FinalStage sync(Boolean var1);
    }

    public static interface DeviceIdStage {
        public _FinalStage deviceId(String var1);

        public Builder from(LocksUnlockDoorRequest var1);
    }
}

