/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import com.seam.api.types.DevicePropertiesModel;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class DeviceProperties {
    private final boolean online;
    private final String name;
    private final DevicePropertiesModel model;

    private DeviceProperties(boolean online, String name, DevicePropertiesModel model) {
        this.online = online;
        this.name = name;
        this.model = model;
    }

    @JsonProperty(value="online")
    public boolean getOnline() {
        return this.online;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="model")
    public DevicePropertiesModel getModel() {
        return this.model;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeviceProperties && this.equalTo((DeviceProperties)other);
    }

    private boolean equalTo(DeviceProperties other) {
        return this.online == other.online && this.name.equals(other.name) && this.model.equals(other.model);
    }

    public int hashCode() {
        return Objects.hash(this.online, this.name, this.model);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OnlineStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OnlineStage,
    NameStage,
    ModelStage,
    _FinalStage {
        private boolean online;
        private String name;
        private DevicePropertiesModel model;

        private Builder() {
        }

        @Override
        public Builder from(DeviceProperties other) {
            this.online(other.getOnline());
            this.name(other.getName());
            this.model(other.getModel());
            return this;
        }

        @Override
        @JsonSetter(value="online")
        public NameStage online(boolean online) {
            this.online = online;
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public ModelStage name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @JsonSetter(value="model")
        public _FinalStage model(DevicePropertiesModel model) {
            this.model = model;
            return this;
        }

        @Override
        public DeviceProperties build() {
            return new DeviceProperties(this.online, this.name, this.model);
        }
    }

    public static interface _FinalStage {
        public DeviceProperties build();
    }

    public static interface ModelStage {
        public _FinalStage model(DevicePropertiesModel var1);
    }

    public static interface NameStage {
        public ModelStage name(String var1);
    }

    public static interface OnlineStage {
        public NameStage online(boolean var1);

        public Builder from(DeviceProperties var1);
    }
}

