/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = ThermostatsListResponse.Builder.class)
public final class ThermostatsListResponse {
    private final List<Device> thermostats;

    private final boolean ok;

    private final Map<String, Object> additionalProperties;

    private ThermostatsListResponse(List<Device> thermostats, boolean ok, Map<String, Object> additionalProperties) {
        this.thermostats = thermostats;
        this.ok = ok;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("thermostats")
    public List<Device> getThermostats() {
        return thermostats;
    }

    @JsonProperty("ok")
    public boolean getOk() {
        return ok;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ThermostatsListResponse && equalTo((ThermostatsListResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ThermostatsListResponse other) {
        return thermostats.equals(other.thermostats) && ok == other.ok;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.thermostats, this.ok);
    }

    @Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OkStage builder() {
        return new Builder();
    }

    public interface OkStage {
        _FinalStage ok(boolean ok);

        Builder from(ThermostatsListResponse other);
    }

    public interface _FinalStage {
        ThermostatsListResponse build();

        _FinalStage thermostats(List<Device> thermostats);

        _FinalStage addThermostats(Device thermostats);

        _FinalStage addAllThermostats(List<Device> thermostats);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements OkStage, _FinalStage {
        private boolean ok;

        private List<Device> thermostats = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @Override
        public Builder from(ThermostatsListResponse other) {
            thermostats(other.getThermostats());
            ok(other.getOk());
            return this;
        }

        @Override
        @JsonSetter("ok")
        public _FinalStage ok(boolean ok) {
            this.ok = ok;
            return this;
        }

        @Override
        public _FinalStage addAllThermostats(List<Device> thermostats) {
            this.thermostats.addAll(thermostats);
            return this;
        }

        @Override
        public _FinalStage addThermostats(Device thermostats) {
            this.thermostats.add(thermostats);
            return this;
        }

        @Override
        @JsonSetter(value = "thermostats", nulls = Nulls.SKIP)
        public _FinalStage thermostats(List<Device> thermostats) {
            this.thermostats.clear();
            this.thermostats.addAll(thermostats);
            return this;
        }

        @Override
        public ThermostatsListResponse build() {
            return new ThermostatsListResponse(thermostats, ok, additionalProperties);
        }
    }
}
