/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.clientsessions.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ClientSessionsCreateRequest {
    private final Optional<String> userIdentifierKey;
    private final Optional<List<String>> connectWebviewIds;
    private final Optional<List<String>> connectedAccountIds;
    private final Map<String, Object> additionalProperties;

    private ClientSessionsCreateRequest(Optional<String> userIdentifierKey, Optional<List<String>> connectWebviewIds, Optional<List<String>> connectedAccountIds, Map<String, Object> additionalProperties) {
        this.userIdentifierKey = userIdentifierKey;
        this.connectWebviewIds = connectWebviewIds;
        this.connectedAccountIds = connectedAccountIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="user_identifier_key")
    public Optional<String> getUserIdentifierKey() {
        return this.userIdentifierKey;
    }

    @JsonProperty(value="connect_webview_ids")
    public Optional<List<String>> getConnectWebviewIds() {
        return this.connectWebviewIds;
    }

    @JsonProperty(value="connected_account_ids")
    public Optional<List<String>> getConnectedAccountIds() {
        return this.connectedAccountIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ClientSessionsCreateRequest && this.equalTo((ClientSessionsCreateRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ClientSessionsCreateRequest other) {
        return this.userIdentifierKey.equals(other.userIdentifierKey) && this.connectWebviewIds.equals(other.connectWebviewIds) && this.connectedAccountIds.equals(other.connectedAccountIds);
    }

    public int hashCode() {
        return Objects.hash(this.userIdentifierKey, this.connectWebviewIds, this.connectedAccountIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> userIdentifierKey = Optional.empty();
        private Optional<List<String>> connectWebviewIds = Optional.empty();
        private Optional<List<String>> connectedAccountIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ClientSessionsCreateRequest other) {
            this.userIdentifierKey(other.getUserIdentifierKey());
            this.connectWebviewIds(other.getConnectWebviewIds());
            this.connectedAccountIds(other.getConnectedAccountIds());
            return this;
        }

        @JsonSetter(value="user_identifier_key", nulls=Nulls.SKIP)
        public Builder userIdentifierKey(Optional<String> userIdentifierKey) {
            this.userIdentifierKey = userIdentifierKey;
            return this;
        }

        public Builder userIdentifierKey(String userIdentifierKey) {
            this.userIdentifierKey = Optional.of(userIdentifierKey);
            return this;
        }

        @JsonSetter(value="connect_webview_ids", nulls=Nulls.SKIP)
        public Builder connectWebviewIds(Optional<List<String>> connectWebviewIds) {
            this.connectWebviewIds = connectWebviewIds;
            return this;
        }

        public Builder connectWebviewIds(List<String> connectWebviewIds) {
            this.connectWebviewIds = Optional.of(connectWebviewIds);
            return this;
        }

        @JsonSetter(value="connected_account_ids", nulls=Nulls.SKIP)
        public Builder connectedAccountIds(Optional<List<String>> connectedAccountIds) {
            this.connectedAccountIds = connectedAccountIds;
            return this;
        }

        public Builder connectedAccountIds(List<String> connectedAccountIds) {
            this.connectedAccountIds = Optional.of(connectedAccountIds);
            return this;
        }

        public ClientSessionsCreateRequest build() {
            return new ClientSessionsCreateRequest(this.userIdentifierKey, this.connectWebviewIds, this.connectedAccountIds, this.additionalProperties);
        }
    }
}

