/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.events.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import com.seam.api.types.EventsListRequestBetweenItem;
import com.seam.api.types.EventsListRequestEventType;
import com.seam.api.types.EventsListRequestEventTypesItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class EventsListRequest {
    private final Optional<String> since;
    private final Optional<List<EventsListRequestBetweenItem>> between;
    private final Optional<String> deviceId;
    private final Optional<List<String>> deviceIds;
    private final Optional<String> accessCodeId;
    private final Optional<List<String>> accessCodeIds;
    private final Optional<EventsListRequestEventType> eventType;
    private final Optional<List<EventsListRequestEventTypesItem>> eventTypes;
    private final Optional<String> connectedAccountId;
    private final Map<String, Object> additionalProperties;

    private EventsListRequest(Optional<String> since, Optional<List<EventsListRequestBetweenItem>> between, Optional<String> deviceId, Optional<List<String>> deviceIds, Optional<String> accessCodeId, Optional<List<String>> accessCodeIds, Optional<EventsListRequestEventType> eventType, Optional<List<EventsListRequestEventTypesItem>> eventTypes, Optional<String> connectedAccountId, Map<String, Object> additionalProperties) {
        this.since = since;
        this.between = between;
        this.deviceId = deviceId;
        this.deviceIds = deviceIds;
        this.accessCodeId = accessCodeId;
        this.accessCodeIds = accessCodeIds;
        this.eventType = eventType;
        this.eventTypes = eventTypes;
        this.connectedAccountId = connectedAccountId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="since")
    public Optional<String> getSince() {
        return this.since;
    }

    @JsonProperty(value="between")
    public Optional<List<EventsListRequestBetweenItem>> getBetween() {
        return this.between;
    }

    @JsonProperty(value="device_id")
    public Optional<String> getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="device_ids")
    public Optional<List<String>> getDeviceIds() {
        return this.deviceIds;
    }

    @JsonProperty(value="access_code_id")
    public Optional<String> getAccessCodeId() {
        return this.accessCodeId;
    }

    @JsonProperty(value="access_code_ids")
    public Optional<List<String>> getAccessCodeIds() {
        return this.accessCodeIds;
    }

    @JsonProperty(value="event_type")
    public Optional<EventsListRequestEventType> getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="event_types")
    public Optional<List<EventsListRequestEventTypesItem>> getEventTypes() {
        return this.eventTypes;
    }

    @JsonProperty(value="connected_account_id")
    public Optional<String> getConnectedAccountId() {
        return this.connectedAccountId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EventsListRequest && this.equalTo((EventsListRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EventsListRequest other) {
        return this.since.equals(other.since) && this.between.equals(other.between) && this.deviceId.equals(other.deviceId) && this.deviceIds.equals(other.deviceIds) && this.accessCodeId.equals(other.accessCodeId) && this.accessCodeIds.equals(other.accessCodeIds) && this.eventType.equals(other.eventType) && this.eventTypes.equals(other.eventTypes) && this.connectedAccountId.equals(other.connectedAccountId);
    }

    public int hashCode() {
        return Objects.hash(this.since, this.between, this.deviceId, this.deviceIds, this.accessCodeId, this.accessCodeIds, this.eventType, this.eventTypes, this.connectedAccountId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> since = Optional.empty();
        private Optional<List<EventsListRequestBetweenItem>> between = Optional.empty();
        private Optional<String> deviceId = Optional.empty();
        private Optional<List<String>> deviceIds = Optional.empty();
        private Optional<String> accessCodeId = Optional.empty();
        private Optional<List<String>> accessCodeIds = Optional.empty();
        private Optional<EventsListRequestEventType> eventType = Optional.empty();
        private Optional<List<EventsListRequestEventTypesItem>> eventTypes = Optional.empty();
        private Optional<String> connectedAccountId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(EventsListRequest other) {
            this.since(other.getSince());
            this.between(other.getBetween());
            this.deviceId(other.getDeviceId());
            this.deviceIds(other.getDeviceIds());
            this.accessCodeId(other.getAccessCodeId());
            this.accessCodeIds(other.getAccessCodeIds());
            this.eventType(other.getEventType());
            this.eventTypes(other.getEventTypes());
            this.connectedAccountId(other.getConnectedAccountId());
            return this;
        }

        @JsonSetter(value="since", nulls=Nulls.SKIP)
        public Builder since(Optional<String> since) {
            this.since = since;
            return this;
        }

        public Builder since(String since) {
            this.since = Optional.of(since);
            return this;
        }

        @JsonSetter(value="between", nulls=Nulls.SKIP)
        public Builder between(Optional<List<EventsListRequestBetweenItem>> between) {
            this.between = between;
            return this;
        }

        public Builder between(List<EventsListRequestBetweenItem> between) {
            this.between = Optional.of(between);
            return this;
        }

        @JsonSetter(value="device_id", nulls=Nulls.SKIP)
        public Builder deviceId(Optional<String> deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = Optional.of(deviceId);
            return this;
        }

        @JsonSetter(value="device_ids", nulls=Nulls.SKIP)
        public Builder deviceIds(Optional<List<String>> deviceIds) {
            this.deviceIds = deviceIds;
            return this;
        }

        public Builder deviceIds(List<String> deviceIds) {
            this.deviceIds = Optional.of(deviceIds);
            return this;
        }

        @JsonSetter(value="access_code_id", nulls=Nulls.SKIP)
        public Builder accessCodeId(Optional<String> accessCodeId) {
            this.accessCodeId = accessCodeId;
            return this;
        }

        public Builder accessCodeId(String accessCodeId) {
            this.accessCodeId = Optional.of(accessCodeId);
            return this;
        }

        @JsonSetter(value="access_code_ids", nulls=Nulls.SKIP)
        public Builder accessCodeIds(Optional<List<String>> accessCodeIds) {
            this.accessCodeIds = accessCodeIds;
            return this;
        }

        public Builder accessCodeIds(List<String> accessCodeIds) {
            this.accessCodeIds = Optional.of(accessCodeIds);
            return this;
        }

        @JsonSetter(value="event_type", nulls=Nulls.SKIP)
        public Builder eventType(Optional<EventsListRequestEventType> eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder eventType(EventsListRequestEventType eventType) {
            this.eventType = Optional.of(eventType);
            return this;
        }

        @JsonSetter(value="event_types", nulls=Nulls.SKIP)
        public Builder eventTypes(Optional<List<EventsListRequestEventTypesItem>> eventTypes) {
            this.eventTypes = eventTypes;
            return this;
        }

        public Builder eventTypes(List<EventsListRequestEventTypesItem> eventTypes) {
            this.eventTypes = Optional.of(eventTypes);
            return this;
        }

        @JsonSetter(value="connected_account_id", nulls=Nulls.SKIP)
        public Builder connectedAccountId(Optional<String> connectedAccountId) {
            this.connectedAccountId = connectedAccountId;
            return this;
        }

        public Builder connectedAccountId(String connectedAccountId) {
            this.connectedAccountId = Optional.of(connectedAccountId);
            return this;
        }

        public EventsListRequest build() {
            return new EventsListRequest(this.since, this.between, this.deviceId, this.deviceIds, this.accessCodeId, this.accessCodeIds, this.eventType, this.eventTypes, this.connectedAccountId, this.additionalProperties);
        }
    }
}

