/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import com.seam.api.types.ConnectedAccountCustomMetadataValue;
import com.seam.api.types.ConnectedAccountUserIdentifier;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ConnectedAccount {
    private final Optional<String> connectedAccountId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<ConnectedAccountUserIdentifier> userIdentifier;
    private final Optional<String> accountType;
    private final Optional<Object> errors;
    private final Optional<Object> warnings;
    private final Optional<Map<String, Optional<ConnectedAccountCustomMetadataValue>>> customMetadata;
    private final Map<String, Object> additionalProperties;

    private ConnectedAccount(Optional<String> connectedAccountId, Optional<OffsetDateTime> createdAt, Optional<ConnectedAccountUserIdentifier> userIdentifier, Optional<String> accountType, Optional<Object> errors, Optional<Object> warnings, Optional<Map<String, Optional<ConnectedAccountCustomMetadataValue>>> customMetadata, Map<String, Object> additionalProperties) {
        this.connectedAccountId = connectedAccountId;
        this.createdAt = createdAt;
        this.userIdentifier = userIdentifier;
        this.accountType = accountType;
        this.errors = errors;
        this.warnings = warnings;
        this.customMetadata = customMetadata;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="connected_account_id")
    public Optional<String> getConnectedAccountId() {
        return this.connectedAccountId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="user_identifier")
    public Optional<ConnectedAccountUserIdentifier> getUserIdentifier() {
        return this.userIdentifier;
    }

    @JsonProperty(value="account_type")
    public Optional<String> getAccountType() {
        return this.accountType;
    }

    @JsonProperty(value="errors")
    public Optional<Object> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="warnings")
    public Optional<Object> getWarnings() {
        return this.warnings;
    }

    @JsonProperty(value="custom_metadata")
    public Optional<Map<String, Optional<ConnectedAccountCustomMetadataValue>>> getCustomMetadata() {
        return this.customMetadata;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConnectedAccount && this.equalTo((ConnectedAccount)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConnectedAccount other) {
        return this.connectedAccountId.equals(other.connectedAccountId) && this.createdAt.equals(other.createdAt) && this.userIdentifier.equals(other.userIdentifier) && this.accountType.equals(other.accountType) && this.errors.equals(other.errors) && this.warnings.equals(other.warnings) && this.customMetadata.equals(other.customMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.connectedAccountId, this.createdAt, this.userIdentifier, this.accountType, this.errors, this.warnings, this.customMetadata);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> connectedAccountId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<ConnectedAccountUserIdentifier> userIdentifier = Optional.empty();
        private Optional<String> accountType = Optional.empty();
        private Optional<Object> errors = Optional.empty();
        private Optional<Object> warnings = Optional.empty();
        private Optional<Map<String, Optional<ConnectedAccountCustomMetadataValue>>> customMetadata = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ConnectedAccount other) {
            this.connectedAccountId(other.getConnectedAccountId());
            this.createdAt(other.getCreatedAt());
            this.userIdentifier(other.getUserIdentifier());
            this.accountType(other.getAccountType());
            this.errors(other.getErrors());
            this.warnings(other.getWarnings());
            this.customMetadata(other.getCustomMetadata());
            return this;
        }

        @JsonSetter(value="connected_account_id", nulls=Nulls.SKIP)
        public Builder connectedAccountId(Optional<String> connectedAccountId) {
            this.connectedAccountId = connectedAccountId;
            return this;
        }

        public Builder connectedAccountId(String connectedAccountId) {
            this.connectedAccountId = Optional.of(connectedAccountId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="user_identifier", nulls=Nulls.SKIP)
        public Builder userIdentifier(Optional<ConnectedAccountUserIdentifier> userIdentifier) {
            this.userIdentifier = userIdentifier;
            return this;
        }

        public Builder userIdentifier(ConnectedAccountUserIdentifier userIdentifier) {
            this.userIdentifier = Optional.of(userIdentifier);
            return this;
        }

        @JsonSetter(value="account_type", nulls=Nulls.SKIP)
        public Builder accountType(Optional<String> accountType) {
            this.accountType = accountType;
            return this;
        }

        public Builder accountType(String accountType) {
            this.accountType = Optional.of(accountType);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<Object> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(Object errors) {
            this.errors = Optional.of(errors);
            return this;
        }

        @JsonSetter(value="warnings", nulls=Nulls.SKIP)
        public Builder warnings(Optional<Object> warnings) {
            this.warnings = warnings;
            return this;
        }

        public Builder warnings(Object warnings) {
            this.warnings = Optional.of(warnings);
            return this;
        }

        @JsonSetter(value="custom_metadata", nulls=Nulls.SKIP)
        public Builder customMetadata(Optional<Map<String, Optional<ConnectedAccountCustomMetadataValue>>> customMetadata) {
            this.customMetadata = customMetadata;
            return this;
        }

        public Builder customMetadata(Map<String, Optional<ConnectedAccountCustomMetadataValue>> customMetadata) {
            this.customMetadata = Optional.of(customMetadata);
            return this;
        }

        public ConnectedAccount build() {
            return new ConnectedAccount(this.connectedAccountId, this.createdAt, this.userIdentifier, this.accountType, this.errors, this.warnings, this.customMetadata, this.additionalProperties);
        }
    }
}

