/*
 * Decompiled with CFR 0.152.
 */
package io.github.senthilganeshs.fj.ds;

import io.github.senthilganeshs.fj.ds.Iterable;
import io.github.senthilganeshs.fj.ds.Iterable3;
import io.github.senthilganeshs.fj.ds.Maybe;
import io.github.senthilganeshs.fj.ds.Triple;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;

public interface Iterable2<A, B> {
    public <R, S> Iterable2<R, S> empty();

    public Iterable2<A, B> build(A var1, B var2);

    public <T> T foldl(T var1, TriFunction<T, A, B, T> var2);

    default public Iterable3<Maybe<A>, Maybe<B>, Iterable2<A, B>> unbuild() {
        return Triple.of(Maybe.nothing(), Maybe.nothing(), this.empty());
    }

    public static <R> Iterable2<Iterable<R>, Iterable<R>> goForward(Iterable2<Iterable<R>, Iterable<R>> zipper) {
        return zipper.foldl(zipper.empty(), (t, lhs, rhs) -> lhs.unbuild().flatMap((topM, tail) -> t.build(tail, topM.concat(rhs))));
    }

    public static <R> Iterable2<Iterable<R>, Iterable<R>> goBack(Iterable2<Iterable<R>, Iterable<R>> zipper) {
        return zipper.foldl(zipper.empty(), (t, lhs, rhs) -> rhs.unbuild().flatMap((topM, tail) -> t.build(topM.concat(lhs), tail)));
    }

    default public <T> T foldr(T seed, TriFunction<A, B, T, T> fn) {
        Function res = this.foldl(t -> t, (g, a, b) -> s -> g.apply(fn.apply(a, b, s)));
        return (T)res.apply(seed);
    }

    default public Iterable2<A, B> filter(BiPredicate<A, B> pred) {
        return this.foldl(this.empty(), (i2, a, b) -> pred.test(a, b) ? i2.build(a, b) : i2);
    }

    default public <R, S> Iterable2<R, S> map(Function<A, R> lfn, Function<B, S> rfn) {
        return this.foldl(this.empty(), (i2, a, b) -> i2.build(lfn.apply(a), rfn.apply(b)));
    }

    default public Iterable2<A, B> concat(Iterable2<A, B> first) {
        return this.foldl(first, (i2, a, b) -> i2.build(a, b));
    }

    default public <R, S> Iterable2<R, S> flatMap(BiFunction<A, B, Iterable2<R, S>> fn) {
        return this.foldl(this.empty(), (i2, a, b) -> ((Iterable2)fn.apply(a, b)).concat((Iterable2)i2));
    }

    default public <R, S> Iterable2<R, S> apply(Iterable2<Function<A, R>, Function<B, S>> fns) {
        return fns.flatMap(this::map);
    }

    public static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }
}

