/*
 * Decompiled with CFR 0.152.
 */
package io.github.senthilganeshs.fj.ds;

import io.github.senthilganeshs.fj.ds.Iterable;
import java.util.function.BiFunction;

public interface Maybe<T>
extends Iterable<T> {
    public static final Maybe<Void> NOTHING = new Nothing<Void>();

    public static <R> Maybe<R> nothing() {
        return NOTHING;
    }

    public static <R> Maybe<R> some(R value) {
        return new Some<R>(value);
    }

    public static final class Some<T>
    implements Maybe<T> {
        private T value;

        Some(T value) {
            this.value = value;
        }

        @Override
        public <R> Maybe<R> empty() {
            return Maybe.nothing();
        }

        @Override
        public Maybe<T> build(T input) {
            return new Some<T>(input);
        }

        @Override
        public <R> R foldl(R seed, BiFunction<R, T, R> fn) {
            return fn.apply(seed, this.value);
        }

        public String toString() {
            return "Some (" + this.value + ")";
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other instanceof Some) {
                Some sOther = (Some)other;
                return sOther.value.equals(this.value);
            }
            return false;
        }
    }

    public static final class Nothing<T>
    implements Maybe<T> {
        @Override
        public <R> Maybe<R> empty() {
            return Maybe.nothing();
        }

        @Override
        public Maybe<T> build(T input) {
            return Maybe.some(input);
        }

        @Override
        public <R> R foldl(R seed, BiFunction<R, T, R> fn) {
            return seed;
        }

        public String toString() {
            return "Nothing";
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            return other instanceof Nothing;
        }
    }
}

