/*
 * Decompiled with CFR 0.152.
 */
package io.github.senthilganeshs.fj.ds;

import io.github.senthilganeshs.fj.ds.Iterable3;

public interface Triple<A, B, C>
extends Iterable3<A, B, C> {
    public static final Triple<Void, Void, Void> EMPTY = new Nil<Void, Void, Void>();

    @Override
    public Triple<A, B, C> build(A var1, B var2, C var3);

    public static <A, B, C> Triple<A, B, C> nil() {
        return EMPTY;
    }

    public static <A, B, C> Triple<A, B, C> of(A a, B b, C c) {
        return new Simple<A, B, C>(a, b, c);
    }

    public static final class Simple<A, B, C>
    implements Triple<A, B, C> {
        private final C c;
        private final B b;
        private final A a;

        Simple(A a, B b, C c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        @Override
        public <R, S, T> Iterable3<R, S, T> empty() {
            return Triple.nil();
        }

        @Override
        public <T> T foldl(T seed, Iterable3.QuadFunction<T, A, B, C, T> fn) {
            return fn.apply(seed, this.a, this.b, this.c);
        }

        @Override
        public Triple<A, B, C> build(A a, B b, C c) {
            return new Simple<A, B, C>(a, b, c);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other instanceof Simple) {
                Simple sOther = (Simple)other;
                if (sOther.a.equals(this.a) && sOther.b.equals(this.b)) {
                    return sOther.c.equals(this.c);
                }
            }
            return false;
        }

        public String toString() {
            return String.format("(%s, %s, %s)", this.a, this.b, this.c);
        }
    }

    public static final class Nil<A, B, C>
    implements Triple<A, B, C> {
        @Override
        public <R, S, T> Iterable3<R, S, T> empty() {
            return Triple.nil();
        }

        @Override
        public <T> T foldl(T seed, Iterable3.QuadFunction<T, A, B, C, T> fn) {
            return seed;
        }

        @Override
        public Triple<A, B, C> build(A a, B b, C c) {
            return new Simple<A, B, C>(a, b, c);
        }

        public String toString() {
            return "()";
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            return other instanceof Nil;
        }
    }
}

