/*
 * Decompiled with CFR 0.152.
 */
package io.github.senthilganeshs.fj.ds;

import io.github.senthilganeshs.fj.ds.Iterable2;

public interface Tuple<A, B>
extends Iterable2<A, B> {
    public static final Tuple<Void, Void> EMPTY = new Nil<Void, Void>();

    @Override
    public Tuple<A, B> build(A var1, B var2);

    public Tuple<B, A> swap();

    public static <A, B> Tuple<A, B> nil() {
        return EMPTY;
    }

    public static <A, B> Tuple<A, B> of(A a, B b) {
        return new Simple<A, B>(a, b);
    }

    public static final class Simple<A, B>
    implements Tuple<A, B> {
        private final B b;
        private final A a;

        Simple(A a, B b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public <R, S> Iterable2<R, S> empty() {
            return Tuple.nil();
        }

        @Override
        public <T> T foldl(T seed, Iterable2.TriFunction<T, A, B, T> fn) {
            return fn.apply(seed, this.a, this.b);
        }

        @Override
        public Tuple<A, B> build(A a, B b) {
            return new Simple<A, B>(a, b);
        }

        @Override
        public Tuple<B, A> swap() {
            return new Simple<B, A>(this.b, this.a);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other instanceof Simple) {
                Simple sOther = (Simple)other;
                if (sOther.b.equals(this.b)) {
                    if (sOther.a == null && this.a == null) {
                        return true;
                    }
                    return sOther.a.equals(this.a);
                }
            }
            return false;
        }

        public String toString() {
            return String.format("(%s, %s)", this.a, this.b);
        }
    }

    public static final class Nil<A, B>
    implements Tuple<A, B> {
        @Override
        public <R, S> Iterable2<R, S> empty() {
            return Tuple.nil();
        }

        @Override
        public <T> T foldl(T seed, Iterable2.TriFunction<T, A, B, T> fn) {
            return seed;
        }

        @Override
        public Tuple<A, B> build(A a, B b) {
            return new Simple<A, B>(a, b);
        }

        @Override
        public Tuple<B, A> swap() {
            return new Nil<A, B>();
        }

        public String toString() {
            return "()";
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            return other instanceof Nil;
        }
    }
}

