/*
 * Decompiled with CFR 0.152.
 */
package io.github.shsmysore.fcmjava.client.retry.strategy;

import io.github.shsmysore.fcmjava.client.functional.Action0;
import io.github.shsmysore.fcmjava.client.functional.Func1;
import io.github.shsmysore.fcmjava.client.retry.strategy.IRetryStrategy;
import io.github.shsmysore.fcmjava.exceptions.FcmRetryAfterException;
import java.time.Duration;

public class SimpleRetryStrategy
implements IRetryStrategy {
    private final int maxRetries;

    public SimpleRetryStrategy(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    @Override
    public void doWithRetry(Action0 action) {
        this.getWithRetry(() -> {
            action.invoke();
            return null;
        });
    }

    @Override
    public <TResult> TResult getWithRetry(Func1<TResult> function) {
        int currentRetryCount = 0;
        TResult returnValue = null;
        while (true) {
            try {
                returnValue = function.invoke();
            }
            catch (FcmRetryAfterException e) {
                if (++currentRetryCount == this.maxRetries) {
                    throw e;
                }
                this.internalSleep(e.getRetryDelay());
                if (currentRetryCount <= this.maxRetries) continue;
            }
            break;
        }
        return returnValue;
    }

    private void internalSleep(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

