/*
 * Decompiled with CFR 0.152.
 */
package io.github.shsmysore.fcmjava.client.http.apache;

import io.github.shsmysore.fcmjava.client.http.IHttpClient;
import io.github.shsmysore.fcmjava.client.serializer.IJsonSerializer;
import io.github.shsmysore.fcmjava.client.serializer.JsonSerializer;
import io.github.shsmysore.fcmjava.http.options.IFcmClientSettings;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;

public class DefaultHttpClient
implements IHttpClient {
    private final IFcmClientSettings settings;
    private final IJsonSerializer serializer;
    private static final HttpClient.Builder defaultHttpBuilder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1);
    private final HttpClient client;

    public DefaultHttpClient(IFcmClientSettings settings) {
        this(settings, defaultHttpBuilder);
    }

    public DefaultHttpClient(IFcmClientSettings settings, HttpClient.Builder httpClientBuilder) {
        this(settings, new JsonSerializer(), httpClientBuilder);
    }

    public DefaultHttpClient(IFcmClientSettings settings, IJsonSerializer serializer) {
        this(settings, serializer, defaultHttpBuilder);
    }

    public DefaultHttpClient(IFcmClientSettings settings, IJsonSerializer serializer, HttpClient.Builder httpClientBuilder) {
        if (settings == null) {
            throw new IllegalArgumentException("settings");
        }
        if (httpClientBuilder == null) {
            throw new IllegalArgumentException("httpClientBuilder");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer");
        }
        this.settings = settings;
        this.serializer = serializer;
        this.client = httpClientBuilder.build();
    }

    private <TRequestMessage> HttpRequest buildPostRequest(TRequestMessage requestMessage) {
        String content = this.serializer.serialize(requestMessage);
        return HttpRequest.newBuilder().uri(URI.create("https://fcm.googleapis.com/fcm/send")).header("Content-Type", "application/json").header("Authorization", String.format("key=%s", this.settings.getApiKey())).POST(HttpRequest.BodyPublishers.ofString(content)).build();
    }

    @Override
    public <TRequestMessage, TResponseMessage> CompletableFuture<TResponseMessage> postAsync(TRequestMessage requestMessage, Class<TResponseMessage> responseType) {
        try {
            HttpRequest request = this.buildPostRequest(requestMessage);
            return ((CompletableFuture)this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenApply(responseBody -> this.serializer.deserialize((String)responseBody, responseType));
        }
        catch (Exception e) {
            throw new RuntimeException("Something went wrong.", e);
        }
    }

    @Override
    public <TRequestMessage, TResponseMessage> TResponseMessage postSync(TRequestMessage requestMessage, Class<TResponseMessage> responseType) {
        try {
            HttpRequest request = this.buildPostRequest(requestMessage);
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            return this.serializer.deserialize(response.body(), responseType);
        }
        catch (Exception e) {
            throw new RuntimeException("Something went wrong.", e);
        }
    }
}

