/*
 * Decompiled with CFR 0.152.
 */
package io.github.shsmysore.fcmjava.client;

import io.github.shsmysore.fcmjava.client.http.IHttpClient;
import io.github.shsmysore.fcmjava.client.http.apache.DefaultHttpClient;
import io.github.shsmysore.fcmjava.client.settings.PropertiesBasedSettings;
import io.github.shsmysore.fcmjava.http.client.IFcmClient;
import io.github.shsmysore.fcmjava.http.options.IFcmClientSettings;
import io.github.shsmysore.fcmjava.requests.data.DataMulticastMessage;
import io.github.shsmysore.fcmjava.requests.data.DataUnicastMessage;
import io.github.shsmysore.fcmjava.requests.groups.AddDeviceGroupMessage;
import io.github.shsmysore.fcmjava.requests.groups.CreateDeviceGroupMessage;
import io.github.shsmysore.fcmjava.requests.groups.RemoveDeviceGroupMessage;
import io.github.shsmysore.fcmjava.requests.notification.NotificationMulticastMessage;
import io.github.shsmysore.fcmjava.requests.notification.NotificationUnicastMessage;
import io.github.shsmysore.fcmjava.requests.topic.TopicMulticastMessage;
import io.github.shsmysore.fcmjava.requests.topic.TopicUnicastMessage;
import io.github.shsmysore.fcmjava.responses.CreateDeviceGroupMessageResponse;
import io.github.shsmysore.fcmjava.responses.FcmMessageResponse;
import io.github.shsmysore.fcmjava.responses.TopicMessageResponse;
import java.util.concurrent.CompletableFuture;

public class FcmClient
implements IFcmClient {
    private final IFcmClientSettings settings;
    private final IHttpClient httpClient;

    public FcmClient() {
        this(PropertiesBasedSettings.createFromDefault());
    }

    public FcmClient(IFcmClientSettings settings) {
        this(settings, new DefaultHttpClient(settings));
    }

    public FcmClient(IFcmClientSettings settings, IHttpClient httpClient) {
        if (settings == null) {
            throw new IllegalArgumentException("settings");
        }
        if (httpClient == null) {
            throw new IllegalArgumentException("httpClient");
        }
        this.settings = settings;
        this.httpClient = httpClient;
    }

    public FcmMessageResponse send(DataMulticastMessage message) {
        return this.postSync(message, FcmMessageResponse.class);
    }

    public FcmMessageResponse send(NotificationMulticastMessage notification) {
        return this.postSync(notification, FcmMessageResponse.class);
    }

    public FcmMessageResponse send(DataUnicastMessage message) {
        return this.postSync(message, FcmMessageResponse.class);
    }

    public FcmMessageResponse send(NotificationUnicastMessage notification) {
        return this.postSync(notification, FcmMessageResponse.class);
    }

    public CreateDeviceGroupMessageResponse send(CreateDeviceGroupMessage message) {
        return this.postSync(message, CreateDeviceGroupMessageResponse.class);
    }

    public TopicMessageResponse send(TopicUnicastMessage message) {
        return this.postSync(message, TopicMessageResponse.class);
    }

    public TopicMessageResponse send(TopicMulticastMessage message) {
        return this.postSync(message, TopicMessageResponse.class);
    }

    public void send(RemoveDeviceGroupMessage message) {
        this.postSync(message, Void.class);
    }

    public void send(AddDeviceGroupMessage message) {
        this.postSync(message, Void.class);
    }

    public CompletableFuture<FcmMessageResponse> sendAsync(DataMulticastMessage message) {
        return this.postAsync(message, FcmMessageResponse.class);
    }

    public CompletableFuture<FcmMessageResponse> sendAsync(NotificationMulticastMessage notification) {
        return this.postAsync(notification, FcmMessageResponse.class);
    }

    public CompletableFuture<FcmMessageResponse> sendAsync(DataUnicastMessage message) {
        return this.postAsync(message, FcmMessageResponse.class);
    }

    public CompletableFuture<FcmMessageResponse> sendAsync(NotificationUnicastMessage notification) {
        return this.postAsync(notification, FcmMessageResponse.class);
    }

    public CompletableFuture<CreateDeviceGroupMessageResponse> sendAsync(CreateDeviceGroupMessage message) {
        return this.postAsync(message, CreateDeviceGroupMessageResponse.class);
    }

    public CompletableFuture<TopicMessageResponse> sendAsync(TopicUnicastMessage message) {
        return this.postAsync(message, TopicMessageResponse.class);
    }

    public CompletableFuture<TopicMessageResponse> sendAsync(TopicMulticastMessage message) {
        return this.postAsync(message, TopicMessageResponse.class);
    }

    public CompletableFuture<Void> sendAsync(RemoveDeviceGroupMessage message) {
        return this.postAsync(message, Void.class);
    }

    public CompletableFuture<Void> sendAsync(AddDeviceGroupMessage message) {
        return this.postAsync(message, Void.class);
    }

    protected <TRequestMessage, TResponseMessage> TResponseMessage postSync(TRequestMessage requestMessage, Class<TResponseMessage> responseType) {
        return this.httpClient.postSync(requestMessage, responseType);
    }

    public <TRequestMessage, TResponseMessage> CompletableFuture<TResponseMessage> postAsync(TRequestMessage requestMessage, Class<TResponseMessage> responseType) {
        return this.httpClient.postAsync(requestMessage, responseType);
    }
}

