/*
 * Decompiled with CFR 0.152.
 */
package io.github.shsmysore.fcmjava.client.http.apache;

import io.github.shsmysore.fcmjava.client.http.IHttpClient;
import io.github.shsmysore.fcmjava.client.serializer.IJsonSerializer;
import io.github.shsmysore.fcmjava.client.serializer.JsonSerializer;
import io.github.shsmysore.fcmjava.exceptions.FcmAuthenticationException;
import io.github.shsmysore.fcmjava.exceptions.FcmBadRequestException;
import io.github.shsmysore.fcmjava.exceptions.FcmGeneralException;
import io.github.shsmysore.fcmjava.http.options.IFcmClientSettings;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClient
implements IHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHttpClient.class);
    private final int MAX_RETRY;
    private static final Random random = new Random();
    private final IFcmClientSettings settings;
    private final IJsonSerializer serializer;
    private static final HttpClient.Builder defaultHttpBuilder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1);
    private final HttpClient client;

    public DefaultHttpClient(IFcmClientSettings settings) {
        this(settings, defaultHttpBuilder);
    }

    public DefaultHttpClient(IFcmClientSettings settings, HttpClient.Builder httpClientBuilder) {
        this(settings, new JsonSerializer(), httpClientBuilder, 3);
    }

    public DefaultHttpClient(IFcmClientSettings settings, IJsonSerializer serializer) {
        this(settings, serializer, defaultHttpBuilder, 3);
    }

    public DefaultHttpClient(IFcmClientSettings settings, IJsonSerializer serializer, HttpClient.Builder httpClientBuilder, int maxRetry) {
        if (settings == null) {
            throw new IllegalArgumentException("settings");
        }
        if (httpClientBuilder == null) {
            throw new IllegalArgumentException("httpClientBuilder");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer");
        }
        this.settings = settings;
        this.serializer = serializer;
        this.client = httpClientBuilder.build();
        this.MAX_RETRY = maxRetry;
    }

    private <TRequestMessage> HttpRequest buildPostRequest(TRequestMessage requestMessage) {
        String content = this.serializer.serialize(requestMessage);
        return HttpRequest.newBuilder().uri(URI.create("https://fcm.googleapis.com/fcm/send")).header("Content-Type", "application/json").header("Authorization", String.format("key=%s", this.settings.getApiKey())).POST(HttpRequest.BodyPublishers.ofString(content)).build();
    }

    @Override
    public <TRequestMessage, TResponseMessage> CompletableFuture<TResponseMessage> postAsync(TRequestMessage requestMessage, Class<TResponseMessage> responseType) {
        try {
            HttpRequest request = this.buildPostRequest(requestMessage);
            HttpResponse.BodyHandler<String> handler = HttpResponse.BodyHandlers.ofString();
            return ((CompletableFuture)((CompletableFuture)this.retrySend(this.client, request, handler, 1, null).thenApply(this::evaluateResponse)).thenApply(HttpResponse::body)).thenApply(responseBody -> this.serializer.deserialize((String)responseBody, responseType));
        }
        catch (Exception e) {
            throw new RuntimeException("Something went wrong.", e);
        }
    }

    private <T> CompletableFuture<HttpResponse<T>> retrySend(HttpClient client, HttpRequest request, HttpResponse.BodyHandler<T> handler, int count, HttpResponse<T> resp) {
        if (resp != null && resp.statusCode() < 500 || count > this.MAX_RETRY) {
            return this.toResponse(resp);
        }
        return ((CompletableFuture)((CompletableFuture)client.sendAsync(request, handler).thenApply(Optional::of)).exceptionally(ex -> {
            LOGGER.error("Exception: ", ex);
            return Optional.empty();
        })).thenComposeAsync(res -> {
            if (res.isEmpty()) {
                this.fixedDelay();
            }
            HttpResponse currentResponse = res.orElse(null);
            return this.retrySend(client, request, handler, count + 1, currentResponse);
        });
    }

    private <T> CompletableFuture<HttpResponse<T>> toResponse(HttpResponse<T> resp) {
        if (resp != null) {
            return CompletableFuture.completedFuture(resp);
        }
        LOGGER.error("Failed on all retries.");
        throw new RuntimeException("All retries failed.");
    }

    private void fixedDelay() {
        try {
            long waitMilliSec = random.nextInt(29000) + 1000;
            Thread.sleep(waitMilliSec);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Delay interrupted.");
            throw new RuntimeException("Delay interrupted.");
        }
    }

    private <T> HttpResponse<T> evaluateResponse(HttpResponse<T> resp) {
        if (resp.statusCode() == 401 || resp.statusCode() == 403) {
            throw new FcmAuthenticationException("Unauthorized");
        }
        if (resp.statusCode() == 400) {
            throw new FcmBadRequestException("Bad request");
        }
        if (resp.statusCode() >= 500) {
            throw new FcmGeneralException(resp.statusCode(), "Something went wrong.");
        }
        return resp;
    }

    @Override
    public <TRequestMessage, TResponseMessage> TResponseMessage postSync(TRequestMessage requestMessage, Class<TResponseMessage> responseType) {
        try {
            HttpRequest request = this.buildPostRequest(requestMessage);
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            return this.serializer.deserialize(response.body(), responseType);
        }
        catch (Exception e) {
            throw new RuntimeException("Something went wrong.", e);
        }
    }
}

