/*
 * Decompiled with CFR 0.152.
 */
package io.github.solid.resourcepack.api.material;

import io.github.solid.resourcepack.api.material.MaterialType;
import io.github.solid.resourcepack.material.SolidBlockMaterial;
import io.github.solid.resourcepack.material.SolidItemMaterial;
import io.github.solid.resourcepack.material.SolidMaterial;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.key.Key;
import org.bukkit.Material;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lio/github/solid/resourcepack/api/material/SolidMaterialMapper;", "", "()V", "from", "Lio/github/solid/resourcepack/material/SolidMaterial;", "key", "Lnet/kyori/adventure/key/Key;", "material", "Lorg/bukkit/Material;", "type", "Lio/github/solid/resourcepack/api/material/MaterialType;", "solid-api"})
public final class SolidMaterialMapper {
    @NotNull
    public static final SolidMaterialMapper INSTANCE = new SolidMaterialMapper();

    private SolidMaterialMapper() {
    }

    @ApiStatus.Experimental
    @NotNull
    public final SolidMaterial from(@NotNull Material material) {
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        if (material.isItem()) {
            return SolidItemMaterial.valueOf((String)material.name()).toGeneric();
        }
        if (material.isBlock()) {
            return SolidBlockMaterial.valueOf((String)material.name()).toGeneric();
        }
        throw new IllegalArgumentException("Material " + material + " is not supported");
    }

    @NotNull
    public final SolidMaterial from(@NotNull Key key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = key.value();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value(...)");
        String[] stringArray = new String[]{"/"};
        List split = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String string2 = ((String)CollectionsKt.first((List)split)).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        String type = string2;
        String string3 = ((String)CollectionsKt.last((List)split)).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        String material = string3;
        return this.from(Material.valueOf((String)material), MaterialType.valueOf(type));
    }

    @NotNull
    public final SolidMaterial from(@NotNull Material material, @NotNull MaterialType type) {
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        List returned = new ArrayList();
        if (type == MaterialType.ITEM || type == MaterialType.BOTH) {
            try {
                returned.add(SolidItemMaterial.valueOf((String)material.name()).toGeneric());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (type == MaterialType.BLOCK || type == MaterialType.BOTH) {
            try {
                returned.add(SolidBlockMaterial.valueOf((String)material.name()).toGeneric());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (returned.size() != 1) {
            throw new IllegalArgumentException("Material " + material + " is not supported");
        }
        return (SolidMaterial)CollectionsKt.first((List)returned);
    }
}

