/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative;

import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix3D;
import edu.emory.mathcs.restoretools.Enums;
import edu.emory.mathcs.restoretools.iterative.DoubleCommon3D;
import edu.emory.mathcs.restoretools.iterative.IterativeDeconvolver;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.restoretools.iterative.preconditioner.DoublePreconditioner3D;
import edu.emory.mathcs.restoretools.iterative.preconditioner.FFTDoublePreconditioner3D;
import edu.emory.mathcs.restoretools.iterative.psf.DoublePSFMatrix3D;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.image.ColorModel;

public abstract class AbstractDoubleIterativeDeconvolver3D
implements IterativeDeconvolver {
    protected static final DenseDoubleAlgebra alg = DenseDoubleAlgebra.DEFAULT;
    protected DoubleMatrix3D B;
    protected DoublePSFMatrix3D A;
    protected DoublePreconditioner3D P;
    protected ColorModel cmY;
    protected int bSlices;
    protected int bColumns;
    protected int bRows;
    protected int maxIters;
    protected boolean useThreshold;
    protected double threshold;
    protected boolean showIteration;
    protected boolean logConvergence;
    protected Enums.OutputType output;
    protected String name;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractDoubleIterativeDeconvolver3D(String name, ImagePlus imB, ImagePlus[][][] imPSF, IterativeEnums.PreconditionerType preconditioner, double preconditionerTol, IterativeEnums.BoundaryType boundary, IterativeEnums.ResizingType resizing, Enums.OutputType output, boolean useThreshold, double threshold, int maxIters, boolean showIteration, boolean logConvergence) {
        this.name = name;
        IJ.showStatus((String)(name + ": initialization..."));
        ImageStack isB = imB.getStack();
        ImageProcessor ipB = imB.getProcessor();
        this.cmY = ipB.getColorModel();
        this.bSlices = isB.getSize();
        this.bColumns = ipB.getWidth();
        this.bRows = ipB.getHeight();
        this.B = new DenseDoubleMatrix3D(this.bSlices, this.bRows, this.bColumns);
        this.A = new DoublePSFMatrix3D(imPSF, boundary, resizing, new int[]{this.bSlices, this.bRows, this.bColumns});
        DoubleCommon3D.assignPixelsToMatrix(isB, this.B);
        switch (preconditioner) {
            case FFT: {
                this.P = new FFTDoublePreconditioner3D(this.A, this.B, preconditionerTol);
                break;
            }
            case NONE: {
                this.P = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported preconditioner type.");
            }
        }
        IJ.showStatus((String)(name + ": initialization..."));
        if (output == Enums.OutputType.SAME_AS_SOURCE) {
            if (ipB instanceof ByteProcessor) {
                this.output = Enums.OutputType.BYTE;
            } else if (ipB instanceof ShortProcessor) {
                this.output = Enums.OutputType.SHORT;
            } else {
                if (!(ipB instanceof FloatProcessor)) throw new IllegalArgumentException("Unsupported image type.");
                this.output = Enums.OutputType.FLOAT;
            }
        } else {
            this.output = output;
        }
        this.useThreshold = useThreshold;
        this.threshold = threshold;
        this.maxIters = maxIters;
        this.showIteration = showIteration;
        this.logConvergence = logConvergence;
    }

    public DoublePreconditioner3D getPreconditioner() {
        return this.P;
    }
}

