/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix3D;
import edu.emory.mathcs.restoretools.Enums;
import edu.emory.mathcs.restoretools.iterative.FloatCommon2D;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.StackConverter;
import java.awt.image.ColorModel;
import java.util.concurrent.Future;

public class FloatCommon3D {
    private FloatCommon3D() {
    }

    public static void assignPixelsToMatrix(final ImageStack stack, final FloatMatrix3D X) {
        int slices = X.slices();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && X.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futures = new Future[np];
            int k = slices / np;
            for (int j = 0; j < np; ++j) {
                final int startslice = j * k;
                final int stopslice = j == np - 1 ? slices : startslice + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int s = startslice; s < stopslice; ++s) {
                            ImageProcessor ip = stack.getProcessor(s + 1);
                            FloatCommon2D.assignPixelsToMatrix(X.viewSlice(s), ip);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int s = 0; s < slices; ++s) {
                ImageProcessor ip = stack.getProcessor(s + 1);
                FloatCommon2D.assignPixelsToMatrix(X.viewSlice(s), ip);
            }
        }
    }

    public static void assignPixelsToStack(ImageStack stack, FloatMatrix3D X, ColorModel cmY) {
        int slices = X.slices();
        int rows = X.rows();
        int cols = X.columns();
        for (int s = 0; s < slices; ++s) {
            FloatProcessor ip = new FloatProcessor(cols, rows);
            FloatCommon2D.assignPixelsToProcessor(ip, X.viewSlice(s), cmY);
            stack.addSlice(null, (ImageProcessor)ip, s);
        }
    }

    public static void assignPixelsToStack(ImageStack stack, FloatMatrix3D X, ColorModel cmY, float threshold) {
        int slices = X.slices();
        int rows = X.rows();
        int cols = X.columns();
        for (int s = 0; s < slices; ++s) {
            FloatProcessor ip = new FloatProcessor(cols, rows);
            FloatCommon2D.assignPixelsToProcessor(ip, X.viewSlice(s), cmY, threshold);
            stack.addSlice(null, (ImageProcessor)ip, s);
        }
    }

    public static void assignPixelsToStackPadded(ImageStack stack, FloatMatrix3D X, int slices, int rows, int cols, int sOff, int rOff, int cOff, ColorModel cmY) {
        for (int s = 0; s < slices; ++s) {
            FloatProcessor ip = new FloatProcessor(cols, rows);
            FloatCommon2D.assignPixelsToProcessorPadded(ip, X.viewSlice(s + sOff), rows, cols, rOff, cOff, cmY);
            stack.addSlice(null, (ImageProcessor)ip, s);
        }
    }

    public static void assignPixelsToStackPadded(ImageStack stack, FloatMatrix3D X, int slices, int rows, int cols, int sOff, int rOff, int cOff, ColorModel cmY, float threshold) {
        for (int s = 0; s < slices; ++s) {
            FloatProcessor ip = new FloatProcessor(cols, rows);
            FloatCommon2D.assignPixelsToProcessorPadded(ip, X.viewSlice(s + sOff), rows, cols, rOff, cOff, cmY, threshold);
            stack.addSlice(null, (ImageProcessor)ip, s);
        }
    }

    public static void updatePixelsInStack(ImageStack stack, FloatMatrix3D X, ColorModel cmY) {
        int slices = X.slices();
        for (int s = 0; s < slices; ++s) {
            FloatProcessor ip = (FloatProcessor)stack.getProcessor(s + 1);
            FloatCommon2D.assignPixelsToProcessor(ip, X.viewSlice(s), cmY);
        }
    }

    public static void updatePixelsInStackPadded(ImageStack stack, FloatMatrix3D X, int slices, int rows, int cols, int sOff, int rOff, int cOff, ColorModel cmY, float threshold) {
        for (int s = 0; s < slices; ++s) {
            FloatProcessor ip = (FloatProcessor)stack.getProcessor(s + 1);
            FloatCommon2D.assignPixelsToProcessorPadded(ip, X.viewSlice(s + sOff), rows, cols, rOff, cOff, cmY, threshold);
        }
    }

    public static void updatePixelsInStackPadded(ImageStack stack, FloatMatrix3D X, int slices, int rows, int cols, int sOff, int rOff, int cOff, ColorModel cmY) {
        for (int s = 0; s < slices; ++s) {
            FloatProcessor ip = (FloatProcessor)stack.getProcessor(s + 1);
            FloatCommon2D.assignPixelsToProcessorPadded(ip, X.viewSlice(s + sOff), rows, cols, rOff, cOff, cmY);
        }
    }

    public static void updatePixelsInStack(ImageStack stack, FloatMatrix3D X, ColorModel cmY, float threshold) {
        int slices = X.slices();
        for (int s = 0; s < slices; ++s) {
            FloatProcessor ip = (FloatProcessor)stack.getProcessor(s + 1);
            FloatCommon2D.assignPixelsToProcessor(ip, X.viewSlice(s), cmY, threshold);
        }
    }

    public static void assignPixelsToStack(ImageStack stack, FloatMatrix1D X, int[] xsize3D, ColorModel cmY) {
        int slices = xsize3D[0];
        int rows = xsize3D[1];
        int cols = xsize3D[2];
        int sliceStride = rows * cols;
        for (int s = 0; s < slices; ++s) {
            FloatProcessor ip = new FloatProcessor(cols, rows);
            FloatCommon2D.assignPixelsToProcessor(ip, X.viewPart(s * sliceStride, sliceStride), cmY);
            ip.setColorModel(cmY);
            ip.setMinAndMax(0.0, 0.0);
            stack.addSlice(null, (ImageProcessor)ip, s);
        }
    }

    public static void assignPixelsToStack(ImageStack stack, FloatMatrix1D X, int[] xsize3D, ColorModel cmY, float threshold) {
        int slices = xsize3D[0];
        int rows = xsize3D[1];
        int cols = xsize3D[2];
        int sliceStride = rows * cols;
        for (int s = 0; s < slices; ++s) {
            FloatProcessor ip = new FloatProcessor(cols, rows);
            FloatCommon2D.assignPixelsToProcessor(ip, X.viewPart(s * sliceStride, sliceStride), cmY, threshold);
            ip.setColorModel(cmY);
            ip.setMinAndMax(0.0, 0.0);
            stack.addSlice(null, (ImageProcessor)ip, s);
        }
    }

    public static void updatePixelsInStack(ImageStack stack, FloatMatrix1D X, int[] xsize3D, ColorModel cmY) {
        int slices = xsize3D[0];
        int rows = xsize3D[1];
        int cols = xsize3D[2];
        int sliceStride = rows * cols;
        for (int s = 0; s < slices; ++s) {
            FloatProcessor ip = (FloatProcessor)stack.getProcessor(s + 1);
            FloatCommon2D.assignPixelsToProcessor(ip, X.viewPart(s * sliceStride, sliceStride), cmY);
        }
    }

    public static void updatePixelsInStack(ImageStack stack, FloatMatrix1D X, int[] xsize3D, ColorModel cmY, float threshold) {
        int slices = xsize3D[0];
        int rows = xsize3D[1];
        int cols = xsize3D[2];
        int sliceStride = rows * cols;
        for (int s = 0; s < slices; ++s) {
            FloatProcessor ip = (FloatProcessor)stack.getProcessor(s + 1);
            FloatCommon2D.assignPixelsToProcessor(ip, X.viewPart(s * sliceStride, sliceStride), cmY, threshold);
        }
    }

    public static FloatMatrix3D circShift(FloatMatrix3D PSF, int[] center) {
        int slices = PSF.slices();
        int rows = PSF.rows();
        int cols = PSF.columns();
        int cs = center[0];
        int cr = center[1];
        int cc = center[2];
        DenseFloatMatrix3D P1 = new DenseFloatMatrix3D(slices, rows, cols);
        P1.viewPart(0, 0, 0, slices - cs, rows - cr, cols - cc).assign(PSF.viewPart(cs, cr, cc, slices - cs, rows - cr, cols - cc));
        P1.viewPart(0, rows - cr, 0, slices - cs, cr, cols - cc).assign(PSF.viewPart(cs, 0, cc, slices - cs, cr, cols - cc));
        P1.viewPart(0, 0, cols - cc, slices - cs, rows - cr, cc).assign(PSF.viewPart(cs, cr, 0, slices - cs, rows - cr, cc));
        P1.viewPart(0, rows - cr, cols - cc, slices - cs, cr, cc).assign(PSF.viewPart(cs, 0, 0, slices - cs, cr, cc));
        P1.viewPart(slices - cs, 0, 0, cs, rows - cr, cols - cc).assign(PSF.viewPart(0, cr, cc, cs, rows - cr, cols - cc));
        P1.viewPart(slices - cs, 0, cols - cc, cs, rows - cr, cc).assign(PSF.viewPart(0, cr, 0, cs, rows - cr, cc));
        P1.viewPart(slices - cs, rows - cr, 0, cs, cr, cols - cc).assign(PSF.viewPart(0, 0, cc, cs, cr, cols - cc));
        P1.viewPart(slices - cs, rows - cr, cols - cc, cs, cr, cc).assign(PSF.viewPart(0, 0, 0, cs, cr, cc));
        return P1;
    }

    public static void convertImage(ImagePlus image, Enums.OutputType output) {
        switch (output) {
            case BYTE: {
                new StackConverter(image).convertToGray8();
                break;
            }
            case SHORT: {
                new StackConverter(image).convertToGray16();
                break;
            }
        }
    }

    public static FloatMatrix3D padPeriodic(final FloatMatrix3D X, int slicesPad, final int rowsPad, final int colsPad) {
        final int slices = X.slices();
        final int rows = X.rows();
        final int cols = X.columns();
        if (slices == slicesPad && rows == rowsPad && cols == colsPad) {
            return X;
        }
        DenseFloatMatrix3D Xpad = new DenseFloatMatrix3D(slicesPad, rowsPad, colsPad);
        final int sOff = (slicesPad - slices + 1) / 2;
        final int rOff = (rowsPad - rows + 1) / 2;
        final int cOff = (colsPad - cols + 1) / 2;
        final float[] elemsXpad = (float[])Xpad.elements();
        final int slicesStrideXpad = Xpad.rows() * Xpad.columns();
        final int rowsStrideXpad = Xpad.columns();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (X.isView()) {
            if (np > 1 && X.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                Future[] futures = new Future[np];
                int k = slicesPad / np;
                for (int j = 0; j < np; ++j) {
                    final int startslice = -sOff + j * k;
                    final int stopslice = j == np - 1 ? slicesPad - sOff : startslice + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int s = startslice; s < stopslice; ++s) {
                                int sOut = s + sOff;
                                int sIn = FloatCommon3D.periodic(s, slices);
                                for (int r = -rOff; r < rowsPad - rOff; ++r) {
                                    int rOut = r + rOff;
                                    int rIn = FloatCommon3D.periodic(r, rows);
                                    for (int c = -cOff; c < colsPad - cOff; ++c) {
                                        int cOut = c + cOff;
                                        int cIn = FloatCommon3D.periodic(c, cols);
                                        int idxXpad = sOut * slicesStrideXpad + rOut * rowsStrideXpad + cOut;
                                        elemsXpad[idxXpad] = X.getQuick(sIn, rIn, cIn);
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int s = -sOff; s < slicesPad - sOff; ++s) {
                    int sOut = s + sOff;
                    int sIn = FloatCommon3D.periodic(s, slices);
                    for (int r = -rOff; r < rowsPad - rOff; ++r) {
                        int rOut = r + rOff;
                        int rIn = FloatCommon3D.periodic(r, rows);
                        for (int c = -cOff; c < colsPad - cOff; ++c) {
                            int cOut = c + cOff;
                            int cIn = FloatCommon3D.periodic(c, cols);
                            int idxXpad = sOut * slicesStrideXpad + rOut * rowsStrideXpad + cOut;
                            elemsXpad[idxXpad] = X.getQuick(sIn, rIn, cIn);
                        }
                    }
                }
            }
        } else {
            final float[] elemsX = (float[])X.elements();
            final int slicesStrideX = X.rows() * X.columns();
            final int rowsStrideX = X.columns();
            if (np > 1 && X.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                Future[] futures = new Future[np];
                int k = slicesPad / np;
                for (int j = 0; j < np; ++j) {
                    final int startslice = -sOff + j * k;
                    final int stopslice = j == np - 1 ? slicesPad - sOff : startslice + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int s = startslice; s < stopslice; ++s) {
                                int sOut = s + sOff;
                                int sIn = FloatCommon3D.periodic(s, slices);
                                for (int r = -rOff; r < rowsPad - rOff; ++r) {
                                    int rOut = r + rOff;
                                    int rIn = FloatCommon3D.periodic(r, rows);
                                    for (int c = -cOff; c < colsPad - cOff; ++c) {
                                        int cOut = c + cOff;
                                        int cIn = FloatCommon3D.periodic(c, cols);
                                        int idxX = sIn * slicesStrideX + rIn * rowsStrideX + cIn;
                                        int idxXpad = sOut * slicesStrideXpad + rOut * rowsStrideXpad + cOut;
                                        elemsXpad[idxXpad] = elemsX[idxX];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int s = -sOff; s < slicesPad - sOff; ++s) {
                    int sOut = s + sOff;
                    int sIn = FloatCommon3D.periodic(s, slices);
                    for (int r = -rOff; r < rowsPad - rOff; ++r) {
                        int rOut = r + rOff;
                        int rIn = FloatCommon3D.periodic(r, rows);
                        for (int c = -cOff; c < colsPad - cOff; ++c) {
                            int cOut = c + cOff;
                            int cIn = FloatCommon3D.periodic(c, cols);
                            int idxX = sIn * slicesStrideX + rIn * rowsStrideX + cIn;
                            int idxXpad = sOut * slicesStrideXpad + rOut * rowsStrideXpad + cOut;
                            elemsXpad[idxXpad] = elemsX[idxX];
                        }
                    }
                }
            }
        }
        return Xpad;
    }

    public static FloatMatrix3D padReflexive(final FloatMatrix3D X, int slicesPad, final int rowsPad, final int colsPad) {
        final int slices = X.slices();
        final int rows = X.rows();
        final int cols = X.columns();
        if (slices == slicesPad && rows == rowsPad && cols == colsPad) {
            return X;
        }
        DenseFloatMatrix3D Xpad = new DenseFloatMatrix3D(slicesPad, rowsPad, colsPad);
        final int sOff = (slicesPad - slices + 1) / 2;
        final int rOff = (rowsPad - rows + 1) / 2;
        final int cOff = (colsPad - cols + 1) / 2;
        final float[] elemsXpad = (float[])Xpad.elements();
        final int slicesStrideXpad = Xpad.rows() * Xpad.columns();
        final int rowsStrideXpad = Xpad.columns();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (X.isView()) {
            if (np > 1 && X.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                Future[] futures = new Future[np];
                int k = slicesPad / np;
                for (int j = 0; j < np; ++j) {
                    final int startslice = -sOff + j * k;
                    final int stopslice = j == np - 1 ? slicesPad - sOff : startslice + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int s = startslice; s < stopslice; ++s) {
                                int sOut = s + sOff;
                                int sIn = FloatCommon3D.mirror(s, slices);
                                for (int r = -rOff; r < rowsPad - rOff; ++r) {
                                    int rOut = r + rOff;
                                    int rIn = FloatCommon3D.mirror(r, rows);
                                    for (int c = -cOff; c < colsPad - cOff; ++c) {
                                        int cOut = c + cOff;
                                        int cIn = FloatCommon3D.mirror(c, cols);
                                        int idxXpad = sOut * slicesStrideXpad + rOut * rowsStrideXpad + cOut;
                                        elemsXpad[idxXpad] = X.getQuick(sIn, rIn, cIn);
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int s = -sOff; s < slicesPad - sOff; ++s) {
                    int sOut = s + sOff;
                    int sIn = FloatCommon3D.mirror(s, slices);
                    for (int r = -rOff; r < rowsPad - rOff; ++r) {
                        int rOut = r + rOff;
                        int rIn = FloatCommon3D.mirror(r, rows);
                        for (int c = -cOff; c < colsPad - cOff; ++c) {
                            int cOut = c + cOff;
                            int cIn = FloatCommon3D.mirror(c, cols);
                            int idxXpad = sOut * slicesStrideXpad + rOut * rowsStrideXpad + cOut;
                            elemsXpad[idxXpad] = X.getQuick(sIn, rIn, cIn);
                        }
                    }
                }
            }
        } else {
            final float[] elemsX = (float[])X.elements();
            final int slicesStrideX = X.rows() * X.columns();
            final int rowsStrideX = X.columns();
            if (np > 1 && X.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                Future[] futures = new Future[np];
                int k = slicesPad / np;
                for (int j = 0; j < np; ++j) {
                    final int startslice = -sOff + j * k;
                    final int stopslice = j == np - 1 ? slicesPad - sOff : startslice + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int s = startslice; s < stopslice; ++s) {
                                int sOut = s + sOff;
                                int sIn = FloatCommon3D.mirror(s, slices);
                                for (int r = -rOff; r < rowsPad - rOff; ++r) {
                                    int rOut = r + rOff;
                                    int rIn = FloatCommon3D.mirror(r, rows);
                                    for (int c = -cOff; c < colsPad - cOff; ++c) {
                                        int cOut = c + cOff;
                                        int cIn = FloatCommon3D.mirror(c, cols);
                                        int idxX = sIn * slicesStrideX + rIn * rowsStrideX + cIn;
                                        int idxXpad = sOut * slicesStrideXpad + rOut * rowsStrideXpad + cOut;
                                        elemsXpad[idxXpad] = elemsX[idxX];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int s = -sOff; s < slicesPad - sOff; ++s) {
                    int sOut = s + sOff;
                    int sIn = FloatCommon3D.mirror(s, slices);
                    for (int r = -rOff; r < rowsPad - rOff; ++r) {
                        int rOut = r + rOff;
                        int rIn = FloatCommon3D.mirror(r, rows);
                        for (int c = -cOff; c < colsPad - cOff; ++c) {
                            int cOut = c + cOff;
                            int cIn = FloatCommon3D.mirror(c, cols);
                            int idxX = sIn * slicesStrideX + rIn * rowsStrideX + cIn;
                            int idxXpad = sOut * slicesStrideXpad + rOut * rowsStrideXpad + cOut;
                            elemsXpad[idxXpad] = elemsX[idxX];
                        }
                    }
                }
            }
        }
        return Xpad;
    }

    public static FloatMatrix3D padZero(FloatMatrix3D X, int slicesPad, int rowsPad, int colsPad) {
        int slices = X.slices();
        int rows = X.rows();
        int cols = X.columns();
        if (slices == slicesPad && rows == rowsPad && cols == colsPad) {
            return X;
        }
        int kOff = (slicesPad - slices + 1) / 2;
        int jOff = (rowsPad - rows + 1) / 2;
        int iOff = (colsPad - cols + 1) / 2;
        DenseFloatMatrix3D Xpad = new DenseFloatMatrix3D(slicesPad, rowsPad, colsPad);
        Xpad.viewPart(kOff, jOff, iOff, slices, rows, cols).assign(X);
        return Xpad;
    }

    public static FloatMatrix3D padZero(FloatMatrix3D X, int[] padSize, IterativeEnums.PaddingType padding) {
        if (padSize[0] == 0 && padSize[1] == 0 & padSize[2] == 0) {
            return X;
        }
        DenseFloatMatrix3D Xpad = null;
        switch (padding) {
            case BOTH: {
                Xpad = new DenseFloatMatrix3D(X.slices() + 2 * padSize[0], X.rows() + 2 * padSize[1], X.columns() + 2 * padSize[2]);
                Xpad.viewPart(padSize[0], padSize[1], padSize[2], X.slices(), X.rows(), X.columns()).assign(X);
                break;
            }
            case POST: {
                Xpad = new DenseFloatMatrix3D(X.slices() + padSize[0], X.rows() + padSize[1], X.columns() + padSize[2]);
                Xpad.viewPart(0, 0, 0, X.slices(), X.rows(), X.columns()).assign(X);
                break;
            }
            case PRE: {
                Xpad = new DenseFloatMatrix3D(X.slices() + padSize[0], X.rows() + padSize[1], X.columns() + padSize[2]);
                Xpad.viewPart(padSize[0], padSize[1], padSize[2], X.slices(), X.rows(), X.columns()).assign(X);
            }
        }
        return Xpad;
    }

    private static int mirror(int i, int n) {
        int ip = FloatCommon3D.mod(i, 2 * n);
        if (ip < n) {
            return ip;
        }
        return n - ip % n - 1;
    }

    private static int mod(int i, int n) {
        return (i % n + n) % n;
    }

    private static int periodic(int i, int n) {
        int ip = FloatCommon3D.mod(i, 2 * n);
        if (ip < n) {
            return ip;
        }
        return ip % n;
    }
}

