/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative.cgls;

import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.mathcs.restoretools.Enums;
import edu.emory.mathcs.restoretools.iterative.AbstractFloatIterativeDeconvolver3D;
import edu.emory.mathcs.restoretools.iterative.FloatCommon2D;
import edu.emory.mathcs.restoretools.iterative.FloatCommon3D;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.restoretools.iterative.cgls.CGLSOptions;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;

public class CGLSFloatIterativeDeconvolver3D
extends AbstractFloatIterativeDeconvolver3D {
    protected boolean autoStoppingTol;
    protected float stoppingTol;

    public CGLSFloatIterativeDeconvolver3D(ImagePlus imB, ImagePlus[][][] imPSF, IterativeEnums.PreconditionerType preconditioner, float preconditionerTol, IterativeEnums.BoundaryType boundary, IterativeEnums.ResizingType resizing, Enums.OutputType output, int maxIters, boolean showIteration, CGLSOptions options) {
        super("CGLS", imB, imPSF, preconditioner, preconditionerTol, boundary, resizing, output, options.getUseThreshold(), (float)options.getThreshold(), maxIters, showIteration, options.getLogConvergence());
        this.autoStoppingTol = options.getAutoStoppingTol();
        this.stoppingTol = (float)options.getStoppingTol();
    }

    public ImagePlus deconvolve() {
        int k;
        float gamma;
        float oldgamma = 0.0f;
        if (this.autoStoppingTol) {
            this.stoppingTol = FloatCommon2D.sqrteps * alg.vectorNorm2(this.A.times(this.B, true));
        }
        FloatMatrix3D s = this.A.times(this.B, false);
        s.assign(this.B, FloatFunctions.plusMultFirst((float)-1.0f));
        FloatMatrix3D r = this.A.times(s, true);
        float rnrm = alg.vectorNorm2(r);
        if (this.P != null) {
            r = this.P.solve((AbstractMatrix3D)r, true);
            gamma = alg.vectorNorm2(r);
            gamma *= gamma;
        } else {
            gamma = rnrm;
            gamma *= gamma;
        }
        ImagePlus imX = null;
        ImageStack is = new ImageStack(this.bColumns, this.bRows);
        if (this.showIteration) {
            FloatCommon3D.assignPixelsToStack(is, this.B, this.cmY);
            imX = new ImagePlus("(deblurred)", is);
            imX.show();
        }
        FloatMatrix3D p = r.copy();
        for (k = 0; k < this.maxIters; ++k) {
            FloatMatrix3D q;
            if (rnrm <= this.stoppingTol) {
                IJ.log((String)("CGLS converged after " + k + "iterations."));
                break;
            }
            IJ.showStatus((String)(this.name + "iteration: " + (k + 1) + "/" + this.maxIters));
            if (k >= 1) {
                float beta = gamma / oldgamma;
                p.assign(r, FloatFunctions.plusMultFirst((float)beta));
            }
            if (this.P != null) {
                r = this.P.solve((AbstractMatrix3D)p, false);
                q = this.A.times(r, false);
            } else {
                q = this.A.times(p, false);
            }
            float nq = alg.vectorNorm2(q);
            nq *= nq;
            float alpha = gamma / nq;
            if (this.P != null) {
                this.B.assign(r, FloatFunctions.plusMultSecond((float)alpha));
            } else {
                this.B.assign(p, FloatFunctions.plusMultSecond((float)alpha));
            }
            s.assign(q, FloatFunctions.plusMultSecond((float)(-alpha)));
            r = this.A.times(s, true);
            rnrm = alg.vectorNorm2(r);
            if (this.P != null) {
                r = this.P.solve((AbstractMatrix3D)r, true);
                oldgamma = gamma;
                gamma = alg.vectorNorm2(r);
                gamma *= gamma;
            } else {
                oldgamma = gamma;
                gamma = rnrm;
                gamma *= gamma;
            }
            if (this.logConvergence) {
                IJ.log((String)(k + 1 + ".  Norm of the residual = " + rnrm));
            }
            if (!this.showIteration) continue;
            if (this.useThreshold) {
                FloatCommon3D.updatePixelsInStack(is, this.B, this.cmY, this.threshold);
            } else {
                FloatCommon3D.updatePixelsInStack(is, this.B, this.cmY);
            }
            ImageProcessor ip1 = imX.getProcessor();
            ip1.setMinAndMax(0.0, 0.0);
            ip1.setColorModel(this.cmY);
            imX.updateAndDraw();
        }
        if (this.logConvergence && k == this.maxIters) {
            IJ.log((String)"CGLS didn't converge. Reason: maximum number of iterations performed.");
        }
        if (!this.showIteration) {
            if (this.useThreshold) {
                FloatCommon3D.assignPixelsToStack(is, this.B, this.cmY, this.threshold);
            } else {
                FloatCommon3D.assignPixelsToStack(is, this.B, this.cmY);
            }
            imX = new ImagePlus("(deblurred)", is);
        }
        FloatCommon3D.convertImage(imX, this.output);
        return imX;
    }
}

