/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative.mrnsd;

import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.mathcs.restoretools.Enums;
import edu.emory.mathcs.restoretools.iterative.AbstractFloatIterativeDeconvolver3D;
import edu.emory.mathcs.restoretools.iterative.FloatCommon2D;
import edu.emory.mathcs.restoretools.iterative.FloatCommon3D;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.restoretools.iterative.mrnsd.MRNSDOptions;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;

public class MRNSDFloatIterativeDeconvolver3D
extends AbstractFloatIterativeDeconvolver3D {
    protected boolean autoStoppingTol;
    protected float stoppingTol;

    public MRNSDFloatIterativeDeconvolver3D(ImagePlus imB, ImagePlus[][][] imPSF, IterativeEnums.PreconditionerType preconditioner, float preconditionerTol, IterativeEnums.BoundaryType boundary, IterativeEnums.ResizingType resizing, Enums.OutputType output, int maxIters, boolean showIteration, MRNSDOptions options) {
        super("MRNSD", imB, imPSF, preconditioner, preconditionerTol, boundary, resizing, output, options.getUseThreshold(), (float)options.getThreshold(), maxIters, showIteration, options.getLogConvergence());
        this.autoStoppingTol = options.getAutoStoppingTol();
        this.stoppingTol = (float)options.getStoppingTol();
    }

    public ImagePlus deconvolve() {
        int k;
        float rnrm;
        float gamma;
        float tau;
        float sigsq = tau = FloatCommon2D.sqrteps;
        float[] minAndLoc = this.B.getMinLocation();
        float minB = minAndLoc[0];
        if (minB < 0.0f) {
            this.B.assign(FloatFunctions.plus((float)(-minB + sigsq)));
        }
        if (this.autoStoppingTol) {
            this.stoppingTol = FloatCommon2D.sqrteps * alg.vectorNorm2(this.A.times(this.B, true));
        }
        FloatMatrix3D r = this.A.times(this.B, false);
        r.assign(this.B, FloatFunctions.plusMultFirst((float)-1.0f));
        if (this.P != null) {
            r = this.P.solve((AbstractMatrix3D)r, false);
            r = this.P.solve((AbstractMatrix3D)r, true);
            r = this.A.times(r, true);
            r.assign(FloatFunctions.neg);
            gamma = this.B.aggregate(r, FloatFunctions.plus, FloatFunctions.multSquare);
            rnrm = alg.vectorNorm2(r);
        } else {
            r = this.A.times(r, true);
            r.assign(FloatFunctions.neg);
            gamma = this.B.aggregate(r, FloatFunctions.plus, FloatFunctions.multSquare);
            rnrm = (float)Math.sqrt(gamma);
        }
        ImagePlus imX = null;
        ImageStack is = new ImageStack(this.bColumns, this.bRows);
        if (this.showIteration) {
            FloatCommon3D.assignPixelsToStack(is, this.B, this.cmY);
            imX = new ImagePlus("(deblurred)", is);
            imX.show();
        }
        IntArrayList sliceList = new IntArrayList((int)this.B.size() / 2);
        IntArrayList rowList = new IntArrayList((int)this.B.size() / 2);
        IntArrayList columnList = new IntArrayList((int)this.B.size() / 2);
        FloatArrayList valueList = new FloatArrayList((int)this.B.size() / 2);
        for (k = 0; k < this.maxIters; ++k) {
            if (rnrm <= this.stoppingTol) {
                IJ.log((String)("MRNSD converged after " + k + "iterations."));
                break;
            }
            IJ.showStatus((String)(this.name + " iteration: " + (k + 1) + "/" + this.maxIters));
            FloatMatrix3D s = this.B.copy();
            s.assign(r, FloatFunctions.multNeg);
            FloatMatrix3D u = this.A.times(s, false);
            if (this.P != null) {
                u = this.P.solve((AbstractMatrix3D)u, false);
            }
            float theta = gamma / u.aggregate(FloatFunctions.plus, FloatFunctions.square);
            s.getNegativeValues(sliceList, rowList, columnList, valueList);
            FloatMatrix3D w = this.B.copy();
            w.assign(s, FloatFunctions.divNeg, sliceList, rowList, columnList);
            float alpha = Math.min(theta, w.aggregate(FloatFunctions.min, FloatFunctions.identity, sliceList, rowList, columnList));
            this.B.assign(s, FloatFunctions.plusMultSecond((float)alpha));
            if (this.P != null) {
                w = this.P.solve((AbstractMatrix3D)u, true);
                w = this.A.times(w, true);
                r.assign(w, FloatFunctions.plusMultSecond((float)alpha));
                gamma = this.B.aggregate(r, FloatFunctions.plus, FloatFunctions.multSquare);
                rnrm = alg.vectorNorm2(r);
            } else {
                w = this.A.times(u, true);
                r.assign(w, FloatFunctions.plusMultSecond((float)alpha));
                gamma = this.B.aggregate(r, FloatFunctions.plus, FloatFunctions.multSquare);
                rnrm = (float)Math.sqrt(gamma);
            }
            if (this.logConvergence) {
                IJ.log((String)(k + 1 + ".  Norm of the residual = " + rnrm));
            }
            if (!this.showIteration) continue;
            if (this.useThreshold) {
                FloatCommon3D.updatePixelsInStack(is, this.B, this.cmY, this.threshold);
            } else {
                FloatCommon3D.updatePixelsInStack(is, this.B, this.cmY);
            }
            ImageProcessor ip1 = imX.getProcessor();
            ip1.setMinAndMax(0.0, 0.0);
            ip1.setColorModel(this.cmY);
            imX.updateAndDraw();
        }
        if (this.logConvergence && k == this.maxIters) {
            IJ.log((String)"MRNSD didn't converge. Reason: maximum number of iterations performed.");
        }
        if (!this.showIteration) {
            if (this.useThreshold) {
                FloatCommon3D.assignPixelsToStack(is, this.B, this.cmY, this.threshold);
            } else {
                FloatCommon3D.assignPixelsToStack(is, this.B, this.cmY);
            }
            imX = new ImagePlus("(deblurred)", is);
        }
        FloatCommon3D.convertImage(imX, this.output);
        return imX;
    }
}

