/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative.preconditioner;

import cern.colt.function.tint.IntComparator;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleSorting;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.math.tdouble.DoubleFunctions;
import edu.emory.mathcs.restoretools.iterative.DoubleCommon2D;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.restoretools.iterative.preconditioner.DoublePreconditioner2D;
import edu.emory.mathcs.restoretools.iterative.psf.DoublePSFMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import ij.IJ;
import java.util.concurrent.Future;

public class FFTDoublePreconditioner2D
implements DoublePreconditioner2D {
    private AbstractMatrix2D matdata;
    private double tol;
    private IterativeEnums.BoundaryType boundary;
    private int[] imSize;
    private int[] psfSize;
    private int[] padSize;

    public FFTDoublePreconditioner2D(DoublePSFMatrix2D PSFMatrix, DoubleMatrix2D B, double tol) {
        this.tol = tol;
        this.boundary = PSFMatrix.getBoundary();
        this.imSize = new int[2];
        this.imSize[0] = B.rows();
        this.imSize[1] = B.columns();
        if (PSFMatrix.getType() == IterativeEnums.PSFType.INVARIANT) {
            this.psfSize = PSFMatrix.getInvPsfSize();
            this.padSize = PSFMatrix.getInvPadSize();
        } else {
            this.psfSize = PSFMatrix.getPSF().getSize();
            int[] minimal = new int[]{this.psfSize[0] + this.imSize[0], this.psfSize[1] + this.imSize[1]};
            switch (PSFMatrix.getResizing()) {
                case AUTO: {
                    int[] nextPowTwo = new int[]{!ConcurrencyUtils.isPowerOf2((int)minimal[0]) ? ConcurrencyUtils.nextPow2((int)minimal[0]) : minimal[0], !ConcurrencyUtils.isPowerOf2((int)minimal[1]) ? ConcurrencyUtils.nextPow2((int)minimal[1]) : minimal[1]};
                    if ((double)nextPowTwo[0] >= 1.5 * (double)minimal[0] || (double)nextPowTwo[1] >= 1.5 * (double)minimal[1]) {
                        this.psfSize[0] = minimal[0];
                        this.psfSize[1] = minimal[1];
                        break;
                    }
                    this.psfSize[0] = nextPowTwo[0];
                    this.psfSize[1] = nextPowTwo[1];
                    break;
                }
                case MINIMAL: {
                    this.psfSize[0] = minimal[0];
                    this.psfSize[1] = minimal[1];
                    break;
                }
                case NEXT_POWER_OF_TWO: {
                    this.psfSize[0] = minimal[0];
                    this.psfSize[1] = minimal[1];
                    if (!ConcurrencyUtils.isPowerOf2((int)this.psfSize[0])) {
                        this.psfSize[0] = ConcurrencyUtils.nextPow2((int)this.psfSize[0]);
                    }
                    if (ConcurrencyUtils.isPowerOf2((int)this.psfSize[1])) break;
                    this.psfSize[1] = ConcurrencyUtils.nextPow2((int)this.psfSize[1]);
                }
            }
            this.padSize = new int[2];
            if (this.imSize[0] < this.psfSize[0]) {
                this.padSize[0] = (this.psfSize[0] - this.imSize[0] + 1) / 2;
            }
            if (this.imSize[1] < this.psfSize[1]) {
                this.padSize[1] = (this.psfSize[1] - this.imSize[1] + 1) / 2;
            }
        }
        this.constructMatrix(PSFMatrix.getPSF().getImage(), B, PSFMatrix.getPSF().getCenter());
    }

    public double getTolerance() {
        return this.tol;
    }

    public DoubleMatrix1D solve(DoubleMatrix1D b, boolean transpose) {
        DenseDoubleMatrix2D B = null;
        B = b.isView() ? new DenseDoubleMatrix2D(this.imSize[0], this.imSize[1], (double[])b.copy().elements(), 0, 0, this.imSize[1], 1, false) : new DenseDoubleMatrix2D(this.imSize[0], this.imSize[1], (double[])b.elements(), 0, 0, this.imSize[1], 1, false);
        B = this.solve((AbstractMatrix2D)B, transpose);
        return new DenseDoubleMatrix1D((int)B.size(), (double[])B.elements(), 0, 1, false);
    }

    public DoubleMatrix2D solve(AbstractMatrix2D B, boolean transpose) {
        switch (this.boundary) {
            case ZERO: {
                B = DoubleCommon2D.padZero((DoubleMatrix2D)B, this.psfSize[0], this.psfSize[1]);
                break;
            }
            case PERIODIC: {
                B = DoubleCommon2D.padPeriodic((DoubleMatrix2D)B, this.psfSize[0], this.psfSize[1]);
                break;
            }
            case REFLEXIVE: {
                B = DoubleCommon2D.padReflexive((DoubleMatrix2D)B, this.psfSize[0], this.psfSize[1]);
            }
        }
        B = ((DenseDoubleMatrix2D)B).getFft2();
        if (transpose) {
            ((DComplexMatrix2D)B).assign((DComplexMatrix2D)this.matdata, DComplexFunctions.multConjSecond);
        } else {
            ((DComplexMatrix2D)B).assign((DComplexMatrix2D)this.matdata, DComplexFunctions.mult);
        }
        ((DenseDComplexMatrix2D)B).ifft2(true);
        return ((DComplexMatrix2D)B).viewPart(this.padSize[0], this.padSize[1], this.imSize[0], this.imSize[1]).getRealPart();
    }

    private void constructMatrix(DoubleMatrix2D[][] PSFs, DoubleMatrix2D B, int[][][] center) {
        this.matdata = PSFs[0][0].like();
        int[] center1 = center[0][0];
        int rows = PSFs.length;
        int columns = PSFs[0].length;
        int size = rows * columns;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                ((DoubleMatrix2D)this.matdata).assign(PSFs[r][c], DoubleFunctions.plus);
            }
        }
        if (size != 1) {
            ((DoubleMatrix2D)this.matdata).assign(DoubleFunctions.div((double)size));
        }
        switch (this.boundary) {
            case ZERO: {
                B = DoubleCommon2D.padZero(B, this.psfSize[0], this.psfSize[1]);
                break;
            }
            case PERIODIC: {
                B = DoubleCommon2D.padPeriodic(B, this.psfSize[0], this.psfSize[1]);
                break;
            }
            case REFLEXIVE: {
                B = DoubleCommon2D.padReflexive(B, this.psfSize[0], this.psfSize[1]);
            }
        }
        this.precMatrixOnePsf(center1, B);
    }

    private void precMatrixOnePsf(int[] center, DoubleMatrix2D Bpad) {
        int[] padSize = new int[]{Bpad.rows() - this.matdata.rows(), Bpad.columns() - this.matdata.columns()};
        if (padSize[0] > 0 || padSize[1] > 0) {
            this.matdata = DoubleCommon2D.padZero((DoubleMatrix2D)this.matdata, padSize, IterativeEnums.PaddingType.POST);
        }
        this.matdata = DoubleCommon2D.circShift((DoubleMatrix2D)this.matdata, center);
        this.matdata = ((DenseDoubleMatrix2D)this.matdata).getFft2();
        DComplexMatrix2D E = ((DComplexMatrix2D)this.matdata).copy();
        E.assign(DComplexFunctions.abs);
        E = E.getRealPart();
        double[] maxAndLoc = ((DoubleMatrix2D)E).getMaxLocation();
        final double maxE = maxAndLoc[0];
        if (this.tol == -1.0) {
            IJ.showStatus((String)"Computing tolerance for preconditioner...");
            double[] minAndLoc = ((DoubleMatrix2D)E).getMinLocation();
            double minE = minAndLoc[0];
            this.tol = maxE / minE < 100.0 ? 0.0 : this.defaultTol2((DoubleMatrix2D)E, Bpad);
            IJ.showStatus((String)"Computing tolerance for preconditioner...done.");
        }
        final double[] one = new double[]{1.0, 0.0};
        if (maxE != 1.0) {
            ((DComplexMatrix2D)this.matdata).assign(DComplexFunctions.div((double[])new double[]{maxE, 0.0}));
        }
        int rows = E.rows();
        final int cols = E.columns();
        final double[] elementsE = (double[])((DoubleMatrix2D)E).elements();
        final int zeroE = (int)((DoubleMatrix2D)E).index(0, 0);
        final int rowStrideE = ((DoubleMatrix2D)E).rowStride();
        final int columnStrideE = ((DoubleMatrix2D)E).columnStride();
        final double[] elementsM = (double[])((DComplexMatrix2D)this.matdata).elements();
        final int zeroM = (int)((DComplexMatrix2D)this.matdata).index(0, 0);
        final int rowStrideM = ((DComplexMatrix2D)this.matdata).rowStride();
        final int columnStrideM = ((DComplexMatrix2D)this.matdata).columnStride();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futures = new Future[np];
            int k = rows / np;
            for (int j = 0; j < np; ++j) {
                final int startrow = j * k;
                final int stoprow = j == np - 1 ? rows : startrow + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        double[] elem = new double[2];
                        int idxE = zeroE + startrow * rowStrideE;
                        int idxM = zeroM + startrow * rowStrideM;
                        if (maxE != 1.0) {
                            for (int r = startrow; r < stoprow; ++r) {
                                int iE = idxE;
                                int iM = idxM;
                                for (int c = 0; c < cols; ++c) {
                                    elem[0] = elementsM[iM];
                                    elem[1] = elementsM[iM + 1];
                                    if (elementsE[iE] >= FFTDoublePreconditioner2D.this.tol) {
                                        if (elem[1] != 0.0) {
                                            elem[0] = elem[0] * maxE;
                                            elem[1] = elem[1] * maxE;
                                            double tmp = elem[0] * elem[0] + elem[1] * elem[1];
                                            elem[0] = elem[0] / tmp;
                                            elem[1] = -elem[1] / tmp;
                                        } else {
                                            elem[0] = maxE / elem[0];
                                            elem[1] = 0.0;
                                        }
                                        elementsM[iM] = elem[0];
                                        elementsM[iM + 1] = elem[1];
                                    } else {
                                        elementsM[iM] = one[0];
                                        elementsM[iM + 1] = one[1];
                                    }
                                    iE += columnStrideE;
                                    iM += columnStrideM;
                                }
                                idxE += rowStrideE;
                                idxM += rowStrideM;
                            }
                        } else {
                            for (int r = startrow; r < stoprow; ++r) {
                                int iE = idxE;
                                int iM = idxM;
                                for (int c = 0; c < cols; ++c) {
                                    elem[0] = elementsM[iM];
                                    elem[1] = elementsM[iM + 1];
                                    if (elementsE[iE] >= FFTDoublePreconditioner2D.this.tol) {
                                        if (elem[1] != 0.0) {
                                            double tmp = elem[0] * elem[0] + elem[1] * elem[1];
                                            elem[0] = elem[0] / tmp;
                                            elem[1] = -elem[1] / tmp;
                                        } else {
                                            elem[0] = 1.0 / elem[0];
                                            elem[1] = 0.0;
                                        }
                                        elementsM[iM] = elem[0];
                                        elementsM[iM + 1] = elem[1];
                                    } else {
                                        elementsM[iM] = one[0];
                                        elementsM[iM + 1] = one[1];
                                    }
                                    iE += columnStrideE;
                                    iM += columnStrideM;
                                }
                                idxE += rowStrideE;
                                idxM += rowStrideM;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            double[] elem = new double[2];
            int idxE = zeroE;
            int idxM = zeroM;
            if (maxE != 1.0) {
                for (int r = 0; r < rows; ++r) {
                    int iE = idxE;
                    int iM = idxM;
                    for (int c = 0; c < cols; ++c) {
                        elem[0] = elementsM[iM];
                        elem[1] = elementsM[iM + 1];
                        if (elementsE[iE] >= this.tol) {
                            if (elem[1] != 0.0) {
                                elem[0] = elem[0] * maxE;
                                elem[1] = elem[1] * maxE;
                                double tmp = elem[0] * elem[0] + elem[1] * elem[1];
                                elem[0] = elem[0] / tmp;
                                elem[1] = -elem[1] / tmp;
                            } else {
                                elem[0] = maxE / elem[0];
                                elem[1] = 0.0;
                            }
                            elementsM[iM] = elem[0];
                            elementsM[iM + 1] = elem[1];
                        } else {
                            elementsM[iM] = one[0];
                            elementsM[iM + 1] = one[1];
                        }
                        iE += columnStrideE;
                        iM += columnStrideM;
                    }
                    idxE += rowStrideE;
                    idxM += rowStrideM;
                }
            } else {
                for (int r = 0; r < rows; ++r) {
                    int iE = idxE;
                    int iM = idxM;
                    for (int c = 0; c < cols; ++c) {
                        elem[0] = elementsM[iM];
                        elem[1] = elementsM[iM + 1];
                        if (elementsE[iE] >= this.tol) {
                            if (elem[1] != 0.0) {
                                double tmp = elem[0] * elem[0] + elem[1] * elem[1];
                                elem[0] = elem[0] / tmp;
                                elem[1] = -elem[1] / tmp;
                            } else {
                                elem[0] = 1.0 / elem[0];
                                elem[1] = 0.0;
                            }
                            elementsM[iM] = elem[0];
                            elementsM[iM + 1] = elem[1];
                        } else {
                            elementsM[iM] = one[0];
                            elementsM[iM + 1] = one[1];
                        }
                        iE += columnStrideE;
                        iM += columnStrideM;
                    }
                    idxE += rowStrideE;
                    idxM += rowStrideM;
                }
            }
        }
    }

    private double defaultTol2(DoubleMatrix2D E, DoubleMatrix2D B) {
        int k;
        DenseDoubleMatrix1D s = new DenseDoubleMatrix1D((int)E.size());
        System.arraycopy((double[])E.elements(), 0, (double[])s.elements(), 0, (int)s.size());
        final double[] evalues = (double[])s.elements();
        IntComparator compDec = new IntComparator(){

            public int compare(int a, int b) {
                if (evalues[a] != evalues[a] || evalues[b] != evalues[b]) {
                    return FFTDoublePreconditioner2D.this.compareNaN(evalues[a], evalues[b]);
                }
                return evalues[a] < evalues[b] ? 1 : (evalues[a] == evalues[b] ? 0 : -1);
            }
        };
        int[] indices = DoubleSorting.quickSort.sortIndex((DoubleMatrix1D)s, compDec);
        s = s.viewSelection(indices);
        DenseDComplexMatrix2D Bhat = ((DenseDoubleMatrix2D)B).getFft2();
        ((DComplexMatrix2D)Bhat).assign(DComplexFunctions.abs);
        Bhat = ((DComplexMatrix2D)Bhat).getRealPart();
        DenseDoubleMatrix1D bhat = new DenseDoubleMatrix1D((int)Bhat.size(), (double[])((DoubleMatrix2D)Bhat).elements(), 0, 1, false);
        bhat = bhat.viewSelection(indices);
        bhat.assign(DoubleFunctions.div((double)Math.sqrt(B.size())));
        int n = (int)s.size();
        double[] rho = new double[n - 1];
        rho[n - 2] = bhat.getQuick(n - 1) * bhat.getQuick(n - 1);
        DenseDoubleMatrix1D G = new DenseDoubleMatrix1D(n - 1);
        double[] elemsG = (double[])G.elements();
        elemsG[n - 2] = rho[n - 2];
        for (k = n - 2; k > 0; --k) {
            double bhatel = bhat.getQuick(k);
            rho[k - 1] = rho[k] + bhatel * bhatel;
            double temp1 = n - k;
            temp1 *= temp1;
            elemsG[k - 1] = rho[k - 1] / temp1;
        }
        for (k = 0; k < n - 3; ++k) {
            if (s.getQuick(k) != s.getQuick(k + 1)) continue;
            elemsG[k] = Double.POSITIVE_INFINITY;
        }
        return s.getQuick((int)G.getMinLocation()[1]);
    }

    private final int compareNaN(double a, double b) {
        if (a != a) {
            if (b != b) {
                return 0;
            }
            return 1;
        }
        return -1;
    }
}

