/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative.preconditioner;

import cern.colt.function.tint.IntComparator;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.algo.DoubleSorting;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix3D;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.math.tdouble.DoubleFunctions;
import edu.emory.mathcs.restoretools.iterative.DoubleCommon3D;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.restoretools.iterative.preconditioner.DoublePreconditioner3D;
import edu.emory.mathcs.restoretools.iterative.psf.DoublePSFMatrix3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import ij.IJ;
import java.util.concurrent.Future;

public class FFTDoublePreconditioner3D
implements DoublePreconditioner3D {
    private AbstractMatrix3D matdata;
    private double tol;
    private IterativeEnums.BoundaryType boundary;
    private int[] imSize;
    private int[] psfSize;
    private int[] padSize;

    public FFTDoublePreconditioner3D(DoublePSFMatrix3D PSFMatrix, DoubleMatrix3D B, double tol) {
        this.tol = tol;
        this.boundary = PSFMatrix.getBoundary();
        this.imSize = new int[3];
        this.imSize[0] = B.slices();
        this.imSize[1] = B.rows();
        this.imSize[2] = B.columns();
        if (PSFMatrix.getType() == IterativeEnums.PSFType.INVARIANT) {
            this.psfSize = PSFMatrix.getInvPsfSize();
            this.padSize = PSFMatrix.getInvPadSize();
        } else {
            this.psfSize = PSFMatrix.getPSF().getSize();
            int[] minimal = new int[]{this.psfSize[0] + this.imSize[0], this.psfSize[1] + this.imSize[1], this.psfSize[2] + this.imSize[2]};
            switch (PSFMatrix.getResizing()) {
                case AUTO: {
                    int[] nextPowTwo = new int[]{!ConcurrencyUtils.isPowerOf2((int)minimal[0]) ? ConcurrencyUtils.nextPow2((int)minimal[0]) : minimal[0], !ConcurrencyUtils.isPowerOf2((int)minimal[1]) ? ConcurrencyUtils.nextPow2((int)minimal[1]) : minimal[1], !ConcurrencyUtils.isPowerOf2((int)minimal[2]) ? ConcurrencyUtils.nextPow2((int)minimal[2]) : minimal[2]};
                    if ((double)nextPowTwo[0] >= 1.5 * (double)minimal[0] || (double)nextPowTwo[1] >= 1.5 * (double)minimal[1] || (double)nextPowTwo[2] >= 1.5 * (double)minimal[2]) {
                        this.psfSize[0] = minimal[0];
                        this.psfSize[1] = minimal[1];
                        this.psfSize[2] = minimal[2];
                        break;
                    }
                    this.psfSize[0] = nextPowTwo[0];
                    this.psfSize[1] = nextPowTwo[1];
                    this.psfSize[2] = nextPowTwo[2];
                    break;
                }
                case MINIMAL: {
                    this.psfSize[0] = minimal[0];
                    this.psfSize[1] = minimal[1];
                    this.psfSize[2] = minimal[2];
                    break;
                }
                case NEXT_POWER_OF_TWO: {
                    this.psfSize[0] = minimal[0];
                    this.psfSize[1] = minimal[1];
                    this.psfSize[2] = minimal[2];
                    if (!ConcurrencyUtils.isPowerOf2((int)this.psfSize[0])) {
                        this.psfSize[0] = ConcurrencyUtils.nextPow2((int)this.psfSize[0]);
                    }
                    if (!ConcurrencyUtils.isPowerOf2((int)this.psfSize[1])) {
                        this.psfSize[1] = ConcurrencyUtils.nextPow2((int)this.psfSize[1]);
                    }
                    if (ConcurrencyUtils.isPowerOf2((int)this.psfSize[2])) break;
                    this.psfSize[2] = ConcurrencyUtils.nextPow2((int)this.psfSize[2]);
                }
            }
            this.padSize = new int[3];
            if (this.imSize[0] < this.psfSize[0]) {
                this.padSize[0] = (this.psfSize[0] - this.imSize[0] + 1) / 2;
            }
            if (this.imSize[1] < this.psfSize[1]) {
                this.padSize[1] = (this.psfSize[1] - this.imSize[1] + 1) / 2;
            }
            if (this.imSize[2] < this.psfSize[2]) {
                this.padSize[2] = (this.psfSize[2] - this.imSize[2] + 1) / 2;
            }
        }
        this.constructMatrix(PSFMatrix.getPSF().getImage(), B, PSFMatrix.getPSF().getCenter());
    }

    public double getTolerance() {
        return this.tol;
    }

    public DoubleMatrix1D solve(DoubleMatrix1D b, boolean transpose) {
        DenseDoubleMatrix3D B = null;
        B = b.isView() ? new DenseDoubleMatrix3D(this.imSize[0], this.imSize[1], this.imSize[2], (double[])b.copy().elements(), 0, 0, 0, this.imSize[1] * this.imSize[2], this.imSize[2], 1, false) : new DenseDoubleMatrix3D(this.imSize[0], this.imSize[1], this.imSize[2], (double[])b.elements(), 0, 0, 0, this.imSize[1] * this.imSize[2], this.imSize[2], 1, false);
        B = this.solve((AbstractMatrix3D)B, transpose);
        return new DenseDoubleMatrix1D((int)B.size(), (double[])B.elements(), 0, 1, false);
    }

    public DoubleMatrix3D solve(AbstractMatrix3D B, boolean transpose) {
        switch (this.boundary) {
            case ZERO: {
                B = DoubleCommon3D.padZero((DoubleMatrix3D)B, this.psfSize[0], this.psfSize[1], this.psfSize[2]);
                break;
            }
            case PERIODIC: {
                B = DoubleCommon3D.padPeriodic((DoubleMatrix3D)B, this.psfSize[0], this.psfSize[1], this.psfSize[2]);
                break;
            }
            case REFLEXIVE: {
                B = DoubleCommon3D.padReflexive((DoubleMatrix3D)B, this.psfSize[0], this.psfSize[1], this.psfSize[2]);
            }
        }
        B = ((DenseDoubleMatrix3D)B).getFft3();
        if (transpose) {
            ((DComplexMatrix3D)B).assign((DComplexMatrix3D)this.matdata, DComplexFunctions.multConjSecond);
        } else {
            ((DComplexMatrix3D)B).assign((DComplexMatrix3D)this.matdata, DComplexFunctions.mult);
        }
        ((DenseDComplexMatrix3D)B).ifft3(true);
        return ((DComplexMatrix3D)B).viewPart(this.padSize[0], this.padSize[1], this.padSize[2], this.imSize[0], this.imSize[1], this.imSize[2]).getRealPart();
    }

    private void constructMatrix(DoubleMatrix3D[][][] PSFs, DoubleMatrix3D B, int[][][][] center) {
        this.matdata = PSFs[0][0][0].like();
        int[] center1 = center[0][0][0];
        int slices = PSFs.length;
        int rows = PSFs[0].length;
        int columns = PSFs[0][0].length;
        int size = slices * rows * columns;
        for (int s = 0; s < slices; ++s) {
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < columns; ++c) {
                    ((DoubleMatrix3D)this.matdata).assign(PSFs[s][r][c], DoubleFunctions.plus);
                }
            }
        }
        if (size != 1) {
            ((DoubleMatrix3D)this.matdata).assign(DoubleFunctions.div((double)size));
        }
        switch (this.boundary) {
            case ZERO: {
                B = DoubleCommon3D.padZero(B, this.psfSize[0], this.psfSize[1], this.psfSize[2]);
                break;
            }
            case PERIODIC: {
                B = DoubleCommon3D.padPeriodic(B, this.psfSize[0], this.psfSize[1], this.psfSize[2]);
                break;
            }
            case REFLEXIVE: {
                B = DoubleCommon3D.padReflexive(B, this.psfSize[0], this.psfSize[1], this.psfSize[2]);
            }
        }
        this.precMatrixOnePsf(center1, B);
    }

    private void precMatrixOnePsf(int[] center, DoubleMatrix3D Bpad) {
        int[] padSize = new int[]{Bpad.slices() - this.matdata.slices(), Bpad.rows() - this.matdata.rows(), Bpad.columns() - this.matdata.columns()};
        if (padSize[0] > 0 || padSize[1] > 0 || padSize[2] > 0) {
            this.matdata = DoubleCommon3D.padZero((DoubleMatrix3D)this.matdata, padSize, IterativeEnums.PaddingType.POST);
        }
        this.matdata = DoubleCommon3D.circShift((DoubleMatrix3D)this.matdata, center);
        this.matdata = ((DenseDoubleMatrix3D)this.matdata).getFft3();
        DComplexMatrix3D E = ((DComplexMatrix3D)this.matdata).copy();
        E.assign(DComplexFunctions.abs);
        E = E.getRealPart();
        double[] maxAndLoc = ((DoubleMatrix3D)E).getMaxLocation();
        final double maxE = maxAndLoc[0];
        if (this.tol == -1.0) {
            IJ.showStatus((String)"Computing tolerance for preconditioner...");
            double[] minAndLoc = ((DoubleMatrix3D)E).getMinLocation();
            double minE = minAndLoc[0];
            this.tol = maxE / minE < 100.0 ? 0.0 : this.defaultTol2((DoubleMatrix3D)E, Bpad);
            IJ.showStatus((String)"Computing tolerance for preconditioner...done.");
        }
        final double[] one = new double[]{1.0, 0.0};
        if (maxE != 1.0) {
            ((DComplexMatrix3D)this.matdata).assign(DComplexFunctions.div((double[])new double[]{maxE, 0.0}));
        }
        int slices = E.slices();
        final int rows = E.rows();
        final int cols = E.columns();
        final double[] elementsE = (double[])((DoubleMatrix3D)E).elements();
        final int zeroE = (int)((DoubleMatrix3D)E).index(0, 0, 0);
        final int sliceStrideE = ((DoubleMatrix3D)E).sliceStride();
        final int rowStrideE = ((DoubleMatrix3D)E).rowStride();
        final int columnStrideE = ((DoubleMatrix3D)E).columnStride();
        final double[] elementsM = (double[])((DComplexMatrix3D)this.matdata).elements();
        final int zeroM = (int)((DComplexMatrix3D)this.matdata).index(0, 0, 0);
        final int sliceStrideM = ((DComplexMatrix3D)this.matdata).sliceStride();
        final int rowStrideM = ((DComplexMatrix3D)this.matdata).rowStride();
        final int columnStrideM = ((DComplexMatrix3D)this.matdata).columnStride();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && slices * rows * cols >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futures = new Future[np];
            int k = slices / np;
            for (int j = 0; j < np; ++j) {
                final int startslice = j * k;
                final int stopslice = j == np - 1 ? slices : startslice + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        double[] elem = new double[2];
                        if (maxE != 1.0) {
                            for (int s = startslice; s < stopslice; ++s) {
                                for (int r = 0; r < rows; ++r) {
                                    for (int c = 0; c < cols; ++c) {
                                        int idxE = zeroE + s * sliceStrideE + r * rowStrideE + c * columnStrideE;
                                        int idxM = zeroM + s * sliceStrideM + r * rowStrideM + c * columnStrideM;
                                        elem[0] = elementsM[idxM];
                                        elem[1] = elementsM[idxM + 1];
                                        if (elementsE[idxE] >= FFTDoublePreconditioner3D.this.tol) {
                                            if (elem[1] != 0.0) {
                                                double scalar;
                                                if (Math.abs(elem[0]) >= Math.abs(elem[1])) {
                                                    elem[0] = scalar = 1.0 / (elem[0] + elem[1] * (elem[1] / elem[0]));
                                                    elem[1] = scalar * (-elem[1] / elem[0]);
                                                } else {
                                                    scalar = 1.0 / (elem[0] * (elem[0] / elem[1]) + elem[1]);
                                                    elem[0] = scalar * (elem[0] / elem[1]);
                                                    elem[1] = -scalar;
                                                }
                                            } else {
                                                elem[0] = 1.0 / elem[0];
                                                elem[1] = 0.0;
                                            }
                                            elem[0] = elem[0] * maxE;
                                            elem[1] = elem[1] * maxE;
                                            elementsM[idxM] = elem[0];
                                            elementsM[idxM + 1] = elem[1];
                                            continue;
                                        }
                                        elementsM[idxM] = one[0];
                                        elementsM[idxM + 1] = one[1];
                                    }
                                }
                            }
                        } else {
                            for (int s = startslice; s < stopslice; ++s) {
                                for (int r = 0; r < rows; ++r) {
                                    for (int c = 0; c < cols; ++c) {
                                        int idxE = zeroE + s * sliceStrideE + r * rowStrideE + c * columnStrideE;
                                        int idxM = zeroM + s * sliceStrideM + r * rowStrideM + c * columnStrideM;
                                        elem[0] = elementsM[idxM];
                                        elem[1] = elementsM[idxM + 1];
                                        if (elementsE[idxE] >= FFTDoublePreconditioner3D.this.tol) {
                                            if (elem[1] != 0.0) {
                                                double scalar;
                                                if (Math.abs(elem[0]) >= Math.abs(elem[1])) {
                                                    elem[0] = scalar = 1.0 / (elem[0] + elem[1] * (elem[1] / elem[0]));
                                                    elem[1] = scalar * (-elem[1] / elem[0]);
                                                } else {
                                                    scalar = 1.0 / (elem[0] * (elem[0] / elem[1]) + elem[1]);
                                                    elem[0] = scalar * (elem[0] / elem[1]);
                                                    elem[1] = -scalar;
                                                }
                                            } else {
                                                elem[0] = 1.0 / elem[0];
                                                elem[1] = 0.0;
                                            }
                                            elementsM[idxM] = elem[0];
                                            elementsM[idxM + 1] = elem[1];
                                            continue;
                                        }
                                        elementsM[idxM] = one[0];
                                        elementsM[idxM + 1] = one[1];
                                    }
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            double[] elem = new double[2];
            if (maxE != 1.0) {
                for (int s = 0; s < slices; ++s) {
                    for (int r = 0; r < rows; ++r) {
                        for (int c = 0; c < cols; ++c) {
                            int idxE = zeroE + s * sliceStrideE + r * rowStrideE + c * columnStrideE;
                            int idxM = zeroM + s * sliceStrideM + r * rowStrideM + c * columnStrideM;
                            elem[0] = elementsM[idxM];
                            elem[1] = elementsM[idxM + 1];
                            if (elementsE[idxE] >= this.tol) {
                                if (elem[1] != 0.0) {
                                    double scalar;
                                    if (Math.abs(elem[0]) >= Math.abs(elem[1])) {
                                        elem[0] = scalar = 1.0 / (elem[0] + elem[1] * (elem[1] / elem[0]));
                                        elem[1] = scalar * (-elem[1] / elem[0]);
                                    } else {
                                        scalar = 1.0 / (elem[0] * (elem[0] / elem[1]) + elem[1]);
                                        elem[0] = scalar * (elem[0] / elem[1]);
                                        elem[1] = -scalar;
                                    }
                                } else {
                                    elem[0] = 1.0 / elem[0];
                                    elem[1] = 0.0;
                                }
                                elem[0] = elem[0] * maxE;
                                elem[1] = elem[1] * maxE;
                                elementsM[idxM] = elem[0];
                                elementsM[idxM + 1] = elem[1];
                                continue;
                            }
                            elementsM[idxM] = one[0];
                            elementsM[idxM + 1] = one[1];
                        }
                    }
                }
            } else {
                for (int s = 0; s < slices; ++s) {
                    for (int r = 0; r < rows; ++r) {
                        for (int c = 0; c < cols; ++c) {
                            int idxE = zeroE + s * sliceStrideE + r * rowStrideE + c * columnStrideE;
                            int idxM = zeroM + s * sliceStrideM + r * rowStrideM + c * columnStrideM;
                            elem[0] = elementsM[idxM];
                            elem[1] = elementsM[idxM + 1];
                            if (elementsE[idxE] >= this.tol) {
                                if (elem[1] != 0.0) {
                                    double scalar;
                                    if (Math.abs(elem[0]) >= Math.abs(elem[1])) {
                                        elem[0] = scalar = 1.0 / (elem[0] + elem[1] * (elem[1] / elem[0]));
                                        elem[1] = scalar * (-elem[1] / elem[0]);
                                    } else {
                                        scalar = 1.0 / (elem[0] * (elem[0] / elem[1]) + elem[1]);
                                        elem[0] = scalar * (elem[0] / elem[1]);
                                        elem[1] = -scalar;
                                    }
                                } else {
                                    elem[0] = 1.0 / elem[0];
                                    elem[1] = 0.0;
                                }
                                elementsM[idxM] = elem[0];
                                elementsM[idxM + 1] = elem[1];
                                continue;
                            }
                            elementsM[idxM] = one[0];
                            elementsM[idxM + 1] = one[1];
                        }
                    }
                }
            }
        }
    }

    private double defaultTol2(DoubleMatrix3D E, DoubleMatrix3D B) {
        int k;
        DenseDoubleMatrix1D s = new DenseDoubleMatrix1D((int)E.size());
        System.arraycopy((double[])E.elements(), 0, (double[])s.elements(), 0, (int)s.size());
        final double[] evalues = (double[])s.elements();
        IntComparator compDec = new IntComparator(){

            public int compare(int a, int b) {
                if (evalues[a] != evalues[a] || evalues[b] != evalues[b]) {
                    return FFTDoublePreconditioner3D.this.compareNaN(evalues[a], evalues[b]);
                }
                return evalues[a] < evalues[b] ? 1 : (evalues[a] == evalues[b] ? 0 : -1);
            }
        };
        int[] indices = DoubleSorting.quickSort.sortIndex((DoubleMatrix1D)s, compDec);
        s = s.viewSelection(indices);
        DenseDComplexMatrix3D Bhat = ((DenseDoubleMatrix3D)B).getFft3();
        ((DComplexMatrix3D)Bhat).assign(DComplexFunctions.abs);
        Bhat = ((DComplexMatrix3D)Bhat).getRealPart();
        DenseDoubleMatrix1D bhat = new DenseDoubleMatrix1D((int)Bhat.size(), (double[])((DoubleMatrix3D)Bhat).elements(), 0, 1, false);
        bhat = bhat.viewSelection(indices);
        bhat.assign(DoubleFunctions.div((double)Math.sqrt(B.size())));
        int n = (int)s.size();
        double[] rho = new double[n - 1];
        rho[n - 2] = bhat.getQuick(n - 1) * bhat.getQuick(n - 1);
        DenseDoubleMatrix1D G = new DenseDoubleMatrix1D(n - 1);
        double[] elemsG = (double[])G.elements();
        elemsG[n - 2] = rho[n - 2];
        for (k = n - 2; k > 0; --k) {
            double bhatel = bhat.getQuick(k);
            rho[k - 1] = rho[k] + bhatel * bhatel;
            double temp1 = n - k;
            temp1 *= temp1;
            elemsG[k - 1] = rho[k - 1] / temp1;
        }
        for (k = 0; k < n - 3; ++k) {
            if (s.getQuick(k) != s.getQuick(k + 1)) continue;
            elemsG[k] = Double.POSITIVE_INFINITY;
        }
        return s.getQuick((int)G.getMinLocation()[1]);
    }

    private final int compareNaN(double a, double b) {
        if (a != a) {
            if (b != b) {
                return 0;
            }
            return 1;
        }
        return -1;
    }
}

