/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative.preconditioner;

import cern.colt.function.tint.IntComparator;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatSorting;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexFunctions;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.mathcs.restoretools.iterative.FloatCommon2D;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.restoretools.iterative.preconditioner.FloatPreconditioner2D;
import edu.emory.mathcs.restoretools.iterative.psf.FloatPSFMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import ij.IJ;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class FFTFloatPreconditioner2D
implements FloatPreconditioner2D {
    private AbstractMatrix2D matdata;
    private float tol;
    private IterativeEnums.BoundaryType boundary;
    private int[] imSize;
    private int[] psfSize;
    private int[] padSize;

    public FFTFloatPreconditioner2D(FloatPSFMatrix2D PSFMatrix, FloatMatrix2D B, float tol) {
        this.tol = tol;
        this.boundary = PSFMatrix.getBoundary();
        this.imSize = new int[2];
        this.imSize[0] = B.rows();
        this.imSize[1] = B.columns();
        if (PSFMatrix.getType() == IterativeEnums.PSFType.INVARIANT) {
            this.psfSize = PSFMatrix.getInvPsfSize();
            this.padSize = PSFMatrix.getInvPadSize();
        } else {
            this.psfSize = PSFMatrix.getPSF().getSize();
            int[] minimal = new int[]{this.psfSize[0] + this.imSize[0], this.psfSize[1] + this.imSize[1]};
            switch (PSFMatrix.getResizing()) {
                case AUTO: {
                    int[] nextPowTwo = new int[]{!ConcurrencyUtils.isPowerOf2((int)minimal[0]) ? ConcurrencyUtils.nextPow2((int)minimal[0]) : minimal[0], !ConcurrencyUtils.isPowerOf2((int)minimal[1]) ? ConcurrencyUtils.nextPow2((int)minimal[1]) : minimal[1]};
                    if ((double)nextPowTwo[0] >= 1.5 * (double)minimal[0] || (double)nextPowTwo[1] >= 1.5 * (double)minimal[1]) {
                        this.psfSize[0] = minimal[0];
                        this.psfSize[1] = minimal[1];
                        break;
                    }
                    this.psfSize[0] = nextPowTwo[0];
                    this.psfSize[1] = nextPowTwo[1];
                    break;
                }
                case MINIMAL: {
                    this.psfSize[0] = minimal[0];
                    this.psfSize[1] = minimal[1];
                    break;
                }
                case NEXT_POWER_OF_TWO: {
                    this.psfSize[0] = minimal[0];
                    this.psfSize[1] = minimal[1];
                    if (!ConcurrencyUtils.isPowerOf2((int)this.psfSize[0])) {
                        this.psfSize[0] = ConcurrencyUtils.nextPow2((int)this.psfSize[0]);
                    }
                    if (ConcurrencyUtils.isPowerOf2((int)this.psfSize[1])) break;
                    this.psfSize[1] = ConcurrencyUtils.nextPow2((int)this.psfSize[1]);
                }
            }
            this.padSize = new int[2];
            if (this.imSize[0] < this.psfSize[0]) {
                this.padSize[0] = (this.psfSize[0] - this.imSize[0] + 1) / 2;
            }
            if (this.imSize[1] < this.psfSize[1]) {
                this.padSize[1] = (this.psfSize[1] - this.imSize[1] + 1) / 2;
            }
        }
        this.constructMatrix(PSFMatrix.getPSF().getImage(), B, PSFMatrix.getPSF().getCenter());
    }

    public float getTolerance() {
        return this.tol;
    }

    public FloatMatrix1D solve(FloatMatrix1D b, boolean transpose) {
        DenseFloatMatrix2D B = null;
        B = b.isView() ? new DenseFloatMatrix2D(this.imSize[0], this.imSize[1], (float[])b.copy().elements(), 0, 0, this.imSize[1], 1, false) : new DenseFloatMatrix2D(this.imSize[0], this.imSize[1], (float[])b.elements(), 0, 0, this.imSize[1], 1, false);
        B = this.solve((AbstractMatrix2D)B, transpose);
        return new DenseFloatMatrix1D((int)B.size(), (float[])B.elements(), 0, 1, false);
    }

    public FloatMatrix2D solve(AbstractMatrix2D B, boolean transpose) {
        switch (this.boundary) {
            case ZERO: {
                B = FloatCommon2D.padZero((FloatMatrix2D)B, this.psfSize[0], this.psfSize[1]);
                break;
            }
            case PERIODIC: {
                B = FloatCommon2D.padPeriodic((FloatMatrix2D)B, this.psfSize[0], this.psfSize[1]);
                break;
            }
            case REFLEXIVE: {
                B = FloatCommon2D.padReflexive((FloatMatrix2D)B, this.psfSize[0], this.psfSize[1]);
            }
        }
        B = ((DenseFloatMatrix2D)B).getFft2();
        if (transpose) {
            ((FComplexMatrix2D)B).assign((FComplexMatrix2D)this.matdata, FComplexFunctions.multConjSecond);
        } else {
            ((FComplexMatrix2D)B).assign((FComplexMatrix2D)this.matdata, FComplexFunctions.mult);
        }
        ((DenseFComplexMatrix2D)B).ifft2(true);
        return ((FComplexMatrix2D)B).viewPart(this.padSize[0], this.padSize[1], this.imSize[0], this.imSize[1]).getRealPart();
    }

    private void constructMatrix(FloatMatrix2D[][] PSFs, FloatMatrix2D B, int[][][] center) {
        this.matdata = PSFs[0][0].like();
        int[] center1 = center[0][0];
        int rows = PSFs.length;
        int columns = PSFs[0].length;
        int size = rows * columns;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                ((FloatMatrix2D)this.matdata).assign(PSFs[r][c], FloatFunctions.plus);
            }
        }
        if (size != 1) {
            ((FloatMatrix2D)this.matdata).assign(FloatFunctions.div((float)size));
        }
        switch (this.boundary) {
            case ZERO: {
                B = FloatCommon2D.padZero(B, this.psfSize[0], this.psfSize[1]);
                break;
            }
            case PERIODIC: {
                B = FloatCommon2D.padPeriodic(B, this.psfSize[0], this.psfSize[1]);
                break;
            }
            case REFLEXIVE: {
                B = FloatCommon2D.padReflexive(B, this.psfSize[0], this.psfSize[1]);
            }
        }
        this.precMatrixOnePsf(center1, B);
    }

    private void precMatrixOnePsf(int[] center, FloatMatrix2D Bpad) {
        int[] padSize = new int[]{Bpad.rows() - this.matdata.rows(), Bpad.columns() - this.matdata.columns()};
        if (padSize[0] > 0 || padSize[1] > 0) {
            this.matdata = FloatCommon2D.padZero((FloatMatrix2D)this.matdata, padSize, IterativeEnums.PaddingType.POST);
        }
        this.matdata = FloatCommon2D.circShift((FloatMatrix2D)this.matdata, center);
        this.matdata = ((DenseFloatMatrix2D)this.matdata).getFft2();
        FComplexMatrix2D E = ((FComplexMatrix2D)this.matdata).copy();
        E.assign(FComplexFunctions.abs);
        E = E.getRealPart();
        float[] maxAndLoc = ((FloatMatrix2D)E).getMaxLocation();
        final float maxE = maxAndLoc[0];
        if (this.tol == -1.0f) {
            IJ.showStatus((String)"Computing tolerance for preconditioner...");
            float[] minAndLoc = ((FloatMatrix2D)E).getMinLocation();
            float minE = minAndLoc[0];
            this.tol = maxE / minE < 100.0f ? 0.0f : this.defaultTol2((FloatMatrix2D)E, Bpad);
            IJ.showStatus((String)"Computing tolerance for preconditioner...done.");
        }
        final float[] one = new float[]{1.0f, 0.0f};
        if ((double)maxE != 1.0) {
            ((FComplexMatrix2D)this.matdata).assign(FComplexFunctions.div((float[])new float[]{maxE, 0.0f}));
        }
        int rows = E.rows();
        final int cols = E.columns();
        final float[] elementsE = (float[])((FloatMatrix2D)E).elements();
        final int zeroE = (int)((FloatMatrix2D)E).index(0, 0);
        final int rowStrideE = ((FloatMatrix2D)E).rowStride();
        final int columnStrideE = ((FloatMatrix2D)E).columnStride();
        final float[] elementsM = (float[])((FComplexMatrix2D)this.matdata).elements();
        final int zeroM = (int)((FComplexMatrix2D)this.matdata).index(0, 0);
        final int rowStrideM = ((FComplexMatrix2D)this.matdata).rowStride();
        final int columnStrideM = ((FComplexMatrix2D)this.matdata).columnStride();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            Future[] futures = new Future[np];
            int k = rows / np;
            for (j = 0; j < np; ++j) {
                final int startrow = j * k;
                final int stoprow = j == np - 1 ? rows : startrow + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        float[] elem = new float[2];
                        int idxE = zeroE + startrow * rowStrideE;
                        int idxM = zeroM + startrow * rowStrideM;
                        if ((double)maxE != 1.0) {
                            for (int r = startrow; r < stoprow; ++r) {
                                int iE = idxE;
                                int iM = idxM;
                                for (int c = 0; c < cols; ++c) {
                                    elem[0] = elementsM[iM];
                                    elem[1] = elementsM[iM + 1];
                                    if (elementsE[iE] >= FFTFloatPreconditioner2D.this.tol) {
                                        if ((double)elem[1] != 0.0) {
                                            float scalar;
                                            if (Math.abs(elem[0]) >= Math.abs(elem[1])) {
                                                elem[0] = scalar = (float)(1.0 / (double)(elem[0] + elem[1] * (elem[1] / elem[0])));
                                                elem[1] = scalar * (-elem[1] / elem[0]);
                                            } else {
                                                scalar = (float)(1.0 / (double)(elem[0] * (elem[0] / elem[1]) + elem[1]));
                                                elem[0] = scalar * (elem[0] / elem[1]);
                                                elem[1] = -scalar;
                                            }
                                        } else {
                                            elem[0] = 1.0f / elem[0];
                                            elem[1] = 0.0f;
                                        }
                                        elem[0] = elem[0] * maxE;
                                        elem[1] = elem[1] * maxE;
                                        elementsM[iM] = elem[0];
                                        elementsM[iM + 1] = elem[1];
                                    } else {
                                        elementsM[iM] = one[0];
                                        elementsM[iM + 1] = one[1];
                                    }
                                    iE += columnStrideE;
                                    iM += columnStrideM;
                                }
                                idxE += rowStrideE;
                                idxM += rowStrideM;
                            }
                        } else {
                            for (int r = startrow; r < stoprow; ++r) {
                                int iE = idxE;
                                int iM = idxM;
                                for (int c = 0; c < cols; ++c) {
                                    elem[0] = elementsM[iM];
                                    elem[1] = elementsM[iM + 1];
                                    if (elementsE[iE] >= FFTFloatPreconditioner2D.this.tol) {
                                        elem = FComplex.inv((float[])elem);
                                        elementsM[iM] = elem[0];
                                        elementsM[iM + 1] = elem[1];
                                    } else {
                                        elementsM[iM] = one[0];
                                        elementsM[iM + 1] = one[1];
                                    }
                                    iE += columnStrideE;
                                    iM += columnStrideM;
                                }
                                idxE += rowStrideE;
                                idxM += rowStrideM;
                            }
                        }
                    }
                });
            }
            try {
                for (j = 0; j < np; ++j) {
                    futures[j].get();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            float[] elem = new float[2];
            int idxE = zeroE;
            int idxM = zeroM;
            if ((double)maxE != 1.0) {
                for (int r = 0; r < rows; ++r) {
                    int iE = idxE;
                    int iM = idxM;
                    for (int c = 0; c < cols; ++c) {
                        elem[0] = elementsM[iM];
                        elem[1] = elementsM[iM + 1];
                        if (elementsE[iE] >= this.tol) {
                            if ((double)elem[1] != 0.0) {
                                float scalar;
                                if (Math.abs(elem[0]) >= Math.abs(elem[1])) {
                                    elem[0] = scalar = (float)(1.0 / (double)(elem[0] + elem[1] * (elem[1] / elem[0])));
                                    elem[1] = scalar * (-elem[1] / elem[0]);
                                } else {
                                    scalar = (float)(1.0 / (double)(elem[0] * (elem[0] / elem[1]) + elem[1]));
                                    elem[0] = scalar * (elem[0] / elem[1]);
                                    elem[1] = -scalar;
                                }
                            } else {
                                elem[0] = 1.0f / elem[0];
                                elem[1] = 0.0f;
                            }
                            elem[0] = elem[0] * maxE;
                            elem[1] = elem[1] * maxE;
                            elementsM[iM] = elem[0];
                            elementsM[iM + 1] = elem[1];
                        } else {
                            elementsM[iM] = one[0];
                            elementsM[iM + 1] = one[1];
                        }
                        iE += columnStrideE;
                        iM += columnStrideM;
                    }
                    idxE += rowStrideE;
                    idxM += rowStrideM;
                }
            } else {
                for (int r = 0; r < rows; ++r) {
                    int iE = idxE;
                    int iM = idxM;
                    for (int c = 0; c < cols; ++c) {
                        elem[0] = elementsM[iM];
                        elem[1] = elementsM[iM + 1];
                        if (elementsE[iE] >= this.tol) {
                            elem = FComplex.inv((float[])elem);
                            elementsM[iM] = elem[0];
                            elementsM[iM + 1] = elem[1];
                        } else {
                            elementsM[iM] = one[0];
                            elementsM[iM + 1] = one[1];
                        }
                        iE += columnStrideE;
                        iM += columnStrideM;
                    }
                    idxE += rowStrideE;
                    idxM += rowStrideM;
                }
            }
        }
    }

    private float defaultTol2(FloatMatrix2D E, FloatMatrix2D B) {
        int k;
        DenseFloatMatrix1D s = new DenseFloatMatrix1D((int)E.size());
        System.arraycopy((float[])E.elements(), 0, (float[])s.elements(), 0, (int)s.size());
        final float[] evalues = (float[])s.elements();
        IntComparator compDec = new IntComparator(){

            public int compare(int a, int b) {
                if (evalues[a] != evalues[a] || evalues[b] != evalues[b]) {
                    return FFTFloatPreconditioner2D.this.compareNaN(evalues[a], evalues[b]);
                }
                return evalues[a] < evalues[b] ? 1 : (evalues[a] == evalues[b] ? 0 : -1);
            }
        };
        int[] indices = FloatSorting.quickSort.sortIndex((FloatMatrix1D)s, compDec);
        s = s.viewSelection(indices);
        DenseFComplexMatrix2D Bhat = ((DenseFloatMatrix2D)B).getFft2();
        ((FComplexMatrix2D)Bhat).assign(FComplexFunctions.abs);
        Bhat = ((FComplexMatrix2D)Bhat).getRealPart();
        DenseFloatMatrix1D bhat = new DenseFloatMatrix1D((int)Bhat.size(), (float[])((FloatMatrix2D)Bhat).elements(), 0, 1, false);
        bhat = bhat.viewSelection(indices);
        bhat.assign(FloatFunctions.div((float)((float)Math.sqrt(B.size()))));
        int n = (int)s.size();
        float[] rho = new float[n - 1];
        rho[n - 2] = bhat.getQuick(n - 1) * bhat.getQuick(n - 1);
        DenseFloatMatrix1D G = new DenseFloatMatrix1D(n - 1);
        float[] elemsG = (float[])G.elements();
        elemsG[n - 2] = rho[n - 2];
        for (k = n - 2; k > 0; --k) {
            float bhatel = bhat.getQuick(k);
            rho[k - 1] = rho[k] + bhatel * bhatel;
            float temp1 = n - k;
            temp1 *= temp1;
            elemsG[k - 1] = rho[k - 1] / temp1;
        }
        for (k = 0; k < n - 3; ++k) {
            if (s.getQuick(k) != s.getQuick(k + 1)) continue;
            elemsG[k] = Float.POSITIVE_INFINITY;
        }
        return s.getQuick((int)G.getMinLocation()[1]);
    }

    private final int compareNaN(float a, float b) {
        if (a != a) {
            if (b != b) {
                return 0;
            }
            return 1;
        }
        return -1;
    }
}

