/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative.psf;

import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.math.tdouble.DoubleFunctions;
import edu.emory.mathcs.restoretools.iterative.DoubleCommon2D;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.restoretools.iterative.psf.DoublePSF2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import ij.ImagePlus;

public class DoublePSFMatrix2D {
    private static final long serialVersionUID = -7503394849184235286L;
    private IterativeEnums.BoundaryType boundary;
    private IterativeEnums.ResizingType resizing;
    private IterativeEnums.PSFType type;
    private DoublePSF2D PSF;
    private int[] invPsfSize;
    private int[] invPadSize;
    private int[] varPsfSize;
    private int[] varPadSize;
    private int[] varNregions;
    private int[] varRsize;
    private int[] varPadSize1;
    private RegionIndices varRi;
    private RegionIndices varRiTr;
    private int[] imSize;
    private int[] varEpadSize;
    private RegionIndices varEri;
    private RegionIndices varTri;
    private DComplexMatrix2D[][] matdata;

    public DoublePSFMatrix2D(ImagePlus[][] imPSF, IterativeEnums.BoundaryType boundary, IterativeEnums.ResizingType resizing, int[] imSize) {
        this.PSF = new DoublePSF2D(imPSF);
        this.boundary = boundary;
        this.resizing = resizing;
        this.imSize = new int[2];
        this.imSize[0] = imSize[0];
        this.imSize[1] = imSize[1];
        if (this.PSF.getNumberOfImages() > 1) {
            int j;
            int i;
            this.type = IterativeEnums.PSFType.VARIANT;
            this.varPadSize = new int[2];
            this.varPsfSize = this.PSF.getSize();
            this.varPadSize[0] = (int)Math.round((double)this.varPsfSize[0] / 2.0);
            this.varPadSize[1] = (int)Math.round((double)this.varPsfSize[1] / 2.0);
            this.constructMatrix();
            this.varNregions = new int[2];
            this.varNregions[0] = this.matdata.length;
            this.varNregions[1] = this.matdata[0].length;
            this.varRsize = new int[2];
            this.varRsize[0] = (int)Math.ceil((double)imSize[0] / (double)this.varNregions[0]);
            this.varRsize[1] = (int)Math.ceil((double)imSize[1] / (double)this.varNregions[1]);
            this.varPadSize1 = new int[2];
            this.varPadSize1[0] = this.varRsize[0] * this.varNregions[0] - imSize[0];
            this.varPadSize1[1] = this.varRsize[1] * this.varNregions[1] - imSize[1];
            this.varRi = this.regionIndices(this.varNregions, this.varRsize);
            this.varRiTr = this.regionIndices(this.varNregions, this.varRsize);
            for (i = 0; i < this.varRiTr.iidx.length; ++i) {
                for (j = 0; j < this.varRiTr.iidx[0].length; ++j) {
                    this.varRiTr.iidx[i][j] = this.varRiTr.iidx[i][j] + this.varPadSize[0];
                }
            }
            this.varRiTr.iidx[0][0] = 0;
            this.varRiTr.iidx[this.varRiTr.iidx.length - 1][this.varRiTr.iidx[0].length - 1] = this.varRiTr.iidx[this.varRiTr.iidx.length - 1][this.varRiTr.iidx[0].length - 1] + this.varPadSize[0];
            for (i = 0; i < this.varRiTr.jidx.length; ++i) {
                for (j = 0; j < this.varRiTr.jidx[0].length; ++j) {
                    this.varRiTr.jidx[i][j] = this.varRiTr.jidx[i][j] + this.varPadSize[1];
                }
            }
            this.varRiTr.jidx[0][0] = 0;
            this.varRiTr.jidx[this.varRiTr.jidx.length - 1][this.varRiTr.jidx[0].length - 1] = this.varRiTr.jidx[this.varRiTr.jidx.length - 1][this.varRiTr.jidx[0].length - 1] + this.varPadSize[1];
            this.varEpadSize = new int[2];
            this.varEpadSize[0] = 2 * this.varPadSize[0];
            this.varEpadSize[1] = 2 * this.varPadSize[1];
            this.varEri = this.eregionIndices(this.varRi.iidx, this.varRi.jidx, this.varNregions, this.varEpadSize);
            this.varTri = this.tregionIndices(this.varRiTr.iidx, this.varRiTr.jidx, this.varNregions, this.varPadSize);
        } else {
            this.type = IterativeEnums.PSFType.INVARIANT;
            this.invPsfSize = this.PSF.getSize();
            int[] minimal = new int[]{this.invPsfSize[0] + imSize[0], this.invPsfSize[1] + imSize[1]};
            switch (resizing) {
                case AUTO: {
                    int[] nextPowTwo = new int[]{!ConcurrencyUtils.isPowerOf2((int)minimal[0]) ? ConcurrencyUtils.nextPow2((int)minimal[0]) : minimal[0], !ConcurrencyUtils.isPowerOf2((int)minimal[1]) ? ConcurrencyUtils.nextPow2((int)minimal[1]) : minimal[1]};
                    if ((double)nextPowTwo[0] >= 1.5 * (double)minimal[0] || (double)nextPowTwo[1] >= 1.5 * (double)minimal[1]) {
                        this.invPsfSize[0] = minimal[0];
                        this.invPsfSize[1] = minimal[1];
                        break;
                    }
                    this.invPsfSize[0] = nextPowTwo[0];
                    this.invPsfSize[1] = nextPowTwo[1];
                    break;
                }
                case MINIMAL: {
                    this.invPsfSize[0] = minimal[0];
                    this.invPsfSize[1] = minimal[1];
                    break;
                }
                case NEXT_POWER_OF_TWO: {
                    this.invPsfSize[0] = minimal[0];
                    this.invPsfSize[1] = minimal[1];
                    if (!ConcurrencyUtils.isPowerOf2((int)this.invPsfSize[0])) {
                        this.invPsfSize[0] = ConcurrencyUtils.nextPow2((int)this.invPsfSize[0]);
                    }
                    if (ConcurrencyUtils.isPowerOf2((int)this.invPsfSize[1])) break;
                    this.invPsfSize[1] = ConcurrencyUtils.nextPow2((int)this.invPsfSize[1]);
                }
            }
            this.invPadSize = new int[2];
            if (imSize[0] < this.invPsfSize[0]) {
                this.invPadSize[0] = (this.invPsfSize[0] - imSize[0] + 1) / 2;
            }
            if (imSize[1] < this.invPsfSize[1]) {
                this.invPadSize[1] = (this.invPsfSize[1] - imSize[1] + 1) / 2;
            }
            this.constructMatrix();
        }
    }

    public DoubleMatrix1D times(DoubleMatrix1D b, boolean transpose) {
        DenseDoubleMatrix2D B = null;
        B = b.isView() ? new DenseDoubleMatrix2D(this.imSize[0], this.imSize[1], (double[])b.copy().elements(), 0, 0, this.imSize[1], 1, false) : new DenseDoubleMatrix2D(this.imSize[0], this.imSize[1], (double[])b.elements(), 0, 0, this.imSize[1], 1, false);
        B = this.times((DoubleMatrix2D)B, transpose);
        return new DenseDoubleMatrix1D((int)B.size(), (double[])B.elements(), 0, 1, false);
    }

    public DoubleMatrix2D times(DoubleMatrix2D B, boolean transpose) {
        DoubleMatrix2D Bpad = null;
        switch (this.type) {
            case INVARIANT: {
                switch (this.boundary) {
                    case ZERO: {
                        Bpad = DoubleCommon2D.padZero(B, this.invPsfSize[0], this.invPsfSize[1]);
                        break;
                    }
                    case PERIODIC: {
                        Bpad = DoubleCommon2D.padPeriodic(B, this.invPsfSize[0], this.invPsfSize[1]);
                        break;
                    }
                    case REFLEXIVE: {
                        Bpad = DoubleCommon2D.padReflexive(B, this.invPsfSize[0], this.invPsfSize[1]);
                    }
                }
                return this.invariantMultiply((AbstractMatrix2D)Bpad, transpose);
            }
            case VARIANT: {
                switch (this.boundary) {
                    case ZERO: {
                        Bpad = DoubleCommon2D.padZero(B, this.imSize[0] + 2 * this.varPadSize[0], this.imSize[1] + 2 * this.varPadSize[1]);
                        break;
                    }
                    case REFLEXIVE: {
                        Bpad = DoubleCommon2D.padReflexive(B, this.imSize[0] + 2 * this.varPadSize[0], this.imSize[1] + 2 * this.varPadSize[1]);
                        break;
                    }
                    case PERIODIC: {
                        Bpad = DoubleCommon2D.padPeriodic(B, this.imSize[0] + 2 * this.varPadSize[0], this.imSize[1] + 2 * this.varPadSize[1]);
                    }
                }
                if (transpose) {
                    return this.variantTransposeMultiply(Bpad);
                }
                return this.variantMultiply(Bpad);
            }
        }
        return null;
    }

    public DoublePSF2D getPSF() {
        return this.PSF;
    }

    public int[] getSize() {
        int[] psfSize = this.PSF.getSize();
        psfSize[0] = psfSize[0] * psfSize[0];
        psfSize[1] = psfSize[1] * psfSize[1];
        return psfSize;
    }

    public IterativeEnums.BoundaryType getBoundary() {
        return this.boundary;
    }

    public int[] getInvPsfSize() {
        return this.invPsfSize;
    }

    public int[] getInvPadSize() {
        return this.invPadSize;
    }

    public IterativeEnums.ResizingType getResizing() {
        return this.resizing;
    }

    public IterativeEnums.PSFType getType() {
        return this.type;
    }

    private DoubleMatrix2D invariantMultiply(AbstractMatrix2D Bpad, boolean transpose) {
        Bpad = ((DenseDoubleMatrix2D)Bpad).getFft2();
        if (transpose) {
            ((DComplexMatrix2D)Bpad).assign(this.matdata[0][0], DComplexFunctions.multConjSecond);
        } else {
            ((DComplexMatrix2D)Bpad).assign(this.matdata[0][0], DComplexFunctions.mult);
        }
        ((DenseDComplexMatrix2D)Bpad).ifft2(true);
        return ((DComplexMatrix2D)Bpad).viewPart(this.invPadSize[0], this.invPadSize[1], this.imSize[0], this.imSize[1]).getRealPart();
    }

    private DoubleMatrix2D variantMultiply(DoubleMatrix2D Bpad) {
        if (this.varPadSize1[0] > 0 || this.varPadSize1[1] > 0) {
            Bpad = DoubleCommon2D.padZero(Bpad, this.varPadSize1, IterativeEnums.PaddingType.POST);
        }
        DenseDoubleMatrix2D Y = new DenseDoubleMatrix2D(Bpad.rows(), Bpad.columns());
        for (int i = 0; i < this.varNregions[0]; ++i) {
            for (int j = 0; j < this.varNregions[1]; ++j) {
                DoubleMatrix2D Xt = Bpad.viewPart(this.varEri.iidx[i][0], this.varEri.jidx[j][0], this.varEri.iidx[i][1] - this.varEri.iidx[i][0] + 1, this.varEri.jidx[j][1] - this.varEri.jidx[j][0] + 1);
                DoubleMatrix2D Yt = this.variantMultiplyOnePsf(i, j, Xt, false);
                Y.viewPart(this.varRi.iidx[i][0], this.varRi.jidx[j][0], this.varRi.iidx[i][1] - this.varRi.iidx[i][0] + 1, this.varRi.jidx[j][1] - this.varRi.jidx[j][0] + 1).assign(Yt);
            }
        }
        Y = Y.viewPart(0, 0, this.imSize[0], this.imSize[1]).copy();
        return Y;
    }

    private DoubleMatrix2D variantTransposeMultiply(DoubleMatrix2D Bpad) {
        if (this.varPadSize1[0] > 0 || this.varPadSize1[1] > 0) {
            Bpad = DoubleCommon2D.padZero(Bpad, this.varPadSize1, IterativeEnums.PaddingType.POST);
        }
        DenseDoubleMatrix2D Y = new DenseDoubleMatrix2D(Bpad.rows(), Bpad.columns());
        int[] eregionSize = new int[2];
        for (int i = 0; i < this.varNregions[0]; ++i) {
            for (int j = 0; j < this.varNregions[1]; ++j) {
                eregionSize[0] = this.varEri.iidx[i][1] - this.varEri.iidx[i][0] + 1;
                eregionSize[1] = this.varEri.jidx[j][1] - this.varEri.jidx[j][0] + 1;
                DenseDoubleMatrix2D Xt = new DenseDoubleMatrix2D(eregionSize[0], eregionSize[1]);
                Xt.viewPart(this.varTri.iidx[i][0], this.varTri.jidx[j][0], this.varTri.iidx[i][1] - this.varTri.iidx[i][0] + 1, this.varTri.jidx[j][1] - this.varTri.jidx[j][0] + 1).assign(Bpad.viewPart(this.varRiTr.iidx[i][0], this.varRiTr.jidx[j][0], this.varRiTr.iidx[i][1] - this.varRiTr.iidx[i][0] + 1, this.varRiTr.jidx[j][1] - this.varRiTr.jidx[j][0] + 1));
                Xt = DoubleCommon2D.padZero((DoubleMatrix2D)Xt, this.varPadSize, IterativeEnums.PaddingType.BOTH);
                DoubleMatrix2D Yt = this.variantMultiplyOnePsf(i, j, (DoubleMatrix2D)Xt, true);
                Y.viewPart(this.varEri.iidx[i][0], this.varEri.jidx[j][0], this.varEri.iidx[i][1] - this.varEri.iidx[i][0] + 1, this.varEri.jidx[j][1] - this.varEri.jidx[j][0] + 1).assign(Y.viewPart(this.varEri.iidx[i][0], this.varEri.jidx[j][0], this.varEri.iidx[i][1] - this.varEri.iidx[i][0] + 1, this.varEri.jidx[j][1] - this.varEri.jidx[j][0] + 1).assign(Yt, DoubleFunctions.plus));
            }
        }
        int[][] idx = new int[2][2];
        idx[0][0] = this.varPadSize[0];
        idx[0][1] = this.varPadSize[1];
        idx[1][0] = this.varPadSize[0] + this.imSize[0];
        idx[1][1] = this.varPadSize[1] + this.imSize[1];
        Y = Y.viewPart(idx[0][0], idx[0][1], idx[1][0] - idx[0][0], idx[1][1] - idx[0][1]).copy();
        return Y;
    }

    private DoubleMatrix2D variantMultiplyOnePsf(int row, int col, DoubleMatrix2D X, boolean transpose) {
        int[] imSize = new int[]{X.rows() - 2 * this.varPadSize[0], X.columns() - 2 * this.varPadSize[1]};
        PartitionInfo pi = this.partitionInfo(imSize, this.varPadSize);
        int[] padSize1 = new int[]{pi.rsize[0] * pi.nregions[0] - imSize[0], pi.rsize[1] * pi.nregions[1] - imSize[1]};
        if (padSize1[0] > 0 || padSize1[1] > 0) {
            X = DoubleCommon2D.padZero(X, padSize1, IterativeEnums.PaddingType.POST);
        }
        RegionIndices ri = this.regionIndices(pi.nregions, pi.rsize);
        int[] epadSize = new int[]{2 * this.varPadSize[0], 2 * this.varPadSize[1]};
        RegionIndices eri = this.eregionIndices(ri.iidx, ri.jidx, pi.nregions, epadSize);
        int[][] tidx = new int[2][2];
        tidx[0][0] = this.varPadSize[0];
        tidx[0][1] = this.varPadSize[1];
        tidx[1][0] = this.varPadSize[0] + pi.rsize[0] - 1;
        tidx[1][1] = this.varPadSize[1] + pi.rsize[1] - 1;
        DenseDoubleMatrix2D Y = new DenseDoubleMatrix2D(X.rows(), X.columns());
        for (int i = 0; i < pi.nregions[0]; ++i) {
            for (int j = 0; j < pi.nregions[1]; ++j) {
                DoubleMatrix2D Xt = X.viewPart(eri.iidx[i][0], eri.jidx[j][0], eri.iidx[i][1] - eri.iidx[i][0] + 1, eri.jidx[j][1] - eri.jidx[j][0] + 1);
                DoubleMatrix2D Yt = this.multiplyOneRegion(row, col, (AbstractMatrix2D)Xt, transpose);
                Y.viewPart(ri.iidx[i][0], ri.jidx[j][0], ri.iidx[i][1] - ri.iidx[i][0] + 1, ri.jidx[j][1] - ri.jidx[j][0] + 1).assign(Yt.viewPart(tidx[0][0], tidx[0][1], tidx[1][0] - tidx[0][0] + 1, tidx[1][1] - tidx[0][1] + 1));
            }
        }
        Y = Y.viewPart(0, 0, imSize[0], imSize[1]);
        return Y;
    }

    private DoubleMatrix2D multiplyOneRegion(int row, int col, AbstractMatrix2D X, boolean transpose) {
        int rowsX = X.rows();
        int colsX = X.columns();
        int[] padSize = new int[]{this.matdata[row][col].rows() - rowsX, this.matdata[row][col].columns() - colsX};
        if (padSize[0] > 0 || padSize[1] > 0) {
            X = DoubleCommon2D.padZero((DoubleMatrix2D)X, padSize, IterativeEnums.PaddingType.POST);
        } else if (X.isView()) {
            X = ((DoubleMatrix2D)X).copy();
        }
        X = ((DenseDoubleMatrix2D)X).getFft2();
        if (transpose) {
            ((DComplexMatrix2D)X).assign(this.matdata[row][col], DComplexFunctions.multConjSecond);
        } else {
            ((DComplexMatrix2D)X).assign(this.matdata[row][col], DComplexFunctions.mult);
        }
        ((DenseDComplexMatrix2D)X).ifft2(true);
        X = ((DComplexMatrix2D)X).getRealPart();
        X = ((DoubleMatrix2D)X).viewPart(0, 0, rowsX, colsX);
        return (DoubleMatrix2D)X;
    }

    private PartitionInfo partitionInfo(int[] imSize, int[] padSize) {
        int[] psfSize = new int[]{padSize[0] == 0 ? 1 : 2 * padSize[0], padSize[1] == 0 ? 1 : 2 * padSize[1]};
        PartitionInfo pi = new PartitionInfo();
        pi.rsize[0] = Math.min(psfSize[0], imSize[0]);
        pi.rsize[1] = Math.min(psfSize[1], imSize[1]);
        pi.nregions[0] = (int)Math.ceil((double)imSize[0] / (double)pi.rsize[0]);
        pi.nregions[1] = (int)Math.ceil((double)imSize[1] / (double)pi.rsize[1]);
        return pi;
    }

    private RegionIndices regionIndices(int[] nregions, int[] rsize) {
        int i;
        RegionIndices ri = new RegionIndices(nregions);
        ri.iidx[0][0] = 0;
        ri.iidx[0][1] = rsize[0] - 1;
        ri.jidx[0][0] = 0;
        ri.jidx[0][1] = rsize[1] - 1;
        for (i = 1; i < nregions[0]; ++i) {
            ri.iidx[i][0] = ri.iidx[i - 1][1] + 1;
            ri.iidx[i][1] = ri.iidx[i][0] + rsize[0] - 1;
        }
        for (i = 1; i < nregions[1]; ++i) {
            ri.jidx[i][0] = ri.jidx[i - 1][1] + 1;
            ri.jidx[i][1] = ri.jidx[i][0] + rsize[1] - 1;
        }
        return ri;
    }

    private RegionIndices eregionIndices(int[][] iidx, int[][] jidx, int[] nregions, int[] rsize) {
        int i;
        RegionIndices eri = new RegionIndices(nregions);
        for (i = 0; i < nregions[0]; ++i) {
            eri.iidx[i][0] = iidx[i][0];
            eri.iidx[i][1] = iidx[i][1] + 2 * (int)Math.floor((double)rsize[0] / 2.0);
        }
        for (i = 0; i < nregions[1]; ++i) {
            eri.jidx[i][0] = jidx[i][0];
            eri.jidx[i][1] = jidx[i][1] + 2 * (int)Math.floor((double)rsize[1] / 2.0);
        }
        return eri;
    }

    private RegionIndices tregionIndices(int[][] iidx, int[][] jidx, int[] nregions, int[] padSize) {
        int i;
        RegionIndices tri = new RegionIndices(nregions);
        for (i = 1; i < nregions[0]; ++i) {
            tri.iidx[i][0] = padSize[0];
        }
        for (i = 0; i < nregions[0] - 1; ++i) {
            tri.iidx[i][1] = iidx[0][1];
        }
        tri.iidx[nregions[0] - 1][1] = nregions[0] > 1 ? iidx[0][1] + padSize[0] : iidx[0][1];
        for (i = 1; i < nregions[1]; ++i) {
            tri.jidx[i][0] = padSize[1];
        }
        for (i = 0; i < nregions[1] - 1; ++i) {
            tri.jidx[i][1] = jidx[0][1];
        }
        tri.jidx[nregions[1] - 1][1] = nregions[1] > 1 ? jidx[0][1] + padSize[1] : jidx[0][1];
        return tri;
    }

    private void constructMatrix() {
        DoubleMatrix2D[][] image = this.PSF.getImage();
        int[][][] center = this.PSF.getCenter();
        switch (this.type) {
            case INVARIANT: {
                this.matdata = new DComplexMatrix2D[1][1];
                this.matdata[0][0] = this.onePsfMatrixInvariant(image[0][0], center[0][0]);
                break;
            }
            case VARIANT: {
                this.matdata = new DComplexMatrix2D[image.length][image[0].length];
                for (int i = 0; i < this.matdata.length; ++i) {
                    for (int j = 0; j < this.matdata[0].length; ++j) {
                        this.matdata[i][j] = this.onePsfMatrixVariant(image[i][j], center[i][j]);
                    }
                }
                break;
            }
            default: {
                return;
            }
        }
    }

    private DComplexMatrix2D onePsfMatrixInvariant(DoubleMatrix2D image, int[] center) {
        image.normalize();
        int rows = image.rows();
        int columns = image.columns();
        DenseDoubleMatrix2D matdata = new DenseDoubleMatrix2D(this.invPsfSize[0], this.invPsfSize[1]);
        ((DoubleMatrix2D)matdata).viewPart(0, 0, rows, columns).assign(image);
        matdata = DoubleCommon2D.circShift((DoubleMatrix2D)matdata, center);
        matdata = matdata.getFft2();
        return (DComplexMatrix2D)matdata;
    }

    private DComplexMatrix2D onePsfMatrixVariant(DoubleMatrix2D image, int[] center) {
        image.normalize();
        int columns = 2 * image.columns();
        int rows = 2 * image.rows();
        switch (this.resizing) {
            case AUTO: {
                int[] nextPowTwo = new int[]{!ConcurrencyUtils.isPowerOf2((int)rows) ? ConcurrencyUtils.nextPow2((int)rows) : rows, !ConcurrencyUtils.isPowerOf2((int)columns) ? ConcurrencyUtils.nextPow2((int)columns) : columns};
                if (!((double)nextPowTwo[0] < 1.5 * (double)rows) || !((double)nextPowTwo[1] < 1.5 * (double)columns)) break;
                rows = nextPowTwo[0];
                columns = nextPowTwo[1];
                break;
            }
            case NEXT_POWER_OF_TWO: {
                if (!ConcurrencyUtils.isPowerOf2((int)rows)) {
                    rows = ConcurrencyUtils.nextPow2((int)rows);
                }
                if (ConcurrencyUtils.isPowerOf2((int)columns)) break;
                columns = ConcurrencyUtils.nextPow2((int)columns);
                break;
            }
        }
        DenseDoubleMatrix2D matdata = new DenseDoubleMatrix2D(rows, columns);
        ((DoubleMatrix2D)matdata).viewPart(0, 0, image.rows(), image.columns()).assign(image);
        matdata = DoubleCommon2D.circShift((DoubleMatrix2D)matdata, center);
        matdata = matdata.getFft2();
        return (DComplexMatrix2D)matdata;
    }

    private class RegionIndices {
        public final int[][] iidx;
        public final int[][] jidx;

        public RegionIndices(int[] nregions) {
            this.iidx = new int[nregions[0]][2];
            this.jidx = new int[nregions[1]][2];
        }
    }

    private class PartitionInfo {
        public final int[] nregions = new int[2];
        public final int[] rsize = new int[2];

        private PartitionInfo() {
        }
    }
}

