/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative.wpl;

import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix3D;
import cern.jet.math.tdouble.DoubleFunctions;
import edu.emory.mathcs.restoretools.Enums;
import edu.emory.mathcs.restoretools.iterative.DoubleCommon3D;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.restoretools.iterative.wpl.WPLOptions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.image.ColorModel;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class WPLDoubleIterativeDeconvolver3D {
    protected DoubleMatrix3D B;
    protected DoubleMatrix3D PSF;
    protected ColorModel cmY;
    protected int bSlices;
    protected int bColumns;
    protected int bRows;
    protected int maxIters;
    protected boolean useThreshold;
    protected double threshold;
    protected boolean showIteration;
    protected boolean logConvergence;
    protected Enums.OutputType output;
    private int slices;
    private int columns;
    private int rows;
    private double minB = 0.0;
    private double minPSF = 0.0;
    private double sum;
    private double scalePSF = 1.0;
    private double[][] gweights;
    protected double gamma;
    protected double filterXY;
    protected double filterZ;
    protected boolean normalize;
    protected boolean antiRing;
    protected double changeThreshPercent;
    protected boolean dB;
    protected boolean detectDivergence;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WPLDoubleIterativeDeconvolver3D(ImagePlus imB, ImagePlus imPSF, IterativeEnums.BoundaryType boundary, IterativeEnums.ResizingType resizing, Enums.OutputType output, int maxIters, boolean showIteration, WPLOptions options) {
        IJ.showStatus((String)"WPL initialization...");
        ImageProcessor ipB = imB.getProcessor();
        if (output == Enums.OutputType.SAME_AS_SOURCE) {
            if (ipB instanceof ByteProcessor) {
                this.output = Enums.OutputType.BYTE;
            } else if (ipB instanceof ShortProcessor) {
                this.output = Enums.OutputType.SHORT;
            } else {
                if (!(ipB instanceof FloatProcessor)) throw new IllegalArgumentException("Unsupported image type.");
                this.output = Enums.OutputType.FLOAT;
            }
        } else {
            this.output = output;
        }
        ImageStack isB = imB.getStack();
        this.cmY = ipB.getColorModel();
        this.bSlices = imB.getStackSize();
        this.bColumns = ipB.getWidth();
        this.bRows = ipB.getHeight();
        this.B = new DenseDoubleMatrix3D(this.bSlices, this.bRows, this.bColumns);
        DoubleCommon3D.assignPixelsToMatrix(isB, this.B);
        ImageStack isPSF = imPSF.getStack();
        ImageProcessor ipPSF = imPSF.getProcessor();
        int psfSlices = imPSF.getStackSize();
        int psfColumns = ipPSF.getWidth();
        int psfRows = ipPSF.getHeight();
        this.PSF = new DenseDoubleMatrix3D(psfSlices, psfRows, psfColumns);
        DoubleCommon3D.assignPixelsToMatrix(isPSF, this.PSF);
        this.maxIters = maxIters;
        this.showIteration = showIteration;
        this.gamma = options.getGamma();
        this.filterXY = options.getFilterXY();
        this.filterZ = options.getFilterZ();
        this.normalize = options.isNormalize();
        this.antiRing = options.isAntiRing();
        this.changeThreshPercent = options.getChangeThreshPercent();
        this.dB = options.isDB();
        this.detectDivergence = options.isDetectDivergence();
        this.logConvergence = options.isLogConvergence();
        if (this.dB) {
            this.minB = WPLDoubleIterativeDeconvolver3D.unDB(this.B);
            this.minPSF = WPLDoubleIterativeDeconvolver3D.unDB(this.PSF);
        }
        this.sum = this.PSF.zSum();
        if (this.sum != 0.0 && this.normalize) {
            this.scalePSF /= this.sum;
        }
        this.slices = WPLDoubleIterativeDeconvolver3D.expandedSize(psfSlices, this.bSlices, resizing);
        this.columns = WPLDoubleIterativeDeconvolver3D.expandedSize(psfColumns, this.bColumns, resizing);
        this.rows = WPLDoubleIterativeDeconvolver3D.expandedSize(psfRows, this.bRows, resizing);
        if (psfSlices > this.slices || psfColumns > this.columns || psfRows > this.rows) {
            throw new IllegalArgumentException("PSF cannot be largest that the image.");
        }
        this.gweights = WPLDoubleIterativeDeconvolver3D.gaussianWeights(this.slices, this.rows, this.columns, this.filterXY, this.filterXY, this.filterZ);
        switch (boundary) {
            case PERIODIC: {
                this.B = DoubleCommon3D.padPeriodic(this.B, this.slices, this.rows, this.columns);
                break;
            }
            case REFLEXIVE: {
                this.B = DoubleCommon3D.padReflexive(this.B, this.slices, this.rows, this.columns);
                break;
            }
            case ZERO: {
                this.B = DoubleCommon3D.padZero(this.B, this.slices, this.rows, this.columns);
            }
        }
        double[] maxLoc = this.PSF.getMaxLocation();
        int[] padSize = new int[]{this.slices - psfSlices, this.rows - psfRows, this.columns - psfColumns};
        this.PSF = DoubleCommon3D.padZero(this.PSF, padSize, IterativeEnums.PaddingType.POST);
        this.PSF = DoubleCommon3D.circShift(this.PSF, new int[]{(int)maxLoc[1], (int)maxLoc[2], (int)maxLoc[3]});
    }

    public ImagePlus deconvolve() {
        DoubleMatrix3D X;
        ((DenseDoubleMatrix3D)this.PSF).dht3();
        DoubleMatrix3D AX = this.B.like();
        if (this.antiRing) {
            IJ.showStatus((String)"WPL: performing anti-ringing step.");
            X = this.B.copy();
            ((DenseDoubleMatrix3D)X).dht3();
            WPLDoubleIterativeDeconvolver3D.convolveFD(this.slices, this.rows, this.columns, this.PSF, X, AX);
            ((DenseDoubleMatrix3D)AX).idht3(true);
            WPLDoubleIterativeDeconvolver3D.copyDataAverage(this.bSlices, this.bRows, this.bColumns, this.slices, this.rows, this.columns, this.sum, this.B, AX, this.B);
        }
        if (this.gamma > 1.0E-4) {
            IJ.showStatus((String)"WPL: Wiener filter");
            double magMax = WPLDoubleIterativeDeconvolver3D.findMagMax(this.PSF);
            ((DenseDoubleMatrix3D)this.B).dht3();
            X = this.PSF.copy();
            WPLDoubleIterativeDeconvolver3D.deconvolveFD(this.gamma, magMax, this.slices, this.rows, this.columns, X, X, this.PSF);
            AX = this.B.copy();
            WPLDoubleIterativeDeconvolver3D.deconvolveFD(this.gamma, magMax, this.slices, this.rows, this.columns, AX, X, this.B);
            ((DenseDoubleMatrix3D)this.B).idht3(true);
        }
        int sOff = (this.slices - this.bSlices + 1) / 2;
        int rOff = (this.rows - this.bRows + 1) / 2;
        int cOff = (this.columns - this.bColumns + 1) / 2;
        ((DenseDoubleMatrix3D)this.PSF).idht3(true);
        double aSum = this.PSF.aggregate(DoubleFunctions.plus, DoubleFunctions.abs);
        if (this.scalePSF != 1.0) {
            this.B.assign(DoubleFunctions.div((double)this.scalePSF));
        }
        ((DenseDoubleMatrix3D)this.PSF).dht3();
        X = this.B.copy();
        ImagePlus imX = null;
        ImageStack is = new ImageStack(this.bColumns, this.bRows);
        if (this.showIteration) {
            DoubleCommon3D.assignPixelsToStackPadded(is, X, this.bSlices, this.bRows, this.bColumns, sOff, rOff, cOff, this.cmY);
            imX = new ImagePlus("(deblurred)", is);
            imX.show();
        }
        double oldPercentChange = Double.MAX_VALUE;
        for (int iter = 0; iter < this.maxIters; ++iter) {
            IJ.showStatus((String)("WPL iteration: " + (iter + 1) + "/" + this.maxIters));
            ((DenseDoubleMatrix3D)X).dht3();
            WPLDoubleIterativeDeconvolver3D.gaussianFilter(X, this.gweights);
            WPLDoubleIterativeDeconvolver3D.convolveFD(this.slices, this.rows, this.columns, this.PSF, X, AX);
            ((DenseDoubleMatrix3D)AX).idht3(true);
            ((DenseDoubleMatrix3D)X).idht3(true);
            double meanDelta = WPLDoubleIterativeDeconvolver3D.meanDelta(this.B, AX, X, aSum);
            if (this.showIteration) {
                if (this.threshold == -1.0) {
                    DoubleCommon3D.updatePixelsInStackPadded(is, X, this.bSlices, this.bRows, this.bColumns, sOff, rOff, cOff, this.cmY);
                } else {
                    DoubleCommon3D.updatePixelsInStackPadded(is, X, this.bSlices, this.bRows, this.bColumns, sOff, rOff, cOff, this.cmY, this.threshold);
                }
                ImageProcessor ip1 = imX.getProcessor();
                ip1.setMinAndMax(0.0, 0.0);
                ip1.setColorModel(this.cmY);
                imX.updateAndDraw();
            }
            double sumPixels = WPLDoubleIterativeDeconvolver3D.energySum(X, this.bSlices, this.bRows, this.bColumns, sOff, rOff, cOff);
            double percentChange = 100.0 * meanDelta / sumPixels;
            if (this.logConvergence) {
                IJ.write((String)Double.toString(percentChange));
            }
            if (oldPercentChange - percentChange < this.changeThreshPercent) {
                if (!this.logConvergence) break;
                IJ.write((String)("Automatically terminated after " + (iter + 1) + " iterations."));
                break;
            }
            if (oldPercentChange < percentChange && this.detectDivergence) {
                if (!this.logConvergence) break;
                IJ.write((String)("Automatically terminated due to divergence " + (iter + 1) + " iterations."));
                break;
            }
            oldPercentChange = percentChange;
        }
        ((DenseDoubleMatrix3D)X).dht3();
        WPLDoubleIterativeDeconvolver3D.gaussianFilterWithScaling(X, this.gweights, aSum);
        ((DenseDoubleMatrix3D)X).idht3(true);
        if (this.dB) {
            WPLDoubleIterativeDeconvolver3D.toDB(this.PSF, this.minPSF);
            WPLDoubleIterativeDeconvolver3D.toDB(this.B, this.minB);
            WPLDoubleIterativeDeconvolver3D.toDB(X, -90.0);
        }
        if (!this.showIteration) {
            if (this.threshold == -1.0) {
                DoubleCommon3D.assignPixelsToStackPadded(is, X, this.bSlices, this.bRows, this.bColumns, sOff, rOff, cOff, this.cmY);
            } else {
                DoubleCommon3D.assignPixelsToStackPadded(is, X, this.bSlices, this.bRows, this.bColumns, sOff, rOff, cOff, this.cmY, this.threshold);
            }
            imX = new ImagePlus("(deblurred)", is);
        }
        DoubleCommon3D.convertImage(imX, this.output);
        return imX;
    }

    private static void convolveFD(final int slices, final int rows, final int columns, DoubleMatrix3D H1, DoubleMatrix3D H2, DoubleMatrix3D Result) {
        final double[] h1 = (double[])H1.elements();
        final double[] h2 = (double[])H2.elements();
        final double[] result = (double[])Result.elements();
        final int sliceStride = columns * rows;
        final int rowStride = columns;
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && slices * columns * rows >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futures = new Future[np];
            int k = slices / np;
            for (int j = 0; j < np; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == np - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int sC = (slices - s) % slices;
                            for (int r = 0; r < rows; ++r) {
                                int rC = (rows - r) % rows;
                                for (int c = 0; c < columns; c += 2) {
                                    int cC = (columns - c) % columns;
                                    int idx1 = c + rowStride * r + sliceStride * s;
                                    int idx2 = cC + rowStride * rC + sliceStride * sC;
                                    double h2e = (h2[idx1] + h2[idx2]) / 2.0;
                                    double h2o = (h2[idx1] - h2[idx2]) / 2.0;
                                    result[idx1] = h1[idx1] * h2e + h1[idx2] * h2o;
                                    cC = (columns - c - 1) % columns;
                                    idx1 = c + 1 + rowStride * r + sliceStride * s;
                                    idx2 = cC + rowStride * rC + sliceStride * sC;
                                    h2e = (h2[idx1] + h2[idx2]) / 2.0;
                                    h2o = (h2[idx1] - h2[idx2]) / 2.0;
                                    result[idx1] = h1[idx1] * h2e + h1[idx2] * h2o;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int s = 0; s < slices; ++s) {
                int sC = (slices - s) % slices;
                for (int r = 0; r < rows; ++r) {
                    int rC = (rows - r) % rows;
                    for (int c = 0; c < columns; c += 2) {
                        int cC = (columns - c) % columns;
                        int idx1 = c + rowStride * r + sliceStride * s;
                        int idx2 = cC + rowStride * rC + sliceStride * sC;
                        double h2e = (h2[idx1] + h2[idx2]) / 2.0;
                        double h2o = (h2[idx1] - h2[idx2]) / 2.0;
                        result[idx1] = h1[idx1] * h2e + h1[idx2] * h2o;
                        cC = (columns - c - 1) % columns;
                        idx1 = c + 1 + rowStride * r + sliceStride * s;
                        idx2 = cC + rowStride * rC + sliceStride * sC;
                        h2e = (h2[idx1] + h2[idx2]) / 2.0;
                        h2o = (h2[idx1] - h2[idx2]) / 2.0;
                        result[idx1] = h1[idx1] * h2e + h1[idx2] * h2o;
                    }
                }
            }
        }
    }

    private static void copyDataAverage(final int slices, final int rows, final int columns, int slicesE, final int rowsE, final int columnsE, final double sum, DoubleMatrix3D DataIn, DoubleMatrix3D DataOut, DoubleMatrix3D Result) {
        final double[] dataIn = (double[])DataIn.elements();
        final double[] dataOut = (double[])DataOut.elements();
        final double[] result = (double[])Result.elements();
        final int sOff = (slicesE - slices + 1) / 2;
        final int rOff = (rowsE - rows + 1) / 2;
        final int cOff = (columnsE - columns + 1) / 2;
        final int sliceStride = rowsE * columnsE;
        final int rowStride = columnsE;
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && slicesE * columnsE * rowsE >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futures = new Future[np];
            int k = slicesE / np;
            for (int j = 0; j < np; ++j) {
                final int firstSlice = -sOff + j * k;
                final int lastSlice = j == np - 1 ? slicesE - sOff : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int sOut = s + sOff;
                            double alphaS = s < 0 ? (double)(-s) / (double)sOff : (s > slices - 1 ? (double)((float)(s - slices) / (float)sOff) : 0.0);
                            for (int r = -rOff; r < rowsE - rOff; ++r) {
                                int rOut = r + rOff;
                                double alphaR = r < 0 ? (double)(-r) / (double)rOff : (r > rows - 1 ? (double)(r - rows) / (double)rOff : 0.0);
                                for (int c = -cOff; c < columnsE - cOff; ++c) {
                                    int cOut = c + cOff;
                                    double alphaC = c < 0 ? (double)(-c) / (double)cOff : (c > columns - 1 ? (double)(c - columns) / (double)cOff : 0.0);
                                    double a = alphaS;
                                    if (alphaR > a) {
                                        a = alphaR;
                                    }
                                    if (alphaC > a) {
                                        a = alphaC;
                                    }
                                    int idx = cOut + rowStride * rOut + sliceStride * sOut;
                                    result[idx] = (1.0 - a) * dataIn[idx] + a * dataOut[idx] / sum;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int s = -sOff; s < slicesE - sOff; ++s) {
                int sOut = s + sOff;
                double alphaS = s < 0 ? (double)(-s) / (double)sOff : (s > slices - 1 ? (double)((float)(s - slices) / (float)sOff) : 0.0);
                for (int r = -rOff; r < rowsE - rOff; ++r) {
                    int rOut = r + rOff;
                    double alphaR = r < 0 ? (double)(-r) / (double)rOff : (r > rows - 1 ? (double)(r - rows) / (double)rOff : 0.0);
                    for (int c = -cOff; c < columnsE - cOff; ++c) {
                        int cOut = c + cOff;
                        double alphaC = c < 0 ? (double)(-c) / (double)cOff : (c > columns - 1 ? (double)(c - columns) / (double)cOff : 0.0);
                        double a = alphaS;
                        if (alphaR > a) {
                            a = alphaR;
                        }
                        if (alphaC > a) {
                            a = alphaC;
                        }
                        int idx = cOut + rowStride * rOut + sliceStride * sOut;
                        result[idx] = (1.0 - a) * dataIn[idx] + a * dataOut[idx] / sum;
                    }
                }
            }
        }
    }

    private static void deconvolveFD(double gamma, double magMax, final int slices, final int rows, final int columns, DoubleMatrix3D H1, DoubleMatrix3D H2, DoubleMatrix3D Result) {
        final double gammaScaled = gamma * magMax;
        final double[] h1 = (double[])H1.elements();
        final double[] h2 = (double[])H2.elements();
        final double[] result = (double[])Result.elements();
        final int sliceStride = columns * rows;
        final int rowStride = columns;
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && slices * columns * rows >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futures = new Future[np];
            int k = slices / np;
            for (int j = 0; j < np; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == np - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int sC = (slices - s) % slices;
                            for (int r = 0; r < rows; ++r) {
                                int rC = (rows - r) % rows;
                                for (int c = 0; c < columns; ++c) {
                                    int cC = (columns - c) % columns;
                                    int idx1 = c + rowStride * r + sliceStride * s;
                                    int idx2 = cC + rowStride * rC + sliceStride * sC;
                                    double h2e = (h2[idx1] + h2[idx2]) / 2.0;
                                    double h2o = (h2[idx1] - h2[idx2]) / 2.0;
                                    double mag = h2[idx1] * h2[idx1] + h2[idx2] * h2[idx2];
                                    double tmp = h1[idx1] * h2e - h1[idx2] * h2o;
                                    result[idx1] = tmp / (mag + gammaScaled);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int s = 0; s < slices; ++s) {
                int sC = (slices - s) % slices;
                for (int r = 0; r < rows; ++r) {
                    int rC = (rows - r) % rows;
                    for (int c = 0; c < columns; ++c) {
                        int cC = (columns - c) % columns;
                        int idx1 = c + rowStride * r + sliceStride * s;
                        int idx2 = cC + rowStride * rC + sliceStride * sC;
                        double h2e = (h2[idx1] + h2[idx2]) / 2.0;
                        double h2o = (h2[idx1] - h2[idx2]) / 2.0;
                        double mag = h2[idx1] * h2[idx1] + h2[idx2] * h2[idx2];
                        double tmp = h1[idx1] * h2e - h1[idx2] * h2o;
                        result[idx1] = tmp / (mag + gammaScaled);
                    }
                }
            }
        }
    }

    private static double energySum(DoubleMatrix3D X, int slices, final int rows, final int columns, final int sOff, final int rOff, final int cOff) {
        double sumPixels = 0.0;
        final int rowStride = X.rowStride();
        final int sliceStride = X.sliceStride();
        final double[] elemsX = (double[])X.elements();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && slices * rows * columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            Future[] futures = new Future[np];
            Double[] results = new Double[np];
            int k = slices / np;
            for (j = 0; j < np; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == np - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit((Callable)new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double sumPixels = 0.0;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < rows; ++r) {
                                for (int c = 0; c < columns; ++c) {
                                    sumPixels += elemsX[c + cOff + rowStride * (r + rOff) + sliceStride * (s + sOff)];
                                }
                            }
                        }
                        return sumPixels;
                    }
                });
            }
            try {
                for (j = 0; j < np; ++j) {
                    results[j] = (Double)futures[j].get();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            for (int j2 = 0; j2 < np; ++j2) {
                sumPixels += results[j2].doubleValue();
            }
        } else {
            for (int s = 0; s < slices; ++s) {
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < columns; ++c) {
                        sumPixels += elemsX[c + cOff + rowStride * (r + rOff) + sliceStride * (s + sOff)];
                    }
                }
            }
        }
        return sumPixels;
    }

    private static int expandedSize(int psfSize, int bSize, IterativeEnums.ResizingType resizing) {
        int result = 0;
        int minimal = psfSize + bSize;
        switch (resizing) {
            case AUTO: {
                int nextPowTwo = !ConcurrencyUtils.isPowerOf2((int)minimal) ? ConcurrencyUtils.nextPow2((int)minimal) : minimal;
                if ((double)nextPowTwo >= 1.5 * (double)minimal) {
                    result = minimal;
                    break;
                }
                result = nextPowTwo;
                break;
            }
            case MINIMAL: {
                result = minimal;
                break;
            }
            case NEXT_POWER_OF_TWO: {
                result = minimal;
                if (ConcurrencyUtils.isPowerOf2((int)result)) break;
                result = ConcurrencyUtils.nextPow2((int)result);
            }
        }
        if (result < 4) {
            result = 4;
        }
        return result;
    }

    private static double findMagMax(DoubleMatrix3D H2) {
        final double[] h2 = (double[])H2.elements();
        double magMax = 0.0;
        final int slices = H2.slices();
        final int rows = H2.rows();
        final int columns = H2.columns();
        final int sliceStride = rows * columns;
        final int rowStride = columns;
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && slices * rows * columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            Future[] futures = new Future[np];
            Double[] results = new Double[np];
            int k = slices / np;
            for (j = 0; j < np; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == np - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit((Callable)new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double magMax = 0.0;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int sC = (slices - s) % slices;
                            for (int r = 0; r < rows; ++r) {
                                int rC = (rows - r) % rows;
                                for (int c = 0; c < columns; ++c) {
                                    int idx1 = c + rowStride * r + sliceStride * s;
                                    int cC = (columns - c) % columns;
                                    int idx2 = cC + rowStride * rC + sliceStride * sC;
                                    double mag = h2[idx1] * h2[idx1] + h2[idx2] * h2[idx2];
                                    if (!(mag > magMax)) continue;
                                    magMax = mag;
                                }
                            }
                        }
                        return magMax;
                    }
                });
            }
            try {
                for (j = 0; j < np; ++j) {
                    results[j] = (Double)futures[j].get();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            magMax = results[0];
            for (int j2 = 1; j2 < np; ++j2) {
                if (!(results[j2] > magMax)) continue;
                magMax = results[j2];
            }
        } else {
            for (int s = 0; s < slices; ++s) {
                int sC = (slices - s) % slices;
                for (int r = 0; r < rows; ++r) {
                    int rC = (rows - r) % rows;
                    for (int c = 0; c < columns; ++c) {
                        int idx1 = c + rowStride * r + sliceStride * s;
                        int cC = (columns - c) % columns;
                        int idx2 = cC + rowStride * rC + sliceStride * sC;
                        double mag = h2[idx1] * h2[idx1] + h2[idx2] * h2[idx2];
                        if (!(mag > magMax)) continue;
                        magMax = mag;
                    }
                }
            }
        }
        return magMax;
    }

    private static void gaussianFilter(DoubleMatrix3D X, final double[][] weights) {
        final double[] elems = (double[])X.elements();
        final int sliceStride = X.sliceStride();
        final int rowStride = X.rowStride();
        final int columnStride = X.columnStride();
        int slices = X.slices();
        final int rows = X.rows();
        final int columns = X.columns();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && slices * columns * rows >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futures = new Future[np];
            int k = slices / np;
            for (int j = 0; j < np; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == np - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < rows; ++r) {
                                int idx = s * sliceStride + r * rowStride;
                                for (int c = 0; c < columns; ++c) {
                                    int n = idx;
                                    elems[n] = elems[n] * (weights[2][s] * weights[1][r] * weights[0][c]);
                                    idx += columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int s = 0; s < slices; ++s) {
                for (int r = 0; r < rows; ++r) {
                    int idx = s * sliceStride + r * rowStride;
                    for (int c = 0; c < columns; ++c) {
                        int n = idx;
                        elems[n] = elems[n] * (weights[2][s] * weights[1][r] * weights[0][c]);
                        idx += columnStride;
                    }
                }
            }
        }
    }

    private static void gaussianFilterWithScaling(DoubleMatrix3D X, final double[][] weights, final double scale) {
        final double[] elems = (double[])X.elements();
        final int sliceStride = X.sliceStride();
        final int rowStride = X.rowStride();
        final int columnStride = X.columnStride();
        int slices = X.slices();
        final int rows = X.rows();
        final int columns = X.columns();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && slices * columns * rows >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futures = new Future[np];
            int k = slices / np;
            for (int j = 0; j < np; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == np - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < rows; ++r) {
                                int idx = s * sliceStride + r * rowStride;
                                for (int c = 0; c < columns; ++c) {
                                    int n = idx;
                                    elems[n] = elems[n] * (weights[2][s] * weights[1][r] * weights[0][c] / scale);
                                    idx += columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int s = 0; s < slices; ++s) {
                for (int r = 0; r < rows; ++r) {
                    int idx = s * sliceStride + r * rowStride;
                    for (int c = 0; c < columns; ++c) {
                        int n = idx;
                        elems[n] = elems[n] * (weights[2][s] * weights[1][r] * weights[0][c] / scale);
                        idx += columnStride;
                    }
                }
            }
        }
    }

    private static double[][] gaussianWeights(final int slices, final int rows, final int columns, double filterX, double filterY, double filterZ) {
        final double[][] weights = new double[][]{new double[columns], new double[rows], new double[slices]};
        final double cc = (double)columns / (filterX + 1.0E-6);
        final double rc = (double)rows / (filterY + 1.0E-6);
        final double sc = (double)slices / (filterZ + 1.0E-6);
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && Math.max(slices, Math.max(columns, rows)) >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futures = new Future[np];
            int kcol = columns / np;
            int krow = rows / np;
            int ksls = slices / np;
            for (int j = 0; j < np; ++j) {
                final int firstCol = j * kcol;
                final int lastCol = j == np - 1 ? columns : firstCol + kcol;
                final int firstRow = j * krow;
                final int lastRow = j == np - 1 ? rows : firstRow + krow;
                final int firstSlice = j * ksls;
                final int lastSlice = j == np - 1 ? slices : firstSlice + ksls;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        double tmp;
                        for (int c = firstCol; c < lastCol; ++c) {
                            int cShifted = c;
                            if (cShifted > columns / 2) {
                                cShifted = columns - cShifted;
                            }
                            tmp = (double)cShifted / cc;
                            weights[0][c] = Math.exp(-tmp * tmp);
                        }
                        for (int r = firstRow; r < lastRow; ++r) {
                            int rShifted = r;
                            if (rShifted > rows / 2) {
                                rShifted = rows - rShifted;
                            }
                            tmp = (double)rShifted / rc;
                            weights[1][r] = Math.exp(-tmp * tmp);
                        }
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int sShifted = s;
                            if (sShifted > slices / 2) {
                                sShifted = slices - sShifted;
                            }
                            tmp = (double)sShifted / sc;
                            weights[2][s] = Math.exp(-tmp * tmp);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            double tmp;
            for (int c = 0; c < columns; ++c) {
                int cShifted = c;
                if (cShifted > columns / 2) {
                    cShifted = columns - cShifted;
                }
                tmp = (double)cShifted / cc;
                weights[0][c] = Math.exp(-tmp * tmp);
            }
            for (int r = 0; r < rows; ++r) {
                int rShifted = r;
                if (rShifted > rows / 2) {
                    rShifted = rows - rShifted;
                }
                tmp = (double)rShifted / rc;
                weights[1][r] = Math.exp(-tmp * tmp);
            }
            for (int s = 0; s < slices; ++s) {
                int sShifted = s;
                if (sShifted > slices / 2) {
                    sShifted = slices - sShifted;
                }
                tmp = (double)sShifted / sc;
                weights[2][s] = Math.exp(-tmp * tmp);
            }
        }
        return weights;
    }

    private static double meanDelta(DoubleMatrix3D B, DoubleMatrix3D AX, DoubleMatrix3D X, final double aSum) {
        double meanDelta = 0.0;
        final double[] elemsB = (double[])B.elements();
        final double[] elemsAX = (double[])AX.elements();
        final double[] elemsX = (double[])X.elements();
        int size = (int)B.size();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            Future[] futures = new Future[np];
            Double[] results = new Double[np];
            int k = size / np;
            for (j = 0; j < np; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == np - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit((Callable)new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double meanDelta = 0.0;
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            double delta = elemsB[i] - elemsAX[i] / aSum;
                            int n = i;
                            elemsX[n] = elemsX[n] + delta;
                            if (elemsX[i] < 0.0) {
                                elemsX[i] = 0.0;
                                continue;
                            }
                            meanDelta += Math.abs(delta);
                        }
                        return meanDelta;
                    }
                });
            }
            try {
                for (j = 0; j < np; ++j) {
                    results[j] = (Double)futures[j].get();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            for (int j2 = 0; j2 < np; ++j2) {
                meanDelta += results[j2].doubleValue();
            }
        } else {
            for (int i = 0; i < size; ++i) {
                double delta = elemsB[i] - elemsAX[i] / aSum;
                int n = i;
                elemsX[n] = elemsX[n] + delta;
                if (elemsX[i] < 0.0) {
                    elemsX[i] = 0.0;
                    continue;
                }
                meanDelta += Math.abs(delta);
            }
        }
        return meanDelta;
    }

    private static void toDB(DoubleMatrix3D X, final double minDB) {
        final double[] x = (double[])X.elements();
        final double SCALE = 10.0 / Math.log(10.0);
        final double minVal = Math.exp(minDB / SCALE);
        int size = (int)X.size();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futures = new Future[np];
            int k = size / np;
            for (int j = 0; j < np; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == np - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            x[i] = x[i] > minVal ? SCALE * Math.log(x[i]) : minDB;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int i = 0; i < size; ++i) {
                x[i] = x[i] > minVal ? SCALE * Math.log(x[i]) : minDB;
            }
        }
    }

    private static double unDB(DoubleMatrix3D X) {
        final double[] x = (double[])X.elements();
        final double SCALE = 10.0 / Math.log(10.0);
        int size = (int)X.size();
        double min = Double.MAX_VALUE;
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            Future[] futures = new Future[np];
            Double[] results = new Double[np];
            int k = size / np;
            for (j = 0; j < np; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == np - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit((Callable)new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double min = Double.MAX_VALUE;
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            if (x[i] < min) {
                                min = x[i];
                            }
                            x[i] = Math.exp(x[i] / SCALE);
                        }
                        return min;
                    }
                });
            }
            try {
                for (j = 0; j < np; ++j) {
                    results[j] = (Double)futures[j].get();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            min = results[0];
            for (int j2 = 1; j2 < np; ++j2) {
                if (!(results[j2] < min)) continue;
                min = results[j2];
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (x[i] < min) {
                    min = x[i];
                }
                x[i] = Math.exp(x[i] / SCALE);
            }
        }
        return min;
    }
}

