/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative.wpl;

import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.mathcs.restoretools.Enums;
import edu.emory.mathcs.restoretools.iterative.FloatCommon2D;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.restoretools.iterative.wpl.WPLOptions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import ij.IJ;
import ij.ImagePlus;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.image.ColorModel;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class WPLFloatIterativeDeconvolver2D {
    protected FloatMatrix2D B;
    protected FloatMatrix2D PSF;
    protected ColorModel cmY;
    protected int bColumns;
    protected int bRows;
    protected int maxIters;
    protected boolean useThreshold;
    protected float threshold;
    protected boolean showIteration;
    protected boolean logConvergence;
    protected Enums.OutputType output;
    private int columns;
    private int rows;
    private float minB = 0.0f;
    private float minPSF = 0.0f;
    private float sum;
    private float scalePSF = 1.0f;
    private float[][] gweights;
    protected float gamma;
    protected float filterXY;
    protected float filterZ;
    protected boolean normalize;
    protected boolean antiRing;
    protected float changeThreshPercent;
    protected boolean dB;
    protected boolean detectDivergence;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WPLFloatIterativeDeconvolver2D(ImagePlus imB, ImagePlus imPSF, IterativeEnums.BoundaryType boundary, IterativeEnums.ResizingType resizing, Enums.OutputType output, int maxIters, boolean showIteration, WPLOptions options) {
        IJ.showStatus((String)"WPL initialization...");
        ImageProcessor ipB = imB.getProcessor();
        if (output == Enums.OutputType.SAME_AS_SOURCE) {
            if (ipB instanceof ByteProcessor) {
                this.output = Enums.OutputType.BYTE;
            } else if (ipB instanceof ShortProcessor) {
                this.output = Enums.OutputType.SHORT;
            } else {
                if (!(ipB instanceof FloatProcessor)) throw new IllegalArgumentException("Unsupported image type.");
                this.output = Enums.OutputType.FLOAT;
            }
        } else {
            this.output = output;
        }
        this.cmY = ipB.getColorModel();
        this.bColumns = ipB.getWidth();
        this.bRows = ipB.getHeight();
        this.B = FloatCommon2D.assignPixelsToMatrix(ipB);
        ImageProcessor ipPSF = imPSF.getProcessor();
        int psfColumns = ipPSF.getWidth();
        int psfRows = ipPSF.getHeight();
        this.PSF = FloatCommon2D.assignPixelsToMatrix(ipPSF);
        this.maxIters = maxIters;
        this.showIteration = showIteration;
        this.gamma = (float)options.getGamma();
        this.filterXY = (float)options.getFilterXY();
        this.filterZ = (float)options.getFilterZ();
        this.normalize = options.isNormalize();
        this.antiRing = options.isAntiRing();
        this.changeThreshPercent = (float)options.getChangeThreshPercent();
        this.dB = options.isDB();
        this.detectDivergence = options.isDetectDivergence();
        this.logConvergence = options.isLogConvergence();
        if (this.dB) {
            this.minB = WPLFloatIterativeDeconvolver2D.unDB(this.B);
            this.minPSF = WPLFloatIterativeDeconvolver2D.unDB(this.PSF);
        }
        this.sum = this.PSF.zSum();
        if (this.sum != 0.0f && this.normalize) {
            this.scalePSF /= this.sum;
        }
        this.columns = WPLFloatIterativeDeconvolver2D.expandedSize(psfColumns, this.bColumns, resizing);
        this.rows = WPLFloatIterativeDeconvolver2D.expandedSize(psfRows, this.bRows, resizing);
        if (psfColumns > this.columns || psfRows > this.rows) {
            throw new IllegalArgumentException("PSF cannot be largest that the image.");
        }
        this.gweights = WPLFloatIterativeDeconvolver2D.gaussianWeights(this.rows, this.columns, this.filterXY, this.filterXY);
        switch (boundary) {
            case PERIODIC: {
                this.B = FloatCommon2D.padPeriodic(this.B, this.rows, this.columns);
                break;
            }
            case REFLEXIVE: {
                this.B = FloatCommon2D.padReflexive(this.B, this.rows, this.columns);
                break;
            }
            case ZERO: {
                this.B = FloatCommon2D.padZero(this.B, this.rows, this.columns);
            }
        }
        float[] maxLoc = this.PSF.getMaxLocation();
        int[] padSize = new int[]{this.rows - psfRows, this.columns - psfColumns};
        this.PSF = FloatCommon2D.padZero(this.PSF, padSize, IterativeEnums.PaddingType.POST);
        this.PSF = FloatCommon2D.circShift(this.PSF, new int[]{(int)maxLoc[1], (int)maxLoc[2]});
    }

    public ImagePlus deconvolve() {
        FloatMatrix2D X;
        ((DenseFloatMatrix2D)this.PSF).dht2();
        FloatMatrix2D AX = this.B.like();
        if (this.antiRing) {
            IJ.showStatus((String)"WPL: performing anti-ringing step.");
            X = this.B.copy();
            ((DenseFloatMatrix2D)X).dht2();
            WPLFloatIterativeDeconvolver2D.convolveFD(this.rows, this.columns, this.PSF, X, AX);
            ((DenseFloatMatrix2D)AX).idht2(true);
            WPLFloatIterativeDeconvolver2D.copyDataAverage(this.bRows, this.bColumns, this.rows, this.columns, this.sum, this.B, AX, this.B);
        }
        if ((double)this.gamma > 1.0E-4) {
            IJ.showStatus((String)"WPL: Wiener filter");
            float magMax = WPLFloatIterativeDeconvolver2D.findMagMax(this.PSF);
            ((DenseFloatMatrix2D)this.B).dht2();
            X = this.PSF.copy();
            WPLFloatIterativeDeconvolver2D.deconvolveFD(this.gamma, magMax, this.rows, this.columns, X, X, this.PSF);
            AX = this.B.copy();
            WPLFloatIterativeDeconvolver2D.deconvolveFD(this.gamma, magMax, this.rows, this.columns, AX, X, this.B);
            ((DenseFloatMatrix2D)this.B).idht2(true);
        }
        int rOff = (this.rows - this.bRows + 1) / 2;
        int cOff = (this.columns - this.bColumns + 1) / 2;
        ((DenseFloatMatrix2D)this.PSF).idht2(true);
        float aSum = this.PSF.aggregate(FloatFunctions.plus, FloatFunctions.abs);
        if (this.scalePSF != 1.0f) {
            this.B.assign(FloatFunctions.div((float)this.scalePSF));
        }
        ((DenseFloatMatrix2D)this.PSF).dht2();
        X = this.B.copy();
        ImagePlus imX = null;
        FloatProcessor ip = new FloatProcessor(this.bColumns, this.bRows);
        if (this.showIteration) {
            FloatCommon2D.assignPixelsToProcessorPadded(ip, X, this.bRows, this.bColumns, rOff, cOff, this.cmY);
            imX = new ImagePlus("(deblurred)", (ImageProcessor)ip);
            imX.show();
        }
        float oldPercentChange = Float.MAX_VALUE;
        for (int iter = 0; iter < this.maxIters; ++iter) {
            IJ.showStatus((String)("WPL iteration: " + (iter + 1) + "/" + this.maxIters));
            ((DenseFloatMatrix2D)X).dht2();
            WPLFloatIterativeDeconvolver2D.gaussianFilter(X, this.gweights);
            WPLFloatIterativeDeconvolver2D.convolveFD(this.rows, this.columns, this.PSF, X, AX);
            ((DenseFloatMatrix2D)AX).idht2(true);
            ((DenseFloatMatrix2D)X).idht2(true);
            float meanDelta = WPLFloatIterativeDeconvolver2D.meanDelta(this.B, AX, X, aSum);
            if (this.showIteration) {
                if ((double)this.threshold == -1.0) {
                    FloatCommon2D.assignPixelsToProcessorPadded(ip, X, this.bRows, this.bColumns, rOff, cOff, this.cmY);
                } else {
                    FloatCommon2D.assignPixelsToProcessorPadded(ip, X, this.bRows, this.bColumns, rOff, cOff, this.cmY, this.threshold);
                }
                imX.updateAndDraw();
            }
            float sumPixels = WPLFloatIterativeDeconvolver2D.energySum(X, this.bRows, this.bColumns, cOff, rOff);
            float percentChange = 100.0f * meanDelta / sumPixels;
            if (this.logConvergence) {
                IJ.write((String)Float.toString(percentChange));
            }
            if (oldPercentChange - percentChange < this.changeThreshPercent) {
                if (!this.logConvergence) break;
                IJ.write((String)("Automatically terminated after " + (iter + 1) + " iterations."));
                break;
            }
            if (oldPercentChange < percentChange && this.detectDivergence) {
                if (!this.logConvergence) break;
                IJ.write((String)("Automatically terminated due to divergence " + (iter + 1) + " iterations."));
                break;
            }
            oldPercentChange = percentChange;
        }
        ((DenseFloatMatrix2D)X).dht2();
        WPLFloatIterativeDeconvolver2D.gaussianFilterWithScaling(X, this.gweights, aSum);
        ((DenseFloatMatrix2D)X).idht2(true);
        if (this.dB) {
            WPLFloatIterativeDeconvolver2D.toDB(this.PSF, this.minPSF);
            WPLFloatIterativeDeconvolver2D.toDB(this.B, this.minB);
            WPLFloatIterativeDeconvolver2D.toDB(X, -90.0f);
        }
        if (!this.showIteration) {
            if ((double)this.threshold == -1.0) {
                FloatCommon2D.assignPixelsToProcessorPadded(ip, X, this.bRows, this.bColumns, rOff, cOff, this.cmY);
            } else {
                FloatCommon2D.assignPixelsToProcessorPadded(ip, X, this.bRows, this.bColumns, rOff, cOff, this.cmY, this.threshold);
            }
            imX = new ImagePlus("(deblurred)", (ImageProcessor)ip);
        }
        FloatCommon2D.convertImage(imX, this.output);
        return imX;
    }

    private static void convolveFD(final int rows, final int columns, FloatMatrix2D H1, FloatMatrix2D H2, FloatMatrix2D Result) {
        final float[] h1 = (float[])H1.elements();
        final float[] h2 = (float[])H2.elements();
        final float[] result = (float[])Result.elements();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && columns * rows >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futures = new Future[np];
            int k = rows / np;
            for (int j = 0; j < np; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == np - 1 ? rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int rC = (rows - r) % rows;
                            for (int c = 0; c < columns; ++c) {
                                int cC = (columns - c) % columns;
                                int idx1 = c + columns * r;
                                int idx2 = cC + columns * rC;
                                float h2e = (h2[idx1] + h2[idx2]) / 2.0f;
                                float h2o = (h2[idx1] - h2[idx2]) / 2.0f;
                                result[idx1] = h1[idx1] * h2e + h1[idx2] * h2o;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int r = 0; r < rows; ++r) {
                int rC = (rows - r) % rows;
                for (int c = 0; c < columns; ++c) {
                    int cC = (columns - c) % columns;
                    int idx1 = c + columns * r;
                    int idx2 = cC + columns * rC;
                    float h2e = (h2[idx1] + h2[idx2]) / 2.0f;
                    float h2o = (h2[idx1] - h2[idx2]) / 2.0f;
                    result[idx1] = h1[idx1] * h2e + h1[idx2] * h2o;
                }
            }
        }
    }

    private static void copyDataAverage(final int rows, final int columns, int rowsE, final int columnsE, final float sum, FloatMatrix2D DataIn, FloatMatrix2D DataOut, FloatMatrix2D Result) {
        final float[] dataIn = (float[])DataIn.elements();
        final float[] dataOut = (float[])DataOut.elements();
        final float[] result = (float[])Result.elements();
        final int rOff = (rowsE - rows + 1) / 2;
        final int cOff = (columnsE - columns + 1) / 2;
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && columnsE * rowsE >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futures = new Future[np];
            int k = rowsE / np;
            for (int j = 0; j < np; ++j) {
                final int firstRow = -rOff + j * k;
                final int lastRow = j == np - 1 ? rowsE - rOff : firstRow + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int rOut = r + rOff;
                            float alphaJ = r < 0 ? (float)(-r) / (float)rOff : (r > rows - 1 ? (float)(r - rows) / (float)rOff : 0.0f);
                            for (int c = -cOff; c < columnsE - cOff; ++c) {
                                float a;
                                int cOut = c + cOff;
                                float alphaI = c < 0 ? (float)(-c) / (float)cOff : (c > columns - 1 ? (float)(c - columns) / (float)cOff : 0.0f);
                                if (alphaI > (a = alphaJ)) {
                                    a = alphaI;
                                }
                                int idx = cOut + columnsE * rOut;
                                result[idx] = (1.0f - a) * dataIn[idx] + a * dataOut[idx] / sum;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int r = -rOff; r < rowsE - rOff; ++r) {
                int rOut = r + rOff;
                float alphaJ = r < 0 ? (float)(-r) / (float)rOff : (r > rows - 1 ? (float)(r - rows) / (float)rOff : 0.0f);
                for (int c = -cOff; c < columnsE - cOff; ++c) {
                    float a;
                    int cOut = c + cOff;
                    float alphaI = c < 0 ? (float)(-c) / (float)cOff : (c > columns - 1 ? (float)(c - columns) / (float)cOff : 0.0f);
                    if (alphaI > (a = alphaJ)) {
                        a = alphaI;
                    }
                    int idx = cOut + columnsE * rOut;
                    result[idx] = (1.0f - a) * dataIn[idx] + a * dataOut[idx] / sum;
                }
            }
        }
    }

    private static void deconvolveFD(float gamma, float magMax, final int rows, final int columns, FloatMatrix2D H1, FloatMatrix2D H2, FloatMatrix2D Result) {
        final float gammaScaled = gamma * magMax;
        final float[] h1 = (float[])H1.elements();
        final float[] h2 = (float[])H2.elements();
        final float[] result = (float[])Result.elements();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && columns * rows >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futures = new Future[np];
            int k = rows / np;
            for (int j = 0; j < np; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == np - 1 ? rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int rC = (rows - r) % rows;
                            for (int c = 0; c < columns; ++c) {
                                int cC = (columns - c) % columns;
                                int idx1 = c + columns * r;
                                int idx2 = cC + columns * rC;
                                float h2e = (h2[idx1] + h2[idx2]) / 2.0f;
                                float h2o = (h2[idx1] - h2[idx2]) / 2.0f;
                                float mag = h2[idx1] * h2[idx1] + h2[idx2] * h2[idx2];
                                float tmp = h1[idx1] * h2e - h1[idx2] * h2o;
                                result[idx1] = tmp / (mag + gammaScaled);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int r = 0; r < rows; ++r) {
                int rC = (rows - r) % rows;
                for (int c = 0; c < columns; ++c) {
                    int cC = (columns - c) % columns;
                    int idx1 = c + columns * r;
                    int idx2 = cC + columns * rC;
                    float h2e = (h2[idx1] + h2[idx2]) / 2.0f;
                    float h2o = (h2[idx1] - h2[idx2]) / 2.0f;
                    float mag = h2[idx1] * h2[idx1] + h2[idx2] * h2[idx2];
                    float tmp = h1[idx1] * h2e - h1[idx2] * h2o;
                    result[idx1] = tmp / (mag + gammaScaled);
                }
            }
        }
    }

    private static float energySum(FloatMatrix2D X, int rows, final int columns, final int cOff, final int rOff) {
        float sumPixels = 0.0f;
        final int rowStride = X.rowStride();
        final float[] elemsX = (float[])X.elements();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && rows * columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            Future[] futures = new Future[np];
            Float[] results = new Float[np];
            int k = rows / np;
            for (j = 0; j < np; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == np - 1 ? rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit((Callable)new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float sumPixels = 0.0f;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < columns; ++c) {
                                sumPixels += elemsX[c + cOff + rowStride * (r + rOff)];
                            }
                        }
                        return Float.valueOf(sumPixels);
                    }
                });
            }
            try {
                for (j = 0; j < np; ++j) {
                    results[j] = (Float)futures[j].get();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            for (int j2 = 0; j2 < np; ++j2) {
                sumPixels += results[j2].floatValue();
            }
        } else {
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < columns; ++c) {
                    sumPixels += elemsX[c + cOff + rowStride * (r + rOff)];
                }
            }
        }
        return sumPixels;
    }

    private static int expandedSize(int psfSize, int bSize, IterativeEnums.ResizingType resizing) {
        int result = 0;
        int minimal = psfSize + bSize;
        switch (resizing) {
            case AUTO: {
                int nextPowTwo = !ConcurrencyUtils.isPowerOf2((int)minimal) ? ConcurrencyUtils.nextPow2((int)minimal) : minimal;
                if ((double)nextPowTwo >= 1.5 * (double)minimal) {
                    result = minimal;
                    break;
                }
                result = nextPowTwo;
                break;
            }
            case MINIMAL: {
                result = minimal;
                break;
            }
            case NEXT_POWER_OF_TWO: {
                result = minimal;
                if (ConcurrencyUtils.isPowerOf2((int)result)) break;
                result = ConcurrencyUtils.nextPow2((int)result);
            }
        }
        if (result < 4) {
            result = 4;
        }
        return result;
    }

    private static float findMagMax(FloatMatrix2D H2) {
        final float[] h2 = (float[])H2.elements();
        float magMax = 0.0f;
        final int rows = H2.rows();
        final int columns = H2.columns();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && rows * columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            Future[] futures = new Future[np];
            Float[] results = new Float[np];
            int k = rows / np;
            for (j = 0; j < np; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == np - 1 ? rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit((Callable)new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float magMax = 0.0f;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int rC = (rows - r) % rows;
                            for (int c = 0; c < columns; ++c) {
                                int idx1 = c + columns * r;
                                int cC = (columns - c) % columns;
                                int idx2 = cC + columns * rC;
                                float mag = h2[idx1] * h2[idx1] + h2[idx2] * h2[idx2];
                                if (!(mag > magMax)) continue;
                                magMax = mag;
                            }
                        }
                        return Float.valueOf(magMax);
                    }
                });
            }
            try {
                for (j = 0; j < np; ++j) {
                    results[j] = (Float)futures[j].get();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            magMax = results[0].floatValue();
            for (int j2 = 1; j2 < np; ++j2) {
                if (!(results[j2].floatValue() > magMax)) continue;
                magMax = results[j2].floatValue();
            }
        } else {
            for (int r = 0; r < rows; ++r) {
                int rC = (rows - r) % rows;
                for (int c = 0; c < columns; ++c) {
                    int idx1 = c + columns * r;
                    int cC = (columns - c) % columns;
                    int idx2 = cC + columns * rC;
                    float mag = h2[idx1] * h2[idx1] + h2[idx2] * h2[idx2];
                    if (!(mag > magMax)) continue;
                    magMax = mag;
                }
            }
        }
        return magMax;
    }

    private static void gaussianFilter(FloatMatrix2D X, final float[][] weights) {
        final float[] elems = (float[])X.elements();
        int rows = X.rows();
        final int columns = X.columns();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && columns * rows >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futures = new Future[np];
            int k = rows / np;
            for (int j = 0; j < np; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == np - 1 ? rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        int idx = firstRow * columns;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < columns; ++c) {
                                int n = i++;
                                elems[n] = elems[n] * (weights[1][r] * weights[0][c]);
                            }
                            idx += columns;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            int idx = 0;
            for (int r = 0; r < rows; ++r) {
                int i = idx;
                for (int c = 0; c < columns; ++c) {
                    int n = i++;
                    elems[n] = elems[n] * (weights[1][r] * weights[0][c]);
                }
                idx += columns;
            }
        }
    }

    private static void gaussianFilterWithScaling(FloatMatrix2D X, final float[][] weights, final float scale) {
        final float[] elems = (float[])X.elements();
        int rows = X.rows();
        final int columns = X.columns();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && columns * rows >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futures = new Future[np];
            int k = rows / np;
            for (int j = 0; j < np; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == np - 1 ? rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        int idx = firstRow * columns;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < columns; ++c) {
                                int n = i++;
                                elems[n] = elems[n] * (weights[1][r] * weights[0][c] / scale);
                            }
                            idx += columns;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            int idx = 0;
            for (int r = 0; r < rows; ++r) {
                int i = idx;
                for (int c = 0; c < columns; ++c) {
                    int n = i++;
                    elems[n] = elems[n] * (weights[1][r] * weights[0][c] / scale);
                }
                idx += columns;
            }
        }
    }

    private static float[][] gaussianWeights(final int rows, final int columns, float filterX, float filterY) {
        final float[][] weights = new float[][]{new float[columns], new float[rows]};
        final float cc = (float)((double)columns / ((double)filterX + 1.0E-6));
        final float rc = (float)((double)rows / ((double)filterY + 1.0E-6));
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && Math.max(columns, rows) >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futures = new Future[np];
            int kcol = columns / np;
            int krow = rows / np;
            for (int j = 0; j < np; ++j) {
                final int firstCol = j * kcol;
                final int lastCol = j == np - 1 ? columns : firstCol + kcol;
                final int firstRow = j * krow;
                final int lastRow = j == np - 1 ? rows : firstRow + krow;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        float tmp;
                        for (int c = firstCol; c < lastCol; ++c) {
                            int cShifted = c;
                            if (cShifted > columns / 2) {
                                cShifted = columns - cShifted;
                            }
                            tmp = (float)cShifted / cc;
                            weights[0][c] = (float)Math.exp(-tmp * tmp);
                        }
                        for (int r = firstRow; r < lastRow; ++r) {
                            int rShifted = r;
                            if (rShifted > rows / 2) {
                                rShifted = rows - rShifted;
                            }
                            tmp = (float)rShifted / rc;
                            weights[1][r] = (float)Math.exp(-tmp * tmp);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            float tmp;
            for (int c = 0; c < columns; ++c) {
                int cShifted = c;
                if (cShifted > columns / 2) {
                    cShifted = columns - cShifted;
                }
                tmp = (float)cShifted / cc;
                weights[0][c] = (float)Math.exp(-tmp * tmp);
            }
            for (int r = 0; r < rows; ++r) {
                int rShifted = r;
                if (rShifted > rows / 2) {
                    rShifted = rows - rShifted;
                }
                tmp = (float)rShifted / rc;
                weights[1][r] = (float)Math.exp(-tmp * tmp);
            }
        }
        return weights;
    }

    private static float meanDelta(FloatMatrix2D B, FloatMatrix2D AX, FloatMatrix2D X, final float aSum) {
        float meanDelta = 0.0f;
        final float[] elemsB = (float[])B.elements();
        final float[] elemsAX = (float[])AX.elements();
        final float[] elemsX = (float[])X.elements();
        int size = (int)B.size();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            Future[] futures = new Future[np];
            Float[] results = new Float[np];
            int k = size / np;
            for (j = 0; j < np; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == np - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit((Callable)new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float meanDelta = 0.0f;
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            float delta = elemsB[i] - elemsAX[i] / aSum;
                            int n = i;
                            elemsX[n] = elemsX[n] + delta;
                            if (elemsX[i] < 0.0f) {
                                elemsX[i] = 0.0f;
                                continue;
                            }
                            meanDelta += Math.abs(delta);
                        }
                        return Float.valueOf(meanDelta);
                    }
                });
            }
            try {
                for (j = 0; j < np; ++j) {
                    results[j] = (Float)futures[j].get();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            for (int j2 = 0; j2 < np; ++j2) {
                meanDelta += results[j2].floatValue();
            }
        } else {
            for (int i = 0; i < size; ++i) {
                float delta = elemsB[i] - elemsAX[i] / aSum;
                int n = i;
                elemsX[n] = elemsX[n] + delta;
                if (elemsX[i] < 0.0f) {
                    elemsX[i] = 0.0f;
                    continue;
                }
                meanDelta += Math.abs(delta);
            }
        }
        return meanDelta;
    }

    private static void toDB(FloatMatrix2D X, final float minDB) {
        final float[] x = (float[])X.elements();
        final float SCALE = (float)(10.0 / Math.log(10.0));
        final float minVal = (float)Math.exp(minDB / SCALE);
        int size = (int)X.size();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futures = new Future[np];
            int k = size / np;
            for (int j = 0; j < np; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == np - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            x[i] = x[i] > minVal ? (float)((double)SCALE * Math.log(x[i])) : minDB;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int i = 0; i < size; ++i) {
                x[i] = x[i] > minVal ? (float)((double)SCALE * Math.log(x[i])) : minDB;
            }
        }
    }

    private static float unDB(FloatMatrix2D X) {
        final float[] x = (float[])X.elements();
        final float SCALE = (float)(10.0 / Math.log(10.0));
        int size = (int)X.size();
        float min = Float.MAX_VALUE;
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            Future[] futures = new Future[np];
            Float[] results = new Float[np];
            int k = size / np;
            for (j = 0; j < np; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == np - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit((Callable)new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float min = Float.MAX_VALUE;
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            if (x[i] < min) {
                                min = x[i];
                            }
                            x[i] = (float)Math.exp(x[i] / SCALE);
                        }
                        return Float.valueOf(min);
                    }
                });
            }
            try {
                for (j = 0; j < np; ++j) {
                    results[j] = (Float)futures[j].get();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            min = results[0].floatValue();
            for (int j2 = 1; j2 < np; ++j2) {
                if (!(results[j2].floatValue() < min)) continue;
                min = results[j2].floatValue();
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (x[i] < min) {
                    min = x[i];
                }
                x[i] = (float)Math.exp(x[i] / SCALE);
            }
        }
        return min;
    }
}

