/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import edu.emory.mathcs.restoretools.Enums;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.utils.pc.ConcurrencyUtils;
import ij.ImagePlus;
import ij.process.FloatProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;
import java.util.concurrent.Future;

public class DoubleCommon2D {
    public static final double FMIN_TOL = 1.0E-4;
    public static final double eps = Math.pow(2.0, -52.0);
    public static final double sqrteps = Math.sqrt(eps);

    private DoubleCommon2D() {
    }

    public static void assignPixelsToMatrix(DoubleMatrix2D X, ImageProcessor ip) {
        if (ip instanceof FloatProcessor) {
            X.assign((float[])ip.getPixels());
        } else {
            X.assign((float[])ip.convertToFloat().getPixels());
        }
    }

    public static void assignPixelsToProcessor(FloatProcessor ip, final DoubleMatrix1D x, ColorModel cmY) {
        int rows = ip.getHeight();
        int cols = ip.getWidth();
        int size = rows * cols;
        final float[] px = (float[])ip.getPixels();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (x.isView()) {
            if (np > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = size / np;
                for (int j = 0; j < np; ++j) {
                    final int firstIdx = j * k;
                    final int lastIdx = j == np - 1 ? size : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int i = firstIdx; i < lastIdx; ++i) {
                                px[i] = (float)x.getQuick(i);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int i = 0; i < size; ++i) {
                    px[i] = (float)x.getQuick(i);
                }
            }
        } else {
            final double[] elems = (double[])x.elements();
            if (np > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = size / np;
                for (int j = 0; j < np; ++j) {
                    final int firstIdx = j * k;
                    final int lastIdx = j == np - 1 ? size : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int i = firstIdx; i < lastIdx; ++i) {
                                px[i] = (float)elems[i];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int i = 0; i < size; ++i) {
                    px[i] = (float)elems[i];
                }
            }
        }
        ip.setMinAndMax(0.0, 0.0);
        ip.setColorModel(cmY);
    }

    public static void assignPixelsToProcessor(FloatProcessor ip, final DoubleMatrix1D x, ColorModel cmY, final double threshold) {
        int rows = ip.getHeight();
        int cols = ip.getWidth();
        int size = rows * cols;
        final float[] px = (float[])ip.getPixels();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (x.isView()) {
            if (np > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = size / np;
                for (int j = 0; j < np; ++j) {
                    final int firstIdx = j * k;
                    final int lastIdx = j == np - 1 ? size : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int i = firstIdx; i < lastIdx; ++i) {
                                float elem = (float)x.getQuick(i);
                                px[i] = (double)elem >= threshold ? elem : 0.0f;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int i = 0; i < size; ++i) {
                    float elem = (float)x.getQuick(i);
                    px[i] = (double)elem >= threshold ? elem : 0.0f;
                }
            }
        } else {
            final double[] elems = (double[])x.elements();
            if (np > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = size / np;
                for (int j = 0; j < np; ++j) {
                    final int firstIdx = j * k;
                    final int lastIdx = j == np - 1 ? size : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int i = firstIdx; i < lastIdx; ++i) {
                                float elem = (float)elems[i];
                                px[i] = (double)elem >= threshold ? elem : 0.0f;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int i = 0; i < size; ++i) {
                    float elem = (float)elems[i];
                    px[i] = (double)elem >= threshold ? elem : 0.0f;
                }
            }
        }
        ip.setMinAndMax(0.0, 0.0);
        ip.setColorModel(cmY);
    }

    public static void assignPixelsToProcessor(FloatProcessor ip, final DoubleMatrix2D X, ColorModel cmY) {
        int rows = X.rows();
        final int cols = X.columns();
        final float[] px = (float[])ip.getPixels();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (X.isView()) {
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rows / np;
                for (int j = 0; j < np; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == np - 1 ? rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < cols; ++c) {
                                    px[c + cols * r] = (float)X.getQuick(r, c);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        px[c + cols * r] = (float)X.getQuick(r, c);
                    }
                }
            }
        } else {
            final double[] elems = (double[])X.elements();
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rows / np;
                for (int j = 0; j < np; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == np - 1 ? rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            int idx = firstRow * cols;
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < cols; ++c) {
                                    px[idx] = (float)elems[idx];
                                    ++idx;
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                int idx = 0;
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        px[idx] = (float)elems[idx];
                        ++idx;
                    }
                }
            }
        }
        ip.setMinAndMax(0.0, 0.0);
        ip.setColorModel(cmY);
    }

    public static void assignPixelsToProcessorPadded(FloatProcessor ip, final DoubleMatrix2D X, int rows, final int cols, final int rOff, final int cOff, ColorModel cmY) {
        final float[] px = (float[])ip.getPixels();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (X.isView()) {
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rows / np;
                for (int j = 0; j < np; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == np - 1 ? rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < cols; ++c) {
                                    px[c + cols * r] = (float)X.getQuick(r + rOff, c + cOff);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        px[c + cols * r] = (float)X.getQuick(r + rOff, c + cOff);
                    }
                }
            }
        } else {
            final double[] elems = (double[])X.elements();
            final int rowStride = X.columns();
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rows / np;
                for (int j = 0; j < np; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == np - 1 ? rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < cols; ++c) {
                                    int idx = (r + rOff) * rowStride + (c + cOff);
                                    px[r * cols + c] = (float)elems[idx];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        int idx = (r + rOff) * rowStride + (c + cOff);
                        px[r * cols + c] = (float)elems[idx];
                        ++idx;
                    }
                }
            }
        }
        ip.setMinAndMax(0.0, 0.0);
        ip.setColorModel(cmY);
    }

    public static void assignPixelsToProcessorPadded(FloatProcessor ip, final DoubleMatrix2D X, int rows, final int cols, final int rOff, final int cOff, ColorModel cmY, final double threshold) {
        final float[] px = (float[])ip.getPixels();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (X.isView()) {
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rows / np;
                for (int j = 0; j < np; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == np - 1 ? rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < cols; ++c) {
                                    float elem = (float)X.getQuick(r + rOff, c + cOff);
                                    px[c + cols * r] = (double)elem >= threshold ? elem : 0.0f;
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        float elem = (float)X.getQuick(r + rOff, c + cOff);
                        px[c + cols * r] = (double)elem >= threshold ? elem : 0.0f;
                    }
                }
            }
        } else {
            final double[] elems = (double[])X.elements();
            final int rowStride = X.columns();
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rows / np;
                for (int j = 0; j < np; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == np - 1 ? rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < cols; ++c) {
                                    int idx = (r + rOff) * rowStride + (c + cOff);
                                    px[r * cols + c] = (double)((float)elems[idx]) >= threshold ? (float)elems[idx] : 0.0f;
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        int idx = (r + rOff) * rowStride + (c + cOff);
                        px[r * cols + c] = (double)((float)elems[idx]) >= threshold ? (float)elems[idx] : 0.0f;
                    }
                }
            }
        }
        ip.setMinAndMax(0.0, 0.0);
        ip.setColorModel(cmY);
    }

    public static void assignPixelsToProcessor(FloatProcessor ip, final DoubleMatrix2D X, ColorModel cmY, final double threshold) {
        int rows = X.rows();
        final int cols = X.columns();
        final float[] px = (float[])ip.getPixels();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (X.isView()) {
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rows / np;
                for (int j = 0; j < np; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == np - 1 ? rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < cols; ++c) {
                                    float elem = (float)X.getQuick(r, c);
                                    px[c + cols * r] = (double)elem >= threshold ? elem : 0.0f;
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        float elem = (float)X.getQuick(r, c);
                        px[c + cols * r] = (double)elem >= threshold ? elem : 0.0f;
                    }
                }
            }
        } else {
            final double[] elems = (double[])X.elements();
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rows / np;
                for (int j = 0; j < np; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == np - 1 ? rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            int idx = firstRow * cols;
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < cols; ++c) {
                                    px[idx] = (double)((float)elems[idx]) >= threshold ? (float)elems[idx] : 0.0f;
                                    ++idx;
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                int idx = 0;
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        px[idx] = (double)((float)elems[idx]) >= threshold ? (float)elems[idx] : 0.0f;
                        ++idx;
                    }
                }
            }
        }
        ip.setMinAndMax(0.0, 0.0);
        ip.setColorModel(cmY);
    }

    public static DoubleMatrix2D circShift(DoubleMatrix2D PSF, int[] center) {
        int rows = PSF.rows();
        int cols = PSF.columns();
        int cr = center[0];
        int cc = center[1];
        DenseDoubleMatrix2D P1 = new DenseDoubleMatrix2D(rows, cols);
        P1.viewPart(0, 0, rows - cr, cols - cc).assign(PSF.viewPart(cr, cc, rows - cr, cols - cc));
        P1.viewPart(0, cols - cc, rows - cr, cc).assign(PSF.viewPart(cr, 0, rows - cr, cc));
        P1.viewPart(rows - cr, 0, cr, cols - cc).assign(PSF.viewPart(0, cc, cr, cols - cc));
        P1.viewPart(rows - cr, cols - cc, cr, cc).assign(PSF.viewPart(0, 0, cr, cc));
        return P1;
    }

    public static void convertImage(ImagePlus image, Enums.OutputType output) {
        switch (output) {
            case BYTE: {
                new ImageConverter(image).convertToGray8();
                break;
            }
            case SHORT: {
                new ImageConverter(image).convertToGray16();
                break;
            }
        }
    }

    public static DoubleMatrix2D padPeriodic(final DoubleMatrix2D X, int rowsPad, final int colsPad) {
        final int rows = X.rows();
        final int cols = X.columns();
        if (rows == rowsPad && cols == colsPad) {
            return X;
        }
        DenseDoubleMatrix2D Xpad = new DenseDoubleMatrix2D(rowsPad, colsPad);
        final int rOff = (rowsPad - rows + 1) / 2;
        final int cOff = (colsPad - cols + 1) / 2;
        final double[] elemsXpad = (double[])Xpad.elements();
        final int rowStrideXpad = Xpad.columns();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (X.isView()) {
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rowsPad / np;
                for (int j = 0; j < np; ++j) {
                    final int firstIdx = -rOff + j * k;
                    final int lastIdx = j == np - 1 ? rowsPad - rOff : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int r = firstIdx; r < lastIdx; ++r) {
                                int rOut = r + rOff;
                                int rIn = DoubleCommon2D.periodic(r, rows);
                                for (int c = -cOff; c < colsPad - cOff; ++c) {
                                    int cOut = c + cOff;
                                    int cIn = DoubleCommon2D.periodic(c, cols);
                                    int idxXpad = rOut * rowStrideXpad + cOut;
                                    elemsXpad[idxXpad] = X.getQuick(rIn, cIn);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int r = -rOff; r < rowsPad - rOff; ++r) {
                    int rOut = r + rOff;
                    int rIn = DoubleCommon2D.periodic(r, rows);
                    for (int c = -cOff; c < colsPad - cOff; ++c) {
                        int cOut = c + cOff;
                        int cIn = DoubleCommon2D.periodic(c, cols);
                        int idxXpad = rOut * rowStrideXpad + cOut;
                        elemsXpad[idxXpad] = X.getQuick(rIn, cIn);
                    }
                }
            }
        } else {
            final double[] elemsX = (double[])X.elements();
            final int rowStrideX = X.columns();
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rowsPad / np;
                for (int j = 0; j < np; ++j) {
                    final int firstIdx = -rOff + j * k;
                    final int lastIdx = j == np - 1 ? rowsPad - rOff : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int r = firstIdx; r < lastIdx; ++r) {
                                int rOut = r + rOff;
                                int rIn = DoubleCommon2D.periodic(r, rows);
                                for (int c = -cOff; c < colsPad - cOff; ++c) {
                                    int cOut = c + cOff;
                                    int cIn = DoubleCommon2D.periodic(c, cols);
                                    int idxX = rIn * rowStrideX + cIn;
                                    int idxXpad = rOut * rowStrideXpad + cOut;
                                    elemsXpad[idxXpad] = elemsX[idxX];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int r = -rOff; r < rowsPad - rOff; ++r) {
                    int rOut = r + rOff;
                    int rIn = DoubleCommon2D.periodic(r, rows);
                    for (int c = -cOff; c < colsPad - cOff; ++c) {
                        int cOut = c + cOff;
                        int cIn = DoubleCommon2D.periodic(c, cols);
                        int idxX = rIn * rowStrideX + cIn;
                        int idxXpad = rOut * rowStrideXpad + cOut;
                        elemsXpad[idxXpad] = elemsX[idxX];
                    }
                }
            }
        }
        return Xpad;
    }

    public static DoubleMatrix2D padReflexive(final DoubleMatrix2D X, int rowsPad, final int colsPad) {
        final int rows = X.rows();
        final int cols = X.columns();
        if (rows == rowsPad && cols == colsPad) {
            return X;
        }
        DenseDoubleMatrix2D Xpad = new DenseDoubleMatrix2D(rowsPad, colsPad);
        final int rOff = (rowsPad - rows + 1) / 2;
        final int cOff = (colsPad - cols + 1) / 2;
        final double[] elemsXpad = (double[])Xpad.elements();
        final int rowStrideXpad = Xpad.columns();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (X.isView()) {
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rowsPad / np;
                for (int j = 0; j < np; ++j) {
                    final int firstIdx = -rOff + j * k;
                    final int lastIdx = j == np - 1 ? rowsPad - rOff : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int r = firstIdx; r < lastIdx; ++r) {
                                int rOut = r + rOff;
                                int rIn = DoubleCommon2D.mirror(r, rows);
                                for (int c = -cOff; c < colsPad - cOff; ++c) {
                                    int cOut = c + cOff;
                                    int cIn = DoubleCommon2D.mirror(c, cols);
                                    int idxXpad = rOut * rowStrideXpad + cOut;
                                    elemsXpad[idxXpad] = X.getQuick(rIn, cIn);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int r = -rOff; r < rowsPad - rOff; ++r) {
                    int rOut = r + rOff;
                    int rIn = DoubleCommon2D.mirror(r, rows);
                    for (int c = -cOff; c < colsPad - cOff; ++c) {
                        int cOut = c + cOff;
                        int cIn = DoubleCommon2D.mirror(c, cols);
                        int idxXpad = rOut * rowStrideXpad + cOut;
                        elemsXpad[idxXpad] = X.getQuick(rIn, cIn);
                    }
                }
            }
        } else {
            final double[] elemsX = (double[])X.elements();
            final int rowStrideX = X.columns();
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rowsPad / np;
                for (int j = 0; j < np; ++j) {
                    final int firstIdx = -rOff + j * k;
                    final int lastIdx = j == np - 1 ? rowsPad - rOff : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int r = firstIdx; r < lastIdx; ++r) {
                                int rOut = r + rOff;
                                int rIn = DoubleCommon2D.mirror(r, rows);
                                for (int c = -cOff; c < colsPad - cOff; ++c) {
                                    int cOut = c + cOff;
                                    int cIn = DoubleCommon2D.mirror(c, cols);
                                    int idxX = rIn * rowStrideX + cIn;
                                    int idxXpad = rOut * rowStrideXpad + cOut;
                                    elemsXpad[idxXpad] = elemsX[idxX];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int r = -rOff; r < rowsPad - rOff; ++r) {
                    int rOut = r + rOff;
                    int rIn = DoubleCommon2D.mirror(r, rows);
                    for (int c = -cOff; c < colsPad - cOff; ++c) {
                        int cOut = c + cOff;
                        int cIn = DoubleCommon2D.mirror(c, cols);
                        int idxX = rIn * rowStrideX + cIn;
                        int idxXpad = rOut * rowStrideXpad + cOut;
                        elemsXpad[idxXpad] = elemsX[idxX];
                    }
                }
            }
        }
        return Xpad;
    }

    public static DoubleMatrix2D padZero(DoubleMatrix2D X, int rowsPad, int colsPad) {
        int rows = X.rows();
        int cols = X.columns();
        if (rows == rowsPad && cols == colsPad) {
            return X;
        }
        DenseDoubleMatrix2D Xpad = new DenseDoubleMatrix2D(rowsPad, colsPad);
        int rOff = (rowsPad - rows + 1) / 2;
        int cOff = (colsPad - cols + 1) / 2;
        Xpad.viewPart(rOff, cOff, rows, cols).assign(X);
        return Xpad;
    }

    public static DoubleMatrix2D padZero(DoubleMatrix2D X, int[] padSize, IterativeEnums.PaddingType padding) {
        if (padSize[0] == 0 && padSize[1] == 0) {
            return X;
        }
        DenseDoubleMatrix2D Xpad = null;
        switch (padding) {
            case BOTH: {
                Xpad = new DenseDoubleMatrix2D(X.rows() + 2 * padSize[0], X.columns() + 2 * padSize[1]);
                Xpad.viewPart(padSize[0], padSize[1], X.rows(), X.columns()).assign(X);
                break;
            }
            case POST: {
                Xpad = new DenseDoubleMatrix2D(X.rows() + padSize[0], X.columns() + padSize[1]);
                Xpad.viewPart(0, 0, X.rows(), X.columns()).assign(X);
                break;
            }
            case PRE: {
                Xpad = new DenseDoubleMatrix2D(X.rows() + padSize[0], X.columns() + padSize[1]);
                Xpad.viewPart(padSize[0], padSize[1], X.rows(), X.columns()).assign(X);
            }
        }
        return Xpad;
    }

    public static DoubleMatrix2D dctShift(DoubleMatrix2D PSF, int[] center) {
        int rows = PSF.rows();
        int cols = PSF.columns();
        int cr = center[0];
        int cc = center[1];
        int k = Math.min(Math.min(Math.min(cr, rows - cr - 1), cc), cols - cc - 1);
        int frow = cr - k;
        int lrow = cr + k;
        int rowSize = lrow - frow + 1;
        int fcol = cc - k;
        int lcol = cc + k;
        int colSize = lcol - fcol + 1;
        DenseDoubleMatrix2D PP = new DenseDoubleMatrix2D(rowSize, colSize);
        DenseDoubleMatrix2D P1 = new DenseDoubleMatrix2D(rowSize, colSize);
        DenseDoubleMatrix2D P2 = new DenseDoubleMatrix2D(rowSize, colSize);
        DenseDoubleMatrix2D P3 = new DenseDoubleMatrix2D(rowSize, colSize);
        DenseDoubleMatrix2D P4 = new DenseDoubleMatrix2D(rowSize, colSize);
        DenseDoubleMatrix2D Ps = new DenseDoubleMatrix2D(rows, cols);
        PP.assign(PSF.viewPart(frow, fcol, rowSize, colSize));
        P1.viewPart(0, 0, rowSize - cr + frow, colSize - cc + fcol).assign(PP.viewPart(cr - frow, cc - fcol, rowSize - cr + frow, colSize - cc + fcol));
        P2.viewPart(0, 0, rowSize - cr + frow, colSize - cc + fcol - 1).assign(PP.viewPart(cr - frow, cc - fcol + 1, rowSize - cr + frow, colSize - cc + fcol - 1));
        P3.viewPart(0, 0, rowSize - cr + frow - 1, colSize - cc + fcol).assign(PP.viewPart(cr - frow + 1, cc - fcol, rowSize - cr + frow - 1, colSize - cc + fcol));
        P4.viewPart(0, 0, rowSize - cr + frow - 1, colSize - cc + fcol - 1).assign(PP.viewPart(cr - frow + 1, cc - fcol + 1, rowSize - cr + frow - 1, colSize - cc + fcol - 1));
        P1.assign((DoubleMatrix2D)P2, DoubleFunctions.plus);
        P1.assign((DoubleMatrix2D)P3, DoubleFunctions.plus);
        P1.assign((DoubleMatrix2D)P4, DoubleFunctions.plus);
        Ps.viewPart(0, 0, 2 * k + 1, 2 * k + 1).assign((DoubleMatrix2D)P1);
        return Ps.copy();
    }

    public static void swapQuadrants(final int rows, final int columns, DoubleMatrix2D X) {
        int idx2;
        int idx1;
        int j;
        Future[] futures;
        final double[] x = (double[])X.elements();
        final int cHalf = columns / 2;
        final int rHalf = rows / 2;
        int size = columns * rows / 2;
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            futures = new Future[np];
            int krow = rHalf / np;
            for (j = 0; j < np; ++j) {
                final int firstRow = j * krow;
                final int lastRow = j == np - 1 ? rHalf : firstRow + krow;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int rP = r + rHalf;
                            for (int c = 0; c < columns; ++c) {
                                int idx1 = c + columns * r;
                                int idx2 = c + columns * rP;
                                double temp = x[idx1];
                                x[idx1] = x[idx2];
                                x[idx2] = temp;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int r = 0; r < rHalf; ++r) {
                int rP = r + rHalf;
                for (int c = 0; c < columns; ++c) {
                    idx1 = c + columns * r;
                    idx2 = c + columns * rP;
                    double temp = x[idx1];
                    x[idx1] = x[idx2];
                    x[idx2] = temp;
                }
            }
        }
        if (np > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            futures = new Future[np];
            int kcol = cHalf / np;
            for (j = 0; j < np; ++j) {
                final int firstCol = j * kcol;
                final int lastCol = j == np - 1 ? cHalf : firstCol + kcol;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int c = firstCol; c < lastCol; ++c) {
                            int cP = c + cHalf;
                            for (int r = 0; r < rows; ++r) {
                                int idx1 = c + columns * r;
                                int idx2 = cP + columns * r;
                                double temp = x[idx1];
                                x[idx1] = x[idx2];
                                x[idx2] = temp;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int c = 0; c < cHalf; ++c) {
                int cP = c + cHalf;
                for (int r = 0; r < rows; ++r) {
                    idx1 = c + columns * r;
                    idx2 = cP + columns * r;
                    double temp = x[idx1];
                    x[idx1] = x[idx2];
                    x[idx2] = temp;
                }
            }
        }
    }

    public static void convolveTransposeFD(DoubleMatrix2D H1, DoubleMatrix2D H2, DoubleMatrix2D Result) {
        int rows = H1.rows();
        int columns = H1.columns();
        double[] h1 = (double[])H1.elements();
        double[] h2 = (double[])H2.elements();
        double[] result = (double[])Result.elements();
        for (int r = 0; r < rows; ++r) {
            int rC = (rows - r) % rows;
            for (int c = 0; c < columns; ++c) {
                int cC = (columns - c) % columns;
                int idx1 = c + columns * r;
                int idx2 = cC + columns * rC;
                double h2e = (h2[idx1] + h2[idx2]) / 2.0;
                double h2o = (h2[idx1] - h2[idx2]) / 2.0;
                result[idx2] = h1[idx1] * h2e - h1[idx2] * h2o;
            }
        }
    }

    public static void convolveFD(DoubleMatrix2D H1, DoubleMatrix2D H2, DoubleMatrix2D Result) {
        final int rows = H1.rows();
        final int columns = H1.columns();
        final double[] h1 = (double[])H1.elements();
        final double[] h2 = (double[])H2.elements();
        final double[] result = (double[])Result.elements();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && columns * rows >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futures = new Future[np];
            int k = rows / np;
            for (int j = 0; j < np; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == np - 1 ? rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int rC = (rows - r) % rows;
                            for (int c = 0; c < columns; ++c) {
                                int cC = (columns - c) % columns;
                                int idx1 = c + columns * r;
                                int idx2 = cC + columns * rC;
                                double h2e = (h2[idx1] + h2[idx2]) / 2.0;
                                double h2o = (h2[idx1] - h2[idx2]) / 2.0;
                                result[idx1] = h1[idx1] * h2e + h1[idx2] * h2o;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int r = 0; r < rows; ++r) {
                int rC = (rows - r) % rows;
                for (int c = 0; c < columns; ++c) {
                    int cC = (columns - c) % columns;
                    int idx1 = c + columns * r;
                    int idx2 = cC + columns * rC;
                    double h2e = (h2[idx1] + h2[idx2]) / 2.0;
                    double h2o = (h2[idx1] - h2[idx2]) / 2.0;
                    result[idx1] = h1[idx1] * h2e + h1[idx2] * h2o;
                }
            }
        }
    }

    private static int mirror(int i, int n) {
        int ip = DoubleCommon2D.mod(i, 2 * n);
        if (ip < n) {
            return ip;
        }
        return n - ip % n - 1;
    }

    private static int mod(int i, int n) {
        return (i % n + n) % n;
    }

    private static int periodic(int i, int n) {
        int ip = DoubleCommon2D.mod(i, 2 * n);
        if (ip < n) {
            return ip;
        }
        return ip % n;
    }
}

