/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.mathcs.restoretools.Enums;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.utils.pc.ConcurrencyUtils;
import ij.ImagePlus;
import ij.process.FloatProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;
import java.util.concurrent.Future;

public class FloatCommon2D {
    public static final float FMIN_TOL = 1.0E-4f;
    public static final float eps = (float)Math.pow(2.0, -23.0);
    public static final float sqrteps = (float)Math.sqrt(eps);

    private FloatCommon2D() {
    }

    public static FloatMatrix2D assignPixelsToMatrix(ImageProcessor ip) {
        DenseFloatMatrix2D X = ip instanceof FloatProcessor ? new DenseFloatMatrix2D(ip.getHeight(), ip.getWidth(), (float[])((float[])ip.getPixels()).clone(), 0, 0, ip.getWidth(), 1, false) : new DenseFloatMatrix2D(ip.getHeight(), ip.getWidth(), (float[])ip.convertToFloat().getPixels(), 0, 0, ip.getWidth(), 1, false);
        return X;
    }

    public static void assignPixelsToMatrix(FloatMatrix2D X, ImageProcessor ip) {
        if (ip instanceof FloatProcessor) {
            X.assign((float[])ip.getPixels());
        } else {
            X.assign((float[])ip.convertToFloat().getPixels());
        }
    }

    public static void assignPixelsToProcessor(FloatProcessor ip, FloatMatrix1D x, ColorModel cmY) {
        if (x.isView()) {
            ip.setPixels((Object)((float[])x.copy().elements()));
        } else {
            ip.setPixels((Object)((float[])x.elements()));
        }
        ip.setMinAndMax(0.0, 0.0);
        ip.setColorModel(cmY);
    }

    public static void assignPixelsToProcessor(FloatProcessor ip, final FloatMatrix1D x, ColorModel cmY, final float threshold) {
        int rows = ip.getHeight();
        int cols = ip.getWidth();
        int size = rows * cols;
        final float[] px = (float[])ip.getPixels();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (x.isView()) {
            if (np > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = size / np;
                for (int j = 0; j < np; ++j) {
                    final int firstIdx = j * k;
                    final int lastIdx = j == np - 1 ? size : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int i = firstIdx; i < lastIdx; ++i) {
                                float elem = x.getQuick(i);
                                px[i] = elem >= threshold ? elem : 0.0f;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int i = 0; i < size; ++i) {
                    float elem = x.getQuick(i);
                    px[i] = elem >= threshold ? elem : 0.0f;
                }
            }
        } else {
            final float[] elems = (float[])x.elements();
            if (np > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = size / np;
                for (int j = 0; j < np; ++j) {
                    final int firstIdx = j * k;
                    final int lastIdx = j == np - 1 ? size : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int i = firstIdx; i < lastIdx; ++i) {
                                float elem = elems[i];
                                px[i] = elem >= threshold ? elem : 0.0f;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int i = 0; i < size; ++i) {
                    float elem = elems[i];
                    px[i] = elem >= threshold ? elem : 0.0f;
                }
            }
        }
        ip.setMinAndMax(0.0, 0.0);
        ip.setColorModel(cmY);
    }

    public static void assignPixelsToProcessor(FloatProcessor ip, final FloatMatrix2D X, ColorModel cmY) {
        int rows = X.rows();
        final int cols = X.columns();
        final float[] px = (float[])ip.getPixels();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (X.isView()) {
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rows / np;
                for (int j = 0; j < np; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == np - 1 ? rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < cols; ++c) {
                                    px[c + cols * r] = X.getQuick(r, c);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        px[c + cols * r] = X.getQuick(r, c);
                    }
                }
            }
        } else {
            final float[] elems = (float[])X.elements();
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rows / np;
                for (int j = 0; j < np; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == np - 1 ? rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            int idx = firstRow * cols;
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < cols; ++c) {
                                    px[idx] = elems[idx];
                                    ++idx;
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                int idx = 0;
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        px[idx] = elems[idx];
                        ++idx;
                    }
                }
            }
        }
        ip.setMinAndMax(0.0, 0.0);
        ip.setColorModel(cmY);
    }

    public static void assignPixelsToProcessorPadded(FloatProcessor ip, final FloatMatrix2D X, int rows, final int cols, final int rOff, final int cOff, ColorModel cmY) {
        final float[] px = (float[])ip.getPixels();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (X.isView()) {
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rows / np;
                for (int j = 0; j < np; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == np - 1 ? rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < cols; ++c) {
                                    px[c + cols * r] = X.getQuick(r + rOff, c + cOff);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        px[c + cols * r] = X.getQuick(r + rOff, c + cOff);
                    }
                }
            }
        } else {
            final float[] elems = (float[])X.elements();
            final int rowStride = X.columns();
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rows / np;
                for (int j = 0; j < np; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == np - 1 ? rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < cols; ++c) {
                                    int idx = (r + rOff) * rowStride + (c + cOff);
                                    px[r * cols + c] = elems[idx];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        int idx = (r + rOff) * rowStride + (c + cOff);
                        px[r * cols + c] = elems[idx];
                        ++idx;
                    }
                }
            }
        }
        ip.setMinAndMax(0.0, 0.0);
        ip.setColorModel(cmY);
    }

    public static void assignPixelsToProcessorPadded(FloatProcessor ip, final FloatMatrix2D X, int rows, final int cols, final int rOff, final int cOff, ColorModel cmY, final float threshold) {
        final float[] px = (float[])ip.getPixels();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (X.isView()) {
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rows / np;
                for (int j = 0; j < np; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == np - 1 ? rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < cols; ++c) {
                                    float elem = X.getQuick(r + rOff, c + cOff);
                                    px[c + cols * r] = elem >= threshold ? elem : 0.0f;
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        float elem = X.getQuick(r + rOff, c + cOff);
                        px[c + cols * r] = elem >= threshold ? elem : 0.0f;
                    }
                }
            }
        } else {
            final float[] elems = (float[])X.elements();
            final int rowStride = X.columns();
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rows / np;
                for (int j = 0; j < np; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == np - 1 ? rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < cols; ++c) {
                                    int idx = (r + rOff) * rowStride + (c + cOff);
                                    px[r * cols + c] = elems[idx] >= threshold ? elems[idx] : 0.0f;
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        int idx = (r + rOff) * rowStride + (c + cOff);
                        px[r * cols + c] = elems[idx] >= threshold ? elems[idx] : 0.0f;
                    }
                }
            }
        }
        ip.setMinAndMax(0.0, 0.0);
        ip.setColorModel(cmY);
    }

    public static void assignPixelsToProcessor(FloatProcessor ip, final FloatMatrix2D X, ColorModel cmY, final float threshold) {
        int rows = X.rows();
        final int cols = X.columns();
        final float[] px = (float[])ip.getPixels();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (X.isView()) {
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rows / np;
                for (int j = 0; j < np; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == np - 1 ? rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < cols; ++c) {
                                    float elem = X.getQuick(r, c);
                                    px[c + cols * r] = elem >= threshold ? elem : 0.0f;
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        float elem = X.getQuick(r, c);
                        px[c + cols * r] = elem >= threshold ? elem : 0.0f;
                    }
                }
            }
        } else {
            final float[] elems = (float[])X.elements();
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rows / np;
                for (int j = 0; j < np; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == np - 1 ? rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            int idx = firstRow * cols;
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < cols; ++c) {
                                    px[idx] = elems[idx] >= threshold ? elems[idx] : 0.0f;
                                    ++idx;
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                int idx = 0;
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        px[idx] = elems[idx] >= threshold ? elems[idx] : 0.0f;
                        ++idx;
                    }
                }
            }
        }
        ip.setMinAndMax(0.0, 0.0);
        ip.setColorModel(cmY);
    }

    public static FloatMatrix2D circShift(FloatMatrix2D PSF, int[] center) {
        int rows = PSF.rows();
        int cols = PSF.columns();
        int cr = center[0];
        int cc = center[1];
        DenseFloatMatrix2D P1 = new DenseFloatMatrix2D(rows, cols);
        P1.viewPart(0, 0, rows - cr, cols - cc).assign(PSF.viewPart(cr, cc, rows - cr, cols - cc));
        P1.viewPart(0, cols - cc, rows - cr, cc).assign(PSF.viewPart(cr, 0, rows - cr, cc));
        P1.viewPart(rows - cr, 0, cr, cols - cc).assign(PSF.viewPart(0, cc, cr, cols - cc));
        P1.viewPart(rows - cr, cols - cc, cr, cc).assign(PSF.viewPart(0, 0, cr, cc));
        return P1;
    }

    public static void convertImage(ImagePlus image, Enums.OutputType output) {
        switch (output) {
            case BYTE: {
                new ImageConverter(image).convertToGray8();
                break;
            }
            case SHORT: {
                new ImageConverter(image).convertToGray16();
                break;
            }
        }
    }

    public static FloatMatrix2D padPeriodic(final FloatMatrix2D X, int rowsPad, final int colsPad) {
        final int rows = X.rows();
        final int cols = X.columns();
        if (rows == rowsPad && cols == colsPad) {
            return X;
        }
        DenseFloatMatrix2D Xpad = new DenseFloatMatrix2D(rowsPad, colsPad);
        final int rOff = (rowsPad - rows + 1) / 2;
        final int cOff = (colsPad - cols + 1) / 2;
        final float[] elemsXpad = (float[])Xpad.elements();
        final int rowStrideXpad = Xpad.columns();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (X.isView()) {
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rowsPad / np;
                for (int j = 0; j < np; ++j) {
                    final int firstIdx = -rOff + j * k;
                    final int lastIdx = j == np - 1 ? rowsPad - rOff : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int r = firstIdx; r < lastIdx; ++r) {
                                int rOut = r + rOff;
                                int rIn = FloatCommon2D.periodic(r, rows);
                                for (int c = -cOff; c < colsPad - cOff; ++c) {
                                    int cOut = c + cOff;
                                    int cIn = FloatCommon2D.periodic(c, cols);
                                    int idxXpad = rOut * rowStrideXpad + cOut;
                                    elemsXpad[idxXpad] = X.getQuick(rIn, cIn);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int r = -rOff; r < rowsPad - rOff; ++r) {
                    int rOut = r + rOff;
                    int rIn = FloatCommon2D.periodic(r, rows);
                    for (int c = -cOff; c < colsPad - cOff; ++c) {
                        int cOut = c + cOff;
                        int cIn = FloatCommon2D.periodic(c, cols);
                        int idxXpad = rOut * rowStrideXpad + cOut;
                        elemsXpad[idxXpad] = X.getQuick(rIn, cIn);
                    }
                }
            }
        } else {
            final float[] elemsX = (float[])X.elements();
            final int rowStrideX = X.columns();
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rowsPad / np;
                for (int j = 0; j < np; ++j) {
                    final int firstIdx = -rOff + j * k;
                    final int lastIdx = j == np - 1 ? rowsPad - rOff : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int r = firstIdx; r < lastIdx; ++r) {
                                int rOut = r + rOff;
                                int rIn = FloatCommon2D.periodic(r, rows);
                                for (int c = -cOff; c < colsPad - cOff; ++c) {
                                    int cOut = c + cOff;
                                    int cIn = FloatCommon2D.periodic(c, cols);
                                    int idxX = rIn * rowStrideX + cIn;
                                    int idxXpad = rOut * rowStrideXpad + cOut;
                                    elemsXpad[idxXpad] = elemsX[idxX];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int r = -rOff; r < rowsPad - rOff; ++r) {
                    int rOut = r + rOff;
                    int rIn = FloatCommon2D.periodic(r, rows);
                    for (int c = -cOff; c < colsPad - cOff; ++c) {
                        int cOut = c + cOff;
                        int cIn = FloatCommon2D.periodic(c, cols);
                        int idxX = rIn * rowStrideX + cIn;
                        int idxXpad = rOut * rowStrideXpad + cOut;
                        elemsXpad[idxXpad] = elemsX[idxX];
                    }
                }
            }
        }
        return Xpad;
    }

    public static FloatMatrix2D padReflexive(final FloatMatrix2D X, int rowsPad, final int colsPad) {
        final int rows = X.rows();
        final int cols = X.columns();
        if (rows == rowsPad && cols == colsPad) {
            return X;
        }
        DenseFloatMatrix2D Xpad = new DenseFloatMatrix2D(rowsPad, colsPad);
        final int rOff = (rowsPad - rows + 1) / 2;
        final int cOff = (colsPad - cols + 1) / 2;
        final float[] elemsXpad = (float[])Xpad.elements();
        final int rowStrideXpad = Xpad.columns();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (X.isView()) {
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rowsPad / np;
                for (int j = 0; j < np; ++j) {
                    final int firstIdx = -rOff + j * k;
                    final int lastIdx = j == np - 1 ? rowsPad - rOff : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int r = firstIdx; r < lastIdx; ++r) {
                                int rOut = r + rOff;
                                int rIn = FloatCommon2D.mirror(r, rows);
                                for (int c = -cOff; c < colsPad - cOff; ++c) {
                                    int cOut = c + cOff;
                                    int cIn = FloatCommon2D.mirror(c, cols);
                                    int idxXpad = rOut * rowStrideXpad + cOut;
                                    elemsXpad[idxXpad] = X.getQuick(rIn, cIn);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int r = -rOff; r < rowsPad - rOff; ++r) {
                    int rOut = r + rOff;
                    int rIn = FloatCommon2D.mirror(r, rows);
                    for (int c = -cOff; c < colsPad - cOff; ++c) {
                        int cOut = c + cOff;
                        int cIn = FloatCommon2D.mirror(c, cols);
                        int idxXpad = rOut * rowStrideXpad + cOut;
                        elemsXpad[idxXpad] = X.getQuick(rIn, cIn);
                    }
                }
            }
        } else {
            final float[] elemsX = (float[])X.elements();
            final int rowStrideX = X.columns();
            if (np > 1 && rows * cols >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futures = new Future[np];
                int k = rowsPad / np;
                for (int j = 0; j < np; ++j) {
                    final int firstIdx = -rOff + j * k;
                    final int lastIdx = j == np - 1 ? rowsPad - rOff : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                        public void run() {
                            for (int r = firstIdx; r < lastIdx; ++r) {
                                int rOut = r + rOff;
                                int rIn = FloatCommon2D.mirror(r, rows);
                                for (int c = -cOff; c < colsPad - cOff; ++c) {
                                    int cOut = c + cOff;
                                    int cIn = FloatCommon2D.mirror(c, cols);
                                    int idxX = rIn * rowStrideX + cIn;
                                    int idxXpad = rOut * rowStrideXpad + cOut;
                                    elemsXpad[idxXpad] = elemsX[idxX];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion((Future[])futures);
            } else {
                for (int r = -rOff; r < rowsPad - rOff; ++r) {
                    int rOut = r + rOff;
                    int rIn = FloatCommon2D.mirror(r, rows);
                    for (int c = -cOff; c < colsPad - cOff; ++c) {
                        int cOut = c + cOff;
                        int cIn = FloatCommon2D.mirror(c, cols);
                        int idxX = rIn * rowStrideX + cIn;
                        int idxXpad = rOut * rowStrideXpad + cOut;
                        elemsXpad[idxXpad] = elemsX[idxX];
                    }
                }
            }
        }
        return Xpad;
    }

    public static FloatMatrix2D padZero(FloatMatrix2D X, int rowsPad, int colsPad) {
        int rows = X.rows();
        int cols = X.columns();
        if (rows == rowsPad && cols == colsPad) {
            return X;
        }
        DenseFloatMatrix2D Xpad = new DenseFloatMatrix2D(rowsPad, colsPad);
        int rOff = (rowsPad - rows + 1) / 2;
        int cOff = (colsPad - cols + 1) / 2;
        Xpad.viewPart(rOff, cOff, rows, cols).assign(X);
        return Xpad;
    }

    public static FloatMatrix2D padZero(FloatMatrix2D X, int[] padSize, IterativeEnums.PaddingType padding) {
        if (padSize[0] == 0 && padSize[1] == 0) {
            return X;
        }
        DenseFloatMatrix2D Xpad = null;
        switch (padding) {
            case BOTH: {
                Xpad = new DenseFloatMatrix2D(X.rows() + 2 * padSize[0], X.columns() + 2 * padSize[1]);
                Xpad.viewPart(padSize[0], padSize[1], X.rows(), X.columns()).assign(X);
                break;
            }
            case POST: {
                Xpad = new DenseFloatMatrix2D(X.rows() + padSize[0], X.columns() + padSize[1]);
                Xpad.viewPart(0, 0, X.rows(), X.columns()).assign(X);
                break;
            }
            case PRE: {
                Xpad = new DenseFloatMatrix2D(X.rows() + padSize[0], X.columns() + padSize[1]);
                Xpad.viewPart(padSize[0], padSize[1], X.rows(), X.columns()).assign(X);
            }
        }
        return Xpad;
    }

    public static FloatMatrix2D dctShift(FloatMatrix2D PSF, int[] center) {
        int rows = PSF.rows();
        int cols = PSF.columns();
        int cr = center[0];
        int cc = center[1];
        int k = Math.min(Math.min(Math.min(cr, rows - cr - 1), cc), cols - cc - 1);
        int frow = cr - k;
        int lrow = cr + k;
        int rowSize = lrow - frow + 1;
        int fcol = cc - k;
        int lcol = cc + k;
        int colSize = lcol - fcol + 1;
        DenseFloatMatrix2D PP = new DenseFloatMatrix2D(rowSize, colSize);
        DenseFloatMatrix2D P1 = new DenseFloatMatrix2D(rowSize, colSize);
        DenseFloatMatrix2D P2 = new DenseFloatMatrix2D(rowSize, colSize);
        DenseFloatMatrix2D P3 = new DenseFloatMatrix2D(rowSize, colSize);
        DenseFloatMatrix2D P4 = new DenseFloatMatrix2D(rowSize, colSize);
        DenseFloatMatrix2D Ps = new DenseFloatMatrix2D(rows, cols);
        PP.assign(PSF.viewPart(frow, fcol, rowSize, colSize));
        P1.viewPart(0, 0, rowSize - cr + frow, colSize - cc + fcol).assign(PP.viewPart(cr - frow, cc - fcol, rowSize - cr + frow, colSize - cc + fcol));
        P2.viewPart(0, 0, rowSize - cr + frow, colSize - cc + fcol - 1).assign(PP.viewPart(cr - frow, cc - fcol + 1, rowSize - cr + frow, colSize - cc + fcol - 1));
        P3.viewPart(0, 0, rowSize - cr + frow - 1, colSize - cc + fcol).assign(PP.viewPart(cr - frow + 1, cc - fcol, rowSize - cr + frow - 1, colSize - cc + fcol));
        P4.viewPart(0, 0, rowSize - cr + frow - 1, colSize - cc + fcol - 1).assign(PP.viewPart(cr - frow + 1, cc - fcol + 1, rowSize - cr + frow - 1, colSize - cc + fcol - 1));
        P1.assign((FloatMatrix2D)P2, FloatFunctions.plus);
        P1.assign((FloatMatrix2D)P3, FloatFunctions.plus);
        P1.assign((FloatMatrix2D)P4, FloatFunctions.plus);
        Ps.viewPart(0, 0, 2 * k + 1, 2 * k + 1).assign((FloatMatrix2D)P1);
        return Ps.copy();
    }

    public static void swapQuadrants(final int rows, final int columns, FloatMatrix2D X) {
        int idx2;
        int idx1;
        int j;
        Future[] futures;
        final float[] x = (float[])X.elements();
        final int cHalf = columns / 2;
        final int rHalf = rows / 2;
        int size = columns * rows / 2;
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            futures = new Future[np];
            int krow = rHalf / np;
            for (j = 0; j < np; ++j) {
                final int firstRow = j * krow;
                final int lastRow = j == np - 1 ? rHalf : firstRow + krow;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int rP = r + rHalf;
                            for (int c = 0; c < columns; ++c) {
                                int idx1 = c + columns * r;
                                int idx2 = c + columns * rP;
                                float temp = x[idx1];
                                x[idx1] = x[idx2];
                                x[idx2] = temp;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int r = 0; r < rHalf; ++r) {
                int rP = r + rHalf;
                for (int c = 0; c < columns; ++c) {
                    idx1 = c + columns * r;
                    idx2 = c + columns * rP;
                    float temp = x[idx1];
                    x[idx1] = x[idx2];
                    x[idx2] = temp;
                }
            }
        }
        if (np > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            futures = new Future[np];
            int kcol = cHalf / np;
            for (j = 0; j < np; ++j) {
                final int firstCol = j * kcol;
                final int lastCol = j == np - 1 ? cHalf : firstCol + kcol;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int c = firstCol; c < lastCol; ++c) {
                            int cP = c + cHalf;
                            for (int r = 0; r < rows; ++r) {
                                int idx1 = c + columns * r;
                                int idx2 = cP + columns * r;
                                float temp = x[idx1];
                                x[idx1] = x[idx2];
                                x[idx2] = temp;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int c = 0; c < cHalf; ++c) {
                int cP = c + cHalf;
                for (int r = 0; r < rows; ++r) {
                    idx1 = c + columns * r;
                    idx2 = cP + columns * r;
                    float temp = x[idx1];
                    x[idx1] = x[idx2];
                    x[idx2] = temp;
                }
            }
        }
    }

    public static void convolveTransposeFD(FloatMatrix2D H1, FloatMatrix2D H2, FloatMatrix2D Result) {
        int rows = H1.rows();
        int columns = H1.columns();
        float[] h1 = (float[])H1.elements();
        float[] h2 = (float[])H2.elements();
        float[] result = (float[])Result.elements();
        for (int r = 0; r < rows; ++r) {
            int rC = (rows - r) % rows;
            for (int c = 0; c < columns; ++c) {
                int cC = (columns - c) % columns;
                int idx1 = c + columns * r;
                int idx2 = cC + columns * rC;
                float h2e = (h2[idx1] + h2[idx2]) / 2.0f;
                float h2o = (h2[idx1] - h2[idx2]) / 2.0f;
                result[idx2] = h1[idx1] * h2e - h1[idx2] * h2o;
            }
        }
    }

    public static void convolveFD(FloatMatrix2D H1, FloatMatrix2D H2, FloatMatrix2D Result) {
        final int rows = H1.rows();
        final int columns = H1.columns();
        final float[] h1 = (float[])H1.elements();
        final float[] h2 = (float[])H2.elements();
        final float[] result = (float[])Result.elements();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && columns * rows >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futures = new Future[np];
            int k = rows / np;
            for (int j = 0; j < np; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == np - 1 ? rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int rC = (rows - r) % rows;
                            for (int c = 0; c < columns; ++c) {
                                int cC = (columns - c) % columns;
                                int idx1 = c + columns * r;
                                int idx2 = cC + columns * rC;
                                float h2e = (h2[idx1] + h2[idx2]) / 2.0f;
                                float h2o = (h2[idx1] - h2[idx2]) / 2.0f;
                                result[idx1] = h1[idx1] * h2e + h1[idx2] * h2o;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int r = 0; r < rows; ++r) {
                int rC = (rows - r) % rows;
                for (int c = 0; c < columns; ++c) {
                    int cC = (columns - c) % columns;
                    int idx1 = c + columns * r;
                    int idx2 = cC + columns * rC;
                    float h2e = (h2[idx1] + h2[idx2]) / 2.0f;
                    float h2o = (h2[idx1] - h2[idx2]) / 2.0f;
                    result[idx1] = h1[idx1] * h2e + h1[idx2] * h2o;
                }
            }
        }
    }

    private static int mirror(int i, int n) {
        int ip = FloatCommon2D.mod(i, 2 * n);
        if (ip < n) {
            return ip;
        }
        return n - ip % n - 1;
    }

    private static int mod(int i, int n) {
        return (i % n + n) % n;
    }

    private static int periodic(int i, int n) {
        int ip = FloatCommon2D.mod(i, 2 * n);
        if (ip < n) {
            return ip;
        }
        return ip % n;
    }
}

