/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative.cgls;

import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.jet.math.tdouble.DoubleFunctions;
import edu.emory.mathcs.restoretools.Enums;
import edu.emory.mathcs.restoretools.iterative.AbstractDoubleIterativeDeconvolver3D;
import edu.emory.mathcs.restoretools.iterative.DoubleCommon2D;
import edu.emory.mathcs.restoretools.iterative.DoubleCommon3D;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.restoretools.iterative.cgls.CGLSOptions;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;

public class CGLSDoubleIterativeDeconvolver3D
extends AbstractDoubleIterativeDeconvolver3D {
    protected boolean autoStoppingTol;
    protected double stoppingTol;

    public CGLSDoubleIterativeDeconvolver3D(ImagePlus imB, ImagePlus[][][] imPSF, IterativeEnums.PreconditionerType preconditioner, double preconditionerTol, IterativeEnums.BoundaryType boundary, IterativeEnums.ResizingType resizing, Enums.OutputType output, int maxIters, boolean showIteration, CGLSOptions options) {
        super("CGLS", imB, imPSF, preconditioner, preconditionerTol, boundary, resizing, output, options.getUseThreshold(), options.getThreshold(), maxIters, showIteration, options.getLogConvergence());
        this.autoStoppingTol = options.getAutoStoppingTol();
        this.stoppingTol = options.getStoppingTol();
    }

    public ImagePlus deconvolve() {
        int k;
        double gamma;
        double oldgamma = 0.0;
        if (this.autoStoppingTol) {
            this.stoppingTol = DoubleCommon2D.sqrteps * alg.vectorNorm2(this.A.times(this.B, true));
        }
        DoubleMatrix3D s = this.A.times(this.B, false);
        s.assign(this.B, DoubleFunctions.plusMultFirst((double)-1.0));
        DoubleMatrix3D r = this.A.times(s, true);
        double rnrm = alg.vectorNorm2(r);
        if (this.P != null) {
            r = this.P.solve((AbstractMatrix3D)r, true);
            gamma = alg.vectorNorm2(r);
            gamma *= gamma;
        } else {
            gamma = rnrm;
            gamma *= gamma;
        }
        ImagePlus imX = null;
        ImageStack is = new ImageStack(this.bColumns, this.bRows);
        if (this.showIteration) {
            DoubleCommon3D.assignPixelsToStack(is, this.B, this.cmY);
            imX = new ImagePlus("(deblurred)", is);
            imX.show();
        }
        DoubleMatrix3D p = r.copy();
        for (k = 0; k < this.maxIters; ++k) {
            DoubleMatrix3D q;
            if (rnrm <= this.stoppingTol) {
                IJ.log((String)("CGLS converged after " + k + "iterations."));
                break;
            }
            IJ.showStatus((String)(this.name + "iteration: " + (k + 1) + "/" + this.maxIters));
            if (k >= 1) {
                double beta = gamma / oldgamma;
                p.assign(r, DoubleFunctions.plusMultFirst((double)beta));
            }
            if (this.P != null) {
                r = this.P.solve((AbstractMatrix3D)p, false);
                q = this.A.times(r, false);
            } else {
                q = this.A.times(p, false);
            }
            double nq = alg.vectorNorm2(q);
            nq *= nq;
            double alpha = gamma / nq;
            if (this.P != null) {
                this.B.assign(r, DoubleFunctions.plusMultSecond((double)alpha));
            } else {
                this.B.assign(p, DoubleFunctions.plusMultSecond((double)alpha));
            }
            s.assign(q, DoubleFunctions.plusMultSecond((double)(-alpha)));
            r = this.A.times(s, true);
            rnrm = alg.vectorNorm2(r);
            if (this.P != null) {
                r = this.P.solve((AbstractMatrix3D)r, true);
                oldgamma = gamma;
                gamma = alg.vectorNorm2(r);
                gamma *= gamma;
            } else {
                oldgamma = gamma;
                gamma = rnrm;
                gamma *= gamma;
            }
            if (this.logConvergence) {
                IJ.log((String)(k + 1 + ".  Norm of the residual = " + rnrm));
            }
            if (!this.showIteration) continue;
            if (this.useThreshold) {
                DoubleCommon3D.updatePixelsInStack(is, this.B, this.cmY, this.threshold);
            } else {
                DoubleCommon3D.updatePixelsInStack(is, this.B, this.cmY);
            }
            ImageProcessor ip1 = imX.getProcessor();
            ip1.setMinAndMax(0.0, 0.0);
            ip1.setColorModel(this.cmY);
            imX.updateAndDraw();
        }
        if (this.logConvergence && k == this.maxIters) {
            IJ.log((String)"CGLS didn't converge. Reason: maximum number of iterations performed.");
        }
        if (!this.showIteration) {
            if (this.useThreshold) {
                DoubleCommon3D.assignPixelsToStack(is, this.B, this.cmY, this.threshold);
            } else {
                DoubleCommon3D.assignPixelsToStack(is, this.B, this.cmY);
            }
            imX = new ImagePlus("(deblurred)", is);
        }
        DoubleCommon3D.convertImage(imX, this.output);
        return imX;
    }
}

