/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative.cgls;

import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.mathcs.restoretools.Enums;
import edu.emory.mathcs.restoretools.iterative.AbstractFloatIterativeDeconvolver2D;
import edu.emory.mathcs.restoretools.iterative.FloatCommon2D;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.restoretools.iterative.cgls.CGLSOptions;
import ij.IJ;
import ij.ImagePlus;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class CGLSFloatIterativeDeconvolver2D
extends AbstractFloatIterativeDeconvolver2D {
    protected boolean autoStoppingTol;
    protected float stoppingTol;

    public CGLSFloatIterativeDeconvolver2D(ImagePlus imB, ImagePlus[][] imPSF, IterativeEnums.PreconditionerType preconditioner, float preconditionerTol, IterativeEnums.BoundaryType boundary, IterativeEnums.ResizingType resizing, Enums.OutputType output, int maxIters, boolean showIteration, CGLSOptions options) {
        super("CGLS", imB, imPSF, preconditioner, preconditionerTol, boundary, resizing, output, options.getUseThreshold(), (float)options.getThreshold(), maxIters, showIteration, options.getLogConvergence());
        this.autoStoppingTol = options.getAutoStoppingTol();
        this.stoppingTol = (float)options.getStoppingTol();
    }

    public ImagePlus deconvolve() {
        int k;
        float gamma;
        float oldgamma = 0.0f;
        if (this.autoStoppingTol) {
            this.stoppingTol = FloatCommon2D.sqrteps * alg.vectorNorm2(this.A.times(this.B, true));
        }
        FloatMatrix2D s = this.A.times(this.B, false);
        s.assign(this.B, FloatFunctions.plusMultFirst((float)-1.0f));
        FloatMatrix2D r = this.A.times(s, true);
        float rnrm = alg.vectorNorm2(r);
        if (this.P != null) {
            r = this.P.solve((AbstractMatrix2D)r, true);
            gamma = alg.vectorNorm2(r);
            gamma *= gamma;
        } else {
            gamma = rnrm;
            gamma *= gamma;
        }
        ImagePlus imX = null;
        FloatProcessor ip = new FloatProcessor(this.bColumns, this.bRows);
        if (this.showIteration) {
            FloatCommon2D.assignPixelsToProcessor(ip, this.B, this.cmY);
            imX = new ImagePlus("(deblurred)", (ImageProcessor)ip);
            imX.show();
        }
        FloatMatrix2D p = r.copy();
        for (k = 0; k < this.maxIters; ++k) {
            FloatMatrix2D q;
            if (rnrm <= this.stoppingTol) {
                IJ.log((String)("CGLS converged after " + k + "iterations."));
                break;
            }
            IJ.showStatus((String)(this.name + "iteration: " + (k + 1) + "/" + this.maxIters));
            if (k >= 1) {
                float beta = gamma / oldgamma;
                p.assign(r, FloatFunctions.plusMultFirst((float)beta));
            }
            if (this.P != null) {
                r = this.P.solve((AbstractMatrix2D)p, false);
                q = this.A.times(r, false);
            } else {
                q = this.A.times(p, false);
            }
            float nq = alg.vectorNorm2(q);
            nq *= nq;
            float alpha = gamma / nq;
            if (this.P != null) {
                this.B.assign(r, FloatFunctions.plusMultSecond((float)alpha));
            } else {
                this.B.assign(p, FloatFunctions.plusMultSecond((float)alpha));
            }
            s.assign(q, FloatFunctions.plusMultSecond((float)(-alpha)));
            r = this.A.times(s, true);
            rnrm = alg.vectorNorm2(r);
            if (this.P != null) {
                r = this.P.solve((AbstractMatrix2D)r, true);
                oldgamma = gamma;
                gamma = alg.vectorNorm2(r);
                gamma *= gamma;
            } else {
                oldgamma = gamma;
                gamma = rnrm;
                gamma *= gamma;
            }
            if (this.logConvergence) {
                IJ.log((String)(k + 1 + ".  Norm of the residual = " + rnrm));
            }
            if (!this.showIteration) continue;
            if (this.useThreshold) {
                FloatCommon2D.assignPixelsToProcessor(ip, this.B, this.cmY, this.threshold);
            } else {
                FloatCommon2D.assignPixelsToProcessor(ip, this.B, this.cmY);
            }
            imX.updateAndDraw();
        }
        if (this.logConvergence && k == this.maxIters) {
            IJ.log((String)"CGLS didn't converge. Reason: maximum number of iterations performed.");
        }
        if (!this.showIteration) {
            if (this.useThreshold) {
                FloatCommon2D.assignPixelsToProcessor(ip, this.B, this.cmY, this.threshold);
            } else {
                FloatCommon2D.assignPixelsToProcessor(ip, this.B, this.cmY);
            }
            imX = new ImagePlus("(deblurred)", (ImageProcessor)ip);
        }
        FloatCommon2D.convertImage(imX, this.output);
        return imX;
    }
}

