/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative.mrnsd;

import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import edu.emory.mathcs.restoretools.Enums;
import edu.emory.mathcs.restoretools.iterative.AbstractDoubleIterativeDeconvolver2D;
import edu.emory.mathcs.restoretools.iterative.DoubleCommon2D;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.restoretools.iterative.mrnsd.MRNSDOptions;
import ij.IJ;
import ij.ImagePlus;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class MRNSDDoubleIterativeDeconvolver2D
extends AbstractDoubleIterativeDeconvolver2D {
    protected boolean autoStoppingTol;
    protected double stoppingTol;

    public MRNSDDoubleIterativeDeconvolver2D(ImagePlus imB, ImagePlus[][] imPSF, IterativeEnums.PreconditionerType preconditioner, double preconditionerTol, IterativeEnums.BoundaryType boundary, IterativeEnums.ResizingType resizing, Enums.OutputType output, int maxIters, boolean showIteration, MRNSDOptions options) {
        super("MRNSD", imB, imPSF, preconditioner, preconditionerTol, boundary, resizing, output, options.getUseThreshold(), options.getThreshold(), maxIters, showIteration, options.getLogConvergence());
        this.autoStoppingTol = options.getAutoStoppingTol();
        this.stoppingTol = options.getStoppingTol();
    }

    public ImagePlus deconvolve() {
        int k;
        double rnrm;
        double gamma;
        double tau;
        double sigsq = tau = DoubleCommon2D.sqrteps;
        double[] minAndLoc = this.B.getMinLocation();
        double minB = minAndLoc[0];
        if (minB < 0.0) {
            this.B.assign(DoubleFunctions.plus((double)(-minB + sigsq)));
        }
        if (this.autoStoppingTol) {
            this.stoppingTol = DoubleCommon2D.sqrteps * alg.vectorNorm2(this.A.times(this.B, true));
        }
        DoubleMatrix2D r = this.A.times(this.B, false);
        r.assign(this.B, DoubleFunctions.plusMultFirst((double)-1.0));
        if (this.P != null) {
            r = this.P.solve((AbstractMatrix2D)r, false);
            r = this.P.solve((AbstractMatrix2D)r, true);
            r = this.A.times(r, true);
            r.assign(DoubleFunctions.neg);
            gamma = this.B.aggregate(r, DoubleFunctions.plus, DoubleFunctions.multSquare);
            rnrm = alg.vectorNorm2(r);
        } else {
            r = this.A.times(r, true);
            r.assign(DoubleFunctions.neg);
            gamma = this.B.aggregate(r, DoubleFunctions.plus, DoubleFunctions.multSquare);
            rnrm = Math.sqrt(gamma);
        }
        ImagePlus imX = null;
        FloatProcessor ip = new FloatProcessor(this.bColumns, this.bRows);
        if (this.showIteration) {
            DoubleCommon2D.assignPixelsToProcessor(ip, this.B, this.cmY);
            imX = new ImagePlus("(deblurred)", (ImageProcessor)ip);
            imX.show();
        }
        IntArrayList rowList = new IntArrayList((int)this.B.size() / 2);
        IntArrayList columnList = new IntArrayList((int)this.B.size() / 2);
        DoubleArrayList valueList = new DoubleArrayList((int)this.B.size() / 2);
        for (k = 0; k < this.maxIters; ++k) {
            if (rnrm <= this.stoppingTol) {
                IJ.log((String)("MRNSD converged after " + k + "iterations."));
                break;
            }
            IJ.showStatus((String)(this.name + " iteration: " + (k + 1) + "/" + this.maxIters));
            DoubleMatrix2D s = this.B.copy();
            s.assign(r, DoubleFunctions.multNeg);
            DoubleMatrix2D u = this.A.times(s, false);
            if (this.P != null) {
                u = this.P.solve((AbstractMatrix2D)u, false);
            }
            double theta = gamma / u.aggregate(DoubleFunctions.plus, DoubleFunctions.square);
            s.getNegativeValues(rowList, columnList, valueList);
            DoubleMatrix2D w = this.B.copy();
            w.assign(s, DoubleFunctions.divNeg, rowList, columnList);
            double alpha = Math.min(theta, w.aggregate(DoubleFunctions.min, DoubleFunctions.identity, rowList, columnList));
            this.B.assign(s, DoubleFunctions.plusMultSecond((double)alpha));
            if (this.P != null) {
                w = this.P.solve((AbstractMatrix2D)u, true);
                w = this.A.times(w, true);
                r.assign(w, DoubleFunctions.plusMultSecond((double)alpha));
                gamma = this.B.aggregate(r, DoubleFunctions.plus, DoubleFunctions.multSquare);
                rnrm = alg.vectorNorm2(r);
            } else {
                w = this.A.times(u, true);
                r.assign(w, DoubleFunctions.plusMultSecond((double)alpha));
                gamma = this.B.aggregate(r, DoubleFunctions.plus, DoubleFunctions.multSquare);
                rnrm = Math.sqrt(gamma);
            }
            if (this.logConvergence) {
                IJ.log((String)(k + 1 + ".  Norm of the residual = " + rnrm));
            }
            if (!this.showIteration) continue;
            if (this.useThreshold) {
                DoubleCommon2D.assignPixelsToProcessor(ip, this.B, this.cmY, this.threshold);
            } else {
                DoubleCommon2D.assignPixelsToProcessor(ip, this.B, this.cmY);
            }
            imX.updateAndDraw();
        }
        if (this.logConvergence && k == this.maxIters) {
            IJ.log((String)"MRNSD didn't converge. Reason: maximum number of iterations performed.");
        }
        if (!this.showIteration) {
            if (this.useThreshold) {
                DoubleCommon2D.assignPixelsToProcessor(ip, this.B, this.cmY, this.threshold);
            } else {
                DoubleCommon2D.assignPixelsToProcessor(ip, this.B, this.cmY);
            }
            imX = new ImagePlus("(deblurred)", (ImageProcessor)ip);
        }
        DoubleCommon2D.convertImage(imX, this.output);
        return imX;
    }
}

