/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative.psf;

import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix3D;
import cern.jet.math.tfcomplex.FComplexFunctions;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.mathcs.restoretools.iterative.FloatCommon3D;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.restoretools.iterative.psf.FloatPSF3D;
import edu.emory.mathcs.utils.pc.ConcurrencyUtils;
import ij.ImagePlus;

public class FloatPSFMatrix3D {
    private static final long serialVersionUID = -7503394849184235286L;
    private IterativeEnums.BoundaryType boundary;
    private IterativeEnums.ResizingType resizing;
    private IterativeEnums.PSFType type;
    private FloatPSF3D PSF;
    private int[] invPsfSize;
    private int[] invPadSize;
    private int[] varPsfSize;
    private int[] varPadSize;
    private int[] varNregions;
    private int[] varRsize;
    private int[] varPadSize1;
    private RegionIndices varRi;
    private RegionIndices varRiTr;
    private int[] imSize;
    private int[] varEpadSize;
    private RegionIndices varEri;
    private RegionIndices varTri;
    private FComplexMatrix3D[][][] matdata;

    public FloatPSFMatrix3D(ImagePlus[][][] imPSF, IterativeEnums.BoundaryType boundary, IterativeEnums.ResizingType resizing, int[] imSize) {
        this.PSF = new FloatPSF3D(imPSF);
        this.boundary = boundary;
        this.resizing = resizing;
        this.imSize = new int[3];
        this.imSize[0] = imSize[0];
        this.imSize[1] = imSize[1];
        this.imSize[2] = imSize[2];
        if (this.PSF.getNumberOfImages() > 1) {
            int j;
            int i;
            this.type = IterativeEnums.PSFType.VARIANT;
            this.varPadSize = new int[3];
            this.varPsfSize = this.PSF.getSize();
            this.varPadSize[0] = (int)Math.round((double)this.varPsfSize[0] / 2.0);
            this.varPadSize[1] = (int)Math.round((double)this.varPsfSize[1] / 2.0);
            this.varPadSize[2] = (int)Math.round((double)this.varPsfSize[2] / 2.0);
            this.constructMatrix();
            this.varNregions = new int[3];
            this.varNregions[0] = this.matdata.length;
            this.varNregions[1] = this.matdata[0].length;
            this.varNregions[2] = this.matdata[0][0].length;
            this.varRsize = new int[3];
            this.varRsize[0] = (int)Math.ceil((float)imSize[0] / (float)this.varNregions[0]);
            this.varRsize[1] = (int)Math.ceil((float)imSize[1] / (float)this.varNregions[1]);
            this.varRsize[2] = (int)Math.ceil((float)imSize[2] / (float)this.varNregions[2]);
            this.varPadSize1 = new int[3];
            this.varPadSize1[0] = this.varRsize[0] * this.varNregions[0] - imSize[0];
            this.varPadSize1[1] = this.varRsize[1] * this.varNregions[1] - imSize[1];
            this.varPadSize1[2] = this.varRsize[2] * this.varNregions[2] - imSize[2];
            this.varRi = this.regionIndices(this.varNregions, this.varRsize);
            this.varRiTr = this.regionIndices(this.varNregions, this.varRsize);
            for (i = 0; i < this.varRiTr.iidx.length; ++i) {
                for (j = 0; j < this.varRiTr.iidx[0].length; ++j) {
                    this.varRiTr.iidx[i][j] = this.varRiTr.iidx[i][j] + this.varPadSize[0];
                }
            }
            this.varRiTr.iidx[0][0] = 0;
            this.varRiTr.iidx[this.varRiTr.iidx.length - 1][this.varRiTr.iidx[0].length - 1] = this.varRiTr.iidx[this.varRiTr.iidx.length - 1][this.varRiTr.iidx[0].length - 1] + this.varPadSize[0];
            for (i = 0; i < this.varRiTr.jidx.length; ++i) {
                for (j = 0; j < this.varRiTr.jidx[0].length; ++j) {
                    this.varRiTr.jidx[i][j] = this.varRiTr.jidx[i][j] + this.varPadSize[1];
                }
            }
            this.varRiTr.jidx[0][0] = 0;
            this.varRiTr.jidx[this.varRiTr.jidx.length - 1][this.varRiTr.jidx[0].length - 1] = this.varRiTr.jidx[this.varRiTr.jidx.length - 1][this.varRiTr.jidx[0].length - 1] + this.varPadSize[1];
            for (i = 0; i < this.varRiTr.kidx.length; ++i) {
                for (j = 0; j < this.varRiTr.kidx[0].length; ++j) {
                    this.varRiTr.kidx[i][j] = this.varRiTr.kidx[i][j] + this.varPadSize[2];
                }
            }
            this.varRiTr.kidx[0][0] = 0;
            this.varRiTr.kidx[this.varRiTr.kidx.length - 1][this.varRiTr.kidx[0].length - 1] = this.varRiTr.kidx[this.varRiTr.kidx.length - 1][this.varRiTr.kidx[0].length - 1] + this.varPadSize[2];
            this.varEpadSize = new int[3];
            this.varEpadSize[0] = 2 * this.varPadSize[0];
            this.varEpadSize[1] = 2 * this.varPadSize[1];
            this.varEpadSize[2] = 2 * this.varPadSize[2];
            this.varEri = this.eregionIndices(this.varRi.iidx, this.varRi.jidx, this.varRi.kidx, this.varNregions, this.varEpadSize);
            this.varTri = this.tregionIndices(this.varRiTr.iidx, this.varRiTr.jidx, this.varRiTr.kidx, this.varNregions, this.varPadSize);
        } else {
            this.type = IterativeEnums.PSFType.INVARIANT;
            this.invPsfSize = this.PSF.getSize();
            int[] minimal = new int[]{this.invPsfSize[0] + imSize[0], this.invPsfSize[1] + imSize[1], this.invPsfSize[2] + imSize[2]};
            switch (resizing) {
                case AUTO: {
                    int[] nextPowTwo = new int[]{!ConcurrencyUtils.isPowerOf2((int)minimal[0]) ? ConcurrencyUtils.nextPow2((int)minimal[0]) : minimal[0], !ConcurrencyUtils.isPowerOf2((int)minimal[1]) ? ConcurrencyUtils.nextPow2((int)minimal[1]) : minimal[1], !ConcurrencyUtils.isPowerOf2((int)minimal[2]) ? ConcurrencyUtils.nextPow2((int)minimal[2]) : minimal[2]};
                    if ((double)nextPowTwo[0] >= 1.5 * (double)minimal[0] || (double)nextPowTwo[1] >= 1.5 * (double)minimal[1] || (double)nextPowTwo[2] >= 1.5 * (double)minimal[2]) {
                        this.invPsfSize[0] = minimal[0];
                        this.invPsfSize[1] = minimal[1];
                        this.invPsfSize[2] = minimal[2];
                        break;
                    }
                    this.invPsfSize[0] = nextPowTwo[0];
                    this.invPsfSize[1] = nextPowTwo[1];
                    this.invPsfSize[2] = nextPowTwo[2];
                    break;
                }
                case MINIMAL: {
                    this.invPsfSize[0] = minimal[0];
                    this.invPsfSize[1] = minimal[1];
                    this.invPsfSize[2] = minimal[2];
                    break;
                }
                case NEXT_POWER_OF_TWO: {
                    this.invPsfSize[0] = minimal[0];
                    this.invPsfSize[1] = minimal[1];
                    this.invPsfSize[2] = minimal[2];
                    if (!ConcurrencyUtils.isPowerOf2((int)this.invPsfSize[0])) {
                        this.invPsfSize[0] = ConcurrencyUtils.nextPow2((int)this.invPsfSize[0]);
                    }
                    if (!ConcurrencyUtils.isPowerOf2((int)this.invPsfSize[1])) {
                        this.invPsfSize[1] = ConcurrencyUtils.nextPow2((int)this.invPsfSize[1]);
                    }
                    if (ConcurrencyUtils.isPowerOf2((int)this.invPsfSize[2])) break;
                    this.invPsfSize[2] = ConcurrencyUtils.nextPow2((int)this.invPsfSize[2]);
                }
            }
            this.invPadSize = new int[3];
            if (imSize[0] < this.invPsfSize[0]) {
                this.invPadSize[0] = (this.invPsfSize[0] - imSize[0] + 1) / 2;
            }
            if (imSize[1] < this.invPsfSize[1]) {
                this.invPadSize[1] = (this.invPsfSize[1] - imSize[1] + 1) / 2;
            }
            if (imSize[2] < this.invPsfSize[2]) {
                this.invPadSize[2] = (this.invPsfSize[2] - imSize[2] + 1) / 2;
            }
            this.constructMatrix();
        }
    }

    public FloatMatrix1D times(FloatMatrix1D b, boolean transpose) {
        DenseFloatMatrix3D B = null;
        B = b.isView() ? new DenseFloatMatrix3D(this.imSize[0], this.imSize[1], this.imSize[2], (float[])b.copy().elements(), 0, 0, 0, this.imSize[1] * this.imSize[2], this.imSize[2], 1, false) : new DenseFloatMatrix3D(this.imSize[0], this.imSize[1], this.imSize[2], (float[])b.elements(), 0, 0, 0, this.imSize[1] * this.imSize[2], this.imSize[2], 1, false);
        B = this.times((FloatMatrix3D)B, transpose);
        return new DenseFloatMatrix1D((int)B.size(), (float[])B.elements(), 0, 1, false);
    }

    public FloatMatrix3D times(FloatMatrix3D B, boolean transpose) {
        FloatMatrix3D Bpad = null;
        switch (this.type) {
            case INVARIANT: {
                switch (this.boundary) {
                    case ZERO: {
                        Bpad = FloatCommon3D.padZero(B, this.invPsfSize[0], this.invPsfSize[1], this.invPsfSize[2]);
                        break;
                    }
                    case PERIODIC: {
                        Bpad = FloatCommon3D.padPeriodic(B, this.invPsfSize[0], this.invPsfSize[1], this.invPsfSize[2]);
                        break;
                    }
                    case REFLEXIVE: {
                        Bpad = FloatCommon3D.padReflexive(B, this.invPsfSize[0], this.invPsfSize[1], this.invPsfSize[2]);
                    }
                }
                return this.invariantMultiply((AbstractMatrix3D)Bpad, transpose);
            }
            case VARIANT: {
                switch (this.boundary) {
                    case ZERO: {
                        Bpad = FloatCommon3D.padZero(B, this.imSize[0] + 2 * this.varPadSize[0], this.imSize[1] + 2 * this.varPadSize[1], this.imSize[2] + 2 * this.varPadSize[2]);
                        break;
                    }
                    case REFLEXIVE: {
                        Bpad = FloatCommon3D.padReflexive(B, this.imSize[0] + 2 * this.varPadSize[0], this.imSize[1] + 2 * this.varPadSize[1], this.imSize[2] + 2 * this.varPadSize[2]);
                        break;
                    }
                    case PERIODIC: {
                        Bpad = FloatCommon3D.padPeriodic(B, this.imSize[0] + 2 * this.varPadSize[0], this.imSize[1] + 2 * this.varPadSize[1], this.imSize[2] + 2 * this.varPadSize[2]);
                    }
                }
                if (transpose) {
                    return this.variantTransposeMultiply(Bpad);
                }
                return this.variantMultiply(Bpad);
            }
        }
        return null;
    }

    public FloatPSF3D getPSF() {
        return this.PSF;
    }

    public int[] getSize() {
        int[] psfSize = this.PSF.getSize();
        psfSize[0] = psfSize[0] * psfSize[0];
        psfSize[1] = psfSize[1] * psfSize[1];
        psfSize[2] = psfSize[2] * psfSize[2];
        return psfSize;
    }

    public IterativeEnums.BoundaryType getBoundary() {
        return this.boundary;
    }

    public int[] getInvPsfSize() {
        return this.invPsfSize;
    }

    public int[] getInvPadSize() {
        return this.invPadSize;
    }

    public IterativeEnums.ResizingType getResizing() {
        return this.resizing;
    }

    public IterativeEnums.PSFType getType() {
        return this.type;
    }

    private FloatMatrix3D invariantMultiply(AbstractMatrix3D Bpad, boolean transpose) {
        Bpad = ((DenseFloatMatrix3D)Bpad).getFft3();
        if (transpose) {
            ((FComplexMatrix3D)Bpad).assign(this.matdata[0][0][0], FComplexFunctions.multConjSecond);
        } else {
            ((FComplexMatrix3D)Bpad).assign(this.matdata[0][0][0], FComplexFunctions.mult);
        }
        ((DenseFComplexMatrix3D)Bpad).ifft3(true);
        return ((FComplexMatrix3D)Bpad).viewPart(this.invPadSize[0], this.invPadSize[1], this.invPadSize[2], this.imSize[0], this.imSize[1], this.imSize[2]).getRealPart();
    }

    private FloatMatrix3D variantMultiply(FloatMatrix3D Bpad) {
        if (this.varPadSize1[0] > 0 || this.varPadSize1[1] > 0) {
            Bpad = FloatCommon3D.padZero(Bpad, this.varPadSize1, IterativeEnums.PaddingType.POST);
        }
        DenseFloatMatrix3D Y = new DenseFloatMatrix3D(Bpad.slices(), Bpad.rows(), Bpad.columns());
        for (int i = 0; i < this.varNregions[0]; ++i) {
            for (int j = 0; j < this.varNregions[1]; ++j) {
                for (int k = 0; k < this.varNregions[2]; ++k) {
                    FloatMatrix3D Xt = Bpad.viewPart(this.varEri.iidx[i][0], this.varEri.jidx[j][0], this.varEri.kidx[k][0], this.varEri.iidx[i][1] - this.varEri.iidx[i][0] + 1, this.varEri.jidx[j][1] - this.varEri.jidx[j][0] + 1, this.varEri.kidx[k][1] - this.varEri.kidx[k][0] + 1);
                    FloatMatrix3D Yt = this.variantMultiplyOnePsf(i, j, k, Xt, false);
                    Y.viewPart(this.varRi.iidx[i][0], this.varRi.jidx[j][0], this.varRi.kidx[k][0], this.varRi.iidx[i][1] - this.varRi.iidx[i][0] + 1, this.varRi.jidx[j][1] - this.varRi.jidx[j][0] + 1, this.varRi.kidx[k][1] - this.varRi.kidx[k][0] + 1).assign(Yt);
                }
            }
        }
        Y = Y.viewPart(0, 0, 0, this.imSize[0], this.imSize[1], this.imSize[2]).copy();
        return Y;
    }

    private FloatMatrix3D variantTransposeMultiply(FloatMatrix3D Bpad) {
        if (this.varPadSize1[0] > 0 || this.varPadSize1[1] > 0) {
            Bpad = FloatCommon3D.padZero(Bpad, this.varPadSize1, IterativeEnums.PaddingType.POST);
        }
        DenseFloatMatrix3D Y = new DenseFloatMatrix3D(Bpad.slices(), Bpad.rows(), Bpad.columns());
        int[] eregionSize = new int[3];
        for (int i = 0; i < this.varNregions[0]; ++i) {
            for (int j = 0; j < this.varNregions[1]; ++j) {
                for (int k = 0; k < this.varNregions[2]; ++k) {
                    eregionSize[0] = this.varEri.iidx[i][1] - this.varEri.iidx[i][0] + 1;
                    eregionSize[1] = this.varEri.jidx[j][1] - this.varEri.jidx[j][0] + 1;
                    eregionSize[2] = this.varEri.kidx[k][1] - this.varEri.kidx[k][0] + 1;
                    DenseFloatMatrix3D Xt = new DenseFloatMatrix3D(eregionSize[0], eregionSize[1], eregionSize[2]);
                    Xt.viewPart(this.varTri.iidx[i][0], this.varTri.jidx[j][0], this.varTri.kidx[k][0], this.varTri.iidx[i][1] - this.varTri.iidx[i][0] + 1, this.varTri.jidx[j][1] - this.varTri.jidx[j][0] + 1, this.varTri.kidx[k][1] - this.varTri.kidx[k][0] + 1).assign(Bpad.viewPart(this.varRiTr.iidx[i][0], this.varRiTr.jidx[j][0], this.varRiTr.kidx[k][0], this.varRiTr.iidx[i][1] - this.varRiTr.iidx[i][0] + 1, this.varRiTr.jidx[j][1] - this.varRiTr.jidx[j][0] + 1, this.varRiTr.kidx[k][1] - this.varRiTr.kidx[k][0] + 1));
                    Xt = FloatCommon3D.padZero((FloatMatrix3D)Xt, this.varPadSize, IterativeEnums.PaddingType.BOTH);
                    FloatMatrix3D Yt = this.variantMultiplyOnePsf(i, j, k, (FloatMatrix3D)Xt, true);
                    Y.viewPart(this.varEri.iidx[i][0], this.varEri.jidx[j][0], this.varEri.kidx[k][0], this.varEri.iidx[i][1] - this.varEri.iidx[i][0] + 1, this.varEri.jidx[j][1] - this.varEri.jidx[j][0] + 1, this.varEri.kidx[k][1] - this.varEri.kidx[k][0] + 1).assign(Y.viewPart(this.varEri.iidx[i][0], this.varEri.jidx[j][0], this.varEri.kidx[k][0], this.varEri.iidx[i][1] - this.varEri.iidx[i][0] + 1, this.varEri.jidx[j][1] - this.varEri.jidx[j][0] + 1, this.varEri.kidx[k][1] - this.varEri.kidx[k][0] + 1).assign(Yt, FloatFunctions.plus));
                }
            }
        }
        int[][] idx = new int[2][3];
        idx[0][0] = this.varPadSize[0];
        idx[0][1] = this.varPadSize[1];
        idx[0][2] = this.varPadSize[2];
        idx[1][0] = this.varPadSize[0] + this.imSize[0];
        idx[1][1] = this.varPadSize[1] + this.imSize[1];
        idx[1][2] = this.varPadSize[2] + this.imSize[2];
        Y = Y.viewPart(idx[0][0], idx[0][1], idx[0][2], idx[1][0] - idx[0][0], idx[1][1] - idx[0][1], idx[1][2] - idx[0][2]).copy();
        return Y;
    }

    private FloatMatrix3D variantMultiplyOnePsf(int slice, int row, int col, FloatMatrix3D X, boolean transpose) {
        int[] imSize = new int[]{X.slices() - 2 * this.varPadSize[0], X.rows() - 2 * this.varPadSize[1], X.columns() - 2 * this.varPadSize[2]};
        PartitionInfo pi = this.partitionInfo(imSize, this.varPadSize);
        int[] padSize1 = new int[]{pi.rsize[0] * pi.nregions[0] - imSize[0], pi.rsize[1] * pi.nregions[1] - imSize[1], pi.rsize[2] * pi.nregions[2] - imSize[2]};
        if (padSize1[0] > 0 || padSize1[1] > 0 || padSize1[2] > 0) {
            X = FloatCommon3D.padZero(X, padSize1, IterativeEnums.PaddingType.POST);
        }
        RegionIndices ri = this.regionIndices(pi.nregions, pi.rsize);
        int[] epadSize = new int[]{2 * this.varPadSize[0], 2 * this.varPadSize[1], 2 * this.varPadSize[2]};
        RegionIndices eri = this.eregionIndices(ri.iidx, ri.jidx, ri.kidx, pi.nregions, epadSize);
        int[][] tidx = new int[2][3];
        tidx[0][0] = this.varPadSize[0];
        tidx[0][1] = this.varPadSize[1];
        tidx[0][2] = this.varPadSize[2];
        tidx[1][0] = this.varPadSize[0] + pi.rsize[0] - 1;
        tidx[1][1] = this.varPadSize[1] + pi.rsize[1] - 1;
        tidx[1][2] = this.varPadSize[2] + pi.rsize[2] - 1;
        DenseFloatMatrix3D Y = new DenseFloatMatrix3D(X.slices(), X.rows(), X.columns());
        for (int i = 0; i < pi.nregions[0]; ++i) {
            for (int j = 0; j < pi.nregions[1]; ++j) {
                for (int k = 0; k < pi.nregions[2]; ++k) {
                    FloatMatrix3D Xt = X.viewPart(eri.iidx[i][0], eri.jidx[j][0], eri.kidx[k][0], eri.iidx[i][1] - eri.iidx[i][0] + 1, eri.jidx[j][1] - eri.jidx[j][0] + 1, eri.kidx[k][1] - eri.kidx[k][0] + 1);
                    FloatMatrix3D Yt = this.multiplyOneRegion(slice, row, col, (AbstractMatrix3D)Xt, transpose);
                    Y.viewPart(ri.iidx[i][0], ri.jidx[j][0], ri.kidx[k][0], ri.iidx[i][1] - ri.iidx[i][0] + 1, ri.jidx[j][1] - ri.jidx[j][0] + 1, ri.kidx[k][1] - ri.kidx[k][0] + 1).assign(Yt.viewPart(tidx[0][0], tidx[0][1], tidx[0][2], tidx[1][0] - tidx[0][0] + 1, tidx[1][1] - tidx[0][1] + 1, tidx[1][2] - tidx[0][2] + 1));
                }
            }
        }
        Y = Y.viewPart(0, 0, 0, imSize[0], imSize[1], imSize[2]);
        return Y;
    }

    private FloatMatrix3D multiplyOneRegion(int slice, int row, int col, AbstractMatrix3D X, boolean transpose) {
        int slicesX = X.slices();
        int rowsX = X.rows();
        int colsX = X.columns();
        int[] padSize = new int[]{this.matdata[slice][row][col].slices() - slicesX, this.matdata[slice][row][col].rows() - rowsX, this.matdata[slice][row][col].columns() - colsX};
        if (padSize[0] > 0 || padSize[1] > 0 || padSize[2] > 0) {
            X = FloatCommon3D.padZero((FloatMatrix3D)X, padSize, IterativeEnums.PaddingType.POST);
        } else if (X.isView()) {
            X = ((FloatMatrix3D)X).copy();
        }
        X = ((DenseFloatMatrix3D)X).getFft3();
        if (transpose) {
            ((FComplexMatrix3D)X).assign(this.matdata[slice][row][col], FComplexFunctions.multConjSecond);
        } else {
            ((FComplexMatrix3D)X).assign(this.matdata[slice][row][col], FComplexFunctions.mult);
        }
        ((DenseFComplexMatrix3D)X).ifft3(true);
        X = ((FComplexMatrix3D)X).viewPart(0, 0, 0, slicesX, rowsX, colsX).getRealPart();
        return (FloatMatrix3D)X;
    }

    private PartitionInfo partitionInfo(int[] imSize, int[] padSize) {
        int[] psfSize = new int[]{padSize[0] == 0 ? 1 : 2 * padSize[0], padSize[1] == 0 ? 1 : 2 * padSize[1], padSize[2] == 0 ? 1 : 2 * padSize[2]};
        PartitionInfo pi = new PartitionInfo();
        pi.rsize[0] = Math.min(psfSize[0], imSize[0]);
        pi.rsize[1] = Math.min(psfSize[1], imSize[1]);
        pi.rsize[2] = Math.min(psfSize[2], imSize[2]);
        pi.nregions[0] = (int)Math.ceil((float)imSize[0] / (float)pi.rsize[0]);
        pi.nregions[1] = (int)Math.ceil((float)imSize[1] / (float)pi.rsize[1]);
        pi.nregions[2] = (int)Math.ceil((float)imSize[2] / (float)pi.rsize[2]);
        return pi;
    }

    private RegionIndices regionIndices(int[] nregions, int[] rsize) {
        int i;
        RegionIndices ri = new RegionIndices(nregions);
        ri.iidx[0][0] = 0;
        ri.iidx[0][1] = rsize[0] - 1;
        ri.jidx[0][0] = 0;
        ri.jidx[0][1] = rsize[1] - 1;
        ri.kidx[0][0] = 0;
        ri.kidx[0][1] = rsize[2] - 1;
        for (i = 1; i < nregions[0]; ++i) {
            ri.iidx[i][0] = ri.iidx[i - 1][1] + 1;
            ri.iidx[i][1] = ri.iidx[i][0] + rsize[0] - 1;
        }
        for (i = 1; i < nregions[1]; ++i) {
            ri.jidx[i][0] = ri.jidx[i - 1][1] + 1;
            ri.jidx[i][1] = ri.jidx[i][0] + rsize[1] - 1;
        }
        for (i = 1; i < nregions[2]; ++i) {
            ri.kidx[i][0] = ri.kidx[i - 1][1] + 1;
            ri.kidx[i][1] = ri.kidx[i][0] + rsize[2] - 1;
        }
        return ri;
    }

    private RegionIndices eregionIndices(int[][] iidx, int[][] jidx, int[][] kidx, int[] nregions, int[] rsize) {
        int i;
        RegionIndices eri = new RegionIndices(nregions);
        for (i = 0; i < nregions[0]; ++i) {
            eri.iidx[i][0] = iidx[i][0];
            eri.iidx[i][1] = iidx[i][1] + 2 * (int)Math.floor((double)rsize[0] / 2.0);
        }
        for (i = 0; i < nregions[1]; ++i) {
            eri.jidx[i][0] = jidx[i][0];
            eri.jidx[i][1] = jidx[i][1] + 2 * (int)Math.floor((double)rsize[1] / 2.0);
        }
        for (i = 0; i < nregions[2]; ++i) {
            eri.kidx[i][0] = kidx[i][0];
            eri.kidx[i][1] = kidx[i][1] + 2 * (int)Math.floor((double)rsize[2] / 2.0);
        }
        return eri;
    }

    private RegionIndices tregionIndices(int[][] iidx, int[][] jidx, int[][] kidx, int[] nregions, int[] padSize) {
        int i;
        RegionIndices tri = new RegionIndices(nregions);
        for (i = 1; i < nregions[0]; ++i) {
            tri.iidx[i][0] = padSize[0];
        }
        for (i = 0; i < nregions[0] - 1; ++i) {
            tri.iidx[i][1] = iidx[0][1];
        }
        tri.iidx[nregions[0] - 1][1] = nregions[0] > 1 ? iidx[0][1] + padSize[0] : iidx[0][1];
        for (i = 1; i < nregions[1]; ++i) {
            tri.jidx[i][0] = padSize[1];
        }
        for (i = 0; i < nregions[1] - 1; ++i) {
            tri.jidx[i][1] = jidx[0][1];
        }
        tri.jidx[nregions[1] - 1][1] = nregions[1] > 1 ? jidx[0][1] + padSize[1] : jidx[0][1];
        for (i = 1; i < nregions[2]; ++i) {
            tri.kidx[i][0] = padSize[2];
        }
        for (i = 0; i < nregions[2] - 1; ++i) {
            tri.kidx[i][1] = kidx[0][1];
        }
        tri.kidx[nregions[2] - 1][1] = nregions[2] > 1 ? kidx[0][1] + padSize[2] : kidx[0][1];
        return tri;
    }

    private void constructMatrix() {
        FloatMatrix3D[][][] image = this.PSF.getImage();
        int[][][][] center = this.PSF.getCenter();
        switch (this.type) {
            case INVARIANT: {
                this.matdata = new FComplexMatrix3D[1][1][1];
                this.matdata[0][0][0] = this.onePsfMatrixInvariant(image[0][0][0], center[0][0][0]);
                break;
            }
            case VARIANT: {
                this.matdata = new FComplexMatrix3D[image.length][image[0].length][image[0][0].length];
                for (int i = 0; i < this.matdata.length; ++i) {
                    for (int j = 0; j < this.matdata[0].length; ++j) {
                        for (int k = 0; k < this.matdata[0][0].length; ++k) {
                            this.matdata[i][j][k] = this.onePsfMatrixVariant(image[i][j][k], center[i][j][k]);
                        }
                    }
                }
                break;
            }
            default: {
                return;
            }
        }
    }

    private FComplexMatrix3D onePsfMatrixInvariant(FloatMatrix3D image, int[] center) {
        image.normalize();
        int slices = image.slices();
        int rows = image.rows();
        int columns = image.columns();
        DenseFloatMatrix3D matdata = new DenseFloatMatrix3D(this.invPsfSize[0], this.invPsfSize[1], this.invPsfSize[2]);
        ((FloatMatrix3D)matdata).viewPart(0, 0, 0, slices, rows, columns).assign(image);
        matdata = FloatCommon3D.circShift((FloatMatrix3D)matdata, center);
        matdata = matdata.getFft3();
        return (FComplexMatrix3D)matdata;
    }

    private FComplexMatrix3D onePsfMatrixVariant(FloatMatrix3D image, int[] center) {
        image.normalize();
        int slices = 2 * image.slices();
        int rows = 2 * image.rows();
        int columns = 2 * image.columns();
        switch (this.resizing) {
            case AUTO: {
                int[] nextPowTwo = new int[]{!ConcurrencyUtils.isPowerOf2((int)slices) ? ConcurrencyUtils.nextPow2((int)slices) : slices, !ConcurrencyUtils.isPowerOf2((int)rows) ? ConcurrencyUtils.nextPow2((int)rows) : rows, !ConcurrencyUtils.isPowerOf2((int)columns) ? ConcurrencyUtils.nextPow2((int)columns) : columns};
                if (!((double)nextPowTwo[0] < 1.5 * (double)slices) || !((double)nextPowTwo[1] < 1.5 * (double)rows) || !((double)nextPowTwo[2] < 1.5 * (double)columns)) break;
                slices = nextPowTwo[0];
                rows = nextPowTwo[1];
                columns = nextPowTwo[2];
                break;
            }
            case NEXT_POWER_OF_TWO: {
                if (!ConcurrencyUtils.isPowerOf2((int)slices)) {
                    rows = ConcurrencyUtils.nextPow2((int)slices);
                }
                if (!ConcurrencyUtils.isPowerOf2((int)rows)) {
                    rows = ConcurrencyUtils.nextPow2((int)rows);
                }
                if (ConcurrencyUtils.isPowerOf2((int)columns)) break;
                columns = ConcurrencyUtils.nextPow2((int)columns);
                break;
            }
        }
        DenseFloatMatrix3D matdata = new DenseFloatMatrix3D(slices, rows, columns);
        ((FloatMatrix3D)matdata).viewPart(0, 0, 0, image.slices(), image.rows(), image.columns()).assign(image);
        matdata = FloatCommon3D.circShift((FloatMatrix3D)matdata, center);
        matdata = matdata.getFft3();
        return (FComplexMatrix3D)matdata;
    }

    private class RegionIndices {
        public final int[][] iidx;
        public final int[][] jidx;
        public final int[][] kidx;

        public RegionIndices(int[] nregions) {
            this.iidx = new int[nregions[0]][2];
            this.jidx = new int[nregions[1]][2];
            this.kidx = new int[nregions[2]][2];
        }
    }

    private class PartitionInfo {
        public final int[] nregions = new int[3];
        public final int[] rsize = new int[3];

        private PartitionInfo() {
        }
    }
}

