/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative.wpl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import edu.emory.mathcs.restoretools.Enums;
import edu.emory.mathcs.restoretools.iterative.DoubleCommon2D;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.restoretools.iterative.wpl.WPLOptions;
import edu.emory.mathcs.utils.pc.ConcurrencyUtils;
import ij.IJ;
import ij.ImagePlus;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.image.ColorModel;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class WPLDoubleIterativeDeconvolver2D {
    protected DoubleMatrix2D B;
    protected DoubleMatrix2D PSF;
    protected ColorModel cmY;
    protected int bColumns;
    protected int bRows;
    protected int maxIters;
    protected boolean useThreshold;
    protected double threshold;
    protected boolean showIteration;
    protected boolean logConvergence;
    protected Enums.OutputType output;
    private int columns;
    private int rows;
    private double minB = 0.0;
    private double minPSF = 0.0;
    private double sum;
    private double scalePSF = 1.0;
    private double[][] gweights;
    protected double gamma;
    protected double filterXY;
    protected double filterZ;
    protected boolean normalize;
    protected boolean antiRing;
    protected double changeThreshPercent;
    protected boolean dB;
    protected boolean detectDivergence;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WPLDoubleIterativeDeconvolver2D(ImagePlus imB, ImagePlus imPSF, IterativeEnums.BoundaryType boundary, IterativeEnums.ResizingType resizing, Enums.OutputType output, int maxIters, boolean showIteration, WPLOptions options) {
        IJ.showStatus((String)"WPL initialization...");
        ImageProcessor ipB = imB.getProcessor();
        if (output == Enums.OutputType.SAME_AS_SOURCE) {
            if (ipB instanceof ByteProcessor) {
                this.output = Enums.OutputType.BYTE;
            } else if (ipB instanceof ShortProcessor) {
                this.output = Enums.OutputType.SHORT;
            } else {
                if (!(ipB instanceof FloatProcessor)) throw new IllegalArgumentException("Unsupported image type.");
                this.output = Enums.OutputType.FLOAT;
            }
        } else {
            this.output = output;
        }
        this.cmY = ipB.getColorModel();
        this.bColumns = ipB.getWidth();
        this.bRows = ipB.getHeight();
        this.B = new DenseDoubleMatrix2D(this.bRows, this.bColumns);
        DoubleCommon2D.assignPixelsToMatrix(this.B, ipB);
        ImageProcessor ipPSF = imPSF.getProcessor();
        int psfColumns = ipPSF.getWidth();
        int psfRows = ipPSF.getHeight();
        this.PSF = new DenseDoubleMatrix2D(psfRows, psfColumns);
        DoubleCommon2D.assignPixelsToMatrix(this.PSF, ipPSF);
        this.maxIters = maxIters;
        this.showIteration = showIteration;
        this.gamma = options.getGamma();
        this.filterXY = options.getFilterXY();
        this.filterZ = options.getFilterZ();
        this.normalize = options.isNormalize();
        this.antiRing = options.isAntiRing();
        this.changeThreshPercent = options.getChangeThreshPercent();
        this.dB = options.isDB();
        this.detectDivergence = options.isDetectDivergence();
        this.logConvergence = options.isLogConvergence();
        if (this.dB) {
            this.minB = WPLDoubleIterativeDeconvolver2D.unDB(this.B);
            this.minPSF = WPLDoubleIterativeDeconvolver2D.unDB(this.PSF);
        }
        this.sum = this.PSF.zSum();
        if (this.sum != 0.0 && this.normalize) {
            this.scalePSF /= this.sum;
        }
        this.columns = WPLDoubleIterativeDeconvolver2D.expandedSize(psfColumns, this.bColumns, resizing);
        this.rows = WPLDoubleIterativeDeconvolver2D.expandedSize(psfRows, this.bRows, resizing);
        if (psfColumns > this.columns || psfRows > this.rows) {
            throw new IllegalArgumentException("PSF cannot be largest that the image.");
        }
        this.gweights = WPLDoubleIterativeDeconvolver2D.gaussianWeights(this.rows, this.columns, this.filterXY, this.filterXY);
        switch (boundary) {
            case PERIODIC: {
                this.B = DoubleCommon2D.padPeriodic(this.B, this.rows, this.columns);
                break;
            }
            case REFLEXIVE: {
                this.B = DoubleCommon2D.padReflexive(this.B, this.rows, this.columns);
                break;
            }
            case ZERO: {
                this.B = DoubleCommon2D.padZero(this.B, this.rows, this.columns);
            }
        }
        double[] maxLoc = this.PSF.getMaxLocation();
        int[] padSize = new int[]{this.rows - psfRows, this.columns - psfColumns};
        this.PSF = DoubleCommon2D.padZero(this.PSF, padSize, IterativeEnums.PaddingType.POST);
        this.PSF = DoubleCommon2D.circShift(this.PSF, new int[]{(int)maxLoc[1], (int)maxLoc[2]});
    }

    public ImagePlus deconvolve() {
        DoubleMatrix2D X;
        ((DenseDoubleMatrix2D)this.PSF).dht2();
        DoubleMatrix2D AX = this.B.like();
        if (this.antiRing) {
            IJ.showStatus((String)"WPL: performing anti-ringing step.");
            X = this.B.copy();
            ((DenseDoubleMatrix2D)X).dht2();
            WPLDoubleIterativeDeconvolver2D.convolveFD(this.rows, this.columns, this.PSF, X, AX);
            ((DenseDoubleMatrix2D)AX).idht2(true);
            WPLDoubleIterativeDeconvolver2D.copyDataAverage(this.bRows, this.bColumns, this.rows, this.columns, this.sum, this.B, AX, this.B);
        }
        if (this.gamma > 1.0E-4) {
            IJ.showStatus((String)"WPL: Wiener filter");
            double magMax = WPLDoubleIterativeDeconvolver2D.findMagMax(this.PSF);
            ((DenseDoubleMatrix2D)this.B).dht2();
            X = this.PSF.copy();
            WPLDoubleIterativeDeconvolver2D.deconvolveFD(this.gamma, magMax, this.rows, this.columns, X, X, this.PSF);
            AX = this.B.copy();
            WPLDoubleIterativeDeconvolver2D.deconvolveFD(this.gamma, magMax, this.rows, this.columns, AX, X, this.B);
            ((DenseDoubleMatrix2D)this.B).idht2(true);
        }
        int rOff = (this.rows - this.bRows + 1) / 2;
        int cOff = (this.columns - this.bColumns + 1) / 2;
        ((DenseDoubleMatrix2D)this.PSF).idht2(true);
        double aSum = this.PSF.aggregate(DoubleFunctions.plus, DoubleFunctions.abs);
        if (this.scalePSF != 1.0) {
            this.B.assign(DoubleFunctions.div((double)this.scalePSF));
        }
        ((DenseDoubleMatrix2D)this.PSF).dht2();
        X = this.B.copy();
        ImagePlus imX = null;
        FloatProcessor ip = new FloatProcessor(this.bColumns, this.bRows);
        if (this.showIteration) {
            DoubleCommon2D.assignPixelsToProcessorPadded(ip, X, this.bRows, this.bColumns, rOff, cOff, this.cmY);
            imX = new ImagePlus("(deblurred)", (ImageProcessor)ip);
            imX.show();
        }
        double oldPercentChange = Double.MAX_VALUE;
        for (int iter = 0; iter < this.maxIters; ++iter) {
            IJ.showStatus((String)("WPL iteration: " + (iter + 1) + "/" + this.maxIters));
            ((DenseDoubleMatrix2D)X).dht2();
            WPLDoubleIterativeDeconvolver2D.gaussianFilter(X, this.gweights);
            WPLDoubleIterativeDeconvolver2D.convolveFD(this.rows, this.columns, this.PSF, X, AX);
            ((DenseDoubleMatrix2D)AX).idht2(true);
            ((DenseDoubleMatrix2D)X).idht2(true);
            double meanDelta = WPLDoubleIterativeDeconvolver2D.meanDelta(this.B, AX, X, aSum);
            if (this.showIteration) {
                if (this.threshold == -1.0) {
                    DoubleCommon2D.assignPixelsToProcessorPadded(ip, X, this.bRows, this.bColumns, rOff, cOff, this.cmY);
                } else {
                    DoubleCommon2D.assignPixelsToProcessorPadded(ip, X, this.bRows, this.bColumns, rOff, cOff, this.cmY, this.threshold);
                }
                imX.updateAndDraw();
            }
            double sumPixels = WPLDoubleIterativeDeconvolver2D.energySum(X, this.bRows, this.bColumns, cOff, rOff);
            double percentChange = 100.0 * meanDelta / sumPixels;
            if (this.logConvergence) {
                IJ.write((String)Double.toString(percentChange));
            }
            if (oldPercentChange - percentChange < this.changeThreshPercent) {
                if (!this.logConvergence) break;
                IJ.write((String)("Automatically terminated after " + (iter + 1) + " iterations."));
                break;
            }
            if (oldPercentChange < percentChange && this.detectDivergence) {
                if (!this.logConvergence) break;
                IJ.write((String)("Automatically terminated due to divergence " + (iter + 1) + " iterations."));
                break;
            }
            oldPercentChange = percentChange;
        }
        ((DenseDoubleMatrix2D)X).dht2();
        WPLDoubleIterativeDeconvolver2D.gaussianFilterWithScaling(X, this.gweights, aSum);
        ((DenseDoubleMatrix2D)X).idht2(true);
        if (this.dB) {
            WPLDoubleIterativeDeconvolver2D.toDB(this.PSF, this.minPSF);
            WPLDoubleIterativeDeconvolver2D.toDB(this.B, this.minB);
            WPLDoubleIterativeDeconvolver2D.toDB(X, -90.0);
        }
        if (!this.showIteration) {
            if (this.threshold == -1.0) {
                DoubleCommon2D.assignPixelsToProcessorPadded(ip, X, this.bRows, this.bColumns, rOff, cOff, this.cmY);
            } else {
                DoubleCommon2D.assignPixelsToProcessorPadded(ip, X, this.bRows, this.bColumns, rOff, cOff, this.cmY, this.threshold);
            }
            imX = new ImagePlus("(deblurred)", (ImageProcessor)ip);
        }
        DoubleCommon2D.convertImage(imX, this.output);
        return imX;
    }

    private static void convolveFD(final int rows, final int columns, DoubleMatrix2D H1, DoubleMatrix2D H2, DoubleMatrix2D Result) {
        final double[] h1 = (double[])H1.elements();
        final double[] h2 = (double[])H2.elements();
        final double[] result = (double[])Result.elements();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && columns * rows >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futures = new Future[np];
            int k = rows / np;
            for (int j = 0; j < np; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == np - 1 ? rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int rC = (rows - r) % rows;
                            for (int c = 0; c < columns; ++c) {
                                int cC = (columns - c) % columns;
                                int idx1 = c + columns * r;
                                int idx2 = cC + columns * rC;
                                double h2e = (h2[idx1] + h2[idx2]) / 2.0;
                                double h2o = (h2[idx1] - h2[idx2]) / 2.0;
                                result[idx1] = h1[idx1] * h2e + h1[idx2] * h2o;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int r = 0; r < rows; ++r) {
                int rC = (rows - r) % rows;
                for (int c = 0; c < columns; ++c) {
                    int cC = (columns - c) % columns;
                    int idx1 = c + columns * r;
                    int idx2 = cC + columns * rC;
                    double h2e = (h2[idx1] + h2[idx2]) / 2.0;
                    double h2o = (h2[idx1] - h2[idx2]) / 2.0;
                    result[idx1] = h1[idx1] * h2e + h1[idx2] * h2o;
                }
            }
        }
    }

    private static void copyDataAverage(final int rows, final int columns, int rowsE, final int columnsE, final double sum, DoubleMatrix2D DataIn, DoubleMatrix2D DataOut, DoubleMatrix2D Result) {
        final double[] dataIn = (double[])DataIn.elements();
        final double[] dataOut = (double[])DataOut.elements();
        final double[] result = (double[])Result.elements();
        final int rOff = (rowsE - rows + 1) / 2;
        final int cOff = (columnsE - columns + 1) / 2;
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && columnsE * rowsE >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futures = new Future[np];
            int k = rowsE / np;
            for (int j = 0; j < np; ++j) {
                final int firstRow = -rOff + j * k;
                final int lastRow = j == np - 1 ? rowsE - rOff : firstRow + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int rOut = r + rOff;
                            double alphaJ = r < 0 ? (double)(-r) / (double)rOff : (r > rows - 1 ? (double)(r - rows) / (double)rOff : 0.0);
                            for (int c = -cOff; c < columnsE - cOff; ++c) {
                                double a;
                                int cOut = c + cOff;
                                double alphaI = c < 0 ? (double)(-c) / (double)cOff : (c > columns - 1 ? (double)(c - columns) / (double)cOff : 0.0);
                                if (alphaI > (a = alphaJ)) {
                                    a = alphaI;
                                }
                                int idx = cOut + columnsE * rOut;
                                result[idx] = (1.0 - a) * dataIn[idx] + a * dataOut[idx] / sum;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int r = -rOff; r < rowsE - rOff; ++r) {
                int rOut = r + rOff;
                double alphaJ = r < 0 ? (double)(-r) / (double)rOff : (r > rows - 1 ? (double)(r - rows) / (double)rOff : 0.0);
                for (int c = -cOff; c < columnsE - cOff; ++c) {
                    double a;
                    int cOut = c + cOff;
                    double alphaI = c < 0 ? (double)(-c) / (double)cOff : (c > columns - 1 ? (double)(c - columns) / (double)cOff : 0.0);
                    if (alphaI > (a = alphaJ)) {
                        a = alphaI;
                    }
                    int idx = cOut + columnsE * rOut;
                    result[idx] = (1.0 - a) * dataIn[idx] + a * dataOut[idx] / sum;
                }
            }
        }
    }

    private static void deconvolveFD(double gamma, double magMax, final int rows, final int columns, DoubleMatrix2D H1, DoubleMatrix2D H2, DoubleMatrix2D Result) {
        final double gammaScaled = gamma * magMax;
        final double[] h1 = (double[])H1.elements();
        final double[] h2 = (double[])H2.elements();
        final double[] result = (double[])Result.elements();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && columns * rows >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futures = new Future[np];
            int k = rows / np;
            for (int j = 0; j < np; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == np - 1 ? rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int rC = (rows - r) % rows;
                            for (int c = 0; c < columns; ++c) {
                                int cC = (columns - c) % columns;
                                int idx1 = c + columns * r;
                                int idx2 = cC + columns * rC;
                                double h2e = (h2[idx1] + h2[idx2]) / 2.0;
                                double h2o = (h2[idx1] - h2[idx2]) / 2.0;
                                double mag = h2[idx1] * h2[idx1] + h2[idx2] * h2[idx2];
                                double tmp = h1[idx1] * h2e - h1[idx2] * h2o;
                                result[idx1] = tmp / (mag + gammaScaled);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int r = 0; r < rows; ++r) {
                int rC = (rows - r) % rows;
                for (int c = 0; c < columns; ++c) {
                    int cC = (columns - c) % columns;
                    int idx1 = c + columns * r;
                    int idx2 = cC + columns * rC;
                    double h2e = (h2[idx1] + h2[idx2]) / 2.0;
                    double h2o = (h2[idx1] - h2[idx2]) / 2.0;
                    double mag = h2[idx1] * h2[idx1] + h2[idx2] * h2[idx2];
                    double tmp = h1[idx1] * h2e - h1[idx2] * h2o;
                    result[idx1] = tmp / (mag + gammaScaled);
                }
            }
        }
    }

    private static double energySum(DoubleMatrix2D X, int rows, final int columns, final int cOff, final int rOff) {
        double sumPixels = 0.0;
        final int rowStride = X.rowStride();
        final double[] elemsX = (double[])X.elements();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && rows * columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            Future[] futures = new Future[np];
            Double[] results = new Double[np];
            int k = rows / np;
            for (j = 0; j < np; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == np - 1 ? rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit((Callable)new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double sumPixels = 0.0;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < columns; ++c) {
                                sumPixels += elemsX[c + cOff + rowStride * (r + rOff)];
                            }
                        }
                        return sumPixels;
                    }
                });
            }
            try {
                for (j = 0; j < np; ++j) {
                    results[j] = (Double)futures[j].get();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            for (int j2 = 0; j2 < np; ++j2) {
                sumPixels += results[j2].doubleValue();
            }
        } else {
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < columns; ++c) {
                    sumPixels += elemsX[c + cOff + rowStride * (r + rOff)];
                }
            }
        }
        return sumPixels;
    }

    private static int expandedSize(int psfSize, int bSize, IterativeEnums.ResizingType resizing) {
        int result = 0;
        int minimal = psfSize + bSize;
        switch (resizing) {
            case AUTO: {
                int nextPowTwo = !ConcurrencyUtils.isPowerOf2((int)minimal) ? ConcurrencyUtils.nextPow2((int)minimal) : minimal;
                if ((double)nextPowTwo >= 1.5 * (double)minimal) {
                    result = minimal;
                    break;
                }
                result = nextPowTwo;
                break;
            }
            case MINIMAL: {
                result = minimal;
                break;
            }
            case NEXT_POWER_OF_TWO: {
                result = minimal;
                if (ConcurrencyUtils.isPowerOf2((int)result)) break;
                result = ConcurrencyUtils.nextPow2((int)result);
            }
        }
        if (result < 4) {
            result = 4;
        }
        return result;
    }

    private static double findMagMax(DoubleMatrix2D H2) {
        final double[] h2 = (double[])H2.elements();
        double magMax = 0.0;
        final int rows = H2.rows();
        final int columns = H2.columns();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && rows * columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            Future[] futures = new Future[np];
            Double[] results = new Double[np];
            int k = rows / np;
            for (j = 0; j < np; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == np - 1 ? rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit((Callable)new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double magMax = 0.0;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int rC = (rows - r) % rows;
                            for (int c = 0; c < columns; ++c) {
                                int idx1 = c + columns * r;
                                int cC = (columns - c) % columns;
                                int idx2 = cC + columns * rC;
                                double mag = h2[idx1] * h2[idx1] + h2[idx2] * h2[idx2];
                                if (!(mag > magMax)) continue;
                                magMax = mag;
                            }
                        }
                        return magMax;
                    }
                });
            }
            try {
                for (j = 0; j < np; ++j) {
                    results[j] = (Double)futures[j].get();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            magMax = results[0];
            for (int j2 = 1; j2 < np; ++j2) {
                if (!(results[j2] > magMax)) continue;
                magMax = results[j2];
            }
        } else {
            for (int r = 0; r < rows; ++r) {
                int rC = (rows - r) % rows;
                for (int c = 0; c < columns; ++c) {
                    int idx1 = c + columns * r;
                    int cC = (columns - c) % columns;
                    int idx2 = cC + columns * rC;
                    double mag = h2[idx1] * h2[idx1] + h2[idx2] * h2[idx2];
                    if (!(mag > magMax)) continue;
                    magMax = mag;
                }
            }
        }
        return magMax;
    }

    private static void gaussianFilter(DoubleMatrix2D X, final double[][] weights) {
        final double[] elems = (double[])X.elements();
        int rows = X.rows();
        final int columns = X.columns();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && columns * rows >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futures = new Future[np];
            int k = rows / np;
            for (int j = 0; j < np; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == np - 1 ? rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        int idx = firstRow * columns;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < columns; ++c) {
                                int n = i++;
                                elems[n] = elems[n] * (weights[1][r] * weights[0][c]);
                            }
                            idx += columns;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            int idx = 0;
            for (int r = 0; r < rows; ++r) {
                int i = idx;
                for (int c = 0; c < columns; ++c) {
                    int n = i++;
                    elems[n] = elems[n] * (weights[1][r] * weights[0][c]);
                }
                idx += columns;
            }
        }
    }

    private static void gaussianFilterWithScaling(DoubleMatrix2D X, final double[][] weights, final double scale) {
        final double[] elems = (double[])X.elements();
        int rows = X.rows();
        final int columns = X.columns();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && columns * rows >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futures = new Future[np];
            int k = rows / np;
            for (int j = 0; j < np; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == np - 1 ? rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        int idx = firstRow * columns;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < columns; ++c) {
                                int n = i++;
                                elems[n] = elems[n] * (weights[1][r] * weights[0][c] / scale);
                            }
                            idx += columns;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            int idx = 0;
            for (int r = 0; r < rows; ++r) {
                int i = idx;
                for (int c = 0; c < columns; ++c) {
                    int n = i++;
                    elems[n] = elems[n] * (weights[1][r] * weights[0][c] / scale);
                }
                idx += columns;
            }
        }
    }

    private static double[][] gaussianWeights(final int rows, final int columns, double filterX, double filterY) {
        final double[][] weights = new double[][]{new double[columns], new double[rows]};
        final double cc = (double)columns / (filterX + 1.0E-6);
        final double rc = (double)rows / (filterY + 1.0E-6);
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && Math.max(columns, rows) >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futures = new Future[np];
            int kcol = columns / np;
            int krow = rows / np;
            for (int j = 0; j < np; ++j) {
                final int firstCol = j * kcol;
                final int lastCol = j == np - 1 ? columns : firstCol + kcol;
                final int firstRow = j * krow;
                final int lastRow = j == np - 1 ? rows : firstRow + krow;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        double tmp;
                        for (int c = firstCol; c < lastCol; ++c) {
                            int cShifted = c;
                            if (cShifted > columns / 2) {
                                cShifted = columns - cShifted;
                            }
                            tmp = (double)cShifted / cc;
                            weights[0][c] = Math.exp(-tmp * tmp);
                        }
                        for (int r = firstRow; r < lastRow; ++r) {
                            int rShifted = r;
                            if (rShifted > rows / 2) {
                                rShifted = rows - rShifted;
                            }
                            tmp = (double)rShifted / rc;
                            weights[1][r] = Math.exp(-tmp * tmp);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            double tmp;
            for (int c = 0; c < columns; ++c) {
                int cShifted = c;
                if (cShifted > columns / 2) {
                    cShifted = columns - cShifted;
                }
                tmp = (double)cShifted / cc;
                weights[0][c] = Math.exp(-tmp * tmp);
            }
            for (int r = 0; r < rows; ++r) {
                int rShifted = r;
                if (rShifted > rows / 2) {
                    rShifted = rows - rShifted;
                }
                tmp = (double)rShifted / rc;
                weights[1][r] = Math.exp(-tmp * tmp);
            }
        }
        return weights;
    }

    private static double meanDelta(DoubleMatrix2D B, DoubleMatrix2D AX, DoubleMatrix2D X, final double aSum) {
        double meanDelta = 0.0;
        final double[] elemsB = (double[])B.elements();
        final double[] elemsAX = (double[])AX.elements();
        final double[] elemsX = (double[])X.elements();
        int size = (int)B.size();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            Future[] futures = new Future[np];
            Double[] results = new Double[np];
            int k = size / np;
            for (j = 0; j < np; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == np - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit((Callable)new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double meanDelta = 0.0;
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            double delta = elemsB[i] - elemsAX[i] / aSum;
                            int n = i;
                            elemsX[n] = elemsX[n] + delta;
                            if (elemsX[i] < 0.0) {
                                elemsX[i] = 0.0;
                                continue;
                            }
                            meanDelta += Math.abs(delta);
                        }
                        return meanDelta;
                    }
                });
            }
            try {
                for (j = 0; j < np; ++j) {
                    results[j] = (Double)futures[j].get();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            for (int j2 = 0; j2 < np; ++j2) {
                meanDelta += results[j2].doubleValue();
            }
        } else {
            for (int i = 0; i < size; ++i) {
                double delta = elemsB[i] - elemsAX[i] / aSum;
                int n = i;
                elemsX[n] = elemsX[n] + delta;
                if (elemsX[i] < 0.0) {
                    elemsX[i] = 0.0;
                    continue;
                }
                meanDelta += Math.abs(delta);
            }
        }
        return meanDelta;
    }

    private static void toDB(DoubleMatrix2D X, final double minDB) {
        final double[] x = (double[])X.elements();
        final double SCALE = 10.0 / Math.log(10.0);
        final double minVal = Math.exp(minDB / SCALE);
        int size = (int)X.size();
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futures = new Future[np];
            int k = size / np;
            for (int j = 0; j < np; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == np - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit((Runnable)new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            x[i] = x[i] > minVal ? SCALE * Math.log(x[i]) : minDB;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        } else {
            for (int i = 0; i < size; ++i) {
                x[i] = x[i] > minVal ? SCALE * Math.log(x[i]) : minDB;
            }
        }
    }

    private static double unDB(DoubleMatrix2D X) {
        final double[] x = (double[])X.elements();
        final double SCALE = 10.0 / Math.log(10.0);
        int size = (int)X.size();
        double min = Double.MAX_VALUE;
        int np = ConcurrencyUtils.getNumberOfThreads();
        if (np > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            Future[] futures = new Future[np];
            Double[] results = new Double[np];
            int k = size / np;
            for (j = 0; j < np; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == np - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit((Callable)new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double min = Double.MAX_VALUE;
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            if (x[i] < min) {
                                min = x[i];
                            }
                            x[i] = Math.exp(x[i] / SCALE);
                        }
                        return min;
                    }
                });
            }
            try {
                for (j = 0; j < np; ++j) {
                    results[j] = (Double)futures[j].get();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            min = results[0];
            for (int j2 = 1; j2 < np; ++j2) {
                if (!(results[j2] < min)) continue;
                min = results[j2];
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (x[i] < min) {
                    min = x[i];
                }
                x[i] = Math.exp(x[i] / SCALE);
            }
        }
        return min;
    }
}

