/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.utils;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrencyUtils {
    private static ExecutorService THREAD_POOL = Executors.newCachedThreadPool(new CustomThreadFactory(new CustomExceptionHandler()));
    private static int NTHREADS = ConcurrencyUtils.getNumberOfProcessors();
    private static int THREADS_BEGIN_N_1D_FFT_2THREADS = 8192;
    private static int THREADS_BEGIN_N_1D_FFT_4THREADS = 65536;
    private static int THREADS_BEGIN_N_1D = 32768;
    private static int THREADS_BEGIN_N_2D = 65536;
    private static int THREADS_BEGIN_N_3D = 65536;

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void shutdown() {
        THREAD_POOL.shutdown();
    }

    public static <T> Future<T> submit(Callable<T> task) {
        if (THREAD_POOL.isShutdown() || THREAD_POOL.isTerminated()) {
            THREAD_POOL = Executors.newCachedThreadPool(new CustomThreadFactory(new CustomExceptionHandler()));
        }
        return THREAD_POOL.submit(task);
    }

    public static Future<?> submit(Runnable task) {
        if (THREAD_POOL.isShutdown() || THREAD_POOL.isTerminated()) {
            THREAD_POOL = Executors.newCachedThreadPool(new CustomThreadFactory(new CustomExceptionHandler()));
        }
        return THREAD_POOL.submit(task);
    }

    public static int getNumberOfProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static int getNumberOfThreads() {
        return NTHREADS;
    }

    public static void waitForCompletion(Future<?>[] futures) {
        int size = futures.length;
        try {
            for (int j = 0; j < size; ++j) {
                futures[j].get();
            }
        }
        catch (ExecutionException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static double waitForCompletion(Future<?>[] futures, DoubleDoubleFunction aggr) {
        int size = futures.length;
        Double[] results = new Double[size];
        double a = 0.0;
        try {
            int j;
            for (j = 0; j < size; ++j) {
                results[j] = (Double)futures[j].get();
            }
            a = results[0];
            for (j = 1; j < size; ++j) {
                a = aggr.apply(a, results[j].doubleValue());
            }
        }
        catch (ExecutionException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return a;
    }

    public static int waitForCompletion(Future<?>[] futures, IntIntFunction aggr) {
        int size = futures.length;
        Integer[] results = new Integer[size];
        int a = 0;
        try {
            int j;
            for (j = 0; j < size; ++j) {
                results[j] = (Integer)futures[j].get();
            }
            a = results[0];
            for (j = 1; j < size; ++j) {
                a = aggr.apply(a, results[j].intValue());
            }
        }
        catch (ExecutionException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return a;
    }

    public static long waitForCompletion(Future<?>[] futures, LongLongFunction aggr) {
        int size = futures.length;
        Long[] results = new Long[size];
        long a = 0L;
        try {
            int j;
            for (j = 0; j < size; ++j) {
                results[j] = (Long)futures[j].get();
            }
            a = results[0];
            for (j = 1; j < size; ++j) {
                a = aggr.apply(a, results[j].longValue());
            }
        }
        catch (ExecutionException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return a;
    }

    public static Object waitForCompletion(Future<?>[] futures, ObjectObjectFunction aggr) {
        int size = futures.length;
        Object[] results = new Object[size];
        Object a = null;
        try {
            int j;
            for (j = 0; j < size; ++j) {
                results[j] = (Integer)futures[j].get();
            }
            a = results[0];
            for (j = 1; j < size; ++j) {
                a = aggr.apply(a, results[j]);
            }
        }
        catch (ExecutionException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return a;
    }

    public static double[] waitForCompletion(Future<?>[] futures, DComplexDComplexDComplexFunction aggr) {
        int size = futures.length;
        double[][] results = new double[size][2];
        double[] a = null;
        try {
            int j;
            for (j = 0; j < size; ++j) {
                results[j] = (double[])futures[j].get();
            }
            a = results[0];
            for (j = 1; j < size; ++j) {
                a = aggr.apply(a, results[j]);
            }
        }
        catch (ExecutionException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return a;
    }

    public static float[] waitForCompletion(Future<?>[] futures, FComplexFComplexFComplexFunction aggr) {
        int size = futures.length;
        float[][] results = new float[size][2];
        float[] a = null;
        try {
            int j;
            for (j = 0; j < size; ++j) {
                results[j] = (float[])futures[j].get();
            }
            a = results[0];
            for (j = 1; j < size; ++j) {
                a = aggr.apply(a, results[j]);
            }
        }
        catch (ExecutionException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return a;
    }

    public static float waitForCompletion(Future<?>[] futures, FloatFloatFunction aggr) {
        int size = futures.length;
        Float[] results = new Float[size];
        float a = 0.0f;
        try {
            int j;
            for (j = 0; j < size; ++j) {
                results[j] = (Float)futures[j].get();
            }
            a = results[0].floatValue();
            for (j = 1; j < size; ++j) {
                a = aggr.apply(a, results[j].floatValue());
            }
        }
        catch (ExecutionException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return a;
    }

    public static int getThreadsBeginN_1D() {
        return THREADS_BEGIN_N_1D;
    }

    public static int getThreadsBeginN_1D_FFT_2Threads() {
        return THREADS_BEGIN_N_1D_FFT_2THREADS;
    }

    public static int getThreadsBeginN_1D_FFT_4Threads() {
        return THREADS_BEGIN_N_1D_FFT_4THREADS;
    }

    public static int getThreadsBeginN_2D() {
        return THREADS_BEGIN_N_2D;
    }

    public static int getThreadsBeginN_3D() {
        return THREADS_BEGIN_N_3D;
    }

    public static void setThreadsBeginN_1D_FFT_2Threads(int n) {
        THREADS_BEGIN_N_1D_FFT_2THREADS = n < 512 ? 512 : n;
    }

    public static void setThreadsBeginN_1D_FFT_4Threads(int n) {
        THREADS_BEGIN_N_1D_FFT_4THREADS = n < 512 ? 512 : n;
    }

    public static void setThreadsBeginN_1D(int n) {
        THREADS_BEGIN_N_1D = n;
    }

    public static void setThreadsBeginN_2D(int n) {
        THREADS_BEGIN_N_2D = n;
    }

    public static void setThreadsBeginN_3D(int n) {
        THREADS_BEGIN_N_3D = n;
    }

    public static void resetThreadsBeginN_FFT() {
        THREADS_BEGIN_N_1D_FFT_2THREADS = 8192;
        THREADS_BEGIN_N_1D_FFT_4THREADS = 65536;
    }

    public static void resetThreadsBeginN() {
        THREADS_BEGIN_N_1D = 32768;
        THREADS_BEGIN_N_2D = 65536;
        THREADS_BEGIN_N_3D = 65536;
    }

    public static void setNumberOfThreads(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n must be greater or equal 1");
        }
        NTHREADS = n;
    }

    public static int nextPow2(int x) {
        if (x < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        if ((x & x - 1) == 0) {
            return x;
        }
        x |= x >>> 1;
        x |= x >>> 2;
        x |= x >>> 4;
        x |= x >>> 8;
        x |= x >>> 16;
        x |= x >>> 32;
        return x + 1;
    }

    public static int extendDimension(int x) {
        if (x < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        int nextExp = ConcurrencyUtils.nextExp2(x);
        int nextPow = nextExp + 1;
        int extDim = (int)Math.round(Math.pow(2.0, nextPow));
        return extDim;
    }

    public static int nextExp2(int n) {
        double e = Math.log(n) / Math.log(2.0);
        int p = (int)Math.ceil(e);
        double f = (double)n / Math.pow(2.0, p);
        if (f == 0.5) {
            --p;
        }
        return p;
    }

    public static int prevPow2(int x) {
        if (x < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        return (int)Math.pow(2.0, Math.floor(Math.log(x) / Math.log(2.0)));
    }

    public static boolean isPowerOf2(int n) {
        if (n <= 0) {
            return false;
        }
        return (n & n - 1) == 0;
    }

    private static class CustomThreadFactory
    implements ThreadFactory {
        private static final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        private final Thread.UncaughtExceptionHandler handler;

        CustomThreadFactory(Thread.UncaughtExceptionHandler handler) {
            this.handler = handler;
        }

        public Thread newThread(Runnable r) {
            Thread t = defaultFactory.newThread(r);
            t.setUncaughtExceptionHandler(this.handler);
            t.setDaemon(true);
            return t;
        }
    }

    private static class CustomExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private CustomExceptionHandler() {
        }

        public void uncaughtException(Thread t, Throwable e) {
            e.printStackTrace();
        }
    }
}

