/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import edu.emory.mathcs.restoretools.Enums;
import edu.emory.mathcs.restoretools.iterative.DoubleCommon2D;
import edu.emory.mathcs.restoretools.iterative.IterativeDeconvolver;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.restoretools.iterative.preconditioner.DoublePreconditioner2D;
import edu.emory.mathcs.restoretools.iterative.preconditioner.FFTDoublePreconditioner2D;
import edu.emory.mathcs.restoretools.iterative.psf.DoublePSFMatrix2D;
import ij.IJ;
import ij.ImagePlus;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.image.ColorModel;

public abstract class AbstractDoubleIterativeDeconvolver2D
implements IterativeDeconvolver {
    protected static final DenseDoubleAlgebra alg = DenseDoubleAlgebra.DEFAULT;
    protected DoubleMatrix2D B;
    protected DoublePSFMatrix2D A;
    protected DoublePreconditioner2D P;
    protected ColorModel cmY;
    protected int bColumns;
    protected int bRows;
    protected int maxIters;
    protected boolean useThreshold;
    protected double threshold;
    protected boolean showIteration;
    protected boolean logConvergence;
    protected Enums.OutputType output;
    protected String name;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractDoubleIterativeDeconvolver2D(String name, ImagePlus imB, ImagePlus[][] imPSF, IterativeEnums.PreconditionerType preconditioner, double preconditionerTol, IterativeEnums.BoundaryType boundary, IterativeEnums.ResizingType resizing, Enums.OutputType output, boolean useThreshold, double threshold, int maxIters, boolean showIteration, boolean logConvergence) {
        this.name = name;
        IJ.showStatus((String)(name + ": initialization..."));
        ImageProcessor ipB = imB.getProcessor();
        this.cmY = ipB.getColorModel();
        this.bColumns = ipB.getWidth();
        this.bRows = ipB.getHeight();
        this.B = new DenseDoubleMatrix2D(this.bRows, this.bColumns);
        this.A = new DoublePSFMatrix2D(imPSF, boundary, resizing, new int[]{this.bRows, this.bColumns});
        DoubleCommon2D.assignPixelsToMatrix(this.B, ipB);
        switch (preconditioner) {
            case FFT: {
                this.P = new FFTDoublePreconditioner2D(this.A, this.B, preconditionerTol);
                break;
            }
            case NONE: {
                this.P = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported preconditioner type.");
            }
        }
        IJ.showStatus((String)(name + ": initialization..."));
        if (output == Enums.OutputType.SAME_AS_SOURCE) {
            if (ipB instanceof ByteProcessor) {
                this.output = Enums.OutputType.BYTE;
            } else if (ipB instanceof ShortProcessor) {
                this.output = Enums.OutputType.SHORT;
            } else {
                if (!(ipB instanceof FloatProcessor)) throw new IllegalArgumentException("Unsupported image type.");
                this.output = Enums.OutputType.FLOAT;
            }
        } else {
            this.output = output;
        }
        this.useThreshold = useThreshold;
        this.threshold = threshold;
        this.maxIters = maxIters;
        this.showIteration = showIteration;
        this.logConvergence = logConvergence;
    }

    public DoublePreconditioner2D getPreconditioner() {
        return this.P;
    }
}

