/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative;

import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.DenseFloatAlgebra;
import edu.emory.mathcs.restoretools.Enums;
import edu.emory.mathcs.restoretools.iterative.FloatCommon2D;
import edu.emory.mathcs.restoretools.iterative.IterativeDeconvolver;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.restoretools.iterative.preconditioner.FFTFloatPreconditioner2D;
import edu.emory.mathcs.restoretools.iterative.preconditioner.FloatPreconditioner2D;
import edu.emory.mathcs.restoretools.iterative.psf.FloatPSFMatrix2D;
import ij.IJ;
import ij.ImagePlus;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.image.ColorModel;

public abstract class AbstractFloatIterativeDeconvolver2D
implements IterativeDeconvolver {
    protected static final DenseFloatAlgebra alg = DenseFloatAlgebra.DEFAULT;
    protected FloatMatrix2D B;
    protected FloatPSFMatrix2D A;
    protected FloatPreconditioner2D P;
    protected ColorModel cmY;
    protected int bColumns;
    protected int bRows;
    protected int maxIters;
    protected boolean useThreshold;
    protected float threshold;
    protected boolean showIteration;
    protected boolean logConvergence;
    protected Enums.OutputType output;
    protected String name;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractFloatIterativeDeconvolver2D(String name, ImagePlus imB, ImagePlus[][] imPSF, IterativeEnums.PreconditionerType preconditioner, float preconditionerTol, IterativeEnums.BoundaryType boundary, IterativeEnums.ResizingType resizing, Enums.OutputType output, boolean useThreshold, float threshold, int maxIters, boolean showIteration, boolean logConvergence) {
        this.name = name;
        IJ.showStatus((String)(name + ": initialization..."));
        ImageProcessor ipB = imB.getProcessor();
        this.cmY = ipB.getColorModel();
        this.bColumns = ipB.getWidth();
        this.bRows = ipB.getHeight();
        this.A = new FloatPSFMatrix2D(imPSF, boundary, resizing, new int[]{this.bRows, this.bColumns});
        this.B = FloatCommon2D.assignPixelsToMatrix(ipB);
        switch (preconditioner) {
            case FFT: {
                this.P = new FFTFloatPreconditioner2D(this.A, this.B, preconditionerTol);
                break;
            }
            case NONE: {
                this.P = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported preconditioner type.");
            }
        }
        IJ.showStatus((String)(name + ": initialization..."));
        if (output == Enums.OutputType.SAME_AS_SOURCE) {
            if (ipB instanceof ByteProcessor) {
                this.output = Enums.OutputType.BYTE;
            } else if (ipB instanceof ShortProcessor) {
                this.output = Enums.OutputType.SHORT;
            } else {
                if (!(ipB instanceof FloatProcessor)) throw new IllegalArgumentException("Unsupported image type.");
                this.output = Enums.OutputType.FLOAT;
            }
        } else {
            this.output = output;
        }
        this.useThreshold = useThreshold;
        this.threshold = threshold;
        this.maxIters = maxIters;
        this.showIteration = showIteration;
        this.logConvergence = logConvergence;
    }

    public FloatPreconditioner2D getPreconditioner() {
        return this.P;
    }
}

