/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative;

import cern.colt.matrix.tdouble.algo.solver.HyBRInnerSolver;
import cern.colt.matrix.tdouble.algo.solver.HyBRRegularizationMethod;
import edu.emory.mathcs.restoretools.Enums;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.restoretools.iterative.cgls.CGLSDoubleIterativeDeconvolver2D;
import edu.emory.mathcs.restoretools.iterative.cgls.CGLSFloatIterativeDeconvolver2D;
import edu.emory.mathcs.restoretools.iterative.cgls.CGLSOptions;
import edu.emory.mathcs.restoretools.iterative.hybr.HyBRDoubleIterativeDeconvolver2D;
import edu.emory.mathcs.restoretools.iterative.hybr.HyBRFloatIterativeDeconvolver2D;
import edu.emory.mathcs.restoretools.iterative.hybr.HyBROptions;
import edu.emory.mathcs.restoretools.iterative.mrnsd.MRNSDDoubleIterativeDeconvolver2D;
import edu.emory.mathcs.restoretools.iterative.mrnsd.MRNSDFloatIterativeDeconvolver2D;
import edu.emory.mathcs.restoretools.iterative.mrnsd.MRNSDOptions;
import edu.emory.mathcs.restoretools.iterative.wpl.WPLDoubleIterativeDeconvolver2D;
import edu.emory.mathcs.restoretools.iterative.wpl.WPLFloatIterativeDeconvolver2D;
import edu.emory.mathcs.restoretools.iterative.wpl.WPLOptions;
import edu.emory.mathcs.utils.pc.ConcurrencyUtils;
import ij.ImagePlus;
import ij.io.Opener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

public class Benchmark2D {
    private static final String path = "/home/pwendyk/images/iterative/";
    private static final String blur_image = "astronaut4096-blur.png";
    private static final String psf_image = "astronaut4096-psf.png";
    private static final IterativeEnums.BoundaryType boundary = IterativeEnums.BoundaryType.REFLEXIVE;
    private static final IterativeEnums.ResizingType resizing = IterativeEnums.ResizingType.AUTO;
    private static final Enums.OutputType output = Enums.OutputType.FLOAT;
    private static final int NITER = 10;
    private static final int MAXITER = 5;
    private static final double PREC_TOL = 0.001;
    private static final String format = "%.2f";

    public static void benchmarkDoubleCGLS2D(int threads) {
        ConcurrencyUtils.setNumberOfThreads((int)threads);
        Opener o = new Opener();
        ImagePlus blurImage = o.openImage("/home/pwendyk/images/iterative/astronaut4096-blur.png");
        ImagePlus[][] psfImage = new ImagePlus[1][1];
        psfImage[0][0] = o.openImage("/home/pwendyk/images/iterative/astronaut4096-psf.png");
        double av_time_deblur = 0.0;
        long elapsedTime_deblur = 0L;
        System.out.println("Benchmarking DoubleCGLS2D using " + threads + " threads");
        CGLSOptions options = new CGLSOptions(false, 0.0, false, 0.0, false);
        for (int i = 0; i < 10; ++i) {
            elapsedTime_deblur = System.nanoTime();
            CGLSDoubleIterativeDeconvolver2D cgls = new CGLSDoubleIterativeDeconvolver2D(blurImage, psfImage, IterativeEnums.PreconditionerType.NONE, 0.0, boundary, resizing, output, 5, false, options);
            ImagePlus imX = cgls.deconvolve();
            elapsedTime_deblur = System.nanoTime() - elapsedTime_deblur;
            av_time_deblur += (double)elapsedTime_deblur;
            cgls = null;
            imX = null;
        }
        blurImage = null;
        psfImage = null;
        System.out.println("Average execution time: " + String.format(format, av_time_deblur / 1.0E9 / 10.0) + " sec");
        Benchmark2D.writeResultsToFile("DoubleCGLS2D_" + threads + "_threads.txt", av_time_deblur / 1.0E9 / 10.0);
    }

    public static void benchmarkDoublePCGLS2D(int threads) {
        ConcurrencyUtils.setNumberOfThreads((int)threads);
        Opener o = new Opener();
        ImagePlus blurImage = o.openImage("/home/pwendyk/images/iterative/astronaut4096-blur.png");
        ImagePlus[][] psfImage = new ImagePlus[1][1];
        psfImage[0][0] = o.openImage("/home/pwendyk/images/iterative/astronaut4096-psf.png");
        double av_time_deblur = 0.0;
        long elapsedTime_deblur = 0L;
        System.out.println("Benchmarking DoublePCGLS2D using " + threads + " threads");
        CGLSOptions options = new CGLSOptions(false, 0.0, false, 0.0, false);
        for (int i = 0; i < 10; ++i) {
            elapsedTime_deblur = System.nanoTime();
            CGLSDoubleIterativeDeconvolver2D cgls = new CGLSDoubleIterativeDeconvolver2D(blurImage, psfImage, IterativeEnums.PreconditionerType.FFT, 0.001, boundary, resizing, output, 5, false, options);
            ImagePlus imX = cgls.deconvolve();
            elapsedTime_deblur = System.nanoTime() - elapsedTime_deblur;
            av_time_deblur += (double)elapsedTime_deblur;
            cgls = null;
            imX = null;
        }
        blurImage = null;
        psfImage = null;
        System.out.println("Average execution time (tol =  0.001): " + String.format(format, av_time_deblur / 1.0E9 / 10.0) + " sec");
        Benchmark2D.writeResultsToFile("DoublePCGLS2D_" + threads + "_threads.txt", av_time_deblur / 1.0E9 / 10.0, 0.001);
    }

    public static void benchmarkDoubleMRNSD2D(int threads) {
        ConcurrencyUtils.setNumberOfThreads((int)threads);
        Opener o = new Opener();
        ImagePlus blurImage = o.openImage("/home/pwendyk/images/iterative/astronaut4096-blur.png");
        ImagePlus[][] psfImage = new ImagePlus[1][1];
        psfImage[0][0] = o.openImage("/home/pwendyk/images/iterative/astronaut4096-psf.png");
        double av_time_deblur = 0.0;
        long elapsedTime_deblur = 0L;
        System.out.println("Benchmarking DoubleMRNSD2D using " + threads + " threads");
        MRNSDOptions options = new MRNSDOptions(false, 0.0, false, 0.0, false);
        for (int i = 0; i < 10; ++i) {
            elapsedTime_deblur = System.nanoTime();
            MRNSDDoubleIterativeDeconvolver2D mrnsd = new MRNSDDoubleIterativeDeconvolver2D(blurImage, psfImage, IterativeEnums.PreconditionerType.NONE, 0.001, boundary, resizing, output, 5, false, options);
            ImagePlus imX = mrnsd.deconvolve();
            elapsedTime_deblur = System.nanoTime() - elapsedTime_deblur;
            av_time_deblur += (double)elapsedTime_deblur;
            mrnsd = null;
            imX = null;
        }
        blurImage = null;
        psfImage = null;
        System.out.println("Average execution time: " + String.format(format, av_time_deblur / 1.0E9 / 10.0) + " sec");
        Benchmark2D.writeResultsToFile("DoubleMRNSD2D_" + threads + "_threads.txt", av_time_deblur / 1.0E9 / 10.0);
    }

    public static void benchmarkDoublePMRNSD2D(int threads) {
        ConcurrencyUtils.setNumberOfThreads((int)threads);
        Opener o = new Opener();
        ImagePlus blurImage = o.openImage("/home/pwendyk/images/iterative/astronaut4096-blur.png");
        ImagePlus[][] psfImage = new ImagePlus[1][1];
        psfImage[0][0] = o.openImage("/home/pwendyk/images/iterative/astronaut4096-psf.png");
        double av_time_deblur = 0.0;
        long elapsedTime_deblur = 0L;
        System.out.println("Benchmarking DoublePMRNSD2D using " + threads + " threads");
        MRNSDOptions options = new MRNSDOptions(false, 0.0, false, 0.0, false);
        for (int i = 0; i < 10; ++i) {
            elapsedTime_deblur = System.nanoTime();
            MRNSDDoubleIterativeDeconvolver2D mrnsd = new MRNSDDoubleIterativeDeconvolver2D(blurImage, psfImage, IterativeEnums.PreconditionerType.FFT, 0.001, boundary, resizing, output, 5, false, options);
            ImagePlus imX = mrnsd.deconvolve();
            elapsedTime_deblur = System.nanoTime() - elapsedTime_deblur;
            av_time_deblur += (double)elapsedTime_deblur;
            mrnsd = null;
            imX = null;
        }
        blurImage = null;
        psfImage = null;
        System.out.println("Average execution time (tol =  0.001): " + String.format(format, av_time_deblur / 1.0E9 / 10.0) + " sec");
        Benchmark2D.writeResultsToFile("DoublePMRNSD2D_" + threads + "_threads.txt", av_time_deblur / 1.0E9 / 10.0, 0.001);
    }

    public static void benchmarkDoubleHyBR2D(int threads) {
        ConcurrencyUtils.setNumberOfThreads((int)threads);
        Opener o = new Opener();
        ImagePlus blurImage = o.openImage("/home/pwendyk/images/iterative/astronaut4096-blur.png");
        ImagePlus[][] psfImage = new ImagePlus[1][1];
        psfImage[0][0] = o.openImage("/home/pwendyk/images/iterative/astronaut4096-psf.png");
        double av_time_deblur = 0.0;
        long elapsedTime_deblur = 0L;
        System.out.println("Benchmarking DoubleHyBR2D using " + threads + " threads");
        HyBROptions options = new HyBROptions(HyBRInnerSolver.TIKHONOV, HyBRRegularizationMethod.ADAPTWGCV, 0.0, 0.0, false, 2, 0.0, false, false, 0.0);
        for (int i = 0; i < 10; ++i) {
            elapsedTime_deblur = System.nanoTime();
            HyBRDoubleIterativeDeconvolver2D hybr = new HyBRDoubleIterativeDeconvolver2D(blurImage, psfImage, IterativeEnums.PreconditionerType.NONE, 0.001, boundary, resizing, output, 5, false, options);
            ImagePlus imX = hybr.deconvolve();
            elapsedTime_deblur = System.nanoTime() - elapsedTime_deblur;
            av_time_deblur += (double)elapsedTime_deblur;
            hybr = null;
            imX = null;
        }
        blurImage = null;
        psfImage = null;
        System.out.println("Average execution time: " + String.format(format, av_time_deblur / 1.0E9 / 10.0) + " sec");
        Benchmark2D.writeResultsToFile("DoubleHyBR2D_" + threads + "_threads.txt", av_time_deblur / 1.0E9 / 10.0);
    }

    public static void benchmarkDoublePHyBR2D(int threads) {
        ConcurrencyUtils.setNumberOfThreads((int)threads);
        Opener o = new Opener();
        ImagePlus blurImage = o.openImage("/home/pwendyk/images/iterative/astronaut4096-blur.png");
        ImagePlus[][] psfImage = new ImagePlus[1][1];
        psfImage[0][0] = o.openImage("/home/pwendyk/images/iterative/astronaut4096-psf.png");
        double av_time_deblur = 0.0;
        long elapsedTime_deblur = 0L;
        System.out.println("Benchmarking preconditioned DoubleHyBR2D using " + threads + " threads");
        HyBROptions options = new HyBROptions(HyBRInnerSolver.TIKHONOV, HyBRRegularizationMethod.ADAPTWGCV, 0.0, 0.0, false, 2, 0.0, false, false, 0.0);
        for (int i = 0; i < 10; ++i) {
            elapsedTime_deblur = System.nanoTime();
            HyBRDoubleIterativeDeconvolver2D hybr = new HyBRDoubleIterativeDeconvolver2D(blurImage, psfImage, IterativeEnums.PreconditionerType.FFT, 0.001, boundary, resizing, output, 5, false, options);
            ImagePlus imX = hybr.deconvolve();
            elapsedTime_deblur = System.nanoTime() - elapsedTime_deblur;
            av_time_deblur += (double)elapsedTime_deblur;
            hybr = null;
            imX = null;
        }
        blurImage = null;
        psfImage = null;
        System.out.println("Average execution time (tol =  0.001): " + String.format(format, av_time_deblur / 1.0E9 / 10.0) + " sec");
        Benchmark2D.writeResultsToFile("DoublePHyBR2D_" + threads + "_threads.txt", av_time_deblur / 1.0E9 / 10.0, 0.001);
    }

    public static void benchmarkDoubleWPL2D(int threads) {
        ConcurrencyUtils.setNumberOfThreads((int)threads);
        Opener o = new Opener();
        ImagePlus blurImage = o.openImage("/home/pwendyk/images/iterative/astronaut4096-blur.png");
        ImagePlus[][] psfImage = new ImagePlus[1][1];
        psfImage[0][0] = o.openImage("/home/pwendyk/images/iterative/astronaut4096-psf.png");
        double av_time_deblur = 0.0;
        long elapsedTime_deblur = 0L;
        System.out.println("Benchmarking DoubleWPL2D using " + threads + " threads");
        WPLOptions options = new WPLOptions(0.0, 1.0, 1.0, true, false, false, 0.0, false, false, false, 0.0);
        for (int i = 0; i < 10; ++i) {
            elapsedTime_deblur = System.nanoTime();
            WPLDoubleIterativeDeconvolver2D wpl = new WPLDoubleIterativeDeconvolver2D(blurImage, psfImage[0][0], boundary, resizing, output, 5, false, options);
            ImagePlus imX = wpl.deconvolve();
            elapsedTime_deblur = System.nanoTime() - elapsedTime_deblur;
            av_time_deblur += (double)elapsedTime_deblur;
            wpl = null;
            imX = null;
        }
        blurImage = null;
        psfImage = null;
        System.out.println("Average execution time: " + String.format(format, av_time_deblur / 1.0E9 / 10.0) + " sec");
        Benchmark2D.writeResultsToFile("DoubleWPL2D_" + threads + "_threads.txt", av_time_deblur / 1.0E9 / 10.0);
    }

    public static void benchmarkDoublePWPL2D(int threads) {
        ConcurrencyUtils.setNumberOfThreads((int)threads);
        Opener o = new Opener();
        ImagePlus blurImage = o.openImage("/home/pwendyk/images/iterative/astronaut4096-blur.png");
        ImagePlus[][] psfImage = new ImagePlus[1][1];
        psfImage[0][0] = o.openImage("/home/pwendyk/images/iterative/astronaut4096-psf.png");
        double av_time_deblur = 0.0;
        long elapsedTime_deblur = 0L;
        System.out.println("Benchmarking DoublePWPL2D using " + threads + " threads");
        WPLOptions options = new WPLOptions(0.01, 1.0, 1.0, true, false, false, 0.0, false, false, false, 0.0);
        for (int i = 0; i < 10; ++i) {
            elapsedTime_deblur = System.nanoTime();
            WPLDoubleIterativeDeconvolver2D wpl = new WPLDoubleIterativeDeconvolver2D(blurImage, psfImage[0][0], boundary, resizing, output, 5, false, options);
            ImagePlus imX = wpl.deconvolve();
            elapsedTime_deblur = System.nanoTime() - elapsedTime_deblur;
            av_time_deblur += (double)elapsedTime_deblur;
            wpl = null;
            imX = null;
        }
        blurImage = null;
        psfImage = null;
        System.out.println("Average execution time (tol =  0.001): " + String.format(format, av_time_deblur / 1.0E9 / 10.0) + " sec");
        Benchmark2D.writeResultsToFile("DoublePWPL2D_" + threads + "_threads.txt", av_time_deblur / 1.0E9 / 10.0, 0.001);
    }

    public static void benchmarkFloatCGLS2D(int threads) {
        ConcurrencyUtils.setNumberOfThreads((int)threads);
        Opener o = new Opener();
        ImagePlus blurImage = o.openImage("/home/pwendyk/images/iterative/astronaut4096-blur.png");
        ImagePlus[][] psfImage = new ImagePlus[1][1];
        psfImage[0][0] = o.openImage("/home/pwendyk/images/iterative/astronaut4096-psf.png");
        double av_time_deblur = 0.0;
        long elapsedTime_deblur = 0L;
        System.out.println("Benchmarking FloatCGLS2D using " + threads + " threads");
        CGLSOptions options = new CGLSOptions(false, 0.0, false, 0.0, false);
        for (int i = 0; i < 10; ++i) {
            elapsedTime_deblur = System.nanoTime();
            CGLSFloatIterativeDeconvolver2D cgls = new CGLSFloatIterativeDeconvolver2D(blurImage, psfImage, IterativeEnums.PreconditionerType.NONE, 0.0f, boundary, resizing, output, 5, false, options);
            ImagePlus imX = cgls.deconvolve();
            elapsedTime_deblur = System.nanoTime() - elapsedTime_deblur;
            av_time_deblur += (double)elapsedTime_deblur;
            cgls = null;
            imX = null;
        }
        blurImage = null;
        psfImage = null;
        System.out.println("Average execution time: " + String.format(format, av_time_deblur / 1.0E9 / 10.0) + " sec");
        Benchmark2D.writeResultsToFile("FloatCGLS2D_" + threads + "_threads.txt", av_time_deblur / 1.0E9 / 10.0);
    }

    public static void benchmarkFloatPCGLS2D(int threads) {
        ConcurrencyUtils.setNumberOfThreads((int)threads);
        Opener o = new Opener();
        ImagePlus blurImage = o.openImage("/home/pwendyk/images/iterative/astronaut4096-blur.png");
        ImagePlus[][] psfImage = new ImagePlus[1][1];
        psfImage[0][0] = o.openImage("/home/pwendyk/images/iterative/astronaut4096-psf.png");
        double av_time_deblur = 0.0;
        long elapsedTime_deblur = 0L;
        System.out.println("Benchmarking FloatPCGLS2D using " + threads + " threads");
        CGLSOptions options = new CGLSOptions(false, 0.0, false, 0.0, false);
        for (int i = 0; i < 10; ++i) {
            elapsedTime_deblur = System.nanoTime();
            CGLSFloatIterativeDeconvolver2D cgls = new CGLSFloatIterativeDeconvolver2D(blurImage, psfImage, IterativeEnums.PreconditionerType.FFT, 0.001f, boundary, resizing, output, 5, false, options);
            ImagePlus imX = cgls.deconvolve();
            elapsedTime_deblur = System.nanoTime() - elapsedTime_deblur;
            av_time_deblur += (double)elapsedTime_deblur;
            cgls = null;
            imX = null;
        }
        blurImage = null;
        psfImage = null;
        System.out.println("Average execution time (tol =  0.001): " + String.format(format, av_time_deblur / 1.0E9 / 10.0) + " sec");
        Benchmark2D.writeResultsToFile("FloatPCGLS2D_" + threads + "_threads.txt", av_time_deblur / 1.0E9 / 10.0, 0.001);
    }

    public static void benchmarkFloatMRNSD2D(int threads) {
        ConcurrencyUtils.setNumberOfThreads((int)threads);
        Opener o = new Opener();
        ImagePlus blurImage = o.openImage("/home/pwendyk/images/iterative/astronaut4096-blur.png");
        ImagePlus[][] psfImage = new ImagePlus[1][1];
        psfImage[0][0] = o.openImage("/home/pwendyk/images/iterative/astronaut4096-psf.png");
        double av_time_deblur = 0.0;
        long elapsedTime_deblur = 0L;
        System.out.println("Benchmarking FloatMRNSD2D using " + threads + " threads");
        MRNSDOptions options = new MRNSDOptions(false, 0.0, false, 0.0, false);
        for (int i = 0; i < 10; ++i) {
            elapsedTime_deblur = System.nanoTime();
            MRNSDFloatIterativeDeconvolver2D mrnsd = new MRNSDFloatIterativeDeconvolver2D(blurImage, psfImage, IterativeEnums.PreconditionerType.NONE, 0.001f, boundary, resizing, output, 5, false, options);
            ImagePlus imX = mrnsd.deconvolve();
            elapsedTime_deblur = System.nanoTime() - elapsedTime_deblur;
            av_time_deblur += (double)elapsedTime_deblur;
            mrnsd = null;
            imX = null;
        }
        blurImage = null;
        psfImage = null;
        System.out.println("Average execution time: " + String.format(format, av_time_deblur / 1.0E9 / 10.0) + " sec");
        Benchmark2D.writeResultsToFile("FloatMRNSD2D_" + threads + "_threads.txt", av_time_deblur / 1.0E9 / 10.0);
    }

    public static void benchmarkFloatPMRNSD2D(int threads) {
        ConcurrencyUtils.setNumberOfThreads((int)threads);
        Opener o = new Opener();
        ImagePlus blurImage = o.openImage("/home/pwendyk/images/iterative/astronaut4096-blur.png");
        ImagePlus[][] psfImage = new ImagePlus[1][1];
        psfImage[0][0] = o.openImage("/home/pwendyk/images/iterative/astronaut4096-psf.png");
        double av_time_deblur = 0.0;
        long elapsedTime_deblur = 0L;
        System.out.println("Benchmarking FloatPMRNSD2D using " + threads + " threads");
        MRNSDOptions options = new MRNSDOptions(false, 0.0, false, 0.0, false);
        for (int i = 0; i < 10; ++i) {
            elapsedTime_deblur = System.nanoTime();
            MRNSDFloatIterativeDeconvolver2D mrnsd = new MRNSDFloatIterativeDeconvolver2D(blurImage, psfImage, IterativeEnums.PreconditionerType.FFT, 0.001f, boundary, resizing, output, 5, false, options);
            ImagePlus imX = mrnsd.deconvolve();
            elapsedTime_deblur = System.nanoTime() - elapsedTime_deblur;
            av_time_deblur += (double)elapsedTime_deblur;
            mrnsd = null;
            imX = null;
        }
        blurImage = null;
        psfImage = null;
        System.out.println("Average execution time (tol =  0.001): " + String.format(format, av_time_deblur / 1.0E9 / 10.0) + " sec");
        Benchmark2D.writeResultsToFile("FloatPMRNSD2D_" + threads + "_threads.txt", av_time_deblur / 1.0E9 / 10.0, 0.001);
    }

    public static void benchmarkFloatHyBR2D(int threads) {
        ConcurrencyUtils.setNumberOfThreads((int)threads);
        Opener o = new Opener();
        ImagePlus blurImage = o.openImage("/home/pwendyk/images/iterative/astronaut4096-blur.png");
        ImagePlus[][] psfImage = new ImagePlus[1][1];
        psfImage[0][0] = o.openImage("/home/pwendyk/images/iterative/astronaut4096-psf.png");
        double av_time_deblur = 0.0;
        long elapsedTime_deblur = 0L;
        System.out.println("Benchmarking FloatHyBR2D using " + threads + " threads");
        HyBROptions options = new HyBROptions(HyBRInnerSolver.TIKHONOV, HyBRRegularizationMethod.ADAPTWGCV, 0.0, 0.0, false, 2, 0.0, false, false, 0.0);
        for (int i = 0; i < 10; ++i) {
            elapsedTime_deblur = System.nanoTime();
            HyBRFloatIterativeDeconvolver2D hybr = new HyBRFloatIterativeDeconvolver2D(blurImage, psfImage, IterativeEnums.PreconditionerType.NONE, 0.001f, boundary, resizing, output, 5, false, options);
            ImagePlus imX = hybr.deconvolve();
            elapsedTime_deblur = System.nanoTime() - elapsedTime_deblur;
            av_time_deblur += (double)elapsedTime_deblur;
            hybr = null;
            imX = null;
        }
        blurImage = null;
        psfImage = null;
        System.out.println("Average execution time: " + String.format(format, av_time_deblur / 1.0E9 / 10.0) + " sec");
        Benchmark2D.writeResultsToFile("FloatHyBR2D_" + threads + "_threads.txt", av_time_deblur / 1.0E9 / 10.0);
    }

    public static void benchmarkFloatPHyBR2D(int threads) {
        ConcurrencyUtils.setNumberOfThreads((int)threads);
        Opener o = new Opener();
        ImagePlus blurImage = o.openImage("/home/pwendyk/images/iterative/astronaut4096-blur.png");
        ImagePlus[][] psfImage = new ImagePlus[1][1];
        psfImage[0][0] = o.openImage("/home/pwendyk/images/iterative/astronaut4096-psf.png");
        double av_time_deblur = 0.0;
        long elapsedTime_deblur = 0L;
        System.out.println("Benchmarking preconditioned FloatHyBR2D using " + threads + " threads");
        HyBROptions options = new HyBROptions(HyBRInnerSolver.TIKHONOV, HyBRRegularizationMethod.ADAPTWGCV, 0.0, 0.0, false, 2, 0.0, false, false, 0.0);
        for (int i = 0; i < 10; ++i) {
            elapsedTime_deblur = System.nanoTime();
            HyBRFloatIterativeDeconvolver2D hybr = new HyBRFloatIterativeDeconvolver2D(blurImage, psfImage, IterativeEnums.PreconditionerType.FFT, 0.001f, boundary, resizing, output, 5, false, options);
            ImagePlus imX = hybr.deconvolve();
            elapsedTime_deblur = System.nanoTime() - elapsedTime_deblur;
            av_time_deblur += (double)elapsedTime_deblur;
            hybr = null;
            imX = null;
        }
        blurImage = null;
        psfImage = null;
        System.out.println("Average execution time (tol =  0.001): " + String.format(format, av_time_deblur / 1.0E9 / 10.0) + " sec");
        Benchmark2D.writeResultsToFile("FloatPHyBR2D_" + threads + "_threads.txt", av_time_deblur / 1.0E9 / 10.0, 0.001);
    }

    public static void benchmarkFloatWPL2D(int threads) {
        ConcurrencyUtils.setNumberOfThreads((int)threads);
        Opener o = new Opener();
        ImagePlus blurImage = o.openImage("/home/pwendyk/images/iterative/astronaut4096-blur.png");
        ImagePlus[][] psfImage = new ImagePlus[1][1];
        psfImage[0][0] = o.openImage("/home/pwendyk/images/iterative/astronaut4096-psf.png");
        double av_time_deblur = 0.0;
        long elapsedTime_deblur = 0L;
        System.out.println("Benchmarking FloatWPL2D using " + threads + " threads");
        WPLOptions options = new WPLOptions(0.0, 1.0, 1.0, true, false, false, 0.0, false, false, false, 0.0);
        for (int i = 0; i < 10; ++i) {
            elapsedTime_deblur = System.nanoTime();
            WPLFloatIterativeDeconvolver2D wpl = new WPLFloatIterativeDeconvolver2D(blurImage, psfImage[0][0], boundary, resizing, output, 5, false, options);
            ImagePlus imX = wpl.deconvolve();
            elapsedTime_deblur = System.nanoTime() - elapsedTime_deblur;
            av_time_deblur += (double)elapsedTime_deblur;
            wpl = null;
            imX = null;
        }
        blurImage = null;
        psfImage = null;
        System.out.println("Average execution time: " + String.format(format, av_time_deblur / 1.0E9 / 10.0) + " sec");
        Benchmark2D.writeResultsToFile("FloatWPL2D_" + threads + "_threads.txt", av_time_deblur / 1.0E9 / 10.0);
    }

    public static void benchmarkFloatPWPL2D(int threads) {
        ConcurrencyUtils.setNumberOfThreads((int)threads);
        Opener o = new Opener();
        ImagePlus blurImage = o.openImage("/home/pwendyk/images/iterative/astronaut4096-blur.png");
        ImagePlus[][] psfImage = new ImagePlus[1][1];
        psfImage[0][0] = o.openImage("/home/pwendyk/images/iterative/astronaut4096-psf.png");
        double av_time_deblur = 0.0;
        long elapsedTime_deblur = 0L;
        System.out.println("Benchmarking FloatPWPL2D using " + threads + " threads");
        WPLOptions options = new WPLOptions(0.01, 1.0, 1.0, true, false, false, 0.0, false, false, false, 0.0);
        for (int i = 0; i < 10; ++i) {
            elapsedTime_deblur = System.nanoTime();
            WPLFloatIterativeDeconvolver2D wpl = new WPLFloatIterativeDeconvolver2D(blurImage, psfImage[0][0], boundary, resizing, output, 5, false, options);
            ImagePlus imX = wpl.deconvolve();
            elapsedTime_deblur = System.nanoTime() - elapsedTime_deblur;
            av_time_deblur += (double)elapsedTime_deblur;
            wpl = null;
            imX = null;
        }
        blurImage = null;
        psfImage = null;
        System.out.println("Average execution time (tol =  0.001): " + String.format(format, av_time_deblur / 1.0E9 / 10.0) + " sec");
        Benchmark2D.writeResultsToFile("FloatPWPL2D_" + threads + "_threads.txt", av_time_deblur / 1.0E9 / 10.0, 0.001);
    }

    public static void writeResultsToFile(String filename, double time_deblur) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            out.write(new Date().toString());
            out.newLine();
            out.write("Number of processors: " + ConcurrencyUtils.getNumberOfThreads());
            out.newLine();
            out.write("deblur time: ");
            out.write(String.format(format, time_deblur));
            out.write(" seconds");
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeResultsToFile(String filename, double time_deblur, double prec_tol) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            out.write(new Date().toString());
            out.newLine();
            out.write("Number of processors: " + ConcurrencyUtils.getNumberOfThreads());
            out.newLine();
            out.write("deblur time (tol = " + prec_tol + "): ");
            out.write(String.format(format, time_deblur));
            out.write(" seconds");
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Benchmark2D.benchmarkFloatPWPL2D(1);
        Benchmark2D.benchmarkFloatPWPL2D(2);
        Benchmark2D.benchmarkFloatPWPL2D(4);
        Benchmark2D.benchmarkFloatPWPL2D(8);
        Benchmark2D.benchmarkFloatPHyBR2D(1);
        Benchmark2D.benchmarkFloatPHyBR2D(2);
        Benchmark2D.benchmarkFloatPHyBR2D(4);
        Benchmark2D.benchmarkFloatPHyBR2D(8);
        Benchmark2D.benchmarkFloatPCGLS2D(1);
        Benchmark2D.benchmarkFloatPCGLS2D(2);
        Benchmark2D.benchmarkFloatPCGLS2D(4);
        Benchmark2D.benchmarkFloatPCGLS2D(8);
        Benchmark2D.benchmarkFloatPMRNSD2D(1);
        Benchmark2D.benchmarkFloatPMRNSD2D(2);
        Benchmark2D.benchmarkFloatPMRNSD2D(4);
        Benchmark2D.benchmarkFloatPMRNSD2D(8);
        System.exit(0);
    }
}

