/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative;

import cern.colt.Arrays;
import cern.colt.Timer;
import cern.colt.matrix.tdouble.algo.solver.HyBRInnerSolver;
import cern.colt.matrix.tdouble.algo.solver.HyBRRegularizationMethod;
import edu.emory.mathcs.restoretools.Enums;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.restoretools.iterative.cgls.CGLSDoubleIterativeDeconvolver3D;
import edu.emory.mathcs.restoretools.iterative.cgls.CGLSFloatIterativeDeconvolver3D;
import edu.emory.mathcs.restoretools.iterative.cgls.CGLSOptions;
import edu.emory.mathcs.restoretools.iterative.hybr.HyBRDoubleIterativeDeconvolver3D;
import edu.emory.mathcs.restoretools.iterative.hybr.HyBRFloatIterativeDeconvolver3D;
import edu.emory.mathcs.restoretools.iterative.hybr.HyBROptions;
import edu.emory.mathcs.restoretools.iterative.mrnsd.MRNSDDoubleIterativeDeconvolver3D;
import edu.emory.mathcs.restoretools.iterative.mrnsd.MRNSDFloatIterativeDeconvolver3D;
import edu.emory.mathcs.restoretools.iterative.mrnsd.MRNSDOptions;
import edu.emory.mathcs.restoretools.iterative.wpl.WPLDoubleIterativeDeconvolver3D;
import edu.emory.mathcs.restoretools.iterative.wpl.WPLFloatIterativeDeconvolver3D;
import edu.emory.mathcs.restoretools.iterative.wpl.WPLOptions;
import edu.emory.mathcs.utils.pc.ConcurrencyUtils;
import ij.IJ;
import ij.ImageJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.WindowManager;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;

public class ParallelIterativeDeconvolution3D
implements PlugIn,
ImageListener {
    private static final String version = "1.11";
    private static final String[] methodNames = new String[]{"MRNSD", "WPL", "CGLS", "HyBR"};
    private static final String[] shortMethodNames = new String[]{"mrnsd", "wpl", "cgls", "hybr"};
    private static final String[] precisionNames = new String[]{"Single", "Double"};
    private static final String[] precondNames = new String[]{"FFT preconditioner", "None"};
    private static final String[] shortPrecondNames = new String[]{"fft", "none"};
    private static final String[] boundaryNames = new String[]{"Reflexive", "Periodic", "Zero"};
    private static final String[] resizingNames = new String[]{"Auto", "Minimal", "Next power of two"};
    private static final String[] outputNames = new String[]{"Same as source", "Byte (8-bit)", "Short (16-bit)", "Float (32-bit)"};
    private static final String[] shortBoundaryNames = new String[]{"ref", "per", "zero"};
    private JFrame mainPanel;
    private JFrame psfCreatePanel;
    private JFrame psfEditPanel;
    private JFrame hybrOptionsPanel;
    private JFrame mrnsdOptionsPanel;
    private JFrame cglsOptionsPanel;
    private JFrame wplOptionsFrame;
    private CGLSDoubleIterativeDeconvolver3D dcgls;
    private HyBRDoubleIterativeDeconvolver3D dhybr;
    private MRNSDDoubleIterativeDeconvolver3D dmrnsd;
    private WPLDoubleIterativeDeconvolver3D dwpl;
    private CGLSFloatIterativeDeconvolver3D fcgls;
    private HyBRFloatIterativeDeconvolver3D fhybr;
    private MRNSDFloatIterativeDeconvolver3D fmrnsd;
    private WPLFloatIterativeDeconvolver3D fwpl;
    private ImagePlus imB;
    private ImagePlus imX;
    private ImagePlus[][][] imPSF;
    private int[] windowIDs;
    private String[] imageTitles;
    private JComboBox blurChoice;
    private JComboBox psfChoice;
    private JComboBox methodChoice;
    private JComboBox precondChoice;
    private JComboBox boundaryChoice;
    private JComboBox resizingChoice;
    private JComboBox outputChoice;
    private JComboBox precisionChoice;
    private JTextField itersField;
    private JTextField threadsField;
    private JTextField precondField;
    private JCheckBox variantPSFCheck;
    private JCheckBox itersCheck;
    private JCheckBox precondCheck;
    private JButton definePSFButton;
    private JButton editPSFButton;
    private JButton optionsButton;
    private JButton deconvolveButton;
    private JButton cancelButton;
    private int psfSlices;
    private int psfRows;
    private int psfColumns;
    private MRNSDOptions mrnsdOptions = new MRNSDOptions();
    private boolean mrnsdOptionsSet = false;
    private CGLSOptions cglsOptions = new CGLSOptions();
    private boolean cglsOptionsSet = false;
    private HyBROptions hybrOptions = new HyBROptions();
    private boolean hybrOptionsSet = false;
    private WPLOptions wplOptions = new WPLOptions();
    private boolean wplOptionsSet = false;
    private int maxIters;
    private int threads;
    private double precTol;

    public static String deconvolveWPL(String pathToBlurredImage, String pathToPsf, String pathToDeblurredImage, String boundaryStr, String resizingStr, String outputStr, String precisionStr, String thresholdStr, String maxItersStr, String nOfThreadsStr, String showIterationsStr, String gammaStr, String filterXYStr, String filterZStr, String normalizeStr, String logMeanStr, String antiRingStr, String changeThreshPercentStr, String dbStr, String detectDivergenceStr) {
        double changeThreshPercent;
        boolean detectDivergence;
        boolean db;
        boolean antiRing;
        boolean logMean;
        boolean normalize;
        double filterZ;
        double filterXY;
        double gamma;
        boolean showIterations;
        int nOfThreads;
        double threshold;
        int maxIters;
        IterativeEnums.BoundaryType boundary = null;
        Enum resizing = null;
        Enum output = null;
        Enum precision = null;
        ImagePlus imX = null;
        ImagePlus imB = IJ.openImage((String)pathToBlurredImage);
        if (imB == null) {
            return "Cannot open image " + pathToBlurredImage;
        }
        ImagePlus imPSF = IJ.openImage((String)pathToPsf);
        if (imPSF == null) {
            return "Cannot open image " + pathToPsf;
        }
        ImageProcessor ipB = imB.getProcessor();
        if (ipB instanceof ColorProcessor) {
            return "RGB images are not currently supported";
        }
        if (imB.getStackSize() == 1) {
            return "For 2D images use Parallel Iterative Deconvolution 2D";
        }
        ImageProcessor ipPSF = imPSF.getProcessor();
        if (ipPSF instanceof ColorProcessor) {
            return "RGB images are not currently supported";
        }
        if (imPSF.getStackSize() == 1) {
            return "For 2D images use Parallel Iterative Deconvolution 2D";
        }
        try {
            maxIters = Integer.parseInt(maxItersStr);
        }
        catch (Exception ex) {
            return "maxIters must be a positive integer";
        }
        if (maxIters < 1) {
            return "maxIters must be a positive integer";
        }
        for (IterativeEnums.BoundaryType boundaryType : IterativeEnums.BoundaryType.values()) {
            if (!boundaryType.toString().equals(boundaryStr)) continue;
            boundary = boundaryType;
            break;
        }
        if (boundary == null) {
            return "boundary must be in " + Arrays.toString((Object[])IterativeEnums.BoundaryType.values());
        }
        for (Enum enum_ : IterativeEnums.ResizingType.values()) {
            if (!enum_.toString().equals(resizingStr)) continue;
            resizing = enum_;
            break;
        }
        if (resizing == null) {
            return "resizing must be in " + Arrays.toString((Object[])IterativeEnums.ResizingType.values());
        }
        for (Enum enum_ : Enums.OutputType.values()) {
            if (!enum_.toString().equals(outputStr)) continue;
            output = enum_;
            break;
        }
        if (output == null) {
            return "output must be in " + Arrays.toString((Object[])Enums.OutputType.values());
        }
        for (Enum enum_ : Enums.PrecisionType.values()) {
            if (!enum_.toString().equals(precisionStr)) continue;
            precision = enum_;
            break;
        }
        if (precision == null) {
            return "precision must be in " + Arrays.toString((Object[])Enums.PrecisionType.values());
        }
        try {
            threshold = Double.parseDouble(thresholdStr);
        }
        catch (Exception ex) {
            return "threshold must be a nonnegative number or -1 to disable";
        }
        if (threshold != -1.0 && threshold < 0.0) {
            return "threshold must be a nonnegative number or -1 to disable";
        }
        try {
            nOfThreads = Integer.parseInt(nOfThreadsStr);
        }
        catch (Exception ex) {
            return "nOfThreads must be power of 2";
        }
        if (nOfThreads < 1) {
            return "nOfThreads must be power of 2";
        }
        if (!ConcurrencyUtils.isPowerOf2((int)nOfThreads)) {
            return "nOfThreads must be power of 2";
        }
        try {
            showIterations = Boolean.parseBoolean(showIterationsStr);
        }
        catch (Exception ex) {
            return "showItrations must be a boolean value (true or false)";
        }
        try {
            gamma = Double.parseDouble(gammaStr);
        }
        catch (Exception ex) {
            return "gamma must be a nonnegative value";
        }
        if (gamma < 0.0) {
            return "gamma must be a nonnegative value";
        }
        try {
            filterXY = Double.parseDouble(filterXYStr);
        }
        catch (Exception ex) {
            return "filterXY must be a nonnegative value";
        }
        if (filterXY < 0.0) {
            return "filterXY must be a nonnegative value";
        }
        try {
            filterZ = Double.parseDouble(filterZStr);
        }
        catch (Exception ex) {
            return "filterZ must be a nonnegative value";
        }
        if (filterZ < 0.0) {
            return "filterZ must be a nonnegative value";
        }
        try {
            normalize = Boolean.parseBoolean(normalizeStr);
        }
        catch (Exception ex) {
            return "normalize must be a boolean value (true or false)";
        }
        try {
            logMean = Boolean.parseBoolean(logMeanStr);
        }
        catch (Exception ex) {
            return "logMean must be a boolean value (true or false)";
        }
        try {
            antiRing = Boolean.parseBoolean(antiRingStr);
        }
        catch (Exception ex) {
            return "antiRing must be a boolean value (true or false)";
        }
        try {
            db = Boolean.parseBoolean(dbStr);
        }
        catch (Exception ex) {
            return "db must be a boolean value (true or false)";
        }
        try {
            detectDivergence = Boolean.parseBoolean(detectDivergenceStr);
        }
        catch (Exception ex) {
            return "detectDivergence must be a boolean value (true or false)";
        }
        try {
            changeThreshPercent = Double.parseDouble(changeThreshPercentStr);
        }
        catch (Exception ex) {
            return "changeThreshPercent must be a nonnegative value";
        }
        if (changeThreshPercent < 0.0) {
            IJ.error((String)"changeThreshPercent must be a nonnegative value");
        }
        ConcurrencyUtils.setNumberOfThreads((int)nOfThreads);
        WPLOptions options = new WPLOptions(gamma, filterXY, filterZ, normalize, logMean, antiRing, changeThreshPercent, db, detectDivergence, threshold != -1.0, threshold);
        switch (1.$SwitchMap$edu$emory$mathcs$restoretools$Enums$PrecisionType[precision.ordinal()]) {
            case 1: {
                WPLDoubleIterativeDeconvolver3D dwpl = new WPLDoubleIterativeDeconvolver3D(imB, imPSF, boundary, (IterativeEnums.ResizingType)resizing, (Enums.OutputType)output, maxIters, showIterations, options);
                imX = dwpl.deconvolve();
                break;
            }
            case 2: {
                WPLFloatIterativeDeconvolver3D fwpl = new WPLFloatIterativeDeconvolver3D(imB, imPSF, boundary, (IterativeEnums.ResizingType)resizing, (Enums.OutputType)output, maxIters, showIterations, options);
                imX = fwpl.deconvolve();
            }
        }
        IJ.save(imX, (String)pathToDeblurredImage);
        return pathToDeblurredImage;
    }

    public static String deconvolveMRNSD(String pathToBlurredImage, String pathToPsf, String pathToDeblurredImage, String preconditionerStr, String preconditionerTolStr, String boundaryStr, String resizingStr, String outputStr, String precisionStr, String stoppingTolStr, String thresholdStr, String logConvergenceStr, String maxItersStr, String nOfThreadsStr, String showIterationsStr) {
        boolean showIterations;
        int nOfThreads;
        boolean logConvergence;
        double threshold;
        double stoppingTol;
        double preconditionerTol;
        int maxIters;
        IterativeEnums.PreconditionerType preconditioner = null;
        Enum boundary = null;
        Enum resizing = null;
        Enum output = null;
        Enum precision = null;
        ImagePlus imX = null;
        ImagePlus imB = IJ.openImage((String)pathToBlurredImage);
        if (imB == null) {
            return "Cannot open image " + pathToBlurredImage;
        }
        ImagePlus[][][] imPSF = new ImagePlus[1][1][1];
        imPSF[0][0][0] = IJ.openImage((String)pathToPsf);
        if (imPSF[0][0][0] == null) {
            return "Cannot open image " + pathToPsf;
        }
        ImageProcessor ipB = imB.getProcessor();
        if (ipB instanceof ColorProcessor) {
            return "RGB images are not currently supported.";
        }
        if (imB.getStackSize() == 1) {
            return "For 2D images use Parallel Iterative Deconvolution 2D";
        }
        ImageProcessor ipPSF = imPSF[0][0][0].getProcessor();
        if (ipPSF instanceof ColorProcessor) {
            return "RGB images are not currently supported.";
        }
        if (imPSF[0][0][0].getStackSize() == 1) {
            return "For 2D images use Parallel Iterative Deconvolution 2D.";
        }
        try {
            maxIters = Integer.parseInt(maxItersStr);
        }
        catch (Exception ex) {
            return "nOfIters must be a positive integer";
        }
        if (maxIters < 1) {
            return "nOfIters must be a positive integer";
        }
        for (IterativeEnums.PreconditionerType preconditionerType : IterativeEnums.PreconditionerType.values()) {
            if (!preconditionerType.toString().equals(preconditionerStr)) continue;
            preconditioner = preconditionerType;
            break;
        }
        if (preconditioner == null) {
            return "preconditioner must be in " + Arrays.toString((Object[])IterativeEnums.PreconditionerType.values());
        }
        for (Enum enum_ : IterativeEnums.BoundaryType.values()) {
            if (!enum_.toString().equals(boundaryStr)) continue;
            boundary = enum_;
            break;
        }
        if (boundary == null) {
            return "boundary must be in " + Arrays.toString((Object[])IterativeEnums.BoundaryType.values());
        }
        for (Enum enum_ : IterativeEnums.ResizingType.values()) {
            if (!enum_.toString().equals(resizingStr)) continue;
            resizing = enum_;
            break;
        }
        if (resizing == null) {
            return "resizing must be in " + Arrays.toString((Object[])IterativeEnums.ResizingType.values());
        }
        for (Enum enum_ : Enums.OutputType.values()) {
            if (!enum_.toString().equals(outputStr)) continue;
            output = enum_;
            break;
        }
        if (output == null) {
            return "output must be in " + Arrays.toString((Object[])Enums.OutputType.values());
        }
        for (Enum enum_ : Enums.PrecisionType.values()) {
            if (!enum_.toString().equals(precisionStr)) continue;
            precision = enum_;
            break;
        }
        if (precision == null) {
            return "precision must be in " + Arrays.toString((Object[])Enums.PrecisionType.values());
        }
        try {
            preconditionerTol = Double.parseDouble(preconditionerTolStr);
        }
        catch (Exception ex) {
            return "preconditionerTol must be a number between 0 and 1 or -1 for auto";
        }
        if (preconditionerTol != -1.0 && (preconditionerTol < 0.0 || preconditionerTol > 1.0)) {
            return "preconditionerTol must be a number between 0 and 1 or -1 for auto";
        }
        try {
            stoppingTol = Double.parseDouble(stoppingTolStr);
        }
        catch (Exception ex) {
            return "stoppingTol must be a number between 0 and 1 or -1 for auto";
        }
        if (stoppingTol != -1.0 && (stoppingTol < 0.0 || stoppingTol > 1.0)) {
            return "stoppingTol must be a number between 0 and 1 or -1 for auto";
        }
        try {
            threshold = Double.parseDouble(thresholdStr);
        }
        catch (Exception ex) {
            return "threshold must be a nonnegative number or -1 to disable";
        }
        if (threshold != -1.0 && threshold < 0.0) {
            return "threshold must be a nonnegative number or -1 to disable";
        }
        try {
            logConvergence = Boolean.parseBoolean(logConvergenceStr);
        }
        catch (Exception ex) {
            return "logConvergence must be a boolean value (true or false)";
        }
        try {
            nOfThreads = Integer.parseInt(nOfThreadsStr);
        }
        catch (Exception ex) {
            return "nOfThreads must be power of 2";
        }
        if (nOfThreads < 1) {
            return "nOfThreads must be power of 2";
        }
        if (!ConcurrencyUtils.isPowerOf2((int)nOfThreads)) {
            return "nOfThreads must be power of 2";
        }
        try {
            showIterations = Boolean.parseBoolean(showIterationsStr);
        }
        catch (Exception ex) {
            return "showItrations must be a boolean value (true or false)";
        }
        ConcurrencyUtils.setNumberOfThreads((int)nOfThreads);
        MRNSDOptions options = new MRNSDOptions(stoppingTol == -1.0, stoppingTol, threshold != -1.0, threshold, logConvergence);
        switch (1.$SwitchMap$edu$emory$mathcs$restoretools$Enums$PrecisionType[precision.ordinal()]) {
            case 1: {
                MRNSDDoubleIterativeDeconvolver3D dmrnsd = new MRNSDDoubleIterativeDeconvolver3D(imB, imPSF, preconditioner, preconditionerTol, (IterativeEnums.BoundaryType)boundary, (IterativeEnums.ResizingType)resizing, (Enums.OutputType)output, maxIters, showIterations, options);
                imX = dmrnsd.deconvolve();
                break;
            }
            case 2: {
                MRNSDFloatIterativeDeconvolver3D fmrnsd = new MRNSDFloatIterativeDeconvolver3D(imB, imPSF, preconditioner, (float)preconditionerTol, (IterativeEnums.BoundaryType)boundary, (IterativeEnums.ResizingType)resizing, (Enums.OutputType)output, maxIters, showIterations, options);
                imX = fmrnsd.deconvolve();
            }
        }
        IJ.save(imX, (String)pathToDeblurredImage);
        return pathToDeblurredImage;
    }

    public static String deconvolveHyBR(String pathToBlurredImage, String pathToPsf, String pathToDeblurredImage, String preconditionerStr, String preconditionerTolStr, String boundaryStr, String resizingStr, String outputStr, String precisionStr, String thresholdStr, String logConvergenceStr, String maxItersStr, String nOfThreadsStr, String showIterationsStr, String innerSolverStr, String regMethodStr, String regParamStr, String omegaStr, String reorthStr, String beginRegStr, String flatTolStr) {
        double flatTol;
        int beginReg;
        boolean reorth;
        double omega;
        double regParam;
        boolean showIteration;
        int nOfThreads;
        boolean logConvergence;
        double threshold;
        double preconditionerTol;
        int maxIters;
        IterativeEnums.PreconditionerType preconditioner = null;
        Enum innerSolver = null;
        Enum regMethod = null;
        Enum boundary = null;
        Enum resizing = null;
        Enum output = null;
        Enum precision = null;
        ImagePlus imX = null;
        ImagePlus imB = IJ.openImage((String)pathToBlurredImage);
        if (imB == null) {
            return "Cannot open image " + pathToBlurredImage;
        }
        ImagePlus[][][] imPSF = new ImagePlus[1][1][1];
        imPSF[0][0][0] = IJ.openImage((String)pathToPsf);
        if (imPSF[0][0][0] == null) {
            return "Cannot open image " + pathToPsf;
        }
        ImageProcessor ipB = imB.getProcessor();
        if (ipB instanceof ColorProcessor) {
            return "RGB images are not currently supported.";
        }
        if (imB.getStackSize() == 1) {
            return "For 2D images use Parallel Iterative Deconvolution 2D";
        }
        ImageProcessor ipPSF = imPSF[0][0][0].getProcessor();
        if (ipPSF instanceof ColorProcessor) {
            return "RGB images are not currently supported.";
        }
        if (imPSF[0][0][0].getStackSize() == 1) {
            return "For 2D images use Parallel Iterative Deconvolution 2D.";
        }
        try {
            maxIters = Integer.parseInt(maxItersStr);
        }
        catch (Exception ex) {
            return "maxIters must be a positive integer";
        }
        if (maxIters < 1) {
            return "maxIters must be a positive integer";
        }
        for (IterativeEnums.PreconditionerType preconditionerType : IterativeEnums.PreconditionerType.values()) {
            if (!preconditionerType.toString().equals(preconditionerStr)) continue;
            preconditioner = preconditionerType;
            break;
        }
        if (preconditioner == null) {
            return "preconditioner must be in " + Arrays.toString((Object[])IterativeEnums.PreconditionerType.values());
        }
        for (Enum enum_ : IterativeEnums.BoundaryType.values()) {
            if (!enum_.toString().equals(boundaryStr)) continue;
            boundary = enum_;
            break;
        }
        if (boundary == null) {
            return "boundary must be in " + Arrays.toString((Object[])IterativeEnums.BoundaryType.values());
        }
        for (Enum enum_ : IterativeEnums.ResizingType.values()) {
            if (!enum_.toString().equals(resizingStr)) continue;
            resizing = enum_;
            break;
        }
        if (resizing == null) {
            return "resizing must be in " + Arrays.toString((Object[])IterativeEnums.ResizingType.values());
        }
        for (Enum enum_ : Enums.OutputType.values()) {
            if (!enum_.toString().equals(outputStr)) continue;
            output = enum_;
            break;
        }
        if (output == null) {
            return "output must be in " + Arrays.toString((Object[])Enums.OutputType.values());
        }
        for (Enum enum_ : Enums.PrecisionType.values()) {
            if (!enum_.toString().equals(precisionStr)) continue;
            precision = enum_;
            break;
        }
        if (precision == null) {
            return "precision must be in " + Arrays.toString((Object[])Enums.PrecisionType.values());
        }
        try {
            preconditionerTol = Double.parseDouble(preconditionerTolStr);
        }
        catch (Exception ex) {
            return "preconditionerTol must be a number between 0 and 1 or -1 for auto";
        }
        if (preconditionerTol != -1.0 && (preconditionerTol < 0.0 || preconditionerTol > 1.0)) {
            return "preconditionerTol must be a number between 0 and 1 or -1 for auto";
        }
        try {
            threshold = Double.parseDouble(thresholdStr);
        }
        catch (Exception ex) {
            return "threshold must be a nonnegative number or -1 to disable";
        }
        if (threshold != -1.0 && threshold < 0.0) {
            return "threshold must be a nonnegative number or -1 to disable";
        }
        try {
            logConvergence = Boolean.parseBoolean(logConvergenceStr);
        }
        catch (Exception ex) {
            return "logConvergence must be a boolean value (true or false)";
        }
        try {
            nOfThreads = Integer.parseInt(nOfThreadsStr);
        }
        catch (Exception ex) {
            return "nOfThreads must be power of 2";
        }
        if (nOfThreads < 1) {
            return "nOfThreads must be power of 2";
        }
        if (!ConcurrencyUtils.isPowerOf2((int)nOfThreads)) {
            return "nOfThreads must be power of 2";
        }
        try {
            showIteration = Boolean.parseBoolean(showIterationsStr);
        }
        catch (Exception ex) {
            return "showItration must be a boolean value (true or false)";
        }
        for (Enum enum_ : HyBRInnerSolver.values()) {
            if (!enum_.toString().equals(innerSolverStr)) continue;
            innerSolver = enum_;
            break;
        }
        if (innerSolver == null) {
            return "innerSolver must be in " + Arrays.toString((Object[])HyBRInnerSolver.values());
        }
        for (Enum enum_ : HyBRRegularizationMethod.values()) {
            if (!enum_.toString().equals(regMethodStr)) continue;
            regMethod = enum_;
            break;
        }
        if (regMethod == null) {
            return "regMethod method must be in " + Arrays.toString((Object[])HyBRRegularizationMethod.values());
        }
        try {
            regParam = Double.parseDouble(regParamStr);
        }
        catch (Exception ex) {
            return "regParam must be a floating-point number between 0 and 1 or -1 for auto";
        }
        if (regParam != -1.0 && (regParam < 0.0 || regParam > 1.0)) {
            return "regParam must be a floating-point number between 0 and 1 or -1 for auto";
        }
        try {
            omega = Double.parseDouble(omegaStr);
        }
        catch (Exception ex) {
            return "omega must be a nonnegative floating-point number";
        }
        if (omega < 0.0) {
            return "omega must be a nonnegative floating-point number";
        }
        try {
            reorth = Boolean.parseBoolean(reorthStr);
        }
        catch (Exception ex) {
            return "reorth must be a boolean value (true or false)";
        }
        try {
            beginReg = Integer.parseInt(beginRegStr);
        }
        catch (Exception ex) {
            return "beginReg must be an integer number greater than 1";
        }
        if (beginReg <= 1) {
            return "beginReg must be an integer number greater than 1";
        }
        try {
            flatTol = Double.parseDouble(flatTolStr);
        }
        catch (Exception ex) {
            return "flatTol must be a nonnegative floating-point number";
        }
        if (flatTol < 0.0) {
            return "flatTol must be a nonnegative floating-point number";
        }
        ConcurrencyUtils.setNumberOfThreads((int)nOfThreads);
        HyBROptions options = new HyBROptions((HyBRInnerSolver)innerSolver, (HyBRRegularizationMethod)regMethod, regParam, omega, reorth, beginReg, flatTol, logConvergence, threshold != -1.0, threshold);
        switch (1.$SwitchMap$edu$emory$mathcs$restoretools$Enums$PrecisionType[precision.ordinal()]) {
            case 1: {
                HyBRDoubleIterativeDeconvolver3D dhybr = new HyBRDoubleIterativeDeconvolver3D(imB, imPSF, preconditioner, preconditionerTol, (IterativeEnums.BoundaryType)boundary, (IterativeEnums.ResizingType)resizing, (Enums.OutputType)output, maxIters, showIteration, options);
                imX = dhybr.deconvolve();
                break;
            }
            case 2: {
                HyBRFloatIterativeDeconvolver3D fhybr = new HyBRFloatIterativeDeconvolver3D(imB, imPSF, preconditioner, (float)preconditionerTol, (IterativeEnums.BoundaryType)boundary, (IterativeEnums.ResizingType)resizing, (Enums.OutputType)output, maxIters, showIteration, options);
                imX = fhybr.deconvolve();
            }
        }
        IJ.save(imX, (String)pathToDeblurredImage);
        return pathToDeblurredImage;
    }

    public static String deconvolveCGLS(String pathToBlurredImage, String pathToPsf, String pathToDeblurredImage, String preconditionerStr, String preconditionerTolStr, String boundaryStr, String resizingStr, String outputStr, String precisionStr, String stoppingTolStr, String thresholdStr, String logConvergenceStr, String maxItersStr, String nOfThreadsStr, String showIterationsStr) {
        boolean showIterations;
        int nOfThreads;
        boolean logConvergence;
        double threshold;
        double stoppingTol;
        double preconditionerTol;
        int maxIters;
        IterativeEnums.PreconditionerType preconditioner = null;
        Enum boundary = null;
        Enum resizing = null;
        Enum output = null;
        Enum precision = null;
        ImagePlus imX = null;
        ImagePlus imB = IJ.openImage((String)pathToBlurredImage);
        if (imB == null) {
            return "Cannot open image " + pathToBlurredImage;
        }
        ImagePlus[][][] imPSF = new ImagePlus[1][1][1];
        imPSF[0][0][0] = IJ.openImage((String)pathToPsf);
        if (imPSF[0][0][0] == null) {
            return "Cannot open image " + pathToPsf;
        }
        ImageProcessor ipB = imB.getProcessor();
        if (ipB instanceof ColorProcessor) {
            return "RGB images are not currently supported.";
        }
        if (imB.getStackSize() == 1) {
            return "For 2D images use Parallel Iterative Deconvolution 2D.";
        }
        ImageProcessor ipPSF = imPSF[0][0][0].getProcessor();
        if (ipPSF instanceof ColorProcessor) {
            return "RGB images are not currently supported.";
        }
        if (imPSF[0][0][0].getStackSize() == 1) {
            return "For 2D images use Parallel Iterative Deconvolution 2D.";
        }
        try {
            maxIters = Integer.parseInt(maxItersStr);
        }
        catch (Exception ex) {
            return "nOfIters must be a positive integer";
        }
        if (maxIters < 1) {
            return "nOfIters must be a positive integer";
        }
        for (IterativeEnums.PreconditionerType preconditionerType : IterativeEnums.PreconditionerType.values()) {
            if (!preconditionerType.toString().equals(preconditionerStr)) continue;
            preconditioner = preconditionerType;
            break;
        }
        if (preconditioner == null) {
            return "preconditioner must be in " + Arrays.toString((Object[])IterativeEnums.PreconditionerType.values());
        }
        for (Enum enum_ : IterativeEnums.BoundaryType.values()) {
            if (!enum_.toString().equals(boundaryStr)) continue;
            boundary = enum_;
            break;
        }
        if (boundary == null) {
            return "boundary must be in " + Arrays.toString((Object[])IterativeEnums.BoundaryType.values());
        }
        for (Enum enum_ : IterativeEnums.ResizingType.values()) {
            if (!enum_.toString().equals(resizingStr)) continue;
            resizing = enum_;
            break;
        }
        if (resizing == null) {
            return "resizing must be in " + Arrays.toString((Object[])IterativeEnums.ResizingType.values());
        }
        for (Enum enum_ : Enums.OutputType.values()) {
            if (!enum_.toString().equals(outputStr)) continue;
            output = enum_;
            break;
        }
        if (output == null) {
            return "output must be in " + Arrays.toString((Object[])Enums.OutputType.values());
        }
        for (Enum enum_ : Enums.PrecisionType.values()) {
            if (!enum_.toString().equals(precisionStr)) continue;
            precision = enum_;
            break;
        }
        if (precision == null) {
            return "precision must be in " + Arrays.toString((Object[])Enums.PrecisionType.values());
        }
        try {
            preconditionerTol = Double.parseDouble(preconditionerTolStr);
        }
        catch (Exception ex) {
            return "preconditionerTol must be a number between 0 and 1 or -1 for auto";
        }
        if (preconditionerTol != -1.0 && (preconditionerTol < 0.0 || preconditionerTol > 1.0)) {
            return "preconditionerTol must be a number between 0 and 1 or -1 for auto";
        }
        try {
            stoppingTol = Double.parseDouble(stoppingTolStr);
        }
        catch (Exception ex) {
            return "stoppingTol must be a number between 0 and 1 or -1 for auto";
        }
        if (stoppingTol != -1.0 && (stoppingTol < 0.0 || stoppingTol > 1.0)) {
            return "stoppingTol must be a number between 0 and 1 or -1 for auto";
        }
        try {
            threshold = Double.parseDouble(thresholdStr);
        }
        catch (Exception ex) {
            return "threshold must be a nonnegative number or -1 to disable";
        }
        if (threshold != -1.0 && threshold < 0.0) {
            return "threshold must be a nonnegative number or -1 to disable";
        }
        try {
            logConvergence = Boolean.parseBoolean(logConvergenceStr);
        }
        catch (Exception ex) {
            return "logConvergence must be a boolean value (true or false)";
        }
        try {
            nOfThreads = Integer.parseInt(nOfThreadsStr);
        }
        catch (Exception ex) {
            return "nOfThreads must be power of 2";
        }
        if (nOfThreads < 1) {
            return "nOfThreads must be power of 2";
        }
        if (!ConcurrencyUtils.isPowerOf2((int)nOfThreads)) {
            return "nOfThreads must be power of 2";
        }
        try {
            showIterations = Boolean.parseBoolean(showIterationsStr);
        }
        catch (Exception ex) {
            return "showItration must be a boolean value (true or false)";
        }
        ConcurrencyUtils.setNumberOfThreads((int)nOfThreads);
        CGLSOptions options = new CGLSOptions(stoppingTol == -1.0, stoppingTol, threshold != -1.0, threshold, logConvergence);
        switch (1.$SwitchMap$edu$emory$mathcs$restoretools$Enums$PrecisionType[precision.ordinal()]) {
            case 1: {
                CGLSDoubleIterativeDeconvolver3D dcgls = new CGLSDoubleIterativeDeconvolver3D(imB, imPSF, preconditioner, preconditionerTol, (IterativeEnums.BoundaryType)boundary, (IterativeEnums.ResizingType)resizing, (Enums.OutputType)output, maxIters, showIterations, options);
                imX = dcgls.deconvolve();
                break;
            }
            case 2: {
                CGLSFloatIterativeDeconvolver3D fcgls = new CGLSFloatIterativeDeconvolver3D(imB, imPSF, preconditioner, (float)preconditionerTol, (IterativeEnums.BoundaryType)boundary, (IterativeEnums.ResizingType)resizing, (Enums.OutputType)output, maxIters, showIterations, options);
                imX = fcgls.deconvolve();
            }
        }
        IJ.save(imX, (String)pathToDeblurredImage);
        return pathToDeblurredImage;
    }

    private ImageListener getImageListener() {
        return this;
    }

    public void run(String arg) {
        if (IJ.versionLessThan((String)"1.35l")) {
            IJ.showMessage((String)"This plugin requires ImageJ 1.35l+");
            return;
        }
        if (!IJ.isJava15()) {
            IJ.showMessage((String)"This plugin requires Sun Java 1.5+");
            return;
        }
        WindowManager.checkForDuplicateName = true;
        ImagePlus.addImageListener((ImageListener)this);
        this.mainPanel = new MainPanel("Parallel Iterative Deconvolution 3D 1.11 ");
    }

    public void imageClosed(ImagePlus imp) {
        this.blurChoice.removeItem(imp.getTitle());
        this.blurChoice.revalidate();
        this.psfChoice.removeItem(imp.getTitle());
        this.psfChoice.revalidate();
        if (this.imX != null && imp.getTitle().equals(this.imX.getTitle())) {
            this.clean_old_data();
        }
    }

    public void imageOpened(ImagePlus imp) {
        this.blurChoice.addItem(imp.getTitle());
        this.blurChoice.revalidate();
        this.psfChoice.addItem(imp.getTitle());
        this.psfChoice.revalidate();
    }

    public void imageUpdated(ImagePlus imp) {
    }

    private void clean_old_data() {
        this.dcgls = null;
        this.dmrnsd = null;
        this.dhybr = null;
        this.dwpl = null;
        this.fcgls = null;
        this.fmrnsd = null;
        this.fhybr = null;
        this.fwpl = null;
    }

    private void clean_all() {
        this.dcgls = null;
        this.dmrnsd = null;
        this.dhybr = null;
        this.dwpl = null;
        this.fcgls = null;
        this.fmrnsd = null;
        this.fhybr = null;
        this.fwpl = null;
        this.imB = null;
        this.imPSF = null;
        this.imX = null;
        this.windowIDs = null;
        this.imageTitles = null;
    }

    public static void main(String[] args) {
        new ImageJ();
        IJ.open((String)"D:\\Research\\Images\\head\\head_blur.tif");
        IJ.open((String)"D:\\Research\\Images\\head\\head_psf.tif");
        IJ.runPlugIn((String)"edu.emory.mathcs.restoretools.iterative.ParallelIterativeDeconvolution3D", null);
    }

    static /* synthetic */ ImagePlus[][][] access$7902(ParallelIterativeDeconvolution3D x0, ImagePlus[][][] x1) {
        x0.imPSF = x1;
        return x1;
    }

    static /* synthetic */ int[] access$8102(ParallelIterativeDeconvolution3D x0, int[] x1) {
        x0.windowIDs = x1;
        return x1;
    }

    static /* synthetic */ String[] access$8202(ParallelIterativeDeconvolution3D x0, String[] x1) {
        x0.imageTitles = x1;
        return x1;
    }

    private class MainPanel
    extends JFrame {
        private static final long serialVersionUID = 3975356344081858245L;
        private final Cursor defaultCursor;
        private final Cursor waitCursor;
        private static final int width = 340;

        public MainPanel(String name) {
            super(name);
            this.defaultCursor = new Cursor(0);
            this.waitCursor = new Cursor(3);
            ParallelIterativeDeconvolution3D.access$8102(ParallelIterativeDeconvolution3D.this, WindowManager.getIDList());
            if (ParallelIterativeDeconvolution3D.this.windowIDs != null) {
                ParallelIterativeDeconvolution3D.access$8202(ParallelIterativeDeconvolution3D.this, new String[ParallelIterativeDeconvolution3D.this.windowIDs.length]);
                for (int i = 0; i < ParallelIterativeDeconvolution3D.this.windowIDs.length; ++i) {
                    ImagePlus im = WindowManager.getImage((int)ParallelIterativeDeconvolution3D.this.windowIDs[i]);
                    ((ParallelIterativeDeconvolution3D)ParallelIterativeDeconvolution3D.this).imageTitles[i] = im != null ? im.getTitle() : "";
                }
            }
            this.init();
        }

        private void init() {
            ToolTipManager.sharedInstance().setDismissDelay(20000);
            Container pane = this.getContentPane();
            pane.setLayout(new BoxLayout(pane, 1));
            JPanel blurPanel = new JPanel();
            blurPanel.setLayout(new FlowLayout(3));
            JLabel blurLabel = new JLabel("Image:");
            blurLabel.setPreferredSize(new Dimension(90, blurLabel.getPreferredSize().height));
            blurPanel.add(blurLabel);
            if (ParallelIterativeDeconvolution3D.this.windowIDs != null) {
                ParallelIterativeDeconvolution3D.this.blurChoice = new JComboBox<String>(ParallelIterativeDeconvolution3D.this.imageTitles);
                ParallelIterativeDeconvolution3D.this.blurChoice.setSelectedIndex(0);
            } else {
                ParallelIterativeDeconvolution3D.this.blurChoice = new JComboBox();
            }
            ParallelIterativeDeconvolution3D.this.blurChoice.setPreferredSize(new Dimension(340, ((ParallelIterativeDeconvolution3D)ParallelIterativeDeconvolution3D.this).blurChoice.getPreferredSize().height));
            ParallelIterativeDeconvolution3D.this.blurChoice.setAlignmentX(0.0f);
            ParallelIterativeDeconvolution3D.this.blurChoice.addActionListener(new BlurChoiceActionListener());
            ParallelIterativeDeconvolution3D.this.blurChoice.setToolTipText("<html>Choose a blurred image.</html>");
            blurPanel.add(ParallelIterativeDeconvolution3D.this.blurChoice);
            JPanel psfPanel = new JPanel();
            psfPanel.setLayout(new GridLayout(2, 1));
            TitledBorder border = new TitledBorder(null, null, 1, 2);
            psfPanel.setBorder(border);
            JPanel psfChoicePanel = new JPanel();
            psfChoicePanel.setLayout(new FlowLayout(3));
            JLabel psfLabel = new JLabel("PSF:");
            psfLabel.setPreferredSize(new Dimension(85, psfLabel.getPreferredSize().height));
            psfChoicePanel.add(psfLabel);
            if (ParallelIterativeDeconvolution3D.this.windowIDs != null) {
                ParallelIterativeDeconvolution3D.this.psfChoice = new JComboBox<String>(ParallelIterativeDeconvolution3D.this.imageTitles);
            } else {
                ParallelIterativeDeconvolution3D.this.psfChoice = new JComboBox();
            }
            ParallelIterativeDeconvolution3D.this.psfChoice.setPreferredSize(new Dimension(340, ((ParallelIterativeDeconvolution3D)ParallelIterativeDeconvolution3D.this).psfChoice.getPreferredSize().height));
            if (ParallelIterativeDeconvolution3D.this.windowIDs != null) {
                if (ParallelIterativeDeconvolution3D.this.windowIDs.length > 1) {
                    ParallelIterativeDeconvolution3D.this.psfChoice.setSelectedIndex(1);
                } else {
                    ParallelIterativeDeconvolution3D.this.psfChoice.setSelectedIndex(0);
                }
            }
            ParallelIterativeDeconvolution3D.this.psfChoice.setAlignmentX(0.0f);
            ParallelIterativeDeconvolution3D.this.psfChoice.addActionListener(new PsfChoiceActionListener());
            ParallelIterativeDeconvolution3D.this.psfChoice.setToolTipText("<html>Choose a PSF image.</html>");
            psfChoicePanel.add(ParallelIterativeDeconvolution3D.this.psfChoice);
            psfPanel.add(psfChoicePanel);
            JPanel psfVariantPanel = new JPanel();
            psfVariantPanel.setLayout(new FlowLayout(4));
            ParallelIterativeDeconvolution3D.this.variantPSFCheck = new JCheckBox("Spatially variant PSF");
            ParallelIterativeDeconvolution3D.this.variantPSFCheck.setSelected(false);
            ParallelIterativeDeconvolution3D.this.variantPSFCheck.addItemListener(new PSFCheckItemListener());
            psfVariantPanel.add(ParallelIterativeDeconvolution3D.this.variantPSFCheck);
            ParallelIterativeDeconvolution3D.this.definePSFButton = new JButton("Define");
            ParallelIterativeDeconvolution3D.this.definePSFButton.addActionListener(new DefinePSFButtonActionListener());
            ParallelIterativeDeconvolution3D.this.definePSFButton.setEnabled(false);
            psfVariantPanel.add(ParallelIterativeDeconvolution3D.this.definePSFButton);
            ParallelIterativeDeconvolution3D.this.editPSFButton = new JButton("Edit");
            ParallelIterativeDeconvolution3D.this.editPSFButton.setEnabled(false);
            ParallelIterativeDeconvolution3D.this.editPSFButton.addActionListener(new EditPSFButtonActionListener());
            psfVariantPanel.add(ParallelIterativeDeconvolution3D.this.editPSFButton);
            psfPanel.add(psfVariantPanel);
            JPanel methodPanel = new JPanel();
            methodPanel.setLayout(new FlowLayout(3));
            JLabel methodLabel = new JLabel("Method:");
            methodLabel.setPreferredSize(new Dimension(90, methodLabel.getPreferredSize().height));
            methodPanel.add(methodLabel);
            ParallelIterativeDeconvolution3D.this.methodChoice = new JComboBox<String>(methodNames);
            ParallelIterativeDeconvolution3D.this.methodChoice.setToolTipText("<html>Choose a method:<br><ul><li>MRNSD - Modified Residual Norm Steepest Descent.<br>This is a nonnegatively constrained algorithm.</li><li>WPL - Wiener Filter Preconditioned Landweber.<br>This is a nonnegatively constrained algorithm.</li><li>CGLS - Conjugate Gradient for Least Squares.</li><li>HyBR - Hybrid Bidiagonalization Regularization.</li></ul></html>");
            ParallelIterativeDeconvolution3D.this.methodChoice.setSelectedIndex(0);
            ParallelIterativeDeconvolution3D.this.methodChoice.setAlignmentX(0.0f);
            ParallelIterativeDeconvolution3D.this.methodChoice.addActionListener(new MethodChoiceActionListener());
            methodPanel.add(ParallelIterativeDeconvolution3D.this.methodChoice);
            ParallelIterativeDeconvolution3D.this.optionsButton = new JButton("Options");
            ParallelIterativeDeconvolution3D.this.optionsButton.addActionListener(new OptionsButtonActionListener());
            methodPanel.add(ParallelIterativeDeconvolution3D.this.optionsButton);
            JPanel precondPanel = new JPanel();
            precondPanel.setLayout(new FlowLayout(3));
            JLabel precondLabel1 = new JLabel("Preconditioner:");
            precondLabel1.setPreferredSize(new Dimension(90, precondLabel1.getPreferredSize().height));
            precondPanel.add(precondLabel1);
            ParallelIterativeDeconvolution3D.this.precondChoice = new JComboBox<String>(precondNames);
            ParallelIterativeDeconvolution3D.this.precondChoice.setSelectedIndex(0);
            ParallelIterativeDeconvolution3D.this.precondChoice.setAlignmentX(0.0f);
            ParallelIterativeDeconvolution3D.this.precondChoice.addActionListener(new PrecondChoiceActionListener());
            ParallelIterativeDeconvolution3D.this.precondChoice.setToolTipText("<html>Choose a preconditioner:<br><ul><li>FFT preconditioner - based on the Fast Fourier Transform.</li><li>None - no preconditioner.</li></ul></html>");
            precondPanel.add(ParallelIterativeDeconvolution3D.this.precondChoice);
            JLabel precondLabel2 = new JLabel("Tolerance:");
            precondPanel.add(precondLabel2);
            ParallelIterativeDeconvolution3D.this.precondField = new JTextField("0.0", 5);
            ParallelIterativeDeconvolution3D.this.precondField.addActionListener(new PrecondFieldActionListener());
            ParallelIterativeDeconvolution3D.this.precondField.setToolTipText("<html>A tolerance to \"regularize\" the preconditioner.</html>");
            ParallelIterativeDeconvolution3D.this.precondField.setEnabled(false);
            precondPanel.add(ParallelIterativeDeconvolution3D.this.precondField);
            ParallelIterativeDeconvolution3D.this.precondCheck = new JCheckBox("Auto");
            ParallelIterativeDeconvolution3D.this.precondCheck.setToolTipText("<html>Automatic choice of a tolerance for preconditioner<br>(based on the Generalized Cross Validation).</html>");
            ParallelIterativeDeconvolution3D.this.precondCheck.setSelected(true);
            ParallelIterativeDeconvolution3D.this.precondCheck.addItemListener(new PrecondCheckItemListener());
            precondPanel.add(ParallelIterativeDeconvolution3D.this.precondCheck);
            JPanel boundaryPanel = new JPanel();
            boundaryPanel.setLayout(new FlowLayout(3));
            JLabel boundaryLabel = new JLabel("Boundary:");
            boundaryLabel.setPreferredSize(new Dimension(90, boundaryLabel.getPreferredSize().height));
            boundaryPanel.add(boundaryLabel);
            ParallelIterativeDeconvolution3D.this.boundaryChoice = new JComboBox<String>(boundaryNames);
            ParallelIterativeDeconvolution3D.this.boundaryChoice.setSelectedIndex(0);
            ParallelIterativeDeconvolution3D.this.boundaryChoice.setAlignmentX(0.0f);
            ParallelIterativeDeconvolution3D.this.boundaryChoice.setToolTipText("<html>Choose boundary conditions.</html>");
            boundaryPanel.add(ParallelIterativeDeconvolution3D.this.boundaryChoice);
            JPanel resizingPanel = new JPanel();
            resizingPanel.setLayout(new FlowLayout(3));
            JLabel resizingLabel = new JLabel("Resizing:");
            resizingLabel.setPreferredSize(new Dimension(90, resizingLabel.getPreferredSize().height));
            resizingPanel.add(resizingLabel);
            ParallelIterativeDeconvolution3D.this.resizingChoice = new JComboBox<String>(resizingNames);
            ParallelIterativeDeconvolution3D.this.resizingChoice.setSelectedIndex(0);
            ParallelIterativeDeconvolution3D.this.resizingChoice.setAlignmentX(0.0f);
            ParallelIterativeDeconvolution3D.this.resizingChoice.setToolTipText("<html>Choose resizing.</html>");
            resizingPanel.add(ParallelIterativeDeconvolution3D.this.resizingChoice);
            JPanel outputPanel = new JPanel();
            outputPanel.setLayout(new FlowLayout(3));
            JLabel outputLabel = new JLabel("Output:");
            outputLabel.setPreferredSize(new Dimension(90, outputLabel.getPreferredSize().height));
            outputPanel.add(outputLabel);
            ParallelIterativeDeconvolution3D.this.outputChoice = new JComboBox<String>(outputNames);
            ParallelIterativeDeconvolution3D.this.outputChoice.setSelectedIndex(0);
            ParallelIterativeDeconvolution3D.this.outputChoice.setAlignmentX(0.0f);
            ParallelIterativeDeconvolution3D.this.outputChoice.setToolTipText("<html>Choose a type of deblurred image.</html>");
            outputPanel.add(ParallelIterativeDeconvolution3D.this.outputChoice);
            JPanel precisionPanel = new JPanel();
            precisionPanel.setLayout(new FlowLayout(3));
            JLabel precisionLabel = new JLabel("Precision:");
            precisionLabel.setPreferredSize(new Dimension(90, precisionLabel.getPreferredSize().height));
            precisionPanel.add(precisionLabel);
            ParallelIterativeDeconvolution3D.this.precisionChoice = new JComboBox<String>(precisionNames);
            ParallelIterativeDeconvolution3D.this.precisionChoice.setSelectedIndex(0);
            ParallelIterativeDeconvolution3D.this.precisionChoice.setAlignmentX(0.0f);
            ParallelIterativeDeconvolution3D.this.precisionChoice.setToolTipText("<html>Choose precision.</html>");
            precisionPanel.add(ParallelIterativeDeconvolution3D.this.precisionChoice);
            JPanel itersPanel = new JPanel();
            itersPanel.setLayout(new FlowLayout(3));
            JLabel itersLabel = new JLabel("Max number of iterations:");
            itersPanel.add(itersLabel);
            ParallelIterativeDeconvolution3D.this.itersField = new JTextField("5", 3);
            ParallelIterativeDeconvolution3D.this.itersField.addActionListener(new ItersFieldActionListener());
            ParallelIterativeDeconvolution3D.this.itersField.setToolTipText("<html>The maximum number of iterations.</html>");
            itersPanel.add(ParallelIterativeDeconvolution3D.this.itersField);
            ParallelIterativeDeconvolution3D.this.itersCheck = new JCheckBox("Show iterations");
            ParallelIterativeDeconvolution3D.this.itersCheck.setToolTipText("<html>Show restored image after each iteration.</html>");
            ParallelIterativeDeconvolution3D.this.itersCheck.setSelected(false);
            itersPanel.add(ParallelIterativeDeconvolution3D.this.itersCheck);
            JPanel threadsPanel = new JPanel();
            threadsPanel.setLayout(new FlowLayout(3));
            JLabel threadsLabel = new JLabel("Max number of threads (power of 2):  ");
            threadsPanel.add(threadsLabel);
            ConcurrencyUtils.setNumberOfThreads((int)ConcurrencyUtils.getNumberOfThreads());
            ParallelIterativeDeconvolution3D.this.threadsField = new JTextField(Integer.toString(ConcurrencyUtils.getNumberOfThreads()), 3);
            ParallelIterativeDeconvolution3D.this.threadsField.addActionListener(new ThreadsFieldActionListener());
            threadsPanel.add(ParallelIterativeDeconvolution3D.this.threadsField);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(4));
            ParallelIterativeDeconvolution3D.this.deconvolveButton = new JButton("Deconvolve");
            ParallelIterativeDeconvolution3D.this.deconvolveButton.addActionListener(new DeconvolveButtonActionListener());
            if (ParallelIterativeDeconvolution3D.this.windowIDs == null) {
                ParallelIterativeDeconvolution3D.this.deconvolveButton.setEnabled(false);
            }
            buttonPanel.add(ParallelIterativeDeconvolution3D.this.deconvolveButton);
            ParallelIterativeDeconvolution3D.this.cancelButton = new JButton("Cancel");
            ParallelIterativeDeconvolution3D.this.cancelButton.addActionListener(new CancelButtonActionListener());
            buttonPanel.add(ParallelIterativeDeconvolution3D.this.cancelButton);
            pane.add(blurPanel);
            pane.add(psfPanel);
            pane.add(methodPanel);
            pane.add(precondPanel);
            pane.add(boundaryPanel);
            pane.add(resizingPanel);
            pane.add(outputPanel);
            pane.add(precisionPanel);
            pane.add(itersPanel);
            pane.add(threadsPanel);
            pane.add(buttonPanel);
            this.validate();
            this.setDefaultCloseOperation(0);
            this.setResizable(false);
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }

        private boolean checkTextFields() {
            try {
                ParallelIterativeDeconvolution3D.this.maxIters = Integer.parseInt(ParallelIterativeDeconvolution3D.this.itersField.getText());
            }
            catch (Exception ex) {
                IJ.error((String)"Number of iterations must be a positive integer.");
                return false;
            }
            if (ParallelIterativeDeconvolution3D.this.maxIters < 1) {
                IJ.error((String)"Number of iterations must be a positive integer.");
                return false;
            }
            if (ParallelIterativeDeconvolution3D.this.precondCheck.isSelected()) {
                ParallelIterativeDeconvolution3D.this.precTol = -1.0;
            } else {
                try {
                    ParallelIterativeDeconvolution3D.this.precTol = Double.parseDouble(ParallelIterativeDeconvolution3D.this.precondField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Tolerance for preconditioner must be a number between 0 and 1.");
                    return false;
                }
                if (ParallelIterativeDeconvolution3D.this.precTol < 0.0 || ParallelIterativeDeconvolution3D.this.precTol > 1.0) {
                    IJ.error((String)"Tolerance for preconditioner must be a number between 0 and 1.");
                    return false;
                }
            }
            try {
                ParallelIterativeDeconvolution3D.this.threads = Integer.parseInt(ParallelIterativeDeconvolution3D.this.threadsField.getText());
            }
            catch (Exception ex) {
                IJ.error((String)"Number of threads must be power of 2.");
                return false;
            }
            if (ParallelIterativeDeconvolution3D.this.threads < 1) {
                IJ.error((String)"Number of threads must be power of 2.");
                return false;
            }
            if (!ConcurrencyUtils.isPowerOf2((int)ParallelIterativeDeconvolution3D.this.threads)) {
                IJ.error((String)"Number of threads must be power of 2.");
                return false;
            }
            ConcurrencyUtils.setNumberOfThreads((int)ParallelIterativeDeconvolution3D.this.threads);
            return true;
        }

        private class CancelButtonActionListener
        implements ActionListener {
            private CancelButtonActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                ParallelIterativeDeconvolution3D.this.mainPanel.dispose();
                ImagePlus.removeImageListener((ImageListener)ParallelIterativeDeconvolution3D.this.getImageListener());
                ParallelIterativeDeconvolution3D.this.clean_all();
                ConcurrencyUtils.shutdown();
            }
        }

        private class DefaultExceptionHandler
        implements Thread.UncaughtExceptionHandler {
            private DefaultExceptionHandler() {
            }

            public void uncaughtException(Thread t, Throwable e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter((Writer)sw, true);
                e.printStackTrace(pw);
                pw.flush();
                sw.flush();
                IJ.log((String)sw.toString());
                ParallelIterativeDeconvolution3D.this.mainPanel.dispose();
                ImagePlus.removeImageListener((ImageListener)ParallelIterativeDeconvolution3D.this.getImageListener());
                ParallelIterativeDeconvolution3D.this.clean_all();
            }
        }

        private class DeconvolveButtonActionListener
        implements ActionListener {
            private final Timer timer = new Timer();

            private DeconvolveButtonActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                Thread deconvolveThread = new Thread(new Runnable(){

                    public void run() {
                        ParallelIterativeDeconvolution3D.this.imB = WindowManager.getImage((String)((String)ParallelIterativeDeconvolution3D.this.blurChoice.getSelectedItem()));
                        if (ParallelIterativeDeconvolution3D.this.imB == null) {
                            int i;
                            IJ.error((String)("Image " + (String)ParallelIterativeDeconvolution3D.this.blurChoice.getSelectedItem() + " was renamed. Please choose the blurred image again."));
                            ParallelIterativeDeconvolution3D.access$8102(ParallelIterativeDeconvolution3D.this, WindowManager.getIDList());
                            if (ParallelIterativeDeconvolution3D.this.windowIDs != null) {
                                ParallelIterativeDeconvolution3D.access$8202(ParallelIterativeDeconvolution3D.this, new String[ParallelIterativeDeconvolution3D.this.windowIDs.length]);
                                for (i = 0; i < ParallelIterativeDeconvolution3D.this.windowIDs.length; ++i) {
                                    ImagePlus im = WindowManager.getImage((int)ParallelIterativeDeconvolution3D.this.windowIDs[i]);
                                    ((ParallelIterativeDeconvolution3D)ParallelIterativeDeconvolution3D.this).imageTitles[i] = im != null ? im.getTitle() : "";
                                }
                            }
                            ParallelIterativeDeconvolution3D.this.blurChoice.removeAllItems();
                            for (i = 0; i < ParallelIterativeDeconvolution3D.this.imageTitles.length; ++i) {
                                ParallelIterativeDeconvolution3D.this.blurChoice.addItem(ParallelIterativeDeconvolution3D.this.imageTitles[i]);
                            }
                            ParallelIterativeDeconvolution3D.this.blurChoice.revalidate();
                            return;
                        }
                        ImageProcessor ipB = ParallelIterativeDeconvolution3D.this.imB.getProcessor();
                        if (ipB instanceof ColorProcessor) {
                            IJ.showMessage((String)"RGB images are not currently supported.");
                            return;
                        }
                        if (ParallelIterativeDeconvolution3D.this.imB.getStackSize() == 1) {
                            IJ.showMessage((String)"For 2D images use Parallel Iterative Deconvolution 2D");
                            return;
                        }
                        if (!ParallelIterativeDeconvolution3D.this.variantPSFCheck.isSelected()) {
                            ParallelIterativeDeconvolution3D.access$7902(ParallelIterativeDeconvolution3D.this, new ImagePlus[1][1][1]);
                            ((ParallelIterativeDeconvolution3D)ParallelIterativeDeconvolution3D.this).imPSF[0][0][0] = WindowManager.getImage((String)((String)ParallelIterativeDeconvolution3D.this.psfChoice.getSelectedItem()));
                            if (ParallelIterativeDeconvolution3D.this.imPSF[0][0][0] == null) {
                                int i;
                                IJ.error((String)("Image " + (String)ParallelIterativeDeconvolution3D.this.psfChoice.getSelectedItem() + " was renamed. Please choose the blurred image again."));
                                ParallelIterativeDeconvolution3D.access$8102(ParallelIterativeDeconvolution3D.this, WindowManager.getIDList());
                                if (ParallelIterativeDeconvolution3D.this.windowIDs != null) {
                                    ParallelIterativeDeconvolution3D.access$8202(ParallelIterativeDeconvolution3D.this, new String[ParallelIterativeDeconvolution3D.this.windowIDs.length]);
                                    for (i = 0; i < ParallelIterativeDeconvolution3D.this.windowIDs.length; ++i) {
                                        ImagePlus im = WindowManager.getImage((int)ParallelIterativeDeconvolution3D.this.windowIDs[i]);
                                        ((ParallelIterativeDeconvolution3D)ParallelIterativeDeconvolution3D.this).imageTitles[i] = im != null ? im.getTitle() : "";
                                    }
                                }
                                ParallelIterativeDeconvolution3D.this.psfChoice.removeAllItems();
                                for (i = 0; i < ParallelIterativeDeconvolution3D.this.imageTitles.length; ++i) {
                                    ParallelIterativeDeconvolution3D.this.psfChoice.addItem(ParallelIterativeDeconvolution3D.this.imageTitles[i]);
                                }
                                ParallelIterativeDeconvolution3D.this.psfChoice.revalidate();
                                return;
                            }
                            ImageProcessor ipPSF = ParallelIterativeDeconvolution3D.this.imPSF[0][0][0].getProcessor();
                            if (ipPSF instanceof ColorProcessor) {
                                IJ.showMessage((String)"RGB images are not currently supported.");
                                return;
                            }
                            if (ParallelIterativeDeconvolution3D.this.imPSF[0][0][0].getStackSize() == 1) {
                                IJ.showMessage((String)"For 2D images use Parallel Iterative Deconvolution 2D.");
                                return;
                            }
                        }
                        if (!MainPanel.this.checkTextFields()) {
                            return;
                        }
                        MainPanel.this.setCursor(MainPanel.this.waitCursor);
                        ParallelIterativeDeconvolution3D.this.deconvolveButton.setEnabled(false);
                        ParallelIterativeDeconvolution3D.this.cancelButton.setEnabled(false);
                        IterativeEnums.MethodType selMethod = IterativeEnums.MethodType.values()[ParallelIterativeDeconvolution3D.this.methodChoice.getSelectedIndex()];
                        IterativeEnums.PreconditionerType selPrecond = IterativeEnums.PreconditionerType.values()[ParallelIterativeDeconvolution3D.this.precondChoice.getSelectedIndex()];
                        IterativeEnums.BoundaryType selBoundary = IterativeEnums.BoundaryType.values()[ParallelIterativeDeconvolution3D.this.boundaryChoice.getSelectedIndex()];
                        IterativeEnums.ResizingType selResizing = IterativeEnums.ResizingType.values()[ParallelIterativeDeconvolution3D.this.resizingChoice.getSelectedIndex()];
                        Enums.OutputType selOutput = Enums.OutputType.values()[ParallelIterativeDeconvolution3D.this.outputChoice.getSelectedIndex()];
                        Enums.PrecisionType selPrecision = Enums.PrecisionType.values()[ParallelIterativeDeconvolution3D.this.precisionChoice.getSelectedIndex()];
                        ParallelIterativeDeconvolution3D.this.clean_old_data();
                        DeconvolveButtonActionListener.this.timer.reset().start();
                        block0 : switch (selPrecision) {
                            case DOUBLE: {
                                switch (selMethod) {
                                    case CGLS: {
                                        ParallelIterativeDeconvolution3D.this.dcgls = new CGLSDoubleIterativeDeconvolver3D(ParallelIterativeDeconvolution3D.this.imB, ParallelIterativeDeconvolution3D.this.imPSF, selPrecond, ParallelIterativeDeconvolution3D.this.precTol, selBoundary, selResizing, selOutput, ParallelIterativeDeconvolution3D.this.maxIters, ParallelIterativeDeconvolution3D.this.itersCheck.isSelected(), ParallelIterativeDeconvolution3D.this.cglsOptions);
                                        ParallelIterativeDeconvolution3D.this.imX = ParallelIterativeDeconvolution3D.this.dcgls.deconvolve();
                                        if (selPrecond != IterativeEnums.PreconditionerType.NONE) {
                                            ParallelIterativeDeconvolution3D.this.precondField.setText(String.format("%.4f", ParallelIterativeDeconvolution3D.this.dcgls.getPreconditioner().getTolerance()));
                                        }
                                        ParallelIterativeDeconvolution3D.this.dcgls = null;
                                        DeconvolveButtonActionListener.this.timer.stop();
                                        break;
                                    }
                                    case MRNSD: {
                                        ParallelIterativeDeconvolution3D.this.dmrnsd = new MRNSDDoubleIterativeDeconvolver3D(ParallelIterativeDeconvolution3D.this.imB, ParallelIterativeDeconvolution3D.this.imPSF, selPrecond, ParallelIterativeDeconvolution3D.this.precTol, selBoundary, selResizing, selOutput, ParallelIterativeDeconvolution3D.this.maxIters, ParallelIterativeDeconvolution3D.this.itersCheck.isSelected(), ParallelIterativeDeconvolution3D.this.mrnsdOptions);
                                        ParallelIterativeDeconvolution3D.this.imX = ParallelIterativeDeconvolution3D.this.dmrnsd.deconvolve();
                                        if (selPrecond != IterativeEnums.PreconditionerType.NONE) {
                                            ParallelIterativeDeconvolution3D.this.precondField.setText(String.format("%.4f", ParallelIterativeDeconvolution3D.this.dmrnsd.getPreconditioner().getTolerance()));
                                        }
                                        ParallelIterativeDeconvolution3D.this.dmrnsd = null;
                                        DeconvolveButtonActionListener.this.timer.stop();
                                        break;
                                    }
                                    case HyBR: {
                                        ParallelIterativeDeconvolution3D.this.dhybr = new HyBRDoubleIterativeDeconvolver3D(ParallelIterativeDeconvolution3D.this.imB, ParallelIterativeDeconvolution3D.this.imPSF, selPrecond, ParallelIterativeDeconvolution3D.this.precTol, selBoundary, selResizing, selOutput, ParallelIterativeDeconvolution3D.this.maxIters, ParallelIterativeDeconvolution3D.this.itersCheck.isSelected(), ParallelIterativeDeconvolution3D.this.hybrOptions);
                                        ParallelIterativeDeconvolution3D.this.imX = ParallelIterativeDeconvolution3D.this.dhybr.deconvolve();
                                        if (selPrecond != IterativeEnums.PreconditionerType.NONE) {
                                            ParallelIterativeDeconvolution3D.this.precondField.setText(String.format("%.4f", ParallelIterativeDeconvolution3D.this.dhybr.getPreconditioner().getTolerance()));
                                        }
                                        ParallelIterativeDeconvolution3D.this.dhybr = null;
                                        DeconvolveButtonActionListener.this.timer.stop();
                                        break;
                                    }
                                    case WPL: {
                                        ParallelIterativeDeconvolution3D.this.dwpl = new WPLDoubleIterativeDeconvolver3D(ParallelIterativeDeconvolution3D.this.imB, ParallelIterativeDeconvolution3D.this.imPSF[0][0][0], selBoundary, selResizing, selOutput, ParallelIterativeDeconvolution3D.this.maxIters, ParallelIterativeDeconvolution3D.this.itersCheck.isSelected(), ParallelIterativeDeconvolution3D.this.wplOptions);
                                        ParallelIterativeDeconvolution3D.this.imX = ParallelIterativeDeconvolution3D.this.dwpl.deconvolve();
                                        ParallelIterativeDeconvolution3D.this.dwpl = null;
                                        DeconvolveButtonActionListener.this.timer.stop();
                                    }
                                }
                                break;
                            }
                            case SINGLE: {
                                switch (selMethod) {
                                    case CGLS: {
                                        ParallelIterativeDeconvolution3D.this.fcgls = new CGLSFloatIterativeDeconvolver3D(ParallelIterativeDeconvolution3D.this.imB, ParallelIterativeDeconvolution3D.this.imPSF, selPrecond, (float)ParallelIterativeDeconvolution3D.this.precTol, selBoundary, selResizing, selOutput, ParallelIterativeDeconvolution3D.this.maxIters, ParallelIterativeDeconvolution3D.this.itersCheck.isSelected(), ParallelIterativeDeconvolution3D.this.cglsOptions);
                                        ParallelIterativeDeconvolution3D.this.imX = ParallelIterativeDeconvolution3D.this.fcgls.deconvolve();
                                        if (selPrecond != IterativeEnums.PreconditionerType.NONE) {
                                            ParallelIterativeDeconvolution3D.this.precondField.setText(String.format("%.4f", Float.valueOf(ParallelIterativeDeconvolution3D.this.fcgls.getPreconditioner().getTolerance())));
                                        }
                                        ParallelIterativeDeconvolution3D.this.fcgls = null;
                                        DeconvolveButtonActionListener.this.timer.stop();
                                        break block0;
                                    }
                                    case MRNSD: {
                                        ParallelIterativeDeconvolution3D.this.fmrnsd = new MRNSDFloatIterativeDeconvolver3D(ParallelIterativeDeconvolution3D.this.imB, ParallelIterativeDeconvolution3D.this.imPSF, selPrecond, (float)ParallelIterativeDeconvolution3D.this.precTol, selBoundary, selResizing, selOutput, ParallelIterativeDeconvolution3D.this.maxIters, ParallelIterativeDeconvolution3D.this.itersCheck.isSelected(), ParallelIterativeDeconvolution3D.this.mrnsdOptions);
                                        ParallelIterativeDeconvolution3D.this.imX = ParallelIterativeDeconvolution3D.this.fmrnsd.deconvolve();
                                        if (selPrecond != IterativeEnums.PreconditionerType.NONE) {
                                            ParallelIterativeDeconvolution3D.this.precondField.setText(String.format("%.4f", Float.valueOf(ParallelIterativeDeconvolution3D.this.fmrnsd.getPreconditioner().getTolerance())));
                                        }
                                        ParallelIterativeDeconvolution3D.this.fmrnsd = null;
                                        DeconvolveButtonActionListener.this.timer.stop();
                                        break block0;
                                    }
                                    case HyBR: {
                                        ParallelIterativeDeconvolution3D.this.fhybr = new HyBRFloatIterativeDeconvolver3D(ParallelIterativeDeconvolution3D.this.imB, ParallelIterativeDeconvolution3D.this.imPSF, selPrecond, (float)ParallelIterativeDeconvolution3D.this.precTol, selBoundary, selResizing, selOutput, ParallelIterativeDeconvolution3D.this.maxIters, ParallelIterativeDeconvolution3D.this.itersCheck.isSelected(), ParallelIterativeDeconvolution3D.this.hybrOptions);
                                        ParallelIterativeDeconvolution3D.this.imX = ParallelIterativeDeconvolution3D.this.fhybr.deconvolve();
                                        if (selPrecond != IterativeEnums.PreconditionerType.NONE) {
                                            ParallelIterativeDeconvolution3D.this.precondField.setText(String.format("%.4f", Float.valueOf(ParallelIterativeDeconvolution3D.this.fhybr.getPreconditioner().getTolerance())));
                                        }
                                        ParallelIterativeDeconvolution3D.this.fhybr = null;
                                        DeconvolveButtonActionListener.this.timer.stop();
                                        break block0;
                                    }
                                    case WPL: {
                                        ParallelIterativeDeconvolution3D.this.fwpl = new WPLFloatIterativeDeconvolver3D(ParallelIterativeDeconvolution3D.this.imB, ParallelIterativeDeconvolution3D.this.imPSF[0][0][0], selBoundary, selResizing, selOutput, ParallelIterativeDeconvolution3D.this.maxIters, ParallelIterativeDeconvolution3D.this.itersCheck.isSelected(), ParallelIterativeDeconvolution3D.this.wplOptions);
                                        ParallelIterativeDeconvolution3D.this.imX = ParallelIterativeDeconvolution3D.this.fwpl.deconvolve();
                                        ParallelIterativeDeconvolution3D.this.fwpl = null;
                                        DeconvolveButtonActionListener.this.timer.stop();
                                    }
                                }
                            }
                        }
                        if (selPrecond != IterativeEnums.PreconditionerType.NONE) {
                            ParallelIterativeDeconvolution3D.this.imX.setTitle(WindowManager.makeUniqueName((String)(ParallelIterativeDeconvolution3D.this.imB.getShortTitle() + "_deblurred_" + shortMethodNames[ParallelIterativeDeconvolution3D.this.methodChoice.getSelectedIndex()] + "_" + shortPrecondNames[ParallelIterativeDeconvolution3D.this.precondChoice.getSelectedIndex()] + ParallelIterativeDeconvolution3D.this.precondField.getText() + "_" + shortBoundaryNames[ParallelIterativeDeconvolution3D.this.boundaryChoice.getSelectedIndex()])));
                        } else {
                            ParallelIterativeDeconvolution3D.this.imX.setTitle(WindowManager.makeUniqueName((String)(ParallelIterativeDeconvolution3D.this.imB.getShortTitle() + "_deblurred_" + shortMethodNames[ParallelIterativeDeconvolution3D.this.methodChoice.getSelectedIndex()] + "_none_" + shortBoundaryNames[ParallelIterativeDeconvolution3D.this.boundaryChoice.getSelectedIndex()])));
                        }
                        if (selMethod == IterativeEnums.MethodType.WPL) {
                            ParallelIterativeDeconvolution3D.this.imX.setTitle(WindowManager.makeUniqueName((String)(ParallelIterativeDeconvolution3D.this.imB.getShortTitle() + "_deblurred_" + shortMethodNames[ParallelIterativeDeconvolution3D.this.methodChoice.getSelectedIndex()] + "_" + shortBoundaryNames[ParallelIterativeDeconvolution3D.this.boundaryChoice.getSelectedIndex()])));
                        }
                        if (!ParallelIterativeDeconvolution3D.this.itersCheck.isSelected()) {
                            ParallelIterativeDeconvolution3D.this.imX.show();
                        } else {
                            ParallelIterativeDeconvolution3D.this.blurChoice.removeItem("(deblurred)");
                            ParallelIterativeDeconvolution3D.this.psfChoice.removeItem("(deblurred)");
                            ParallelIterativeDeconvolution3D.this.blurChoice.addItem(ParallelIterativeDeconvolution3D.this.imX.getTitle());
                            ParallelIterativeDeconvolution3D.this.psfChoice.addItem(ParallelIterativeDeconvolution3D.this.imX.getTitle());
                            ParallelIterativeDeconvolution3D.this.blurChoice.revalidate();
                            ParallelIterativeDeconvolution3D.this.psfChoice.revalidate();
                        }
                        IJ.showStatus((String)DeconvolveButtonActionListener.this.timer.toString());
                        MainPanel.this.setCursor(MainPanel.this.defaultCursor);
                        ParallelIterativeDeconvolution3D.this.deconvolveButton.setEnabled(true);
                        ParallelIterativeDeconvolution3D.this.cancelButton.setEnabled(true);
                    }
                });
                deconvolveThread.setUncaughtExceptionHandler(new DefaultExceptionHandler());
                deconvolveThread.start();
            }
        }

        private class EditPSFButtonActionListener
        implements ActionListener {
            private EditPSFButtonActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                ParallelIterativeDeconvolution3D.this.psfEditPanel.setVisible(true);
            }
        }

        private class DefinePSFButtonActionListener
        implements ActionListener {
            private DefinePSFButtonActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                ParallelIterativeDeconvolution3D.this.psfCreatePanel = new PSFCreatePanel("Create Spatially Variant PSF");
            }
        }

        private class PrecondFieldActionListener
        implements ActionListener {
            private PrecondFieldActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                if (ParallelIterativeDeconvolution3D.this.precondCheck.isSelected()) {
                    ParallelIterativeDeconvolution3D.this.precTol = -1.0;
                } else {
                    try {
                        ParallelIterativeDeconvolution3D.this.precTol = Double.parseDouble(ParallelIterativeDeconvolution3D.this.precondField.getText());
                    }
                    catch (Exception ex) {
                        IJ.error((String)"Tolerance for preconditioner must be a number between 0 and 1.");
                    }
                    if (ParallelIterativeDeconvolution3D.this.precTol < 0.0 || ParallelIterativeDeconvolution3D.this.precTol > 1.0) {
                        IJ.error((String)"Tolerance for preconditioner must be a number between 0 and 1.");
                    }
                }
            }
        }

        private class OptionsButtonActionListener
        implements ActionListener {
            private OptionsButtonActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                IterativeEnums.MethodType selMethod = IterativeEnums.MethodType.values()[ParallelIterativeDeconvolution3D.this.methodChoice.getSelectedIndex()];
                switch (selMethod) {
                    case CGLS: {
                        if (ParallelIterativeDeconvolution3D.this.cglsOptionsSet) {
                            ParallelIterativeDeconvolution3D.this.cglsOptionsPanel.setVisible(true);
                            break;
                        }
                        ParallelIterativeDeconvolution3D.this.cglsOptionsPanel = new CGLSOptionsPanel("CGLS options");
                        break;
                    }
                    case MRNSD: {
                        if (ParallelIterativeDeconvolution3D.this.mrnsdOptionsSet) {
                            ParallelIterativeDeconvolution3D.this.mrnsdOptionsPanel.setVisible(true);
                            break;
                        }
                        ParallelIterativeDeconvolution3D.this.mrnsdOptionsPanel = new MRNSDOptionsPanel("MRNSD options");
                        break;
                    }
                    case HyBR: {
                        if (ParallelIterativeDeconvolution3D.this.hybrOptionsSet) {
                            ParallelIterativeDeconvolution3D.this.hybrOptionsPanel.setVisible(true);
                            break;
                        }
                        ParallelIterativeDeconvolution3D.this.hybrOptionsPanel = new HyBROptionsPanel("HyBR options");
                        break;
                    }
                    case WPL: {
                        if (ParallelIterativeDeconvolution3D.this.wplOptionsSet) {
                            ParallelIterativeDeconvolution3D.this.wplOptionsFrame.setVisible(true);
                            break;
                        }
                        ParallelIterativeDeconvolution3D.this.wplOptionsFrame = new WPLOptionsPanel("WPL options");
                    }
                }
            }
        }

        private class PrecondCheckItemListener
        implements ItemListener {
            private PrecondCheckItemListener() {
            }

            public void itemStateChanged(ItemEvent e) {
                if (ParallelIterativeDeconvolution3D.this.precondCheck.isSelected()) {
                    ParallelIterativeDeconvolution3D.this.precondField.setEnabled(false);
                } else {
                    ParallelIterativeDeconvolution3D.this.precondField.setEnabled(true);
                }
            }
        }

        private class PSFCheckItemListener
        implements ItemListener {
            private PSFCheckItemListener() {
            }

            public void itemStateChanged(ItemEvent e) {
                if (ParallelIterativeDeconvolution3D.this.variantPSFCheck.isSelected()) {
                    ParallelIterativeDeconvolution3D.this.definePSFButton.setEnabled(true);
                    ParallelIterativeDeconvolution3D.this.editPSFButton.setEnabled(false);
                    ParallelIterativeDeconvolution3D.this.psfChoice.setEnabled(false);
                } else {
                    ParallelIterativeDeconvolution3D.this.definePSFButton.setEnabled(false);
                    ParallelIterativeDeconvolution3D.this.editPSFButton.setEnabled(false);
                    ParallelIterativeDeconvolution3D.this.psfChoice.setEnabled(true);
                }
            }
        }

        private class ThreadsFieldActionListener
        implements ActionListener {
            private ThreadsFieldActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    ParallelIterativeDeconvolution3D.this.threads = Integer.parseInt(ParallelIterativeDeconvolution3D.this.threadsField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Number of threads must be power of 2.");
                    return;
                }
                if (ParallelIterativeDeconvolution3D.this.threads < 1) {
                    IJ.error((String)"Number of threads must be power of 2.");
                    return;
                }
                if (!ConcurrencyUtils.isPowerOf2((int)ParallelIterativeDeconvolution3D.this.threads)) {
                    IJ.error((String)"Number of threads must be power of 2.");
                    return;
                }
                ConcurrencyUtils.setNumberOfThreads((int)ParallelIterativeDeconvolution3D.this.threads);
            }
        }

        private class ItersFieldActionListener
        implements ActionListener {
            private ItersFieldActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    ParallelIterativeDeconvolution3D.this.maxIters = Integer.parseInt(ParallelIterativeDeconvolution3D.this.itersField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Number of iterations must be a positive integer.");
                }
                if (ParallelIterativeDeconvolution3D.this.maxIters < 1) {
                    IJ.error((String)"Number of iterations must be a positive integer.");
                }
            }
        }

        private class PrecondChoiceActionListener
        implements ActionListener {
            private PrecondChoiceActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                IterativeEnums.PreconditionerType selPrecond = IterativeEnums.PreconditionerType.values()[ParallelIterativeDeconvolution3D.this.precondChoice.getSelectedIndex()];
                switch (selPrecond) {
                    case FFT: {
                        ParallelIterativeDeconvolution3D.this.precondCheck.setEnabled(true);
                        if (!ParallelIterativeDeconvolution3D.this.precondCheck.isSelected()) {
                            ParallelIterativeDeconvolution3D.this.precondField.setEnabled(true);
                            break;
                        }
                        ParallelIterativeDeconvolution3D.this.precondField.setEnabled(false);
                        break;
                    }
                    case NONE: {
                        ParallelIterativeDeconvolution3D.this.precondField.setEnabled(false);
                        ParallelIterativeDeconvolution3D.this.precondCheck.setEnabled(false);
                    }
                }
            }
        }

        private class MethodChoiceActionListener
        implements ActionListener {
            private MethodChoiceActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                IterativeEnums.MethodType selMethod = IterativeEnums.MethodType.values()[ParallelIterativeDeconvolution3D.this.methodChoice.getSelectedIndex()];
                if (selMethod == IterativeEnums.MethodType.WPL) {
                    ParallelIterativeDeconvolution3D.this.precondChoice.setEnabled(false);
                    ParallelIterativeDeconvolution3D.this.precondCheck.setEnabled(false);
                    ParallelIterativeDeconvolution3D.this.precondField.setEnabled(false);
                    ParallelIterativeDeconvolution3D.this.variantPSFCheck.setSelected(false);
                    ParallelIterativeDeconvolution3D.this.variantPSFCheck.setEnabled(false);
                    ParallelIterativeDeconvolution3D.this.definePSFButton.setEnabled(false);
                    ParallelIterativeDeconvolution3D.this.editPSFButton.setEnabled(false);
                } else {
                    ParallelIterativeDeconvolution3D.this.precondChoice.setEnabled(true);
                    ParallelIterativeDeconvolution3D.this.precondCheck.setEnabled(true);
                    if (!ParallelIterativeDeconvolution3D.this.precondCheck.isSelected()) {
                        ParallelIterativeDeconvolution3D.this.precondField.setEnabled(true);
                    }
                    ParallelIterativeDeconvolution3D.this.variantPSFCheck.setEnabled(true);
                }
            }
        }

        private class PsfChoiceActionListener
        implements ActionListener {
            private PsfChoiceActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                ParallelIterativeDeconvolution3D.access$8102(ParallelIterativeDeconvolution3D.this, WindowManager.getIDList());
                if (ParallelIterativeDeconvolution3D.this.windowIDs != null) {
                    ParallelIterativeDeconvolution3D.this.deconvolveButton.setEnabled(true);
                } else {
                    ParallelIterativeDeconvolution3D.this.deconvolveButton.setEnabled(false);
                }
            }
        }

        private class BlurChoiceActionListener
        implements ActionListener {
            private BlurChoiceActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                ParallelIterativeDeconvolution3D.access$8102(ParallelIterativeDeconvolution3D.this, WindowManager.getIDList());
                if (ParallelIterativeDeconvolution3D.this.windowIDs != null) {
                    ParallelIterativeDeconvolution3D.this.deconvolveButton.setEnabled(true);
                } else {
                    ParallelIterativeDeconvolution3D.this.deconvolveButton.setEnabled(false);
                }
            }
        }
    }

    private class PSFEditPanel
    extends JFrame {
        private static final long serialVersionUID = 11865121724333240L;
        private final Dimension totalSize;
        JButton[][][] buttons;
        JButton nextButton;
        JButton previousButton;
        JButton cancelButton;
        JPanel[] tablePanels;
        JPanel cards;
        CardLayout cl;
        int currentTablePanel;
        int counter;

        public PSFEditPanel(String name) {
            super(name);
            this.totalSize = new Dimension(350, 200);
            this.init();
        }

        private void init() {
            Container pane = this.getContentPane();
            pane.setLayout(new BorderLayout());
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout(new FlowLayout(3));
            JLabel label = new JLabel("Define all PSFs");
            labelPanel.add(label);
            pane.add((Component)labelPanel, "First");
            this.tablePanels = new JPanel[ParallelIterativeDeconvolution3D.this.psfSlices];
            this.cards = new JPanel(new CardLayout());
            this.counter = ParallelIterativeDeconvolution3D.this.psfRows * ParallelIterativeDeconvolution3D.this.psfColumns;
            this.buttons = new JButton[ParallelIterativeDeconvolution3D.this.psfSlices][ParallelIterativeDeconvolution3D.this.psfRows][ParallelIterativeDeconvolution3D.this.psfColumns];
            for (int s = 0; s < ParallelIterativeDeconvolution3D.this.psfSlices; ++s) {
                this.tablePanels[s] = new JPanel();
                this.tablePanels[s].setLayout(new GridLayout(ParallelIterativeDeconvolution3D.this.psfRows, ParallelIterativeDeconvolution3D.this.psfColumns));
                for (int r = 0; r < ParallelIterativeDeconvolution3D.this.psfRows; ++r) {
                    for (int c = 0; c < ParallelIterativeDeconvolution3D.this.psfColumns; ++c) {
                        this.buttons[s][r][c] = new JButton("Null");
                        this.buttons[s][r][c].setToolTipText("Null");
                        this.buttons[s][r][c].addActionListener(new PSFButtonsActionListener());
                        this.buttons[s][r][c].setHorizontalAlignment(2);
                        this.tablePanels[s].add(this.buttons[s][r][c]);
                    }
                }
                this.cards.add((Component)this.tablePanels[s], new Integer(s).toString());
            }
            this.cl = (CardLayout)this.cards.getLayout();
            this.cl.show(this.cards, new Integer(0).toString());
            this.currentTablePanel = 0;
            pane.add((Component)this.cards, "Center");
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(4));
            if (ParallelIterativeDeconvolution3D.this.psfSlices == 1) {
                this.nextButton = new JButton("Finish");
                this.nextButton.setEnabled(false);
                this.nextButton.addActionListener(new FinishButtonActionListener());
                this.cancelButton = new JButton("Cancel");
                this.cancelButton.addActionListener(new CancelButtonActionListener());
                buttonPanel.add(this.nextButton);
                buttonPanel.add(this.cancelButton);
            } else {
                this.previousButton = new JButton("< Previous");
                this.previousButton.setEnabled(false);
                this.previousButton.addActionListener(new PreviousButtonActionListener());
                this.nextButton = new JButton("Next >");
                this.nextButton.setEnabled(false);
                this.nextButton.addActionListener(new NextButtonActionListener());
                this.cancelButton = new JButton("Cancel");
                this.cancelButton.addActionListener(new CancelButtonActionListener());
                buttonPanel.add(this.previousButton);
                buttonPanel.add(this.nextButton);
                buttonPanel.add(this.cancelButton);
            }
            pane.add((Component)buttonPanel, "Last");
            this.validate();
            this.setDefaultCloseOperation(0);
            this.setResizable(true);
            this.setSize(this.totalSize);
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }

        private class CancelButtonActionListener
        implements ActionListener {
            private CancelButtonActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                ParallelIterativeDeconvolution3D.this.psfEditPanel.setVisible(false);
            }
        }

        private class FinishButtonActionListener
        implements ActionListener {
            private FinishButtonActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                ParallelIterativeDeconvolution3D.access$7902(ParallelIterativeDeconvolution3D.this, new ImagePlus[ParallelIterativeDeconvolution3D.this.psfSlices][ParallelIterativeDeconvolution3D.this.psfRows][ParallelIterativeDeconvolution3D.this.psfColumns]);
                Opener o = new Opener();
                for (int s = 0; s < ParallelIterativeDeconvolution3D.this.psfSlices; ++s) {
                    for (int r = 0; r < ParallelIterativeDeconvolution3D.this.psfRows; ++r) {
                        for (int c = 0; c < ParallelIterativeDeconvolution3D.this.psfColumns; ++c) {
                            ((ParallelIterativeDeconvolution3D)ParallelIterativeDeconvolution3D.this).imPSF[s][r][c] = o.openImage(PSFEditPanel.this.buttons[s][r][c].getText());
                            ImageProcessor ipPSF = ParallelIterativeDeconvolution3D.this.imPSF[s][r][c].getProcessor();
                            if (ipPSF instanceof ColorProcessor) {
                                IJ.showMessage((String)"RGB images are not currently supported.");
                                return;
                            }
                            if (ParallelIterativeDeconvolution3D.this.imPSF[s][r][c].getStackSize() != 1) continue;
                            IJ.showMessage((String)"For 2D images use Parallel Iterative Deconvolution 2D");
                            return;
                        }
                    }
                }
                ParallelIterativeDeconvolution3D.this.psfEditPanel.setVisible(false);
                ParallelIterativeDeconvolution3D.this.editPSFButton.setEnabled(true);
            }
        }

        private class PreviousButtonActionListener
        implements ActionListener {
            private PreviousButtonActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                --PSFEditPanel.this.currentTablePanel;
                PSFEditPanel.this.cl.show(PSFEditPanel.this.cards, new Integer(PSFEditPanel.this.currentTablePanel).toString());
                if (PSFEditPanel.this.currentTablePanel == 0) {
                    PSFEditPanel.this.previousButton.setEnabled(false);
                }
                if (PSFEditPanel.this.currentTablePanel == ParallelIterativeDeconvolution3D.this.psfSlices - 2) {
                    PSFEditPanel.this.nextButton.removeActionListener(PSFEditPanel.this.nextButton.getActionListeners()[0]);
                    PSFEditPanel.this.nextButton.addActionListener(new NextButtonActionListener());
                    PSFEditPanel.this.nextButton.setText("Next >");
                }
            }
        }

        private class NextButtonActionListener
        implements ActionListener {
            private NextButtonActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                ++PSFEditPanel.this.currentTablePanel;
                PSFEditPanel.this.cl.show(PSFEditPanel.this.cards, new Integer(PSFEditPanel.this.currentTablePanel).toString());
                PSFEditPanel.this.previousButton.setEnabled(true);
                if (PSFEditPanel.this.currentTablePanel == ParallelIterativeDeconvolution3D.this.psfSlices - 1) {
                    PSFEditPanel.this.nextButton.removeActionListener(PSFEditPanel.this.nextButton.getActionListeners()[0]);
                    PSFEditPanel.this.nextButton.addActionListener(new FinishButtonActionListener());
                    PSFEditPanel.this.nextButton.setText("Finish");
                }
            }
        }

        private class PSFButtonsActionListener
        implements ActionListener {
            private PSFButtonsActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                OpenDialog od = new OpenDialog("Open file", "");
                String directory = od.getDirectory();
                String name = od.getFileName();
                if (name != null) {
                    String path = directory + name;
                    ((JButton)e.getSource()).setText(path);
                    ((JButton)e.getSource()).setToolTipText(path);
                    --PSFEditPanel.this.counter;
                    if (PSFEditPanel.this.counter == 0) {
                        PSFEditPanel.this.nextButton.setEnabled(true);
                    }
                }
            }
        }
    }

    private class PSFCreatePanel
    extends JFrame {
        private static final long serialVersionUID = -4018857998511946590L;
        public JTextField slicesField;
        public JTextField rowsField;
        public JTextField columnsField;

        public PSFCreatePanel(String name) {
            super(name);
            this.init();
        }

        private void init() {
            Container pane = this.getContentPane();
            pane.setLayout(new BoxLayout(pane, 1));
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout(new FlowLayout(3));
            JLabel label = new JLabel("Enter the number of PSFs in the form of 3D matrix (slices x rows x columns)");
            labelPanel.add(label);
            pane.add(labelPanel);
            JPanel textPanel = new JPanel();
            textPanel.setLayout(new FlowLayout(1));
            this.slicesField = new JTextField("2", 3);
            JLabel times1 = new JLabel(" x ");
            this.rowsField = new JTextField("2", 3);
            JLabel times2 = new JLabel(" x ");
            this.columnsField = new JTextField("2", 3);
            textPanel.add(this.slicesField);
            textPanel.add(times1);
            textPanel.add(this.rowsField);
            textPanel.add(times2);
            textPanel.add(this.columnsField);
            pane.add(textPanel);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(4));
            JButton okButton = new JButton("OK");
            okButton.addActionListener(new OkButtonActionListener());
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new CancelButtonActionListener());
            buttonPanel.add(okButton);
            buttonPanel.add(cancelButton);
            pane.add(buttonPanel);
            this.validate();
            this.setDefaultCloseOperation(0);
            this.setResizable(false);
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }

        private boolean checkTextFields() {
            boolean moreThanOne = false;
            try {
                ParallelIterativeDeconvolution3D.this.psfSlices = Integer.parseInt(this.slicesField.getText());
            }
            catch (Exception ex) {
                IJ.error((String)"Number of slices must be a positive integer number.");
                return false;
            }
            if (ParallelIterativeDeconvolution3D.this.psfSlices < 1) {
                IJ.error((String)"Number of slices must be a positive integer number.");
                return false;
            }
            if (ParallelIterativeDeconvolution3D.this.psfSlices > 1) {
                moreThanOne = true;
            }
            try {
                ParallelIterativeDeconvolution3D.this.psfRows = Integer.parseInt(this.rowsField.getText());
            }
            catch (Exception ex) {
                IJ.error((String)"Number of rows must be a positive integer number.");
                return false;
            }
            if (ParallelIterativeDeconvolution3D.this.psfRows < 1) {
                IJ.error((String)"Number of rows must be a positive integer number.");
                return false;
            }
            if (ParallelIterativeDeconvolution3D.this.psfRows > 1) {
                moreThanOne = true;
            }
            try {
                ParallelIterativeDeconvolution3D.this.psfColumns = Integer.parseInt(this.columnsField.getText());
            }
            catch (Exception ex) {
                IJ.error((String)"Number of columns must be a positive integer number.");
                return false;
            }
            if (ParallelIterativeDeconvolution3D.this.psfColumns < 1) {
                IJ.error((String)"Number of columns must be a positive integer number.");
                return false;
            }
            if (ParallelIterativeDeconvolution3D.this.psfColumns > 1) {
                moreThanOne = true;
            }
            if (!moreThanOne) {
                IJ.error((String)"The size of at least one dimension must be greater than 1");
                return false;
            }
            return true;
        }

        private class CancelButtonActionListener
        implements ActionListener {
            private CancelButtonActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                ParallelIterativeDeconvolution3D.this.psfCreatePanel.dispose();
            }
        }

        private class OkButtonActionListener
        implements ActionListener {
            private OkButtonActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                if (PSFCreatePanel.this.checkTextFields()) {
                    ParallelIterativeDeconvolution3D.this.psfCreatePanel.dispose();
                    ParallelIterativeDeconvolution3D.this.psfEditPanel = new PSFEditPanel("Edit Spatially Variant PSF");
                }
            }
        }
    }

    private class WPLOptionsPanel
    extends JFrame {
        private static final long serialVersionUID = 1L;
        private JTextField gammaField;
        private JTextField filterXYfield;
        private JTextField filterZfield;
        private JTextField changeThreshPercentField;
        private JTextField thresholdField;
        private JCheckBox normalizeCheck;
        private JCheckBox logMeanCheck;
        private JCheckBox antiRingCheck;
        private JCheckBox dbCheck;
        private JCheckBox detectDivergenceCheck;
        private JCheckBox thresholdCheck;

        public WPLOptionsPanel(String name) {
            super(name);
            this.init();
        }

        private void init() {
            Container pane = this.getContentPane();
            pane.setLayout(new BoxLayout(pane, 1));
            JPanel normalizePanel = new JPanel();
            normalizePanel.setLayout(new FlowLayout(3));
            this.normalizeCheck = new JCheckBox("Normalize PSF");
            this.normalizeCheck.setSelected(true);
            normalizePanel.add(this.normalizeCheck);
            this.add(normalizePanel);
            JPanel logMeanPanel = new JPanel();
            logMeanPanel.setLayout(new FlowLayout(3));
            this.logMeanCheck = new JCheckBox("Log mean pixel value to track convergence");
            this.logMeanCheck.setSelected(false);
            logMeanPanel.add(this.logMeanCheck);
            pane.add(logMeanPanel);
            JPanel antiRingPanel = new JPanel();
            antiRingPanel.setLayout(new FlowLayout(3));
            this.antiRingCheck = new JCheckBox("Perform anti-ringing step");
            this.antiRingCheck.setSelected(true);
            antiRingPanel.add(this.antiRingCheck);
            pane.add(antiRingPanel);
            JPanel detectDivergencePanel = new JPanel();
            detectDivergencePanel.setLayout(new FlowLayout(3));
            this.detectDivergenceCheck = new JCheckBox("Detect divergence");
            this.detectDivergenceCheck.setSelected(true);
            detectDivergencePanel.add(this.detectDivergenceCheck);
            pane.add(detectDivergencePanel);
            JPanel dbPanel = new JPanel();
            dbPanel.setLayout(new FlowLayout(3));
            this.dbCheck = new JCheckBox("Data (image, psf and result) in dB");
            this.dbCheck.setSelected(false);
            dbPanel.add(this.dbCheck);
            pane.add(dbPanel);
            JPanel thresholdPanel = new JPanel();
            thresholdPanel.setLayout(new FlowLayout(3));
            this.thresholdCheck = new JCheckBox("Threshold:  ");
            this.thresholdCheck.setSelected(false);
            this.thresholdCheck.addItemListener(new ThresholdCheckItemListener());
            thresholdPanel.add(this.thresholdCheck);
            this.thresholdField = new JTextField("0.0", 6);
            this.thresholdField.setEnabled(false);
            this.thresholdField.addActionListener(new ThresholdFieldActionListener());
            thresholdPanel.add(this.thresholdField);
            pane.add(thresholdPanel);
            JPanel gammaPanel = new JPanel();
            gammaPanel.setLayout(new FlowLayout(3));
            JLabel gammaLabel = new JLabel("Wiener filter gamma (suggest 0 [<.0001] to turn off, 0.0001-0.1 as tests)");
            gammaPanel.add(gammaLabel);
            this.gammaField = new JTextField("0.0", 6);
            this.gammaField.addActionListener(new GammaFieldActionListener());
            gammaPanel.add(this.gammaField);
            pane.add(gammaPanel);
            JPanel filterXYPanel = new JPanel();
            filterXYPanel.setLayout(new FlowLayout(3));
            JLabel filterXYlabel = new JLabel("Low pass filter x and y, pixels (suggest 1, 0 to turn off)");
            filterXYlabel.setPreferredSize(gammaLabel.getPreferredSize());
            filterXYPanel.add(filterXYlabel);
            this.filterXYfield = new JTextField("1", 6);
            this.filterXYfield.addActionListener(new FilterXYFieldActionListener());
            filterXYPanel.add(this.filterXYfield);
            pane.add(filterXYPanel);
            JPanel filterZPanel = new JPanel();
            filterZPanel.setLayout(new FlowLayout(3));
            JLabel filterZlabel = new JLabel("Low pass filter z, pixels (suggest 1, 0 to turn off)");
            filterZlabel.setPreferredSize(gammaLabel.getPreferredSize());
            filterZPanel.add(filterZlabel);
            this.filterZfield = new JTextField("1", 6);
            this.filterZfield.addActionListener(new FilterZFieldActionListener());
            filterZPanel.add(this.filterZfield);
            pane.add(filterZPanel);
            JPanel changeThreshPercentPanel = new JPanel();
            changeThreshPercentPanel.setLayout(new FlowLayout(3));
            JLabel changeThreshPercentLabel = new JLabel("Terminate iteration if mean delta < x% (suggest 0.01, 0 to turn off)");
            changeThreshPercentLabel.setPreferredSize(gammaLabel.getPreferredSize());
            changeThreshPercentPanel.add(changeThreshPercentLabel);
            this.changeThreshPercentField = new JTextField("0.01", 6);
            this.changeThreshPercentField.addActionListener(new ChangeThreshPercentFieldActionListener());
            changeThreshPercentPanel.add(this.changeThreshPercentField);
            this.add(changeThreshPercentPanel);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(4));
            JButton okButton = new JButton("OK");
            okButton.addActionListener(new OkButtonActionListener());
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new CancelButtonActionListener());
            buttonPanel.add(okButton);
            buttonPanel.add(cancelButton);
            pane.add(buttonPanel);
            this.validate();
            this.setDefaultCloseOperation(0);
            this.setResizable(false);
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }

        private boolean assignOptions(WPLOptions wplOptions) {
            double gamma = 0.0;
            try {
                gamma = Double.parseDouble(this.gammaField.getText());
            }
            catch (Exception ex) {
                IJ.error((String)"Gamma must be a nonnegative value.");
                return false;
            }
            if (gamma < 0.0) {
                IJ.error((String)"Gamma must be a nonnegative value.");
                return false;
            }
            double filterXY = 0.0;
            try {
                filterXY = Double.parseDouble(this.filterXYfield.getText());
            }
            catch (Exception ex) {
                IJ.error((String)"Filter x and y must be a nonnegative value.");
                return false;
            }
            if (filterXY < 0.0) {
                IJ.error((String)"Filter x and y must be a nonnegative value.");
                return false;
            }
            double filterZ = 0.0;
            try {
                filterZ = Double.parseDouble(this.filterZfield.getText());
            }
            catch (Exception ex) {
                IJ.error((String)"Filter z must be a nonnegative value.");
                return false;
            }
            if (filterZ < 0.0) {
                IJ.error((String)"Filter z must be a nonnegative value.");
                return false;
            }
            double changeThreshPercent = 0.0;
            try {
                changeThreshPercent = Double.parseDouble(this.changeThreshPercentField.getText());
            }
            catch (Exception ex) {
                IJ.error((String)"Mean delta must be a nonnegative value.");
                return false;
            }
            if (changeThreshPercent < 0.0) {
                IJ.error((String)"Mean delta must be a nonnegative value.");
                return false;
            }
            double threshold = 0.0;
            if (this.thresholdCheck.isSelected()) {
                try {
                    threshold = Double.parseDouble(this.thresholdField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Threshold must be a nonnegative value.");
                    return false;
                }
                if (threshold < 0.0) {
                    IJ.error((String)"Threshold must be a nonnegative value.");
                    return false;
                }
            }
            wplOptions.setAntiRing(this.antiRingCheck.isSelected());
            wplOptions.setChangeThreshPercent(changeThreshPercent);
            wplOptions.setDB(this.dbCheck.isSelected());
            wplOptions.setDetectDivergence(this.detectDivergenceCheck.isSelected());
            wplOptions.setFilterXY(filterXY);
            wplOptions.setFilterXY(filterZ);
            wplOptions.setGamma(gamma);
            wplOptions.setLogConvergence(this.logMeanCheck.isSelected());
            wplOptions.setNormalize(this.normalizeCheck.isSelected());
            wplOptions.setThreshold(threshold);
            wplOptions.setUseThreshold(this.thresholdCheck.isSelected());
            return true;
        }

        private class CancelButtonActionListener
        implements ActionListener {
            private CancelButtonActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                ParallelIterativeDeconvolution3D.this.wplOptionsFrame.dispose();
                ParallelIterativeDeconvolution3D.this.wplOptionsSet = false;
            }
        }

        private class OkButtonActionListener
        implements ActionListener {
            private OkButtonActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                if (WPLOptionsPanel.this.assignOptions(ParallelIterativeDeconvolution3D.this.wplOptions)) {
                    ParallelIterativeDeconvolution3D.this.wplOptionsFrame.setVisible(false);
                    ParallelIterativeDeconvolution3D.this.wplOptionsSet = true;
                }
            }
        }

        private class ThresholdCheckItemListener
        implements ItemListener {
            private ThresholdCheckItemListener() {
            }

            public void itemStateChanged(ItemEvent e) {
                if (WPLOptionsPanel.this.thresholdCheck.isSelected()) {
                    WPLOptionsPanel.this.thresholdField.setEnabled(true);
                } else {
                    WPLOptionsPanel.this.thresholdField.setEnabled(false);
                }
            }
        }

        private class ChangeThreshPercentFieldActionListener
        implements ActionListener {
            private ChangeThreshPercentFieldActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                double changeThreshPercent = 0.0;
                try {
                    changeThreshPercent = Double.parseDouble(WPLOptionsPanel.this.changeThreshPercentField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Mean delta must be a nonnegative value.");
                }
                if (changeThreshPercent < 0.0) {
                    IJ.error((String)"Mean delta must be a nonnegative value.");
                }
            }
        }

        private class FilterZFieldActionListener
        implements ActionListener {
            private FilterZFieldActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                double filterZ = 0.0;
                try {
                    filterZ = Double.parseDouble(WPLOptionsPanel.this.filterZfield.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Filter z must be a nonnegative value.");
                }
                if (filterZ < 0.0) {
                    IJ.error((String)"Filter x must be a nonnegative value.");
                }
            }
        }

        private class FilterXYFieldActionListener
        implements ActionListener {
            private FilterXYFieldActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                double filterXY = 0.0;
                try {
                    filterXY = Double.parseDouble(WPLOptionsPanel.this.filterXYfield.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Filter x and y must be a nonnegative value.");
                }
                if (filterXY < 0.0) {
                    IJ.error((String)"Filter x and y must be a nonnegative value.");
                }
            }
        }

        private class GammaFieldActionListener
        implements ActionListener {
            private GammaFieldActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                double gamma = 0.0;
                try {
                    gamma = Double.parseDouble(WPLOptionsPanel.this.gammaField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Gamma must be a nonnegative value.");
                }
                if (gamma < 0.0) {
                    IJ.error((String)"Gamma must be a nonnegative value.");
                }
            }
        }

        private class ThresholdFieldActionListener
        implements ActionListener {
            private ThresholdFieldActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                double threshold = 0.0;
                try {
                    threshold = Double.parseDouble(WPLOptionsPanel.this.thresholdField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Threshold must be a nonnegative value.");
                }
                if (threshold < 0.0) {
                    IJ.error((String)"Threshold must be a nonnegative value.");
                }
            }
        }
    }

    private class HyBROptionsPanel
    extends JFrame {
        private static final long serialVersionUID = 1L;
        private JComboBox solverChoice;
        private JComboBox regChoice;
        private JTextField regField;
        private JTextField begRegField;
        private JTextField omegaField;
        private JTextField flatTolField;
        private JTextField thresholdField;
        private JCheckBox reorthCheck;
        private JCheckBox thresholdCheck;
        private JCheckBox logConvergenceCheck;
        private final String[] innerSolverNames;
        private final String[] regMethodNames;

        public HyBROptionsPanel(String name) {
            super(name);
            this.innerSolverNames = new String[]{"Tikhonov", "None"};
            this.regMethodNames = new String[]{"GCV", "WGCV", "Adaptive WGCV", "None"};
            this.init();
        }

        private void init() {
            Container pane = this.getContentPane();
            pane.setLayout(new BoxLayout(pane, 1));
            JPanel regPanel = new JPanel();
            regPanel.setLayout(new BoxLayout(regPanel, 1));
            TitledBorder border = new TitledBorder(null, "Regularization options", 1, 2);
            regPanel.setBorder(border);
            JPanel regPanelFirstLine = new JPanel();
            regPanelFirstLine.setLayout(new FlowLayout(3));
            JLabel regMethodLabel = new JLabel("Method:");
            regPanelFirstLine.add(regMethodLabel);
            this.regChoice = new JComboBox<String>(this.regMethodNames);
            this.regChoice.setSelectedIndex(ParallelIterativeDeconvolution3D.this.hybrOptions.getRegMethod().ordinal());
            this.regChoice.setAlignmentX(0.0f);
            this.regChoice.addActionListener(new RegMethodChoiceActionListener());
            this.regChoice.setToolTipText("<html>Choose a method for computing a regularization parameter:<br><ul><li>GCV - Generalized Cross-Validation</li><li>WGCV - Weighted Generalized Cross-Validation</li><li>Adaptive WGCV - Adaptive Weighted Generalized Cross-Validation</li><li>None - no method for choosing regularization parameter.<br> You have to enter your own value.</li></ul></html>");
            regPanelFirstLine.add(this.regChoice);
            JLabel regParamLabel = new JLabel("Parameter:");
            regPanelFirstLine.add(regParamLabel);
            this.regField = new JTextField(new Double(ParallelIterativeDeconvolution3D.this.hybrOptions.getRegParameter()).toString(), 5);
            this.regField.setToolTipText("<html>Regularization parameter</html>");
            this.regField.setEnabled(false);
            this.regField.addActionListener(new RegFieldActionListener());
            regPanelFirstLine.add(this.regField);
            regPanel.add(regPanelFirstLine);
            JPanel regPanelThirdLine = new JPanel();
            regPanelThirdLine.setLayout(new FlowLayout(3));
            JLabel omegaLabel = new JLabel("Omega:");
            regPanelThirdLine.add(omegaLabel);
            this.omegaField = new JTextField(new Double(ParallelIterativeDeconvolution3D.this.hybrOptions.getOmega()).toString(), 5);
            this.omegaField.setToolTipText("<html>Omega parameter</html>");
            this.omegaField.setEnabled(false);
            this.omegaField.addActionListener(new OmegaFieldActionListener());
            regPanelThirdLine.add(this.omegaField);
            regPanel.add(regPanelThirdLine);
            JPanel regPanelForthLine = new JPanel();
            regPanelForthLine.setLayout(new FlowLayout(3));
            JLabel begRegLabel = new JLabel("Begin regularization after this iteration:");
            regPanelForthLine.add(begRegLabel);
            this.begRegField = new JTextField(new Integer(ParallelIterativeDeconvolution3D.this.hybrOptions.getBeginReg()).toString(), 2);
            this.begRegField.addActionListener(new BegRegFieldActionListener());
            regPanelForthLine.add(this.begRegField);
            regPanel.add(regPanelForthLine);
            pane.add(regPanel);
            JPanel solverPanel = new JPanel();
            solverPanel.setLayout(new FlowLayout(3));
            JLabel solverLabel = new JLabel("Inner solver:");
            solverPanel.add(solverLabel);
            this.solverChoice = new JComboBox<String>(this.innerSolverNames);
            this.solverChoice.setSelectedIndex(ParallelIterativeDeconvolution3D.this.hybrOptions.getInnerSolver().ordinal());
            this.solverChoice.setAlignmentX(0.0f);
            solverPanel.add(this.solverChoice);
            pane.add(solverPanel);
            JPanel flatTolPanel = new JPanel();
            flatTolPanel.setLayout(new FlowLayout(3));
            JLabel flatTolLabel = new JLabel("Stopping tolerance:");
            flatTolPanel.add(flatTolLabel);
            this.flatTolField = new JTextField(new Double(ParallelIterativeDeconvolution3D.this.hybrOptions.getFlatTolerance()).toString(), 5);
            this.flatTolField.setToolTipText("<html>Tolerance for detecting flatness in <br>the GCV curve as a stopping criteria</html>");
            this.flatTolField.addActionListener(new FlatTolFieldActionListener());
            flatTolPanel.add(this.flatTolField);
            pane.add(flatTolPanel);
            JPanel reorthPanel = new JPanel();
            reorthPanel.setLayout(new FlowLayout(3));
            this.reorthCheck = new JCheckBox("Reorthogonalize Lanczos subspaces");
            this.reorthCheck.setSelected(ParallelIterativeDeconvolution3D.this.hybrOptions.getReorthogonalize());
            reorthPanel.add(this.reorthCheck);
            this.add(reorthPanel);
            JPanel thresholdPanel = new JPanel();
            thresholdPanel.setLayout(new FlowLayout(3));
            this.thresholdCheck = new JCheckBox("Threshold:  ");
            this.thresholdCheck.setSelected(ParallelIterativeDeconvolution3D.this.hybrOptions.getUseThreshold());
            this.thresholdCheck.addItemListener(new ThresholdCheckItemListener());
            thresholdPanel.add(this.thresholdCheck);
            this.thresholdField = new JTextField(new Double(ParallelIterativeDeconvolution3D.this.hybrOptions.getThreshold()).toString(), 6);
            this.thresholdField.setEnabled(ParallelIterativeDeconvolution3D.this.hybrOptions.getUseThreshold());
            this.thresholdField.addActionListener(new ThresholdFieldActionListener());
            thresholdPanel.add(this.thresholdField);
            pane.add(thresholdPanel);
            JPanel logConvergencePanel = new JPanel();
            logConvergencePanel.setLayout(new FlowLayout(3));
            this.logConvergenceCheck = new JCheckBox("Log convergence");
            this.logConvergenceCheck.setSelected(ParallelIterativeDeconvolution3D.this.hybrOptions.getLogConvergence());
            logConvergencePanel.add(this.logConvergenceCheck);
            this.add(logConvergencePanel);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(4));
            JButton okButton = new JButton("OK");
            okButton.addActionListener(new OkButtonActionListener());
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new CancelButtonActionListener());
            buttonPanel.add(okButton);
            buttonPanel.add(cancelButton);
            pane.add(buttonPanel);
            this.validate();
            this.setDefaultCloseOperation(0);
            this.setResizable(false);
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }

        private boolean assignOptions(HyBROptions hybrOptions) {
            int beginReg;
            double omega;
            double flatTolerance;
            double regParam;
            try {
                regParam = Double.parseDouble(this.regField.getText());
            }
            catch (Exception ex) {
                IJ.error((String)"Regularization parameter must be a floating-point number between 0 and 1.");
                return false;
            }
            if (regParam < 0.0 || regParam > 1.0) {
                IJ.error((String)"Regularization parameter must be a floating-point number between 0 and 1.");
                return false;
            }
            try {
                flatTolerance = Double.parseDouble(this.flatTolField.getText());
            }
            catch (Exception ex) {
                IJ.error((String)"GCV tolerance must be a nonnegative floating-point number.");
                return false;
            }
            if (flatTolerance < 0.0) {
                IJ.error((String)"GCV tolerance must be a nonnegative floating-point number.");
                return false;
            }
            try {
                omega = Double.parseDouble(this.omegaField.getText());
            }
            catch (Exception ex) {
                IJ.error((String)"Omega must be a nonnegative floating-point number.");
                return false;
            }
            if (omega < 0.0) {
                IJ.error((String)"Omega must be a nonnegative floating-point number.");
                return false;
            }
            try {
                beginReg = Integer.parseInt(this.begRegField.getText());
            }
            catch (Exception ex) {
                IJ.error((String)"Iteration number must be an integer number greater than 1.");
                return false;
            }
            if (beginReg <= 1) {
                IJ.error((String)"Iteration number must be an integer number greater than 1.");
                return false;
            }
            double threshold = 0.0;
            if (this.thresholdCheck.isSelected()) {
                try {
                    threshold = Double.parseDouble(this.thresholdField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Threshold must be a nonnegative value.");
                    return false;
                }
                if (threshold < 0.0) {
                    IJ.error((String)"Threshold must be a nonnegative value.");
                    return false;
                }
            }
            hybrOptions.setInnerSolver(HyBRInnerSolver.values()[this.solverChoice.getSelectedIndex()]);
            hybrOptions.setRegMethod(HyBRRegularizationMethod.values()[this.regChoice.getSelectedIndex()]);
            hybrOptions.setRegParameter(regParam);
            hybrOptions.setOmega(omega);
            hybrOptions.setReorthogonalize(this.reorthCheck.isSelected());
            hybrOptions.setBeginReg(beginReg);
            hybrOptions.setFlatTolerance(flatTolerance);
            hybrOptions.setLogConvergence(this.logConvergenceCheck.isSelected());
            hybrOptions.setUseThreashold(this.thresholdCheck.isSelected());
            hybrOptions.setThreashold(threshold);
            return true;
        }

        private class CancelButtonActionListener
        implements ActionListener {
            private CancelButtonActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                ParallelIterativeDeconvolution3D.this.hybrOptionsPanel.dispose();
                ParallelIterativeDeconvolution3D.this.hybrOptionsSet = false;
            }
        }

        private class OkButtonActionListener
        implements ActionListener {
            private OkButtonActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                if (HyBROptionsPanel.this.assignOptions(ParallelIterativeDeconvolution3D.this.hybrOptions)) {
                    ParallelIterativeDeconvolution3D.this.hybrOptionsPanel.setVisible(false);
                    ParallelIterativeDeconvolution3D.this.hybrOptionsSet = true;
                }
            }
        }

        private class BegRegFieldActionListener
        implements ActionListener {
            private BegRegFieldActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                double begReg = 0.0;
                try {
                    begReg = Integer.parseInt(HyBROptionsPanel.this.begRegField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Iteration number must be an integer number greater than 1.");
                }
                if (begReg <= 1.0) {
                    IJ.error((String)"Iteration number must be an integer number greater than 1.");
                }
            }
        }

        private class RegFieldActionListener
        implements ActionListener {
            private RegFieldActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                double regParam = 0.0;
                try {
                    regParam = Double.parseDouble(HyBROptionsPanel.this.regField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Regularization parameter must be a floating-point number between 0 and 1.");
                }
                if (regParam < 0.0 || regParam > 1.0) {
                    IJ.error((String)"Regularization parameter must be a floating-point number between 0 and 1.");
                }
            }
        }

        private class RegMethodChoiceActionListener
        implements ActionListener {
            private RegMethodChoiceActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                if (HyBROptionsPanel.this.regChoice.getSelectedIndex() == 1) {
                    HyBROptionsPanel.this.omegaField.setEnabled(true);
                } else {
                    HyBROptionsPanel.this.omegaField.setEnabled(false);
                }
                if (HyBROptionsPanel.this.regChoice.getSelectedIndex() == 3) {
                    HyBROptionsPanel.this.regField.setEnabled(true);
                    HyBROptionsPanel.this.flatTolField.setEnabled(false);
                } else {
                    HyBROptionsPanel.this.regField.setEnabled(false);
                    HyBROptionsPanel.this.flatTolField.setEnabled(true);
                }
            }
        }

        private class FlatTolFieldActionListener
        implements ActionListener {
            private FlatTolFieldActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                double flatGCVTol = 0.0;
                try {
                    flatGCVTol = Double.parseDouble(HyBROptionsPanel.this.flatTolField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"GCV tolerance must be a positive floating-point number.");
                }
                if (flatGCVTol <= 0.0) {
                    IJ.error((String)"Omega must be a positive floating-point number.");
                }
            }
        }

        private class OmegaFieldActionListener
        implements ActionListener {
            private OmegaFieldActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                double omega = 0.0;
                try {
                    omega = Double.parseDouble(HyBROptionsPanel.this.omegaField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Omega must be a nonnegative floating-point number.");
                }
                if (omega < 0.0) {
                    IJ.error((String)"Omega must be a nonnegative floating-point number.");
                }
            }
        }

        private class ThresholdCheckItemListener
        implements ItemListener {
            private ThresholdCheckItemListener() {
            }

            public void itemStateChanged(ItemEvent e) {
                if (HyBROptionsPanel.this.thresholdCheck.isSelected()) {
                    HyBROptionsPanel.this.thresholdField.setEnabled(true);
                } else {
                    HyBROptionsPanel.this.thresholdField.setEnabled(false);
                }
            }
        }

        private class ThresholdFieldActionListener
        implements ActionListener {
            private ThresholdFieldActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                double threshold = 0.0;
                try {
                    threshold = Double.parseDouble(HyBROptionsPanel.this.thresholdField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Threshold must be a nonnegative value.");
                }
                if (threshold < 0.0) {
                    IJ.error((String)"Threshold must be a nonnegative value.");
                }
            }
        }
    }

    private class CGLSOptionsPanel
    extends JFrame {
        private static final long serialVersionUID = -8230645552596239730L;
        private JTextField stoppingTolField;
        private JTextField thresholdField;
        private JCheckBox stoppingTolCheck;
        private JCheckBox thresholdCheck;
        private JCheckBox logConvergenceCheck;

        public CGLSOptionsPanel(String name) {
            super(name);
            this.init();
        }

        private void init() {
            Container pane = this.getContentPane();
            pane.setLayout(new BoxLayout(pane, 1));
            JPanel stoppingTolPanel = new JPanel();
            stoppingTolPanel.setLayout(new FlowLayout(3));
            JLabel stoppingTolLabel = new JLabel("Stopping tolerance:");
            stoppingTolPanel.add(stoppingTolLabel);
            this.stoppingTolField = new JTextField(new Double(ParallelIterativeDeconvolution3D.this.cglsOptions.getStoppingTol()).toString(), 5);
            this.stoppingTolField.addActionListener(new StoppingTolFieldActionListener());
            this.stoppingTolField.setEnabled(false);
            stoppingTolPanel.add(this.stoppingTolField);
            this.stoppingTolCheck = new JCheckBox("Auto");
            this.stoppingTolCheck.addItemListener(new StoppingTolCheckItemListener());
            this.stoppingTolCheck.setSelected(ParallelIterativeDeconvolution3D.this.cglsOptions.getAutoStoppingTol());
            stoppingTolPanel.add(this.stoppingTolCheck);
            pane.add(stoppingTolPanel);
            JPanel thresholdPanel = new JPanel();
            thresholdPanel.setLayout(new FlowLayout(3));
            this.thresholdCheck = new JCheckBox("Threshold:  ");
            this.thresholdCheck.setSelected(ParallelIterativeDeconvolution3D.this.cglsOptions.getUseThreshold());
            this.thresholdCheck.addItemListener(new ThresholdCheckItemListener());
            thresholdPanel.add(this.thresholdCheck);
            this.thresholdField = new JTextField(new Double(ParallelIterativeDeconvolution3D.this.cglsOptions.getThreshold()).toString(), 6);
            this.thresholdField.setEnabled(ParallelIterativeDeconvolution3D.this.cglsOptions.getUseThreshold());
            this.thresholdField.addActionListener(new ThresholdFieldActionListener());
            thresholdPanel.add(this.thresholdField);
            pane.add(thresholdPanel);
            JPanel logConvergencePanel = new JPanel();
            logConvergencePanel.setLayout(new FlowLayout(3));
            this.logConvergenceCheck = new JCheckBox("Log convergence");
            this.logConvergenceCheck.setSelected(ParallelIterativeDeconvolution3D.this.cglsOptions.getLogConvergence());
            logConvergencePanel.add(this.logConvergenceCheck);
            this.add(logConvergencePanel);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(4));
            JButton okButton = new JButton("OK");
            okButton.addActionListener(new OkButtonActionListener());
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new CancelButtonActionListener());
            buttonPanel.add(okButton);
            buttonPanel.add(cancelButton);
            pane.add(buttonPanel);
            this.validate();
            this.validate();
            this.setDefaultCloseOperation(0);
            this.setResizable(false);
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }

        private boolean assignOptions(CGLSOptions cglsOptions) {
            double stoppingTol = 0.0;
            if (!this.stoppingTolCheck.isSelected()) {
                try {
                    stoppingTol = Double.parseDouble(this.stoppingTolField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Stopping tolerance must be a nonnegative floating-point number.");
                    return false;
                }
                if (stoppingTol < 0.0) {
                    IJ.error((String)"Stopping tolerance must be a nonnegative floating-point number.");
                    return false;
                }
            }
            double threshold = 0.0;
            if (!this.thresholdCheck.isSelected()) {
                try {
                    threshold = Double.parseDouble(this.thresholdField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Threshold must be a nonnegative value.");
                    return false;
                }
                if (threshold < 0.0) {
                    IJ.error((String)"Threshold must be a nonnegative value.");
                    return false;
                }
            }
            cglsOptions.setAutoStoppingTol(this.stoppingTolCheck.isSelected());
            cglsOptions.setStoppingTol(stoppingTol);
            cglsOptions.setUseThreshold(this.thresholdCheck.isSelected());
            cglsOptions.setThreshold(threshold);
            cglsOptions.setLogConvergence(this.logConvergenceCheck.isSelected());
            return true;
        }

        private class CancelButtonActionListener
        implements ActionListener {
            private CancelButtonActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                ParallelIterativeDeconvolution3D.this.cglsOptionsPanel.dispose();
                ParallelIterativeDeconvolution3D.this.cglsOptionsSet = false;
            }
        }

        private class OkButtonActionListener
        implements ActionListener {
            private OkButtonActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                if (CGLSOptionsPanel.this.assignOptions(ParallelIterativeDeconvolution3D.this.cglsOptions)) {
                    ParallelIterativeDeconvolution3D.this.cglsOptionsPanel.setVisible(false);
                    ParallelIterativeDeconvolution3D.this.cglsOptionsSet = true;
                }
            }
        }

        private class ThresholdFieldActionListener
        implements ActionListener {
            private ThresholdFieldActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                double threshold = 0.0;
                try {
                    threshold = Double.parseDouble(CGLSOptionsPanel.this.thresholdField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Threshold must be a nonnegative value.");
                }
                if (threshold < 0.0) {
                    IJ.error((String)"Threshold must be a nonnegative value.");
                }
            }
        }

        private class StoppingTolFieldActionListener
        implements ActionListener {
            private StoppingTolFieldActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                double stoppingTol = 0.0;
                try {
                    stoppingTol = Double.parseDouble(CGLSOptionsPanel.this.stoppingTolField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Stopping tolerance must be a nonnegative floating-point number.");
                }
                if (stoppingTol < 0.0) {
                    IJ.error((String)"Stopping tolerance must be a nonnegative floating-point number.");
                }
            }
        }

        private class StoppingTolCheckItemListener
        implements ItemListener {
            private StoppingTolCheckItemListener() {
            }

            public void itemStateChanged(ItemEvent e) {
                if (CGLSOptionsPanel.this.stoppingTolCheck.isSelected()) {
                    CGLSOptionsPanel.this.stoppingTolField.setEnabled(false);
                } else {
                    CGLSOptionsPanel.this.stoppingTolField.setEnabled(true);
                }
            }
        }

        private class ThresholdCheckItemListener
        implements ItemListener {
            private ThresholdCheckItemListener() {
            }

            public void itemStateChanged(ItemEvent e) {
                if (CGLSOptionsPanel.this.thresholdCheck.isSelected()) {
                    CGLSOptionsPanel.this.thresholdField.setEnabled(true);
                } else {
                    CGLSOptionsPanel.this.thresholdField.setEnabled(false);
                }
            }
        }
    }

    private class MRNSDOptionsPanel
    extends JFrame {
        private static final long serialVersionUID = -8230645552596239730L;
        private JTextField stoppingTolField;
        private JTextField thresholdField;
        private JCheckBox stoppingTolCheck;
        private JCheckBox thresholdCheck;
        private JCheckBox logConvergenceCheck;

        public MRNSDOptionsPanel(String name) {
            super(name);
            this.init();
        }

        private void init() {
            Container pane = this.getContentPane();
            pane.setLayout(new BoxLayout(pane, 1));
            JPanel stoppingTolPanel = new JPanel();
            stoppingTolPanel.setLayout(new FlowLayout(3));
            JLabel stoppingTolLabel = new JLabel("Stopping tolerance:");
            stoppingTolPanel.add(stoppingTolLabel);
            this.stoppingTolField = new JTextField(new Double(ParallelIterativeDeconvolution3D.this.mrnsdOptions.getStoppingTol()).toString(), 5);
            this.stoppingTolField.addActionListener(new StoppingTolFieldActionListener());
            this.stoppingTolField.setEnabled(false);
            stoppingTolPanel.add(this.stoppingTolField);
            this.stoppingTolCheck = new JCheckBox("Auto");
            this.stoppingTolCheck.addItemListener(new StoppingTolCheckItemListener());
            this.stoppingTolCheck.setSelected(ParallelIterativeDeconvolution3D.this.mrnsdOptions.getAutoStoppingTol());
            stoppingTolPanel.add(this.stoppingTolCheck);
            pane.add(stoppingTolPanel);
            JPanel thresholdPanel = new JPanel();
            thresholdPanel.setLayout(new FlowLayout(3));
            this.thresholdCheck = new JCheckBox("Threshold:  ");
            this.thresholdCheck.setSelected(ParallelIterativeDeconvolution3D.this.mrnsdOptions.getUseThreshold());
            this.thresholdCheck.addItemListener(new ThresholdCheckItemListener());
            thresholdPanel.add(this.thresholdCheck);
            this.thresholdField = new JTextField(new Double(ParallelIterativeDeconvolution3D.this.mrnsdOptions.getThreshold()).toString(), 6);
            this.thresholdField.setEnabled(ParallelIterativeDeconvolution3D.this.mrnsdOptions.getUseThreshold());
            this.thresholdField.addActionListener(new ThresholdFieldActionListener());
            thresholdPanel.add(this.thresholdField);
            pane.add(thresholdPanel);
            JPanel logConvergencePanel = new JPanel();
            logConvergencePanel.setLayout(new FlowLayout(3));
            this.logConvergenceCheck = new JCheckBox("Log convergence");
            this.logConvergenceCheck.setSelected(ParallelIterativeDeconvolution3D.this.mrnsdOptions.getLogConvergence());
            logConvergencePanel.add(this.logConvergenceCheck);
            pane.add(logConvergencePanel);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(4));
            JButton okButton = new JButton("OK");
            okButton.addActionListener(new OkButtonActionListener());
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new CancelButtonActionListener());
            buttonPanel.add(okButton);
            buttonPanel.add(cancelButton);
            pane.add(buttonPanel);
            this.validate();
            this.setDefaultCloseOperation(0);
            this.setResizable(false);
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }

        private boolean assignOptions(MRNSDOptions mrnsdOptions) {
            double stoppingTol = 0.0;
            if (!this.stoppingTolCheck.isSelected()) {
                try {
                    stoppingTol = Double.parseDouble(this.stoppingTolField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Stopping tolerance must be a nonnegative floating-point number.");
                    return false;
                }
                if (stoppingTol < 0.0) {
                    IJ.error((String)"Stopping tolerance must be a nonnegative floating-point number.");
                    return false;
                }
            }
            double threshold = 0.0;
            if (!this.thresholdCheck.isSelected()) {
                try {
                    threshold = Double.parseDouble(this.thresholdField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Threshold must be a nonnegative value.");
                    return false;
                }
                if (threshold < 0.0) {
                    IJ.error((String)"Threshold must be a nonnegative value.");
                    return false;
                }
            }
            mrnsdOptions.setAutoStoppingTol(this.stoppingTolCheck.isSelected());
            mrnsdOptions.setStoppingTol(stoppingTol);
            mrnsdOptions.setUseThreshold(this.thresholdCheck.isSelected());
            mrnsdOptions.setThreshold(threshold);
            mrnsdOptions.setLogConvergence(this.logConvergenceCheck.isSelected());
            return true;
        }

        private class CancelButtonActionListener
        implements ActionListener {
            private CancelButtonActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                ParallelIterativeDeconvolution3D.this.mrnsdOptionsPanel.dispose();
                ParallelIterativeDeconvolution3D.this.mrnsdOptionsSet = false;
            }
        }

        private class OkButtonActionListener
        implements ActionListener {
            private OkButtonActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                if (MRNSDOptionsPanel.this.assignOptions(ParallelIterativeDeconvolution3D.this.mrnsdOptions)) {
                    ParallelIterativeDeconvolution3D.this.mrnsdOptionsPanel.setVisible(false);
                    ParallelIterativeDeconvolution3D.this.mrnsdOptionsSet = true;
                }
            }
        }

        private class ThresholdFieldActionListener
        implements ActionListener {
            private ThresholdFieldActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                double threshold = 0.0;
                try {
                    threshold = Double.parseDouble(MRNSDOptionsPanel.this.thresholdField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Threshold must be a nonnegative value.");
                }
                if (threshold < 0.0) {
                    IJ.error((String)"Threshold must be a nonnegative value.");
                }
            }
        }

        private class StoppingTolFieldActionListener
        implements ActionListener {
            private StoppingTolFieldActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                double stoppingTol = 0.0;
                try {
                    stoppingTol = Double.parseDouble(MRNSDOptionsPanel.this.stoppingTolField.getText());
                }
                catch (Exception ex) {
                    IJ.error((String)"Stopping tolerance must be a nonnegative floating-point number.");
                }
                if (stoppingTol < 0.0) {
                    IJ.error((String)"Stopping tolerance must be a nonnegative floating-point number.");
                }
            }
        }

        private class StoppingTolCheckItemListener
        implements ItemListener {
            private StoppingTolCheckItemListener() {
            }

            public void itemStateChanged(ItemEvent e) {
                if (MRNSDOptionsPanel.this.stoppingTolCheck.isSelected()) {
                    MRNSDOptionsPanel.this.stoppingTolField.setEnabled(false);
                } else {
                    MRNSDOptionsPanel.this.stoppingTolField.setEnabled(true);
                }
            }
        }

        private class ThresholdCheckItemListener
        implements ItemListener {
            private ThresholdCheckItemListener() {
            }

            public void itemStateChanged(ItemEvent e) {
                if (MRNSDOptionsPanel.this.thresholdCheck.isSelected()) {
                    MRNSDOptionsPanel.this.thresholdField.setEnabled(true);
                } else {
                    MRNSDOptionsPanel.this.thresholdField.setEnabled(false);
                }
            }
        }
    }
}

