/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative.hybr;

import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleSingularValueDecomposition;
import cern.colt.matrix.tdouble.algo.solver.HyBRInnerSolver;
import cern.colt.matrix.tdouble.algo.solver.HyBRRegularizationMethod;
import cern.colt.matrix.tdouble.impl.DenseColumnDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.stat.tdouble.DoubleDescriptive;
import edu.emory.mathcs.restoretools.Enums;
import edu.emory.mathcs.restoretools.iterative.AbstractDoubleIterativeDeconvolver2D;
import edu.emory.mathcs.restoretools.iterative.DoubleCommon2D;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.restoretools.iterative.hybr.HyBROptions;
import edu.emory.mathcs.restoretools.iterative.preconditioner.DoublePreconditioner2D;
import edu.emory.mathcs.restoretools.iterative.psf.DoublePSFMatrix2D;
import ij.IJ;
import ij.ImagePlus;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import optimization.DoubleFmin;
import optimization.DoubleFmin_methods;

public class HyBRDoubleIterativeDeconvolver2D
extends AbstractDoubleIterativeDeconvolver2D {
    private HyBRInnerSolver innerSolver;
    private HyBRRegularizationMethod regMethod;
    private double regParam;
    private double omega;
    private boolean reorth;
    private int begReg;
    private double flatTol;

    public HyBRDoubleIterativeDeconvolver2D(ImagePlus imB, ImagePlus[][] imPSF, IterativeEnums.PreconditionerType preconditioner, double preconditionerTol, IterativeEnums.BoundaryType boundary, IterativeEnums.ResizingType resizing, Enums.OutputType output, int maxIters, boolean showIteration, HyBROptions options) {
        super("HyBR", imB, imPSF, preconditioner, preconditionerTol, boundary, resizing, output, options.getUseThreshold(), options.getThreshold(), maxIters, showIteration, options.getLogConvergence());
        this.innerSolver = options.getInnerSolver();
        this.regMethod = options.getRegMethod();
        this.regParam = options.getRegParameter();
        this.omega = options.getOmega();
        this.reorth = options.getReorthogonalize();
        this.begReg = options.getBeginReg();
        this.flatTol = options.getFlatTolerance();
    }

    public ImagePlus deconvolve() {
        int k;
        DoubleMatrix1D work;
        DoubleLBD lbd;
        double beta;
        int columns = this.A.getSize()[1];
        boolean bump = false;
        boolean warning = false;
        double rnrm = -1.0;
        int iterationsSave = 0;
        HyBRInnerSolver inSolver = HyBRInnerSolver.NONE;
        DoubleMatrix1D f = null;
        DoubleMatrix1D x = null;
        DoubleMatrix1D xSave = null;
        DoubleArrayList omegaList = new DoubleArrayList(new double[this.begReg - 2]);
        DoubleArrayList GCV = new DoubleArrayList(new double[this.begReg - 2]);
        DenseDoubleMatrix1D b = new DenseDoubleMatrix1D((int)this.B.size(), (double[])this.B.elements(), 0, 1, false);
        DenseDoubleMatrix2D U = new DenseDoubleMatrix2D(1, (int)this.B.size());
        DoubleMatrix2D C = null;
        DoubleMatrix2D V = null;
        if (this.P == null) {
            beta = alg.norm2((DoubleMatrix1D)b);
            U.viewRow(0).assign((DoubleMatrix1D)b, DoubleFunctions.multSecond((double)(1.0 / beta)));
            lbd = new DoubleSimpleLBD(this.A, (DoubleMatrix2D)U, this.reorth);
        } else {
            work = this.P.solve((DoubleMatrix1D)b, false);
            beta = alg.norm2(work);
            U.viewRow(0).assign(work, DoubleFunctions.multSecond((double)(1.0 / beta)));
            lbd = new DoublePLBD(this.P, this.A, (DoubleMatrix2D)U, this.reorth);
        }
        ImagePlus imX = null;
        FloatProcessor ip = new FloatProcessor(this.bColumns, this.bRows);
        if (this.showIteration) {
            DoubleCommon2D.assignPixelsToProcessor(ip, this.B, this.cmY);
            imX = new ImagePlus("(deblurred)", (ImageProcessor)ip);
            imX.show();
            IJ.showStatus((String)"HyBR initialization...");
        }
        for (k = 0; k <= this.maxIters; ++k) {
            lbd.apply();
            U = lbd.getU();
            C = lbd.getC();
            V = lbd.getV();
            DenseDoubleMatrix1D v = new DenseDoubleMatrix1D(C.columns() + 1);
            v.setQuick(0, beta);
            if (k < 1) continue;
            IJ.showStatus((String)("HyBR iteration: " + k + "/" + this.maxIters));
            if (k >= this.begReg - 1) {
                inSolver = this.innerSolver;
            }
            switch (inSolver) {
                case TIKHONOV: {
                    DenseDoubleSingularValueDecomposition svd = alg.svd(C);
                    DoubleMatrix2D Ub = svd.getU();
                    double[] sv = svd.getSingularValues();
                    DoubleMatrix2D Vb = svd.getV();
                    if (this.regMethod == HyBRRegularizationMethod.ADAPTWGCV) {
                        work = new DenseDoubleMatrix1D(Ub.rows());
                        Ub.zMult((DoubleMatrix1D)v, work, 1.0, 0.0, true);
                        omegaList.add(Math.min(1.0, this.findOmega(work, sv)));
                        this.omega = DoubleDescriptive.mean((DoubleArrayList)omegaList);
                    }
                    f = new DenseDoubleMatrix1D(Vb.rows());
                    double alpha = this.tikhonovSolver(Ub, sv, Vb, (DoubleMatrix1D)v, f);
                    GCV.add(HyBRDoubleIterativeDeconvolver2D.GCVstopfun(alpha, Ub.viewRow(0), sv, beta, columns));
                    if (k <= 1) break;
                    if (Math.abs(GCV.getQuick(k - 1) - GCV.getQuick(k - 2)) / GCV.get(this.begReg - 2) < this.flatTol) {
                        x = V.zMult(f, null);
                        if (this.useThreshold) {
                            DoubleCommon2D.assignPixelsToProcessor(ip, x, this.cmY, this.threshold);
                        } else {
                            DoubleCommon2D.assignPixelsToProcessor(ip, x, this.cmY);
                        }
                        if (this.logConvergence) {
                            work = this.A.times(x, false);
                            rnrm = alg.norm2(work.assign((DoubleMatrix1D)b, DoubleFunctions.minus));
                            IJ.log((String)(k + ".  Norm of the residual = " + rnrm));
                            IJ.log((String)("HyBR stopped after " + k + " iterations."));
                            IJ.log((String)"Reason for stopping: flat GCV curve.");
                        }
                        if (!this.showIteration) {
                            imX = new ImagePlus("(deblurred)", (ImageProcessor)ip);
                        } else {
                            imX.updateAndDraw();
                        }
                        DoubleCommon2D.convertImage(imX, this.output);
                        return imX;
                    }
                    if (warning && GCV.size() > iterationsSave + 3) {
                        for (int j = iterationsSave; j < GCV.size(); ++j) {
                            if (!(GCV.getQuick(iterationsSave - 1) > GCV.get(j))) continue;
                            bump = true;
                        }
                        if (!bump) {
                            x.assign(xSave);
                            if (this.useThreshold) {
                                DoubleCommon2D.assignPixelsToProcessor(ip, x, this.cmY, this.threshold);
                            } else {
                                DoubleCommon2D.assignPixelsToProcessor(ip, x, this.cmY);
                            }
                            if (this.logConvergence) {
                                work = this.A.times(x, false);
                                rnrm = alg.norm2(work.assign((DoubleMatrix1D)b, DoubleFunctions.minus));
                                IJ.log((String)("HyBR stopped after " + iterationsSave + " iterations."));
                                IJ.log((String)"Reason for stopping: min of GCV curve within window of 4 iterations.");
                            }
                            if (!this.showIteration) {
                                imX = new ImagePlus("(deblurred)", (ImageProcessor)ip);
                            } else {
                                imX.updateAndDraw();
                            }
                            DoubleCommon2D.convertImage(imX, this.output);
                            return imX;
                        }
                        bump = false;
                        warning = false;
                        iterationsSave = this.maxIters;
                        break;
                    }
                    if (warning || !(GCV.get(k - 2) < GCV.get(k - 1))) break;
                    warning = true;
                    xSave = V.zMult(f, null);
                    iterationsSave = k;
                    break;
                }
                case NONE: {
                    f = alg.solve(C, (DoubleMatrix1D)v);
                }
            }
            x = V.zMult(f, null);
            if (this.logConvergence) {
                work = this.A.times(x, false);
                rnrm = alg.norm2(work.assign((DoubleMatrix1D)b, DoubleFunctions.minus));
                IJ.log((String)(k + ".  Norm of the residual = " + rnrm));
            }
            if (!this.showIteration) continue;
            if (this.useThreshold) {
                DoubleCommon2D.assignPixelsToProcessor(ip, x, this.cmY, this.threshold);
            } else {
                DoubleCommon2D.assignPixelsToProcessor(ip, x, this.cmY);
            }
            imX.updateAndDraw();
        }
        if (this.logConvergence && k == this.maxIters + 1) {
            IJ.log((String)"HyBR didn't converge. Reason: maximum number of iterations performed.");
        }
        if (!this.showIteration) {
            if (this.useThreshold) {
                DoubleCommon2D.assignPixelsToProcessor(ip, x, this.cmY, this.threshold);
            } else {
                DoubleCommon2D.assignPixelsToProcessor(ip, x, this.cmY);
            }
            imX = new ImagePlus("(deblurred)", (ImageProcessor)ip);
        }
        DoubleCommon2D.convertImage(imX, this.output);
        return imX;
    }

    private double findOmega(DoubleMatrix1D bhat, double[] s) {
        int m = (int)bhat.size();
        int n = s.length;
        double alpha = s[n - 1];
        double t0 = bhat.viewPart(n, m - n).aggregate(DoubleFunctions.plus, DoubleFunctions.square);
        DenseDoubleMatrix1D s2 = new DenseDoubleMatrix1D(s);
        s2.assign(DoubleFunctions.square);
        double alpha2 = alpha * alpha;
        DoubleMatrix1D tt = s2.copy();
        tt.assign(DoubleFunctions.plus((double)alpha2));
        tt.assign(DoubleFunctions.inv);
        double t1 = s2.aggregate(tt, DoubleFunctions.plus, DoubleFunctions.mult);
        s2 = new DenseDoubleMatrix1D(s);
        s2.assign(DoubleFunctions.mult((double)alpha));
        s2.assign(bhat.viewPart(0, n), DoubleFunctions.mult);
        s2.assign(DoubleFunctions.square);
        DoubleMatrix1D work = tt.copy();
        work.assign(DoubleFunctions.pow((double)3.0));
        work.assign(DoubleFunctions.abs);
        double t3 = work.aggregate((DoubleMatrix1D)s2, DoubleFunctions.plus, DoubleFunctions.mult);
        work = new DenseDoubleMatrix1D(s);
        work.assign(tt, DoubleFunctions.mult);
        double t4 = work.aggregate(DoubleFunctions.plus, DoubleFunctions.square);
        work = tt.copy();
        work.assign(bhat.viewPart(0, n), DoubleFunctions.mult);
        work.assign(DoubleFunctions.mult((double)alpha2));
        double t5 = work.aggregate(DoubleFunctions.plus, DoubleFunctions.square);
        s2 = new DenseDoubleMatrix1D(s);
        s2.assign(bhat.viewPart(0, n), DoubleFunctions.mult);
        s2.assign(DoubleFunctions.square);
        tt.assign(DoubleFunctions.pow((double)3.0));
        tt.assign(DoubleFunctions.abs);
        double v2 = tt.aggregate((DoubleMatrix1D)s2, DoubleFunctions.plus, DoubleFunctions.mult);
        return (double)m * alpha2 * v2 / (t1 * t3 + t4 * (t5 + t0));
    }

    private double tikhonovSolver(DoubleMatrix2D U, double[] s, DoubleMatrix2D V, DoubleMatrix1D b, DoubleMatrix1D x) {
        DenseDoubleMatrix1D bhat = new DenseDoubleMatrix1D(U.rows());
        U.zMult(b, (DoubleMatrix1D)bhat, 1.0, 0.0, true);
        double alpha = 0.0;
        switch (this.regMethod) {
            case GCV: {
                TikFmin fmin = new TikFmin((DoubleMatrix1D)bhat, s, 1.0);
                alpha = DoubleFmin.fmin((double)0.0, (double)1.0, (DoubleFmin_methods)fmin, (double)1.0E-4);
                break;
            }
            case WGCV: {
                TikFmin fmin = new TikFmin((DoubleMatrix1D)bhat, s, this.omega);
                alpha = DoubleFmin.fmin((double)0.0, (double)1.0, (DoubleFmin_methods)fmin, (double)1.0E-4);
                break;
            }
            case ADAPTWGCV: {
                TikFmin fmin = new TikFmin((DoubleMatrix1D)bhat, s, this.omega);
                alpha = DoubleFmin.fmin((double)0.0, (double)1.0, (DoubleFmin_methods)fmin, (double)1.0E-4);
                break;
            }
            case NONE: {
                alpha = this.regParam;
            }
        }
        DenseDoubleMatrix1D d = new DenseDoubleMatrix1D(s);
        d.assign(DoubleFunctions.square);
        d.assign(DoubleFunctions.plus((double)(alpha * alpha)));
        bhat = bhat.viewPart(0, s.length);
        DenseDoubleMatrix1D S = new DenseDoubleMatrix1D(s);
        bhat.assign((DoubleMatrix1D)S, DoubleFunctions.mult);
        bhat.assign((DoubleMatrix1D)d, DoubleFunctions.div);
        V.zMult((DoubleMatrix1D)bhat, x);
        return alpha;
    }

    private static double GCVstopfun(double alpha, DoubleMatrix1D u, double[] s, double beta, int n) {
        int k = s.length;
        double beta2 = beta * beta;
        DenseDoubleMatrix1D s2 = new DenseDoubleMatrix1D(s);
        s2.assign(DoubleFunctions.square);
        double alpha2 = alpha * alpha;
        DoubleMatrix1D t1 = s2.copy();
        t1.assign(DoubleFunctions.plus((double)alpha2));
        t1.assign(DoubleFunctions.inv);
        DoubleMatrix1D t2 = t1.copy();
        t2.assign(u.viewPart(0, k), DoubleFunctions.mult);
        t2.assign(DoubleFunctions.mult((double)alpha2));
        double num = beta2 * (t2.aggregate(DoubleFunctions.plus, DoubleFunctions.square) + Math.pow(Math.abs(u.getQuick(k)), 2.0)) / (double)n;
        double den = ((double)n - t1.aggregate((DoubleMatrix1D)s2, DoubleFunctions.plus, DoubleFunctions.mult)) / (double)n;
        den *= den;
        return num / den;
    }

    private class DoublePLBD
    implements DoubleLBD {
        private final DoubleFactory2D factory = DoubleFactory2D.dense;
        private final DoubleMatrix2D alphaBeta = new DenseDoubleMatrix2D(2, 1);
        private final DoublePreconditioner2D P;
        private final DoublePSFMatrix2D A;
        private DoubleMatrix2D C;
        private DoubleMatrix2D U;
        private DoubleMatrix2D V;
        private boolean reorth;
        private int counter = 1;

        public DoublePLBD(DoublePreconditioner2D P, DoublePSFMatrix2D A, DoubleMatrix2D U, boolean reorth) {
            this.P = P;
            this.A = A;
            this.reorth = reorth;
            this.U = U;
            this.V = null;
            this.C = null;
        }

        public void apply() {
            if (this.reorth) {
                int k = this.U.rows();
                DoubleMatrix1D u = null;
                DoubleMatrix1D v = null;
                DoubleMatrix1D row = null;
                if (k == 1) {
                    row = this.U.viewRow(k - 1).copy();
                    row = this.P.solve(row, true);
                    v = this.A.times(row, true);
                } else {
                    row = this.U.viewRow(k - 1).copy();
                    row = this.P.solve(row, true);
                    v = this.A.times(row, true);
                    row = this.V.viewColumn(k - 2);
                    v.assign(row, DoubleFunctions.plusMultSecond((double)(-this.C.getQuick(k - 1, k - 2))));
                    for (int j = 0; j < k - 1; ++j) {
                        row = this.V.viewColumn(j);
                        v.assign(row, DoubleFunctions.plusMultSecond((double)(-row.zDotProduct(v))));
                    }
                }
                double alpha = alg.norm2(v);
                v.assign(DoubleFunctions.div((double)alpha));
                row = this.A.times(v, false);
                u = this.P.solve(row, false);
                row = this.U.viewRow(k - 1);
                u.assign(row, DoubleFunctions.plusMultSecond((double)(-alpha)));
                for (int j = 0; j < k; ++j) {
                    row = this.U.viewRow(j);
                    u.assign(row, DoubleFunctions.plusMultSecond((double)(-row.zDotProduct(u))));
                }
                double beta = alg.norm2(u);
                this.alphaBeta.setQuick(0, 0, alpha);
                this.alphaBeta.setQuick(1, 0, beta);
                u.assign(DoubleFunctions.div((double)beta));
                this.U = this.factory.appendRow(this.U, u);
                if (this.V == null) {
                    this.V = new DenseColumnDoubleMatrix2D((int)v.size(), 1);
                    this.V.assign((double[])v.elements());
                } else {
                    this.V = this.factory.appendColumn(this.V, v);
                }
                if (this.C == null) {
                    this.C = new DenseDoubleMatrix2D(2, 1);
                    this.C.assign(this.alphaBeta);
                } else {
                    this.C = this.factory.composeBidiagonal(this.C, this.alphaBeta);
                }
            } else {
                DoubleMatrix1D u = null;
                DoubleMatrix1D v = null;
                DoubleMatrix1D row = null;
                if (this.counter == 1) {
                    row = this.U.viewRow(0).copy();
                    row = this.P.solve(row, true);
                    v = this.A.times(row, true);
                } else {
                    row = this.U.viewRow(0).copy();
                    row = this.P.solve(row, true);
                    v = this.A.times(row, true);
                    row = this.V.viewColumn(this.counter - 2);
                    v.assign(row, DoubleFunctions.plusMultSecond((double)(-this.C.getQuick(this.counter - 1, this.counter - 2))));
                }
                double alpha = alg.norm2(v);
                v.assign(DoubleFunctions.div((double)alpha));
                row = this.A.times(v, false);
                u = this.P.solve(row, false);
                row = this.U.viewRow(0);
                u.assign(row, DoubleFunctions.plusMultSecond((double)(-alpha)));
                double beta = alg.norm2(u);
                this.alphaBeta.setQuick(0, 0, alpha);
                this.alphaBeta.setQuick(1, 0, beta);
                u.assign(DoubleFunctions.div((double)beta));
                this.U.viewRow(0).assign(u);
                if (this.V == null) {
                    this.V = new DenseColumnDoubleMatrix2D((int)v.size(), 1);
                    this.V.assign((double[])v.elements());
                } else {
                    this.V = this.factory.appendColumn(this.V, v);
                }
                if (this.C == null) {
                    this.C = new DenseDoubleMatrix2D(2, 1);
                    this.C.assign(this.alphaBeta);
                } else {
                    this.C = this.factory.composeBidiagonal(this.C, this.alphaBeta);
                }
                ++this.counter;
            }
        }

        public DoubleMatrix2D getC() {
            return this.C;
        }

        public DoubleMatrix2D getU() {
            return this.U;
        }

        public DoubleMatrix2D getV() {
            return this.V;
        }
    }

    private class DoubleSimpleLBD
    implements DoubleLBD {
        private final DoubleFactory2D factory = DoubleFactory2D.dense;
        private final DoubleMatrix2D alphaBeta = new DenseDoubleMatrix2D(2, 1);
        private final DoublePSFMatrix2D A;
        private DoubleMatrix2D C;
        private DoubleMatrix2D U;
        private DoubleMatrix2D V;
        private boolean reorth;
        private int counter = 1;

        public DoubleSimpleLBD(DoublePSFMatrix2D A, DoubleMatrix2D U, boolean reorth) {
            this.A = A;
            this.reorth = reorth;
            this.U = U;
            this.V = null;
            this.C = null;
        }

        public void apply() {
            if (this.reorth) {
                int k = this.U.rows();
                DoubleMatrix1D u = null;
                DoubleMatrix1D v = null;
                DoubleMatrix1D column = null;
                if (k == 1) {
                    v = this.A.times(this.U.viewRow(k - 1), true);
                } else {
                    v = this.A.times(this.U.viewRow(k - 1), true);
                    column = this.V.viewColumn(k - 2);
                    v.assign(column, DoubleFunctions.plusMultSecond((double)(-this.C.getQuick(k - 1, k - 2))));
                    for (int j = 0; j < k - 1; ++j) {
                        column = this.V.viewColumn(j);
                        v.assign(column, DoubleFunctions.plusMultSecond((double)(-column.zDotProduct(v))));
                    }
                }
                double alpha = alg.norm2(v);
                v.assign(DoubleFunctions.div((double)alpha));
                u = this.A.times(v, false);
                column = this.U.viewRow(k - 1);
                u.assign(column, DoubleFunctions.plusMultSecond((double)(-alpha)));
                for (int j = 0; j < k; ++j) {
                    column = this.U.viewRow(j);
                    u.assign(column, DoubleFunctions.plusMultSecond((double)(-column.zDotProduct(u))));
                }
                double beta = alg.norm2(u);
                this.alphaBeta.setQuick(0, 0, alpha);
                this.alphaBeta.setQuick(1, 0, beta);
                u.assign(DoubleFunctions.div((double)beta));
                this.U = this.factory.appendRow(this.U, u);
                if (this.V == null) {
                    this.V = new DenseColumnDoubleMatrix2D((int)v.size(), 1);
                    this.V.assign((double[])v.elements());
                } else {
                    this.V = this.factory.appendColumn(this.V, v);
                }
                if (this.C == null) {
                    this.C = new DenseDoubleMatrix2D(2, 1);
                    this.C.assign(this.alphaBeta);
                } else {
                    this.C = this.factory.composeBidiagonal(this.C, this.alphaBeta);
                }
            } else {
                DoubleMatrix1D u = null;
                DoubleMatrix1D v = null;
                DoubleMatrix1D column = null;
                if (this.counter == 1) {
                    v = this.A.times(this.U.viewRow(0), true);
                } else {
                    v = this.A.times(this.U.viewRow(0), true);
                    column = this.V.viewColumn(this.counter - 2);
                    v.assign(column, DoubleFunctions.plusMultSecond((double)(-this.C.getQuick(this.counter - 1, this.counter - 2))));
                }
                double alpha = alg.norm2(v);
                v.assign(DoubleFunctions.div((double)alpha));
                u = this.A.times(v, false);
                column = this.U.viewRow(0);
                u.assign(column, DoubleFunctions.plusMultSecond((double)(-alpha)));
                double beta = alg.norm2(u);
                this.alphaBeta.setQuick(0, 0, alpha);
                this.alphaBeta.setQuick(1, 0, beta);
                u.assign(DoubleFunctions.div((double)beta));
                this.U.viewRow(0).assign(u);
                if (this.V == null) {
                    this.V = new DenseColumnDoubleMatrix2D((int)v.size(), 1);
                    this.V.assign((double[])v.elements());
                } else {
                    this.V = this.factory.appendColumn(this.V, v);
                }
                if (this.C == null) {
                    this.C = new DenseDoubleMatrix2D(2, 1);
                    this.C.assign(this.alphaBeta);
                } else {
                    this.C = this.factory.composeBidiagonal(this.C, this.alphaBeta);
                }
                ++this.counter;
            }
        }

        public DoubleMatrix2D getC() {
            return this.C;
        }

        public DoubleMatrix2D getU() {
            return this.U;
        }

        public DoubleMatrix2D getV() {
            return this.V;
        }
    }

    private static interface DoubleLBD {
        public void apply();

        public DoubleMatrix2D getC();

        public DoubleMatrix2D getU();

        public DoubleMatrix2D getV();
    }

    private static class TikFmin
    implements DoubleFmin_methods {
        DoubleMatrix1D bhat;
        double[] s;
        double omega;

        public TikFmin(DoubleMatrix1D bhat, double[] s, double omega) {
            this.bhat = bhat;
            this.s = s;
            this.omega = omega;
        }

        public double f_to_minimize(double alpha) {
            int m = (int)this.bhat.size();
            int n = this.s.length;
            double t0 = this.bhat.viewPart(n, m - n).aggregate(DoubleFunctions.plus, DoubleFunctions.square);
            DenseDoubleMatrix1D s2 = new DenseDoubleMatrix1D(this.s);
            s2.assign(DoubleFunctions.square);
            double alpha2 = alpha * alpha;
            DoubleMatrix1D work = s2.copy();
            work.assign(DoubleFunctions.plus((double)alpha2));
            work.assign(DoubleFunctions.inv);
            DoubleMatrix1D t1 = work.copy();
            t1.assign(DoubleFunctions.mult((double)alpha2));
            DoubleMatrix1D t2 = t1.copy();
            t2.assign(this.bhat.viewPart(0, n), DoubleFunctions.mult);
            DoubleMatrix1D t3 = work.copy();
            t3.assign((DoubleMatrix1D)s2, DoubleFunctions.mult);
            t3.assign(DoubleFunctions.mult((double)(1.0 - this.omega)));
            double denom = t3.aggregate(t1, DoubleFunctions.plus, DoubleFunctions.plus) + (double)m - (double)n;
            return (double)n * (t2.aggregate(DoubleFunctions.plus, DoubleFunctions.square) + t0) / (denom * denom);
        }
    }
}

