/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative.hybr;

import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.matrix.tdouble.algo.solver.HyBRInnerSolver;
import cern.colt.matrix.tdouble.algo.solver.HyBRRegularizationMethod;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.decomposition.DenseFloatSingularValueDecomposition;
import cern.colt.matrix.tfloat.impl.DenseColumnFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.stat.tfloat.FloatDescriptive;
import edu.emory.mathcs.restoretools.Enums;
import edu.emory.mathcs.restoretools.iterative.AbstractFloatIterativeDeconvolver3D;
import edu.emory.mathcs.restoretools.iterative.FloatCommon3D;
import edu.emory.mathcs.restoretools.iterative.IterativeEnums;
import edu.emory.mathcs.restoretools.iterative.hybr.HyBROptions;
import edu.emory.mathcs.restoretools.iterative.preconditioner.FloatPreconditioner3D;
import edu.emory.mathcs.restoretools.iterative.psf.FloatPSFMatrix3D;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import optimization.FloatFmin;
import optimization.FloatFmin_methods;

public class HyBRFloatIterativeDeconvolver3D
extends AbstractFloatIterativeDeconvolver3D {
    private HyBRInnerSolver innerSolver;
    private HyBRRegularizationMethod regMethod;
    private float regParam;
    private float omega;
    private boolean reorth;
    private int begReg;
    private float flatTol;
    private int[] bsize;

    public HyBRFloatIterativeDeconvolver3D(ImagePlus imB, ImagePlus[][][] imPSF, IterativeEnums.PreconditionerType preconditioner, float preconditionerTol, IterativeEnums.BoundaryType boundary, IterativeEnums.ResizingType resizing, Enums.OutputType output, int maxIters, boolean showIteration, HyBROptions options) {
        super("HyBR", imB, imPSF, preconditioner, preconditionerTol, boundary, resizing, output, options.getUseThreshold(), (float)options.getThreshold(), maxIters, showIteration, options.getLogConvergence());
        this.innerSolver = options.getInnerSolver();
        this.regMethod = options.getRegMethod();
        this.regParam = (float)options.getRegParameter();
        this.omega = (float)options.getOmega();
        this.reorth = options.getReorthogonalize();
        this.begReg = options.getBeginReg();
        this.flatTol = (float)options.getFlatTolerance();
        this.bsize = new int[]{this.bSlices, this.bRows, this.bColumns};
    }

    public ImagePlus deconvolve() {
        int k;
        FloatMatrix1D work;
        FloatLBD lbd;
        float beta;
        int columns = this.A.getSize()[1];
        boolean bump = false;
        boolean warning = false;
        float rnrm = -1.0f;
        int iterationsSave = 0;
        HyBRInnerSolver inSolver = HyBRInnerSolver.NONE;
        FloatMatrix1D f = null;
        FloatMatrix1D x = null;
        FloatMatrix1D xSave = null;
        FloatArrayList omegaList = new FloatArrayList(new float[this.begReg - 2]);
        FloatArrayList GCV = new FloatArrayList(new float[this.begReg - 2]);
        DenseFloatMatrix1D b = new DenseFloatMatrix1D((int)this.B.size(), (float[])this.B.elements(), 0, 1, false);
        DenseFloatMatrix2D U = new DenseFloatMatrix2D(1, (int)this.B.size());
        FloatMatrix2D C = null;
        FloatMatrix2D V = null;
        if (this.P == null) {
            beta = alg.norm2((FloatMatrix1D)b);
            U.viewRow(0).assign((FloatMatrix1D)b, FloatFunctions.multSecond((float)(1.0f / beta)));
            lbd = new FloatSimpleLBD(this.A, (FloatMatrix2D)U, this.reorth);
        } else {
            work = this.P.solve((FloatMatrix1D)b, false);
            beta = alg.norm2(work);
            U.viewRow(0).assign(work, FloatFunctions.multSecond((float)(1.0f / beta)));
            lbd = new FloatPLBD(this.P, this.A, (FloatMatrix2D)U, this.reorth);
        }
        ImagePlus imX = null;
        ImageStack is = new ImageStack(this.bColumns, this.bRows);
        if (this.showIteration) {
            FloatCommon3D.assignPixelsToStack(is, this.B, this.cmY);
            imX = new ImagePlus("(deblurred)", is);
            imX.show();
            IJ.showStatus((String)"HyBR initialization...");
        }
        for (k = 0; k <= this.maxIters; ++k) {
            lbd.apply();
            U = lbd.getU();
            C = lbd.getC();
            V = lbd.getV();
            DenseFloatMatrix1D v = new DenseFloatMatrix1D(C.columns() + 1);
            v.setQuick(0, beta);
            if (k < 1) continue;
            IJ.showStatus((String)("HyBR iteration: " + k + "/" + this.maxIters));
            if (k >= this.begReg - 1) {
                inSolver = this.innerSolver;
            }
            switch (inSolver) {
                case TIKHONOV: {
                    DenseFloatSingularValueDecomposition svd = alg.svd(C);
                    FloatMatrix2D Ub = svd.getU();
                    float[] sv = svd.getSingularValues();
                    FloatMatrix2D Vb = svd.getV();
                    if (this.regMethod == HyBRRegularizationMethod.ADAPTWGCV) {
                        work = new DenseFloatMatrix1D(Ub.rows());
                        Ub.zMult((FloatMatrix1D)v, work, 1.0f, 0.0f, true);
                        omegaList.add(Math.min(1.0f, this.findOmega(work, sv)));
                        this.omega = FloatDescriptive.mean((FloatArrayList)omegaList);
                    }
                    f = new DenseFloatMatrix1D(Vb.rows());
                    float alpha = this.tikhonovSolver(Ub, sv, Vb, (FloatMatrix1D)v, f);
                    GCV.add(HyBRFloatIterativeDeconvolver3D.GCVstopfun(alpha, Ub.viewRow(0), sv, beta, columns));
                    if (k <= 1) break;
                    if (Math.abs(GCV.getQuick(k - 1) - GCV.getQuick(k - 2)) / GCV.get(this.begReg - 2) < this.flatTol) {
                        x = V.zMult(f, null);
                        if (this.logConvergence) {
                            work = this.A.times(x, false);
                            rnrm = alg.norm2(work.assign((FloatMatrix1D)b, FloatFunctions.minus));
                            IJ.log((String)(k + ".  Norm of the residual = " + rnrm));
                            IJ.log((String)("HyBR stopped after " + k + " iterations."));
                            IJ.log((String)"Reason for stopping: flat GCV curve.");
                        }
                        if (!this.showIteration) {
                            if (this.useThreshold) {
                                FloatCommon3D.assignPixelsToStack(is, x, this.bsize, this.cmY, this.threshold);
                            } else {
                                FloatCommon3D.assignPixelsToStack(is, x, this.bsize, this.cmY);
                            }
                            imX = new ImagePlus("(deblurred)", is);
                        } else {
                            if (this.useThreshold) {
                                FloatCommon3D.updatePixelsInStack(is, x, this.bsize, this.cmY, this.threshold);
                            } else {
                                FloatCommon3D.updatePixelsInStack(is, x, this.bsize, this.cmY);
                            }
                            imX.updateAndDraw();
                        }
                        FloatCommon3D.convertImage(imX, this.output);
                        return imX;
                    }
                    if (warning && GCV.size() > iterationsSave + 3) {
                        for (int j = iterationsSave; j < GCV.size(); ++j) {
                            if (!(GCV.getQuick(iterationsSave - 1) > GCV.get(j))) continue;
                            bump = true;
                        }
                        if (!bump) {
                            x.assign(xSave);
                            if (this.logConvergence) {
                                work = this.A.times(x, false);
                                rnrm = alg.norm2(work.assign((FloatMatrix1D)b, FloatFunctions.minus));
                                IJ.log((String)("HyBR stopped after " + iterationsSave + " iterations."));
                                IJ.log((String)"Reason for stopping: min of GCV curve within window of 4 iterations.");
                            }
                            if (!this.showIteration) {
                                if (this.useThreshold) {
                                    FloatCommon3D.assignPixelsToStack(is, x, this.bsize, this.cmY, this.threshold);
                                } else {
                                    FloatCommon3D.assignPixelsToStack(is, x, this.bsize, this.cmY);
                                }
                                imX = new ImagePlus("(deblurred)", is);
                            } else {
                                if (this.useThreshold) {
                                    FloatCommon3D.updatePixelsInStack(is, x, this.bsize, this.cmY, this.threshold);
                                } else {
                                    FloatCommon3D.updatePixelsInStack(is, x, this.bsize, this.cmY);
                                }
                                imX.updateAndDraw();
                            }
                            FloatCommon3D.convertImage(imX, this.output);
                            return imX;
                        }
                        bump = false;
                        warning = false;
                        iterationsSave = this.maxIters;
                        break;
                    }
                    if (warning || !(GCV.get(k - 2) < GCV.get(k - 1))) break;
                    warning = true;
                    xSave = V.zMult(f, null);
                    iterationsSave = k;
                    break;
                }
                case NONE: {
                    f = alg.solve(C, (FloatMatrix1D)v);
                }
            }
            x = V.zMult(f, null);
            if (this.logConvergence) {
                work = this.A.times(x, false);
                rnrm = alg.norm2(work.assign((FloatMatrix1D)b, FloatFunctions.minus));
                IJ.log((String)(k + ".  Norm of the residual = " + rnrm));
            }
            if (!this.showIteration) continue;
            if (this.useThreshold) {
                FloatCommon3D.updatePixelsInStack(is, x, this.bsize, this.cmY, this.threshold);
            } else {
                FloatCommon3D.updatePixelsInStack(is, x, this.bsize, this.cmY);
            }
            imX.updateAndDraw();
        }
        if (this.logConvergence && k == this.maxIters + 1) {
            IJ.log((String)"HyBR didn't converge. Reason: maximum number of iterations performed.");
        }
        if (!this.showIteration) {
            if (this.useThreshold) {
                FloatCommon3D.assignPixelsToStack(is, x, this.bsize, this.cmY, this.threshold);
            } else {
                FloatCommon3D.assignPixelsToStack(is, x, this.bsize, this.cmY);
            }
            imX = new ImagePlus("(deblurred)", is);
        }
        FloatCommon3D.convertImage(imX, this.output);
        return imX;
    }

    private float findOmega(FloatMatrix1D bhat, float[] s) {
        int m = (int)bhat.size();
        int n = s.length;
        float alpha = s[n - 1];
        float t0 = bhat.viewPart(n, m - n).aggregate(FloatFunctions.plus, FloatFunctions.square);
        DenseFloatMatrix1D s2 = new DenseFloatMatrix1D(s);
        s2.assign(FloatFunctions.square);
        float alpha2 = alpha * alpha;
        FloatMatrix1D tt = s2.copy();
        tt.assign(FloatFunctions.plus((float)alpha2));
        tt.assign(FloatFunctions.inv);
        float t1 = s2.aggregate(tt, FloatFunctions.plus, FloatFunctions.mult);
        s2 = new DenseFloatMatrix1D(s);
        s2.assign(FloatFunctions.mult((float)alpha));
        s2.assign(bhat.viewPart(0, n), FloatFunctions.mult);
        s2.assign(FloatFunctions.square);
        FloatMatrix1D work = tt.copy();
        work.assign(FloatFunctions.pow((float)3.0f));
        work.assign(FloatFunctions.abs);
        float t3 = work.aggregate((FloatMatrix1D)s2, FloatFunctions.plus, FloatFunctions.mult);
        work = new DenseFloatMatrix1D(s);
        work.assign(tt, FloatFunctions.mult);
        float t4 = work.aggregate(FloatFunctions.plus, FloatFunctions.square);
        work = tt.copy();
        work.assign(bhat.viewPart(0, n), FloatFunctions.mult);
        work.assign(FloatFunctions.mult((float)alpha2));
        float t5 = work.aggregate(FloatFunctions.plus, FloatFunctions.square);
        s2 = new DenseFloatMatrix1D(s);
        s2.assign(bhat.viewPart(0, n), FloatFunctions.mult);
        s2.assign(FloatFunctions.square);
        tt.assign(FloatFunctions.pow((float)3.0f));
        tt.assign(FloatFunctions.abs);
        float v2 = tt.aggregate((FloatMatrix1D)s2, FloatFunctions.plus, FloatFunctions.mult);
        return (float)m * alpha2 * v2 / (t1 * t3 + t4 * (t5 + t0));
    }

    private float tikhonovSolver(FloatMatrix2D U, float[] s, FloatMatrix2D V, FloatMatrix1D b, FloatMatrix1D x) {
        DenseFloatMatrix1D bhat = new DenseFloatMatrix1D(U.rows());
        U.zMult(b, (FloatMatrix1D)bhat, 1.0f, 0.0f, true);
        float alpha = 0.0f;
        switch (this.regMethod) {
            case GCV: {
                TikFmin fmin = new TikFmin((FloatMatrix1D)bhat, s, 1.0f);
                alpha = FloatFmin.fmin((float)0.0f, (float)1.0f, (FloatFmin_methods)fmin, (float)1.0E-4f);
                break;
            }
            case WGCV: {
                TikFmin fmin = new TikFmin((FloatMatrix1D)bhat, s, this.omega);
                alpha = FloatFmin.fmin((float)0.0f, (float)1.0f, (FloatFmin_methods)fmin, (float)1.0E-4f);
                break;
            }
            case ADAPTWGCV: {
                TikFmin fmin = new TikFmin((FloatMatrix1D)bhat, s, this.omega);
                alpha = FloatFmin.fmin((float)0.0f, (float)1.0f, (FloatFmin_methods)fmin, (float)1.0E-4f);
                break;
            }
            case NONE: {
                alpha = this.regParam;
            }
        }
        DenseFloatMatrix1D d = new DenseFloatMatrix1D(s);
        d.assign(FloatFunctions.square);
        d.assign(FloatFunctions.plus((float)(alpha * alpha)));
        bhat = bhat.viewPart(0, s.length);
        DenseFloatMatrix1D S = new DenseFloatMatrix1D(s);
        bhat.assign((FloatMatrix1D)S, FloatFunctions.mult);
        bhat.assign((FloatMatrix1D)d, FloatFunctions.div);
        V.zMult((FloatMatrix1D)bhat, x);
        return alpha;
    }

    private static float GCVstopfun(float alpha, FloatMatrix1D u, float[] s, float beta, int n) {
        int k = s.length;
        float beta2 = beta * beta;
        DenseFloatMatrix1D s2 = new DenseFloatMatrix1D(s);
        s2.assign(FloatFunctions.square);
        float alpha2 = alpha * alpha;
        FloatMatrix1D t1 = s2.copy();
        t1.assign(FloatFunctions.plus((float)alpha2));
        t1.assign(FloatFunctions.inv);
        FloatMatrix1D t2 = t1.copy();
        t2.assign(u.viewPart(0, k), FloatFunctions.mult);
        t2.assign(FloatFunctions.mult((float)alpha2));
        float num = (float)((double)beta2 * ((double)t2.aggregate(FloatFunctions.plus, FloatFunctions.square) + Math.pow(Math.abs(u.getQuick(k)), 2.0)) / (double)n);
        float den = ((float)n - t1.aggregate((FloatMatrix1D)s2, FloatFunctions.plus, FloatFunctions.mult)) / (float)n;
        den *= den;
        return num / den;
    }

    private class FloatPLBD
    implements FloatLBD {
        private final FloatFactory2D factory = FloatFactory2D.dense;
        private final FloatMatrix2D alphaBeta = new DenseFloatMatrix2D(2, 1);
        private final FloatPreconditioner3D P;
        private final FloatPSFMatrix3D A;
        private FloatMatrix2D C;
        private FloatMatrix2D U;
        private FloatMatrix2D V;
        private boolean reorth;
        private int counter = 1;

        public FloatPLBD(FloatPreconditioner3D P, FloatPSFMatrix3D A, FloatMatrix2D U, boolean reorth) {
            this.P = P;
            this.A = A;
            this.reorth = reorth;
            this.U = U;
            this.V = null;
            this.C = null;
        }

        public void apply() {
            if (this.reorth) {
                int k = this.U.rows();
                FloatMatrix1D u = null;
                FloatMatrix1D v = null;
                FloatMatrix1D row = null;
                if (k == 1) {
                    row = this.U.viewRow(k - 1).copy();
                    row = this.P.solve(row, true);
                    v = this.A.times(row, true);
                } else {
                    row = this.U.viewRow(k - 1).copy();
                    row = this.P.solve(row, true);
                    v = this.A.times(row, true);
                    row = this.V.viewColumn(k - 2);
                    v.assign(row, FloatFunctions.plusMultSecond((float)(-this.C.getQuick(k - 1, k - 2))));
                    for (int j = 0; j < k - 1; ++j) {
                        row = this.V.viewColumn(j);
                        v.assign(row, FloatFunctions.plusMultSecond((float)(-row.zDotProduct(v))));
                    }
                }
                float alpha = alg.norm2(v);
                v.assign(FloatFunctions.div((float)alpha));
                row = this.A.times(v, false);
                u = this.P.solve(row, false);
                row = this.U.viewRow(k - 1);
                u.assign(row, FloatFunctions.plusMultSecond((float)(-alpha)));
                for (int j = 0; j < k; ++j) {
                    row = this.U.viewRow(j);
                    u.assign(row, FloatFunctions.plusMultSecond((float)(-row.zDotProduct(u))));
                }
                float beta = alg.norm2(u);
                this.alphaBeta.setQuick(0, 0, alpha);
                this.alphaBeta.setQuick(1, 0, beta);
                u.assign(FloatFunctions.div((float)beta));
                this.U = this.factory.appendRow(this.U, u);
                if (this.V == null) {
                    this.V = new DenseColumnFloatMatrix2D((int)v.size(), 1);
                    this.V.assign((float[])v.elements());
                } else {
                    this.V = this.factory.appendColumn(this.V, v);
                }
                if (this.C == null) {
                    this.C = new DenseFloatMatrix2D(2, 1);
                    this.C.assign(this.alphaBeta);
                } else {
                    this.C = this.factory.composeBidiagonal(this.C, this.alphaBeta);
                }
            } else {
                FloatMatrix1D u = null;
                FloatMatrix1D v = null;
                FloatMatrix1D row = null;
                if (this.counter == 1) {
                    row = this.U.viewRow(0).copy();
                    row = this.P.solve(row, true);
                    v = this.A.times(row, true);
                } else {
                    row = this.U.viewRow(0).copy();
                    row = this.P.solve(row, true);
                    v = this.A.times(row, true);
                    row = this.V.viewColumn(this.counter - 2);
                    v.assign(row, FloatFunctions.plusMultSecond((float)(-this.C.getQuick(this.counter - 1, this.counter - 2))));
                }
                float alpha = alg.norm2(v);
                v.assign(FloatFunctions.div((float)alpha));
                row = this.A.times(v, false);
                u = this.P.solve(row, false);
                row = this.U.viewRow(0);
                u.assign(row, FloatFunctions.plusMultSecond((float)(-alpha)));
                float beta = alg.norm2(u);
                this.alphaBeta.setQuick(0, 0, alpha);
                this.alphaBeta.setQuick(1, 0, beta);
                u.assign(FloatFunctions.div((float)beta));
                this.U.viewRow(0).assign(u);
                if (this.V == null) {
                    this.V = new DenseColumnFloatMatrix2D((int)v.size(), 1);
                    this.V.assign((float[])v.elements());
                } else {
                    this.V = this.factory.appendColumn(this.V, v);
                }
                if (this.C == null) {
                    this.C = new DenseFloatMatrix2D(2, 1);
                    this.C.assign(this.alphaBeta);
                } else {
                    this.C = this.factory.composeBidiagonal(this.C, this.alphaBeta);
                }
                ++this.counter;
            }
        }

        public FloatMatrix2D getC() {
            return this.C;
        }

        public FloatMatrix2D getU() {
            return this.U;
        }

        public FloatMatrix2D getV() {
            return this.V;
        }
    }

    private class FloatSimpleLBD
    implements FloatLBD {
        private final FloatFactory2D factory = FloatFactory2D.dense;
        private final FloatMatrix2D alphaBeta = new DenseFloatMatrix2D(2, 1);
        private final FloatPSFMatrix3D A;
        private FloatMatrix2D C;
        private FloatMatrix2D U;
        private FloatMatrix2D V;
        private boolean reorth;
        private int counter = 1;

        public FloatSimpleLBD(FloatPSFMatrix3D A, FloatMatrix2D U, boolean reorth) {
            this.A = A;
            this.reorth = reorth;
            this.U = U;
            this.V = null;
            this.C = null;
        }

        public void apply() {
            if (this.reorth) {
                int k = this.U.rows();
                FloatMatrix1D u = null;
                FloatMatrix1D v = null;
                FloatMatrix1D column = null;
                if (k == 1) {
                    v = this.A.times(this.U.viewRow(k - 1), true);
                } else {
                    v = this.A.times(this.U.viewRow(k - 1), true);
                    column = this.V.viewColumn(k - 2);
                    v.assign(column, FloatFunctions.plusMultSecond((float)(-this.C.getQuick(k - 1, k - 2))));
                    for (int j = 0; j < k - 1; ++j) {
                        column = this.V.viewColumn(j);
                        v.assign(column, FloatFunctions.plusMultSecond((float)(-column.zDotProduct(v))));
                    }
                }
                float alpha = alg.norm2(v);
                v.assign(FloatFunctions.div((float)alpha));
                u = this.A.times(v, false);
                column = this.U.viewRow(k - 1);
                u.assign(column, FloatFunctions.plusMultSecond((float)(-alpha)));
                for (int j = 0; j < k; ++j) {
                    column = this.U.viewRow(j);
                    u.assign(column, FloatFunctions.plusMultSecond((float)(-column.zDotProduct(u))));
                }
                float beta = alg.norm2(u);
                this.alphaBeta.setQuick(0, 0, alpha);
                this.alphaBeta.setQuick(1, 0, beta);
                u.assign(FloatFunctions.div((float)beta));
                this.U = this.factory.appendRow(this.U, u);
                if (this.V == null) {
                    this.V = new DenseColumnFloatMatrix2D((int)v.size(), 1);
                    this.V.assign((float[])v.elements());
                } else {
                    this.V = this.factory.appendColumn(this.V, v);
                }
                if (this.C == null) {
                    this.C = new DenseFloatMatrix2D(2, 1);
                    this.C.assign(this.alphaBeta);
                } else {
                    this.C = this.factory.composeBidiagonal(this.C, this.alphaBeta);
                }
            } else {
                FloatMatrix1D u = null;
                FloatMatrix1D v = null;
                FloatMatrix1D column = null;
                if (this.counter == 1) {
                    v = this.A.times(this.U.viewRow(0), true);
                } else {
                    v = this.A.times(this.U.viewRow(0), true);
                    column = this.V.viewColumn(this.counter - 2);
                    v.assign(column, FloatFunctions.plusMultSecond((float)(-this.C.getQuick(this.counter - 1, this.counter - 2))));
                }
                float alpha = alg.norm2(v);
                v.assign(FloatFunctions.div((float)alpha));
                u = this.A.times(v, false);
                column = this.U.viewRow(0);
                u.assign(column, FloatFunctions.plusMultSecond((float)(-alpha)));
                float beta = alg.norm2(u);
                this.alphaBeta.setQuick(0, 0, alpha);
                this.alphaBeta.setQuick(1, 0, beta);
                u.assign(FloatFunctions.div((float)beta));
                this.U.viewRow(0).assign(u);
                if (this.V == null) {
                    this.V = new DenseColumnFloatMatrix2D((int)v.size(), 1);
                    this.V.assign((float[])v.elements());
                } else {
                    this.V = this.factory.appendColumn(this.V, v);
                }
                if (this.C == null) {
                    this.C = new DenseFloatMatrix2D(2, 1);
                    this.C.assign(this.alphaBeta);
                } else {
                    this.C = this.factory.composeBidiagonal(this.C, this.alphaBeta);
                }
                ++this.counter;
            }
        }

        public FloatMatrix2D getC() {
            return this.C;
        }

        public FloatMatrix2D getU() {
            return this.U;
        }

        public FloatMatrix2D getV() {
            return this.V;
        }
    }

    private static interface FloatLBD {
        public void apply();

        public FloatMatrix2D getC();

        public FloatMatrix2D getU();

        public FloatMatrix2D getV();
    }

    private static class TikFmin
    implements FloatFmin_methods {
        FloatMatrix1D bhat;
        float[] s;
        float omega;

        public TikFmin(FloatMatrix1D bhat, float[] s, float omega) {
            this.bhat = bhat;
            this.s = s;
            this.omega = omega;
        }

        public float f_to_minimize(float alpha) {
            int m = (int)this.bhat.size();
            int n = this.s.length;
            float t0 = this.bhat.viewPart(n, m - n).aggregate(FloatFunctions.plus, FloatFunctions.square);
            DenseFloatMatrix1D s2 = new DenseFloatMatrix1D(this.s);
            s2.assign(FloatFunctions.square);
            float alpha2 = alpha * alpha;
            FloatMatrix1D work = s2.copy();
            work.assign(FloatFunctions.plus((float)alpha2));
            work.assign(FloatFunctions.inv);
            FloatMatrix1D t1 = work.copy();
            t1.assign(FloatFunctions.mult((float)alpha2));
            FloatMatrix1D t2 = t1.copy();
            t2.assign(this.bhat.viewPart(0, n), FloatFunctions.mult);
            FloatMatrix1D t3 = work.copy();
            t3.assign((FloatMatrix1D)s2, FloatFunctions.mult);
            t3.assign(FloatFunctions.mult((float)(1.0f - this.omega)));
            float denom = t3.aggregate(t1, FloatFunctions.plus, FloatFunctions.plus) + (float)m - (float)n;
            return (float)n * (t2.aggregate(FloatFunctions.plus, FloatFunctions.square) + t0) / (denom * denom);
        }
    }
}

