/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative.psf;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import ij.ImagePlus;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class DoublePSF2D {
    private DoubleMatrix2D[][] image;
    private int[][][] center;

    public DoublePSF2D(ImagePlus[][] imPSF) {
        this.image = new DoubleMatrix2D[imPSF.length][imPSF[0].length];
        this.center = new int[imPSF.length][imPSF[0].length][2];
        for (int i = 0; i < imPSF.length; ++i) {
            for (int j = 0; j < imPSF[0].length; ++j) {
                ImageProcessor ipPSF = imPSF[i][j].getProcessor();
                this.image[i][j] = new DenseDoubleMatrix2D(ipPSF.getHeight(), ipPSF.getWidth());
                if (ipPSF instanceof FloatProcessor) {
                    this.image[i][j].assign((float[])ipPSF.getPixels());
                } else {
                    this.image[i][j].assign((float[])ipPSF.convertToFloat().getPixels());
                }
                double[] tmp = this.image[i][j].getMaxLocation();
                this.center[i][j][0] = (int)tmp[1];
                this.center[i][j][1] = (int)tmp[2];
            }
        }
    }

    public int[][][] getCenter() {
        return this.center;
    }

    public DoubleMatrix2D[][] getImage() {
        return this.image;
    }

    public int getNumberOfImages() {
        return this.image.length;
    }

    public int[] getSize() {
        int[] size = new int[2];
        if (this.image.length > 1 || this.image[0].length > 1) {
            int maxRowSize = this.image[0][0].rows();
            int maxColSize = this.image[0][0].columns();
            for (int i = 0; i < this.image.length; ++i) {
                for (int j = 0; j < this.image[0].length; ++j) {
                    if (this.image[i][j].rows() > maxRowSize) {
                        maxRowSize = this.image[i][j].rows();
                    }
                    if (this.image[i][j].columns() <= maxColSize) continue;
                    maxColSize = this.image[i][j].columns();
                }
            }
            size[0] = maxRowSize;
            size[1] = maxColSize;
        } else {
            size[0] = this.image[0][0].rows();
            size[1] = this.image[0][0].columns();
        }
        return size;
    }
}

