/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.restoretools.iterative.psf;

import cern.colt.matrix.tfloat.FloatMatrix2D;
import edu.emory.mathcs.restoretools.iterative.FloatCommon2D;
import ij.ImagePlus;
import ij.process.ImageProcessor;

public class FloatPSF2D {
    private FloatMatrix2D[][] image;
    private int[][][] center;

    public FloatPSF2D(ImagePlus[][] imPSF) {
        this.image = new FloatMatrix2D[imPSF.length][imPSF[0].length];
        this.center = new int[imPSF.length][imPSF[0].length][2];
        for (int i = 0; i < imPSF.length; ++i) {
            for (int j = 0; j < imPSF[0].length; ++j) {
                ImageProcessor ipPSF = imPSF[i][j].getProcessor();
                this.image[i][j] = FloatCommon2D.assignPixelsToMatrix(ipPSF);
                float[] tmp = this.image[i][j].getMaxLocation();
                this.center[i][j][0] = (int)tmp[1];
                this.center[i][j][1] = (int)tmp[2];
            }
        }
    }

    public int[][][] getCenter() {
        return this.center;
    }

    public FloatMatrix2D[][] getImage() {
        return this.image;
    }

    public int getNumberOfImages() {
        return this.image.length;
    }

    public int[] getSize() {
        int[] size = new int[2];
        if (this.image.length > 1 || this.image[0].length > 1) {
            int maxRowSize = this.image[0][0].rows();
            int maxColSize = this.image[0][0].columns();
            for (int i = 0; i < this.image.length; ++i) {
                for (int j = 0; j < this.image[0].length; ++j) {
                    if (this.image[i][j].rows() > maxRowSize) {
                        maxRowSize = this.image[i][j].rows();
                    }
                    if (this.image[i][j].columns() <= maxColSize) continue;
                    maxColSize = this.image[i][j].columns();
                }
            }
            size[0] = maxRowSize;
            size[1] = maxColSize;
        } else {
            size[0] = this.image[0][0].rows();
            size[1] = this.image[0][0].columns();
        }
        return size;
    }
}

